/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2019-10-31 16:16:45 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_bp_activity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `component` varchar(75) NOT NULL,
  `type` varchar(75) NOT NULL,
  `action` text NOT NULL,
  `content` longtext NOT NULL,
  `primary_link` text NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `secondary_item_id` bigint(20) DEFAULT NULL,
  `date_recorded` datetime NOT NULL,
  `hide_sitewide` tinyint(1) DEFAULT 0,
  `mptt_left` int(11) NOT NULL DEFAULT 0,
  `mptt_right` int(11) NOT NULL DEFAULT 0,
  `is_spam` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `date_recorded` (`date_recorded`),
  KEY `user_id` (`user_id`),
  KEY `item_id` (`item_id`),
  KEY `secondary_item_id` (`secondary_item_id`),
  KEY `component` (`component`),
  KEY `type` (`type`),
  KEY `mptt_left` (`mptt_left`),
  KEY `mptt_right` (`mptt_right`),
  KEY `hide_sitewide` (`hide_sitewide`),
  KEY `is_spam` (`is_spam`)
) ENGINE=InnoDB AUTO_INCREMENT=760 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_activity_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `activity_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_id` (`activity_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_friends` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `initiator_user_id` bigint(20) NOT NULL,
  `friend_user_id` bigint(20) NOT NULL,
  `is_confirmed` tinyint(1) DEFAULT 0,
  `is_limited` tinyint(1) DEFAULT 0,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `initiator_user_id` (`initiator_user_id`),
  KEY `friend_user_id` (`friend_user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_groups` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `creator_id` bigint(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `slug` varchar(200) NOT NULL,
  `description` longtext NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'public',
  `enable_forum` tinyint(1) NOT NULL DEFAULT 1,
  `date_created` datetime NOT NULL,
  `parent_id` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `creator_id` (`creator_id`),
  KEY `status` (`status`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_groups_groupmeta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_groups_members` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `inviter_id` bigint(20) NOT NULL,
  `is_admin` tinyint(1) NOT NULL DEFAULT 0,
  `is_mod` tinyint(1) NOT NULL DEFAULT 0,
  `user_title` varchar(100) NOT NULL,
  `date_modified` datetime NOT NULL,
  `comments` longtext NOT NULL,
  `is_confirmed` tinyint(1) NOT NULL DEFAULT 0,
  `is_banned` tinyint(1) NOT NULL DEFAULT 0,
  `invite_sent` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `is_admin` (`is_admin`),
  KEY `is_mod` (`is_mod`),
  KEY `user_id` (`user_id`),
  KEY `inviter_id` (`inviter_id`),
  KEY `is_confirmed` (`is_confirmed`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_invitations` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `inviter_id` bigint(20) NOT NULL,
  `invitee_email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `class` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `secondary_item_id` bigint(20) DEFAULT NULL,
  `type` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'invite',
  `content` longtext COLLATE utf8mb4_unicode_ci DEFAULT '',
  `date_modified` datetime NOT NULL,
  `invite_sent` tinyint(1) NOT NULL DEFAULT 0,
  `accepted` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `inviter_id` (`inviter_id`),
  KEY `invitee_email` (`invitee_email`),
  KEY `class` (`class`),
  KEY `item_id` (`item_id`),
  KEY `secondary_item_id` (`secondary_item_id`),
  KEY `type` (`type`),
  KEY `invite_sent` (`invite_sent`),
  KEY `accepted` (`accepted`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_bp_messages_messages` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `thread_id` bigint(20) NOT NULL,
  `sender_id` bigint(20) NOT NULL,
  `subject` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `date_sent` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sender_id` (`sender_id`),
  KEY `thread_id` (`thread_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_messages_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `message_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `message_id` (`message_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_messages_notices` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `subject` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `date_sent` datetime NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `is_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_messages_recipients` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `thread_id` bigint(20) NOT NULL,
  `unread_count` int(10) NOT NULL DEFAULT 0,
  `sender_only` tinyint(1) NOT NULL DEFAULT 0,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `thread_id` (`thread_id`),
  KEY `is_deleted` (`is_deleted`),
  KEY `sender_only` (`sender_only`),
  KEY `unread_count` (`unread_count`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_notifications` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `secondary_item_id` bigint(20) DEFAULT NULL,
  `component_name` varchar(75) NOT NULL,
  `component_action` varchar(75) NOT NULL,
  `date_notified` datetime NOT NULL,
  `is_new` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `secondary_item_id` (`secondary_item_id`),
  KEY `user_id` (`user_id`),
  KEY `is_new` (`is_new`),
  KEY `component_name` (`component_name`),
  KEY `component_action` (`component_action`),
  KEY `useritem` (`user_id`,`is_new`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_notifications_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `notification_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notification_id` (`notification_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_xprofile_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `field_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `value` longtext NOT NULL,
  `last_updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `field_id` (`field_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=160 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_xprofile_fields` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL,
  `type` varchar(150) NOT NULL,
  `name` varchar(150) NOT NULL,
  `description` longtext NOT NULL,
  `is_required` tinyint(1) NOT NULL DEFAULT 0,
  `is_default_option` tinyint(1) NOT NULL DEFAULT 0,
  `field_order` bigint(20) NOT NULL DEFAULT 0,
  `option_order` bigint(20) NOT NULL DEFAULT 0,
  `order_by` varchar(15) NOT NULL DEFAULT '',
  `can_delete` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `parent_id` (`parent_id`),
  KEY `field_order` (`field_order`),
  KEY `can_delete` (`can_delete`),
  KEY `is_required` (`is_required`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_xprofile_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `description` mediumtext NOT NULL,
  `group_order` bigint(20) NOT NULL DEFAULT 0,
  `can_delete` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `can_delete` (`can_delete`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_bp_xprofile_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `object_id` bigint(20) NOT NULL,
  `object_type` varchar(150) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_id` (`object_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=512 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=486 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `author` int(10) NOT NULL DEFAULT 0,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `flag_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `schedule_start` int(10) NOT NULL DEFAULT 0,
  `schedule_end` int(10) NOT NULL DEFAULT 0,
  `flag_popup` tinyint(1) NOT NULL DEFAULT 0,
  `group_id` int(10) DEFAULT NULL,
  `flag_group` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_layerslider_revisions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) NOT NULL,
  `author` int(10) NOT NULL DEFAULT 0,
  `data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=63875 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10829 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=3354 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  `advanced` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  `advanced` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_signups` (
  `signup_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `domain` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `activation_key` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`signup_id`),
  KEY `activation_key` (`activation_key`),
  KEY `user_email` (`user_email`),
  KEY `user_login_email` (`user_login`,`user_email`),
  KEY `domain_path` (`domain`(140),`path`(51))
) ENGINE=InnoDB AUTO_INCREMENT=173 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=180 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=180 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4832 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=166 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(10,2) DEFAULT NULL,
  `max_price` decimal(10,2) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(191),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_ir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text1` text CHARACTER SET utf8 COLLATE utf8_persian_ci NOT NULL,
  `text2` text CHARACTER SET utf8 COLLATE utf8_persian_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=550 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=6237 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type` (`location_type`),
  KEY `location_type_code` (`location_type`,`location_code`(90))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type` (`location_type`),
  KEY `location_type_code` (`location_type`,`location_code`(90))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(191)),
  KEY `tax_rate_class` (`tax_rate_class`(191)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_termmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `woocommerce_term_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `woocommerce_term_id` (`woocommerce_term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: wp_bp_activity */
INSERT INTO `wp_bp_activity` VALUES("19", "1", "members", "last_activity", "", "", "", "0", NULL, "2019-10-31 15:56:53", "0", "0", "0", "0");
INSERT INTO `wp_bp_activity` VALUES("523", "79", "members", "last_activity", "", "", "", "0", NULL, "2019-10-30 21:56:49", "0", "0", "0", "0");

/* INSERT TABLE DATA: wp_bp_groups */
INSERT INTO `wp_bp_groups` VALUES("5", "79", "کامپیوتر", "%da%a9%d8%a7%d9%85%d9%be%db%8c%d9%88%d8%aa%d8%b1", "", "public", "0", "2018-12-07 20:32:39", "0");
INSERT INTO `wp_bp_groups` VALUES("10", "79", "زبان", "%d8%b2%d8%a8%d8%a7%d9%86", "", "public", "0", "2019-06-04 13:50:26", "0");

/* INSERT TABLE DATA: wp_bp_groups_groupmeta */
INSERT INTO `wp_bp_groups_groupmeta` VALUES("13", "5", "total_member_count", "1");
INSERT INTO `wp_bp_groups_groupmeta` VALUES("14", "5", "last_activity", "2018-12-07 20:32:39");
INSERT INTO `wp_bp_groups_groupmeta` VALUES("15", "5", "course", "3047");
INSERT INTO `wp_bp_groups_groupmeta` VALUES("28", "10", "total_member_count", "1");
INSERT INTO `wp_bp_groups_groupmeta` VALUES("29", "10", "last_activity", "2019-06-04 13:50:26");
INSERT INTO `wp_bp_groups_groupmeta` VALUES("30", "10", "course", "3255");

/* INSERT TABLE DATA: wp_bp_groups_members */
INSERT INTO `wp_bp_groups_members` VALUES("7", "5", "79", "0", "1", "0", "مدیر گروه", "2018-12-07 20:32:39", "", "1", "0", "0");
INSERT INTO `wp_bp_groups_members` VALUES("12", "10", "79", "0", "1", "0", "مدیر گروه", "2019-06-04 13:50:26", "", "1", "0", "0");

/* INSERT TABLE DATA: wp_bp_messages_messages */
INSERT INTO `wp_bp_messages_messages` VALUES("1", "1", "18", "Hi", "Hii ostad", "2017-10-18 17:35:27");
INSERT INTO `wp_bp_messages_messages` VALUES("2", "2", "18", "Hi", "Hii ostad", "2017-10-18 17:35:29");
INSERT INTO `wp_bp_messages_messages` VALUES("3", "3", "18", "Hi", "Hii ostad", "2017-10-18 17:35:38");
INSERT INTO `wp_bp_messages_messages` VALUES("4", "4", "18", "Hi", "Hii ostad", "2017-10-18 17:35:41");
INSERT INTO `wp_bp_messages_messages` VALUES("5", "5", "3", "hi", "hi adminsk", "2017-10-18 17:38:17");
INSERT INTO `wp_bp_messages_messages` VALUES("6", "6", "3", "aa", "aaa", "2017-10-18 17:44:46");
INSERT INTO `wp_bp_messages_messages` VALUES("7", "7", "29", "fdg", "fgdfdg", "2017-11-23 14:34:27");

/* INSERT TABLE DATA: wp_bp_messages_recipients */
INSERT INTO `wp_bp_messages_recipients` VALUES("1", "3", "1", "0", "0", "0");
INSERT INTO `wp_bp_messages_recipients` VALUES("2", "18", "1", "0", "1", "0");
INSERT INTO `wp_bp_messages_recipients` VALUES("3", "3", "2", "0", "0", "0");
INSERT INTO `wp_bp_messages_recipients` VALUES("4", "18", "2", "0", "1", "0");
INSERT INTO `wp_bp_messages_recipients` VALUES("5", "3", "3", "0", "0", "0");
INSERT INTO `wp_bp_messages_recipients` VALUES("6", "18", "3", "0", "1", "0");
INSERT INTO `wp_bp_messages_recipients` VALUES("7", "3", "4", "0", "0", "0");
INSERT INTO `wp_bp_messages_recipients` VALUES("8", "18", "4", "0", "1", "0");
INSERT INTO `wp_bp_messages_recipients` VALUES("9", "18", "5", "1", "0", "0");
INSERT INTO `wp_bp_messages_recipients` VALUES("10", "3", "5", "0", "1", "0");
INSERT INTO `wp_bp_messages_recipients` VALUES("11", "18", "6", "1", "0", "0");
INSERT INTO `wp_bp_messages_recipients` VALUES("12", "3", "6", "0", "1", "0");
INSERT INTO `wp_bp_messages_recipients` VALUES("13", "3", "7", "0", "0", "0");
INSERT INTO `wp_bp_messages_recipients` VALUES("14", "29", "7", "0", "1", "0");

/* INSERT TABLE DATA: wp_bp_xprofile_data */
INSERT INTO `wp_bp_xprofile_data` VALUES("1", "1", "1", "admin", "2019-10-31 15:36:01");
INSERT INTO `wp_bp_xprofile_data` VALUES("79", "1", "79", "استاد", "2019-01-10 10:21:48");

/* INSERT TABLE DATA: wp_bp_xprofile_fields */
INSERT INTO `wp_bp_xprofile_fields` VALUES("1", "1", "0", "textbox", "نام", "", "1", "0", "1", "0", "", "0");

/* INSERT TABLE DATA: wp_bp_xprofile_groups */
INSERT INTO `wp_bp_xprofile_groups` VALUES("1", "پایه", "", "0", "0");

/* INSERT TABLE DATA: wp_bp_xprofile_meta */
INSERT INTO `wp_bp_xprofile_meta` VALUES("1", "1", "field", "allow_custom_visibility", "disabled");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("15", "9", "review_title", "برای اونایی که میخوان عکاسی یاد بگیرن لازمه");
INSERT INTO `wp_commentmeta` VALUES("16", "9", "review_rating", "4");
INSERT INTO `wp_commentmeta` VALUES("21", "12", "review_title", "دوره بسیار عالی");
INSERT INTO `wp_commentmeta` VALUES("22", "12", "review_rating", "4");
INSERT INTO `wp_commentmeta` VALUES("25", "14", "review_title", "نیاز به بهبود");
INSERT INTO `wp_commentmeta` VALUES("26", "14", "review_rating", "2");
INSERT INTO `wp_commentmeta` VALUES("29", "16", "review_title", "این یه دوره عالیه");
INSERT INTO `wp_commentmeta` VALUES("30", "16", "review_rating", "3");
INSERT INTO `wp_commentmeta` VALUES("41", "241", "quiz_id", "1346");
INSERT INTO `wp_commentmeta` VALUES("46", "238", "quiz_id", "1258");
INSERT INTO `wp_commentmeta` VALUES("180", "336", "quiz_id", "2886");
INSERT INTO `wp_commentmeta` VALUES("181", "336", "marks", "1");
INSERT INTO `wp_commentmeta` VALUES("182", "339", "quiz_id", "1346");
INSERT INTO `wp_commentmeta` VALUES("183", "340", "quiz_id", "1346");
INSERT INTO `wp_commentmeta` VALUES("184", "341", "quiz_id", "1346");
INSERT INTO `wp_commentmeta` VALUES("185", "342", "quiz_id", "1346");
INSERT INTO `wp_commentmeta` VALUES("186", "343", "quiz_id", "1346");
INSERT INTO `wp_commentmeta` VALUES("405", "442", "quiz_id", "1240");
INSERT INTO `wp_commentmeta` VALUES("406", "443", "quiz_id", "1240");
INSERT INTO `wp_commentmeta` VALUES("407", "444", "quiz_id", "1240");
INSERT INTO `wp_commentmeta` VALUES("408", "445", "quiz_id", "1240");
INSERT INTO `wp_commentmeta` VALUES("409", "446", "quiz_id", "1240");
INSERT INTO `wp_commentmeta` VALUES("410", "447", "quiz_id", "1240");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("9", "1235", "اکبر", "donald@gracia.com", "", "182.68.241.184", "2014-02-05 14:53:28", "2014-02-05 14:53:28", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "1242", "ایمان", "linda@walker.com", "", "182.68.241.184", "2014-02-05 14:07:42", "2014-02-05 14:07:42", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("14", "1242", "احمد", "donald@gracia.com", "", "182.68.241.184", "2014-02-05 14:55:58", "2014-02-05 14:55:58", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("16", "1260", "آرزو", "betty@adams.com", "", "182.64.226.197", "2014-02-05 07:04:04", "2014-02-05 07:04:04", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("26", "292", "علی", "dan@danphilibin.com", "http://wpcandy.com", "207.255.235.40", "2008-09-17 17:19:27", "2008-09-17 17:19:27", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\nچاپگرها و متون بلکه روزنامه و <code>مجله</code> در ستون و سطرآنچنان که لازم است.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("31", "306", "حسام", "dan@danphilibin.com", "http://wpcandy.com", "207.255.235.40", "2008-09-17 17:20:13", "2008-09-17 17:20:13", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.\r\n", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("238", "1181", "جعفر", "Attractionbydesign@gmail.com", "", "72.27.238.153", "2014-02-21 20:01:53", "2014-02-21 20:01:53", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("241", "1181", "کامران", "nikola.jovanovic@plummark.com", "", "178.223.166.78", "2014-02-23 17:17:56", "2014-02-23 17:17:56", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("336", "1763", "", "", "", "", "2018-01-08 12:23:35", "2018-01-08 12:23:35", "2", "0", "1", "", "", "0", "3");
INSERT INTO `wp_comments` VALUES("339", "1181", "", "", "", "", "2018-02-09 19:59:13", "2018-02-09 19:59:13", "4", "0", "1", "", "", "0", "48");
INSERT INTO `wp_comments` VALUES("340", "1763", "", "", "", "", "2018-02-09 19:59:14", "2018-02-09 19:59:14", "1", "0", "1", "", "", "0", "48");
INSERT INTO `wp_comments` VALUES("341", "138", "", "", "", "", "2018-02-09 19:59:16", "2018-02-09 19:59:16", "3", "0", "1", "", "", "0", "48");
INSERT INTO `wp_comments` VALUES("342", "110", "", "", "", "", "2018-02-09 19:59:18", "2018-02-09 19:59:18", "3", "0", "1", "", "", "0", "48");
INSERT INTO `wp_comments` VALUES("343", "49", "", "", "", "", "2018-02-09 19:59:19", "2018-02-09 19:59:19", "4", "0", "1", "", "", "0", "48");
INSERT INTO `wp_comments` VALUES("344", "306", "admin", "midiyaweb@gmail.com", "", "77.77.78.200", "2018-02-15 13:22:20", "2018-02-15 13:22:20", "بسیار", "0", "1", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.167 Safari/537.36", "", "31", "1");
INSERT INTO `wp_comments` VALUES("345", "306", "admin", "midiyaweb@gmail.com", "", "77.77.78.200", "2018-02-15 13:24:37", "2018-02-15 13:24:37", "خیلی", "0", "1", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.167 Safari/537.36", "", "344", "1");
INSERT INTO `wp_comments` VALUES("442", "102", "", "", "", "", "2019-06-25 09:06:16", "2019-06-25 09:06:16", "یسبسیب", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("443", "100", "", "", "", "", "2019-06-25 09:06:18", "2019-06-25 09:06:18", "2", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("444", "49", "", "", "", "", "2019-06-25 09:06:20", "2019-06-25 09:06:20", "4", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("445", "1763", "", "", "", "", "2019-06-25 09:06:22", "2019-06-25 09:06:22", "3", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("446", "80", "", "", "", "", "2019-06-25 09:06:23", "2019-06-25 09:06:23", "2", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("447", "37", "", "", "", "", "2019-06-25 09:06:25", "2019-06-25 09:06:25", "یبیبی", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("477", "3320", "ووکامرس", "", "", "", "2019-08-21 14:47:34", "2019-08-21 14:47:34", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>ارسال api الزامی می باشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("478", "3320", "ووکامرس", "", "", "", "2019-08-21 14:47:41", "2019-08-21 14:47:41", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>ارسال api الزامی می باشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("479", "3320", "ووکامرس", "", "", "", "2019-08-21 14:47:49", "2019-08-21 14:47:49", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>ارسال api الزامی می باشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("480", "3320", "ووکامرس", "", "", "", "2019-08-21 16:43:21", "2019-08-21 16:43:21", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "wplms", "a5d6a6ff96c7c8407294_20191031161257", "23", "2019-10-31 16:16:45", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-10-31 16:12:57\";s:7:\"Version\";s:6:\"1.3.22\";s:9:\"VersionWP\";s:5:\"5.2.4\";s:9:\"VersionDB\";s:7:\"10.2.23\";s:10:\"VersionPHP\";s:6:\"5.6.40\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:5:\"wplms\";s:4:\"Hash\";s:35:\"a5d6a6ff96c7c8407294_20191031161257\";s:8:\"NameHash\";s:41:\"wplms_a5d6a6ff96c7c8407294_20191031161257\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:77:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms/wp-snapshots/tmp\";s:8:\"StoreURL\";s:46:\"http://adourasoft.com/demo/wplms/wp-snapshots/\";s:8:\"ScanFile\";s:51:\"wplms_a5d6a6ff96c7c8407294_20191031161257_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"23.1\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:53:\"wplms_a5d6a6ff96c7c8407294_20191031161257_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:60:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-10-31 16:12:57\";s:7:\"Version\";s:6:\"1.3.22\";s:9:\"VersionWP\";s:5:\"5.2.4\";s:9:\"VersionDB\";s:7:\"10.2.23\";s:10:\"VersionPHP\";s:6:\"5.6.40\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:5:\"wplms\";s:4:\"Hash\";s:35:\"a5d6a6ff96c7c8407294_20191031161257\";s:8:\"NameHash\";s:41:\"wplms_a5d6a6ff96c7c8407294_20191031161257\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:77:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms/wp-snapshots/tmp\";s:8:\"StoreURL\";s:46:\"http://adourasoft.com/demo/wplms/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:55:\"wplms_a5d6a6ff96c7c8407294_20191031161257_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:54:\"wplms_a5d6a6ff96c7c8407294_20191031161257_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:19:{s:14:\"wp_bp_activity\";s:1:\"2\";s:19:\"wp_bp_activity_meta\";s:1:\"0\";s:13:\"wp_bp_friends\";s:1:\"0\";s:12:\"wp_bp_groups\";s:1:\"2\";s:22:\"wp_bp_groups_groupmeta\";s:1:\"6\";s:20:\"wp_bp_groups_members\";s:1:\"2\";s:17:\"wp_bp_invitations\";s:1:\"0\";s:23:\"wp_bp_messages_messages\";s:1:\"7\";s:19:\"wp_bp_messages_meta\";s:1:\"0\";s:22:\"wp_bp_messages_notices\";s:1:\"0\";s:25:\"wp_bp_messages_recipients\";s:2:\"14\";s:19:\"wp_bp_notifications\";s:1:\"0\";s:24:\"wp_bp_notifications_meta\";s:1:\"0\";s:19:\"wp_bp_xprofile_data\";s:1:\"2\";s:21:\"wp_bp_xprofile_fields\";s:1:\"1\";s:21:\"wp_bp_xprofile_groups\";s:1:\"1\";s:19:\"wp_bp_xprofile_meta\";s:1:\"1\";s:14:\"wp_commentmeta\";s:2:\"23\";s:11:\"wp_comments\";s:2:\"26\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:132:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms/wp-snapshots/tmp/wplms_a5d6a6ff96c7c8407294_20191031161257_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:69:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms/wp-admin\";i:1;s:79:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms/wp-content/uploads\";i:2;s:81:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms/wp-content/languages\";i:3;s:78:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms/wp-content/themes\";i:4;s:72:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:60:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms\";i:1;s:71:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms/wp-content\";}}s:9:\"Installer\";r:86;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:148;}");

/* INSERT TABLE DATA: wp_layerslider */
INSERT INTO `wp_layerslider` VALUES("3", "1", "Aboutslider", "", "{\"properties\":{\"title\":\"Aboutslider\",\"slug\":\"\",\"sliderVersion\":\"6.1.0\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"fullwidth\",\"width\":\"1080\",\"height\":300,\"maxwidth\":\"1080\",\"responsiveunder\":\"1080\",\"fullSizeMode\":\"normal\",\"fitScreenWidth\":false,\"allowFullscreen\":false,\"maxRatio\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"\",\"hideover\":\"\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":true,\"keybnav\":true,\"touchnav\":true,\"playByScrollSpeed\":\"1\",\"loops\":\"0\",\"forceloopnum\":true,\"skin\":\"v5\",\"sliderfadeinduration\":\"350\",\"sliderstyle\":\"margin-bottom: 0px;\",\"backgroundcolor\":\"\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"auto\",\"navprevnext\":true,\"navstartstop\":true,\"navbuttons\":true,\"hoverprevnext\":true,\"circletimer\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":true,\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"slideBGSize\":\"auto\",\"slideBGPosition\":\"50% 50%\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":true,\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"responsive\":true,\"animatefirstlayer\":true,\"imgpreload\":true,\"lazyload\":true,\"cbinit\":\"function(element) {\\r\\n\\r\\n}\",\"cbstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbpause\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbprev\":\"function(data) {\\r\\n\\r\\n}\",\"cbnext\":\"function(data) {\\r\\n\\r\\n}\",\"undefined\":true},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/themes\\/wplms\\/setup\\/data\\/uploads\\/abtbg.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"deeplink\":\"\",\"skip\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"id\":\"\",\"backgroundThumb\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/themes\\/wplms\\/setup\\/data\\/uploads\\/abtbg.jpg\",\"post_content\":false},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"media\":\"text\",\"type\":\"h3\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0632\\u06cc\\u0631 \\u0646\\u0638\\u0631 \\u0628\\u0647\\u062a\\u0631\\u06cc\\u0646 \\u0627\\u0633\\u0627\\u062a\\u06cc\\u062f \\u0622\\u0645\\u0648\\u0632\\u0634 \\u0628\\u0628\\u06cc\\u0646\\u06cc\\u062f\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInSine\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"25\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"25\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Oswald\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"32px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"rgba(196, 45, 15, 0.81)\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"86px\\\\\\\"}\",\"style\":\"font-weight:400;border-radius:2px;text-transform:uppercase;letter-spacing:2px;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false},{\"subtitle\":\"Layer #2\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u062f\\u0631\\u062f\\u0648\\u0631\\u0647 \\u0647\\u0627\\u06cc \\u0645\\u062c\\u0627\\u0632\\u06cc \\u0634\\u0631\\u06a9\\u062a \\u06a9\\u0646\\u06cc\\u062f \\u0648 \\u0645\\u062f\\u0627\\u0644 \\u0648 \\u06af\\u0648\\u0627\\u0647\\u06cc \\u0646\\u0627\\u0645\\u0647 \\u062f\\u0631\\u06cc\\u0627\\u0641\\u062a \\u06a9\\u0646\\u06cc\\u062f\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInSine\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Oswald\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#943712\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"129px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"93px\\\\\\\"}\",\"style\":\"text-transform:uppercase;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false},{\"subtitle\":\"Layer #3\",\"media\":\"img\",\"type\":\"p\",\"imageId\":2672,\"image\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/uploads\\/layerslider\\/Aboutslider\\/3.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInCubic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"715px\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/uploads\\/layerslider\\/Aboutslider\\/3.png\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false},{\"subtitle\":\"Layer #4\",\"media\":\"img\",\"type\":\"p\",\"imageId\":2673,\"image\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/uploads\\/layerslider\\/Aboutslider\\/4.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInExpo\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"21px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"877px\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/uploads\\/layerslider\\/Aboutslider\\/4.png\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false},{\"subtitle\":\"Layer #5\",\"media\":\"img\",\"type\":\"p\",\"imageId\":2671,\"image\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/uploads\\/layerslider\\/Aboutslider\\/1.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInSine\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"150px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"799px\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/uploads\\/layerslider\\/Aboutslider\\/1.png\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false}],\"meta\":{\"activeLayers\":[0],\"undoStackIndex\":21},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"inherit\"},\"redo\":{\"bgsize\":\"cover\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"cover\"},\"redo\":{\"bgsize\":\"contain\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"contain\"},\"redo\":{\"bgsize\":\"100% 100%\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"100% 100%\"},\"redo\":{\"bgsize\":\"auto\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"auto\"},\"redo\":{\"bgsize\":\"cover\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"cover\"},\"redo\":{\"bgsize\":\"auto\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"auto\"},\"redo\":{\"bgsize\":\"contain\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"contain\"},\"redo\":{\"bgsize\":\"auto\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"auto\"},\"redo\":{\"bgsize\":\"inherit\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"inherit\"},\"redo\":{\"bgsize\":\"auto\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"auto\"},\"redo\":{\"bgsize\":\"cover\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"cover\"},\"redo\":{\"bgsize\":\"contain\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"contain\"},\"redo\":{\"bgsize\":\"auto\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"auto\"},\"redo\":{\"bgsize\":\"cover\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"cover\"},\"redo\":{\"bgsize\":\"contain\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"contain\"},\"redo\":{\"bgsize\":\"inherit\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"inherit\"},\"redo\":{\"bgsize\":\"auto\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"auto\"},\"redo\":{\"bgsize\":\"inherit\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgposition\":\"inherit\"},\"redo\":{\"bgposition\":\"50% 50%\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"inherit\"},\"redo\":{\"bgsize\":\"cover\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"cover\"},\"redo\":{\"bgsize\":\"inherit\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgposition\":\"50% 50%\"},\"redo\":{\"bgposition\":\"inherit\"}}}]}]}", "1484925706", "1484928625", "0", "0", "0", "0", "0", NULL, "0");
INSERT INTO `wp_layerslider` VALUES("4", "1", "homepage slider", "", "{\"properties\":{\"title\":\"homepage slider\",\"slug\":\"\",\"sliderVersion\":\"6.8.4\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"fullwidth\",\"width\":1170,\"height\":480,\"maxwidth\":\"1600\",\"responsiveunder\":\"1170\",\"fullSizeMode\":\"normal\",\"fitScreenWidth\":true,\"allowFullscreen\":true,\"maxRatio\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"\",\"hideover\":\"\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":true,\"keybnav\":true,\"touchnav\":true,\"playByScrollSpeed\":\"1\",\"loops\":\"0\",\"forceloopnum\":true,\"skin\":\"v5\",\"sliderfadeinduration\":\"350\",\"sliderclass\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"backgroundcolor\":\"\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"auto\",\"navprevnext\":true,\"navstartstop\":true,\"navbuttons\":true,\"hoverprevnext\":true,\"circletimer\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":true,\"rememberUnmuteState\":true,\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"popupPositionHorizontal\":\"center\",\"popupPositionVertical\":\"middle\",\"popupWidth\":\"640\",\"popupHeight\":\"360\",\"popupDistanceLeft\":\"10\",\"popupDistanceRight\":\"10\",\"popupDistanceTop\":\"10\",\"popupDistanceBottom\":\"10\",\"popupShowOnTimeout\":\"\",\"popupShowOnIdle\":\"\",\"popupShowOnScroll\":\"\",\"popupShowOnClick\":\"\",\"popupCloseOnTimeout\":\"\",\"popupCloseOnScroll\":\"\",\"popup_repeat\":true,\"popup_repeat_days\":\"\",\"popupShowOnce\":true,\"popup_pages_custom\":\"\",\"popup_pages_exclude\":\"\",\"popup_roles_administrator\":true,\"popup_roles_editor\":true,\"popup_roles_author\":true,\"popup_roles_contributor\":true,\"popup_roles_subscriber\":true,\"popup_roles_visitor\":true,\"popupTransitionIn\":\"fade\",\"popupDurationIn\":\"1000\",\"popupDelayIn\":\"200\",\"popupTransitionOut\":\"fade\",\"popupDurationOut\":\"500\",\"popupResetOnClose\":\"slide\",\"popupShowCloseButton\":true,\"popupCloseButtonStyle\":\"\",\"popupOverlayClickToClose\":true,\"popupOverlayBackground\":\"rgba(0,0,0,.85)\",\"popupOverlayTransitionIn\":\"fade\",\"popupOverlayDurationIn\":\"400\",\"popupOverlayTransitionOut\":\"fade\",\"popupOverlayDurationOut\":\"400\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"slideBGSize\":\"cover\",\"slideBGPosition\":\"50% 50%\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":true,\"preferBlendMode\":\"disabled\",\"previewId\":\"\",\"preview\":\"\",\"post_type\":[\"popups\"],\"post_categories\":[\"16\"],\"post_tags\":[\"28\"],\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"responsive\":true,\"forceresponsive\":true,\"animatefirstlayer\":true,\"imgpreload\":true,\"lazyload\":true,\"cbinit\":\"function(element) {\\r\\n\\r\\n}\",\"cbstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbpause\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbprev\":\"function(data) {\\r\\n\\r\\n}\",\"cbnext\":\"function(data) {\\r\\n\\r\\n}\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/themes\\/wplms\\/setup\\/data\\/uploads\\/s3.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"6000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"id\":\"\",\"backgroundThumb\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/themes\\/wplms\\/setup\\/data\\/uploads\\/s3.jpg\",\"customProperties\":[],\"post_content\":false},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"media\":\"text\",\"type\":\"h2\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0633\\u06cc\\u0633\\u062a\\u0645 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0622\\u0645\\u0648\\u0632\\u0634\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"32\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#FFFfff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"rgba(35, 44, 46, 0.75)\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"2px\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"112px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"477px\\\\\\\"}\",\"style\":\"font-weight:700; letter-spacing:2px;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"uuid\":\"4cfc9691-f084-48d2-acbb-b2d10d9c5f7f\"},{\"subtitle\":\"Layer #2 copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0628\\u0631\\u0627\\u06cc \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% bottom 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"30\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"30\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#FFF\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"49px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"706px\\\\\\\"}\",\"style\":\"font-weight:800;letter-spacing:1px;text-transform:uppercase;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"uuid\":\"96da5e79-1c7c-4083-a6aa-978e57b3e9d6\"},{\"subtitle\":\"Layer #2\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\".\\u062f\\u0648\\u0631\\u0647 \\u0647\\u0627\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u062c\\u0627\\u062f \\u0648 \\u0628\\u0647 \\u0635\\u0648\\u0631\\u062a \\u0622\\u0646\\u0644\\u0627\\u06cc\\u0646 \\u0628\\u0641\\u0631\\u0648\\u0634 \\u0628\\u0631\\u0633\\u0627\\u0646\\u06cc\\u062f<br \\/>\\n\\u0627\\u06cc\\u0646 \\u062a\\u0646\\u0647\\u0627 \\u06cc\\u06a9 \\u0642\\u0627\\u0644\\u0628 \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633 \\u0646\\u06cc\\u0633\\u062a.\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"30\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"30\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"18\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#FFF\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"173px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"416px\\\\\\\",\\\\\\\"text-align\\\\\\\":\\\\\\\"right\\\\\\\"}\",\"style\":\"font-weight:600;text-transform:uppercase;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"uuid\":\"e766c136-c33f-411e-93d6-c7ae7a9ac4d5\"},{\"subtitle\":\"Layer #3\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0628\\u06cc\\u0634\\u062a\\u0631 \\u0628\\u062f\\u0627\\u0646\\u06cc\\u062f\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"15\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"15\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"14\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#FFF\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#000000\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"2px\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"266px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"662px\\\\\\\"}\",\"style\":\"text-transform:uppercase;font-weight:600;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"uuid\":\"126a48b3-5fec-4968-845c-5941030cda68\"},{\"subtitle\":\"Layer #4\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0622\\u063a\\u0627\\u0632 \\u06a9\\u0646\\u06cc\\u062f\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"15\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"15\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"14\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#000\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#fff\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"266px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"774px\\\\\\\"}\",\"style\":\"text-transform:uppercase;font-weight:600;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"uuid\":\"8ae2a777-5e05-4328-9fa7-c51c9c07c106\"}],\"meta\":{\"undoStackIndex\":5,\"activeLayers\":[3]},\"history\":[{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"447px\",\"top\":\"64px\"},\"redo\":{\"left\":\"706px\",\"top\":\"49px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"446px\",\"top\":\"170px\"},\"redo\":{\"left\":\"416px\",\"top\":\"173px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"604px\",\"top\":\"268px\"},\"redo\":{\"left\":\"774px\",\"top\":\"264px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"472px\",\"top\":\"267px\"},\"redo\":{\"left\":\"662px\",\"top\":\"266px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"text-align\":\"\"},\"redo\":{\"text-align\":\"right\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"774px\",\"top\":\"264px\"},\"redo\":{\"left\":\"774px\",\"top\":\"266px\"}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/themes\\/wplms\\/setup\\/data\\/uploads\\/s2.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"6000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\",\"backgroundThumb\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/themes\\/wplms\\/setup\\/data\\/uploads\\/s2.jpg\",\"post_content\":false},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"media\":\"text\",\"type\":\"h3\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u062f\\u0648\\u0631\\u0647 \\u0647\\u0627\\u060c \\u0645\\u0627\\u0698\\u0648\\u0644 \\u0647\\u0627\\u060c \\u0648\\u0627\\u062d\\u062f\\u0647\\u0627 \\u0648 \\u0622\\u0632\\u0645\\u0648\\u0646 \\u0647\\u0627\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u062c\\u0627\\u062f \\u06a9\\u0646\\u06cc\\u062f\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutElastic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#FFF\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"rgba(49, 59, 61, 0.80)\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"77px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"68px\\\\\\\"}\",\"style\":\"font-weight:600;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"e9b77186-ac9a-49f0-9c7e-ffaaa1bc6408\"},{\"subtitle\":\"Layer #2\",\"media\":\"text\",\"type\":\"h3\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0622\\u0632\\u0645\\u0648\\u0646 \\u0647\\u0627 \\u0631\\u0627 \\u0628\\u0647 \\u0635\\u0648\\u0631\\u062a \\u062f\\u0633\\u062a\\u06cc \\u06cc\\u0627 \\u062e\\u0648\\u062f\\u06a9\\u0627\\u0631 \\u0627\\u0631\\u0632\\u06cc\\u0627\\u0628\\u06cc \\u06a9\\u0646\\u06cc\\u062f\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutElastic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#FFF\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"rgba(49, 59, 61, 0.80)\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"134px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"68px\\\\\\\"}\",\"style\":\"font-weight:600;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"5c4b72df-2473-48e7-94b5-525ac7321652\"},{\"subtitle\":\"Layer #3\",\"media\":\"text\",\"type\":\"h3\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0646\\u062a\\u0627\\u06cc\\u062c\\u060c \\u0627\\u0639\\u0644\\u0627\\u0646 \\u0647\\u0627 \\u0648 \\u067e\\u06cc\\u0627\\u0645 \\u0647\\u0627 \\u0631\\u0627 \\u0628\\u0631\\u0631\\u0633\\u06cc \\u06a9\\u0646\\u06cc\\u062f\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutElastic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#FFF\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"rgba(49, 59, 61, 0.80)\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"189px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"67px\\\\\\\"}\",\"style\":\"font-weight:600;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"750fa321-26b5-4765-b942-63d24016a838\"},{\"subtitle\":\"Layer #4\",\"media\":\"text\",\"type\":\"h3\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0645\\u062f\\u0627\\u0644 \\u0647\\u0627 \\u0648 \\u06af\\u0648\\u0627\\u0647\\u06cc \\u0646\\u0627\\u0645\\u0647 \\u0647\\u0627 \\u0631\\u0627 \\u0628\\u0631\\u0627\\u06cc \\u062f\\u0648\\u0631\\u0647 \\u0647\\u0627 \\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutElastic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#FFF\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"rgba(49, 59, 61, 0.80)\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"245px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"66px\\\\\\\"}\",\"style\":\"font-weight:600;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"617319f8-0a0e-44d2-a5c2-ede0655f6809\"},{\"subtitle\":\"Layer #5\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u062f\\u0648\\u0631\\u0647 \\u0647\\u0627 \\u0631\\u0627 \\u0628\\u0647 \\u0635\\u0648\\u0631\\u062a \\u062a\\u06a9\\u06cc\\u060c \\u06af\\u0631\\u0648\\u0647\\u06cc \\u0648 \\u06cc\\u0627 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9\\u06cc \\u0628\\u0641\\u0631\\u0648\\u0634 \\u0628\\u0631\\u0633\\u0627\\u0646\\u06cc\\u062f\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutElastic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#FFF\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"rgba(49, 59, 61, 0.80)\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"303px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"67px\\\\\\\"}\",\"style\":\"font-weight:600;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"572abde3-1de1-4c7e-9a75-ef104d58e9ff\"}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/themes\\/wplms\\/setup\\/data\\/uploads\\/s1.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"6500\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\",\"backgroundThumb\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/themes\\/wplms\\/setup\\/data\\/uploads\\/s1.jpg\",\"post_content\":false},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"media\":\"text\",\"type\":\"h2\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u067e\\u0644\\u0627\\u06af\\u06cc\\u0646 \\u0647\\u0627\\u06cc \\u0642\\u062f\\u0631\\u062a\\u0645\\u0646\\u062f \\u062f\\u0631 \\u06cc\\u06a9 \\u0642\\u0627\\u0644\\u0628\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutBounce\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#000\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"rgba(255, 255, 255, 0.60)\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"117px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"287px\\\\\\\"}\",\"style\":\"font-weight:800;text-transform:uppercase;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"7ee1598a-3294-43e6-81e1-197a9bc2d3f4\"},{\"subtitle\":\"Layer #2\",\"media\":\"img\",\"type\":\"p\",\"imageId\":2675,\"image\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/uploads\\/layerslider\\/homepage-slider\\/buddy.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"00\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"194px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"190px\\\\\\\"}\",\"style\":\"opacity:0.8;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/uploads\\/layerslider\\/homepage-slider\\/buddy.png\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"a9d9da0d-3a84-4e60-a931-fee6e204e985\"},{\"subtitle\":\"Layer #3\",\"media\":\"img\",\"type\":\"p\",\"imageId\":2674,\"image\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/uploads\\/layerslider\\/homepage-slider\\/bbpress.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"195px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"381px\\\\\\\"}\",\"style\":\"opacity:0.8;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/uploads\\/layerslider\\/homepage-slider\\/bbpress.png\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"aaaf2512-7383-430d-877f-fed63053ed5b\"},{\"subtitle\":\"Layer #4\",\"media\":\"img\",\"type\":\"p\",\"imageId\":2677,\"image\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/uploads\\/layerslider\\/homepage-slider\\/woo.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"197px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"606px\\\\\\\"}\",\"style\":\"opacity:0.8;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/uploads\\/layerslider\\/homepage-slider\\/woo.png\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"85c36708-a92e-46c7-b9cc-98beeb94da3f\"},{\"subtitle\":\"Layer #5\",\"media\":\"img\",\"type\":\"p\",\"imageId\":2676,\"image\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/uploads\\/layerslider\\/homepage-slider\\/vibecourse.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"193px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"802px\\\\\\\"}\",\"style\":\"opacity:0.8;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"http:\\/\\/adourasoft.com\\/demo\\/wplms\\/wp-content\\/uploads\\/layerslider\\/homepage-slider\\/vibecourse.png\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"d42fa968-d8ed-40ba-8f32-f1d6e70f6cab\"},{\"subtitle\":\"Layer #6\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0622\\u063a\\u0627\\u0632 \\u06a9\\u0646\\u06cc\\u062f\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"5500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"14\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"000\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#FFF\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"370px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"487px\\\\\\\"}\",\"style\":\"font-weight:600;text-transform:uppercase;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"aad68fd9-ed83-4a90-8a37-6820afb1b8bb\"}]}]}", "1484925708", "1565272562", "0", "0", "0", "0", "0", NULL, "0");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://adourasoft.com/demo/wplms", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://adourasoft.com/demo/wplms", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "wplms", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "یک سایت دیگر با وردپرس فارسی", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "adourasoft@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "0", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("30", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("31", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("32", "active_plugins", "a:20:{i:0;s:27:\"LayerSlider/layerslider.php\";i:1;s:19:\"bbpress/bbpress.php\";i:2;s:39:\"bp-social-connect/bp_social_connect.php\";i:3;s:25:\"buddydrive/buddydrive.php\";i:4;s:24:\"buddypress/bp-loader.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:19:\"eventON/eventon.php\";i:7;s:27:\"js_composer/js_composer.php\";i:8;s:43:\"persian-woocommerce/woocommerce-persian.php\";i:9;s:23:\"revslider/revslider.php\";i:10;s:29:\"vibe-course-module/loader.php\";i:11;s:37:\"vibe-customtypes/vibe-customtypes.php\";i:12;s:35:\"vibe-shortcodes/vibe-shortcodes.php\";i:13;s:27:\"woocommerce/woocommerce.php\";i:14;s:39:\"wplms-assignments/wplms-assignments.php\";i:15;s:37:\"wplms-customizer/wplms-customizer.php\";i:16;s:35:\"wplms-dashboard/wplms-dashboard.php\";i:17;s:31:\"wplms-eventon/wplms-eventon.php\";i:18;s:35:\"wplms-front-end/wplms-front-end.php\";i:19;s:41:\"wplms_vc_templates/wplms_vc_templates.php\";}", "yes");
INSERT INTO `wp_options` VALUES("33", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("34", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("35", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("36", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("37", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("38", "recently_edited", "a:4:{i:0;s:92:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms/wp-content/themes/wplms/rtl.css\";i:1;s:108:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms/wp-content/themes/wplms/admin-rtl-midiyaweb.css\";i:2;s:94:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms/wp-content/themes/wplms/style.css\";i:3;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("39", "template", "wplms", "yes");
INSERT INTO `wp_options` VALUES("40", "stylesheet", "wplms", "yes");
INSERT INTO `wp_options` VALUES("41", "comment_whitelist", "", "yes");
INSERT INTO `wp_options` VALUES("42", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "1", "yes");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("46", "default_role", "student", "yes");
INSERT INTO `wp_options` VALUES("47", "db_version", "44719", "yes");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("50", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("72", "page_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("75", "comment_order", "desc", "yes");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:4:{i:2;a:3:{s:5:\"title\";s:17:\"درباره ما\";s:4:\"text\";s:449:\"<div class=\"textwidget\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.\r\n\r\n<h4>چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.</h4></div>\";s:6:\"filter\";b:0;}i:3;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:87:\"<img src=\"http://adourasoft.com/demo/wplms/wp-content/uploads/2016/05/banner-home.png\">\";s:6:\"filter\";b:0;}i:4;a:3:{s:5:\"title\";s:10:\"اعلان\";s:4:\"text\";s:57:\"این برخی اعلان ها در مگامنو است.\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:2:{s:27:\"LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";s:19:\"arforms/arforms.php\";s:15:\"pluginUninstall\";}", "no");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "1330", "yes");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "1427", "yes");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("87", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("90", "initial_db_version", "35700", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_user_roles", "a:14:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:175:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:14:\"manage_eventon\";b:1;s:15:\"publish_eventon\";b:1;s:12:\"edit_eventon\";b:1;s:12:\"read_eventon\";b:1;s:14:\"delete_eventon\";b:1;s:16:\"publish_eventons\";b:1;s:13:\"edit_eventons\";b:1;s:20:\"edit_others_eventons\";b:1;s:21:\"read_private_eventons\";b:1;s:15:\"delete_eventons\";b:1;s:23:\"delete_private_eventons\";b:1;s:25:\"delete_published_eventons\";b:1;s:22:\"delete_others_eventons\";b:1;s:21:\"edit_private_eventons\";b:1;s:23:\"edit_published_eventons\";b:1;s:20:\"manage_eventon_terms\";b:1;s:18:\"edit_eventon_terms\";b:1;s:20:\"delete_eventon_terms\";b:1;s:20:\"assign_eventon_terms\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:32:\"vc_access_rules_post_types/forum\";b:1;s:32:\"vc_access_rules_post_types/topic\";b:1;s:32:\"vc_access_rules_post_types/reply\";b:1;s:38:\"vc_access_rules_post_types/ajde_events\";b:1;s:33:\"vc_access_rules_post_types/course\";b:1;s:31:\"vc_access_rules_post_types/unit\";b:1;s:31:\"vc_access_rules_post_types/quiz\";b:1;s:35:\"vc_access_rules_post_types/question\";b:1;s:43:\"vc_access_rules_post_types/wplms-assignment\";b:1;s:38:\"vc_access_rules_post_types/certificate\";b:1;s:34:\"vc_access_rules_post_types/product\";b:1;s:39:\"vc_access_rules_post_types/testimonials\";b:1;s:33:\"vc_access_rules_post_types/popups\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:24:\"vc_access_rules_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:13:\"read_eventons\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:57:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:32:\"vc_access_rules_post_types/forum\";b:1;s:32:\"vc_access_rules_post_types/topic\";b:1;s:32:\"vc_access_rules_post_types/reply\";b:1;s:38:\"vc_access_rules_post_types/ajde_events\";b:1;s:33:\"vc_access_rules_post_types/course\";b:1;s:31:\"vc_access_rules_post_types/unit\";b:1;s:31:\"vc_access_rules_post_types/quiz\";b:1;s:35:\"vc_access_rules_post_types/question\";b:1;s:43:\"vc_access_rules_post_types/wplms-assignment\";b:1;s:38:\"vc_access_rules_post_types/certificate\";b:1;s:34:\"vc_access_rules_post_types/product\";b:1;s:39:\"vc_access_rules_post_types/testimonials\";b:1;s:33:\"vc_access_rules_post_types/popups\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:18:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:13:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:7:\"student\";a:2:{s:4:\"name\";s:7:\"Student\";s:12:\"capabilities\";a:1:{i:0;s:4:\"read\";}}s:10:\"instructor\";a:2:{s:4:\"name\";s:10:\"Instructor\";s:12:\"capabilities\";a:37:{s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:10:\"edit_posts\";b:1;s:17:\"manage_categories\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:7:\"level_1\";b:1;s:15:\"publish_eventon\";b:1;s:12:\"edit_eventon\";b:1;s:12:\"read_eventon\";b:1;s:14:\"delete_eventon\";b:1;s:16:\"publish_eventons\";b:1;s:13:\"edit_eventons\";b:1;s:20:\"edit_others_eventons\";b:1;s:21:\"read_private_eventons\";b:1;s:15:\"delete_eventons\";b:1;s:23:\"delete_private_eventons\";b:1;s:25:\"delete_published_eventons\";b:1;s:22:\"delete_others_eventons\";b:1;s:21:\"edit_private_eventons\";b:1;s:23:\"edit_published_eventons\";b:1;s:20:\"manage_eventon_terms\";b:1;s:18:\"edit_eventon_terms\";b:1;s:20:\"delete_eventon_terms\";b:1;s:20:\"assign_eventon_terms\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:13:\"read_eventons\";b:1;}}s:13:\"bbp_keymaster\";a:2:{s:4:\"name\";s:9:\"Keymaster\";s:12:\"capabilities\";a:29:{s:9:\"keep_gate\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:1;s:8:\"throttle\";b:1;s:10:\"view_trash\";b:1;s:14:\"publish_forums\";b:1;s:11:\"edit_forums\";b:1;s:18:\"edit_others_forums\";b:1;s:13:\"delete_forums\";b:1;s:20:\"delete_others_forums\";b:1;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:1;s:13:\"delete_topics\";b:1;s:20:\"delete_others_topics\";b:1;s:19:\"read_private_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:1;s:14:\"delete_replies\";b:1;s:21:\"delete_others_replies\";b:1;s:20:\"read_private_replies\";b:1;s:17:\"manage_topic_tags\";b:1;s:15:\"edit_topic_tags\";b:1;s:17:\"delete_topic_tags\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:13:\"bbp_spectator\";a:2:{s:4:\"name\";s:9:\"Spectator\";s:12:\"capabilities\";a:1:{s:8:\"spectate\";b:1;}}s:11:\"bbp_blocked\";a:2:{s:4:\"name\";s:7:\"Blocked\";s:12:\"capabilities\";a:28:{s:8:\"spectate\";b:0;s:11:\"participate\";b:0;s:8:\"moderate\";b:0;s:8:\"throttle\";b:0;s:10:\"view_trash\";b:0;s:14:\"publish_forums\";b:0;s:11:\"edit_forums\";b:0;s:18:\"edit_others_forums\";b:0;s:13:\"delete_forums\";b:0;s:20:\"delete_others_forums\";b:0;s:19:\"read_private_forums\";b:0;s:18:\"read_hidden_forums\";b:0;s:14:\"publish_topics\";b:0;s:11:\"edit_topics\";b:0;s:18:\"edit_others_topics\";b:0;s:13:\"delete_topics\";b:0;s:20:\"delete_others_topics\";b:0;s:19:\"read_private_topics\";b:0;s:15:\"publish_replies\";b:0;s:12:\"edit_replies\";b:0;s:19:\"edit_others_replies\";b:0;s:14:\"delete_replies\";b:0;s:21:\"delete_others_replies\";b:0;s:20:\"read_private_replies\";b:0;s:17:\"manage_topic_tags\";b:0;s:15:\"edit_topic_tags\";b:0;s:17:\"delete_topic_tags\";b:0;s:17:\"assign_topic_tags\";b:0;}}s:13:\"bbp_moderator\";a:2:{s:4:\"name\";s:9:\"Moderator\";s:12:\"capabilities\";a:25:{s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:1;s:8:\"throttle\";b:1;s:10:\"view_trash\";b:1;s:14:\"publish_forums\";b:1;s:11:\"edit_forums\";b:1;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:1;s:13:\"delete_topics\";b:1;s:20:\"delete_others_topics\";b:1;s:19:\"read_private_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:1;s:14:\"delete_replies\";b:1;s:21:\"delete_others_replies\";b:1;s:20:\"read_private_replies\";b:1;s:17:\"manage_topic_tags\";b:1;s:15:\"edit_topic_tags\";b:1;s:17:\"delete_topic_tags\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:15:\"bbp_participant\";a:2:{s:4:\"name\";s:11:\"Participant\";s:12:\"capabilities\";a:8:{s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop Manager\";s:12:\"capabilities\";a:118:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("92", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("93", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "sidebars_widgets", "a:16:{s:19:\"wp_inactive_widgets\";a:13:{i:0;s:18:\"bp_course_widget-2\";i:1;s:18:\"bp_course_widget-3\";i:2;s:18:\"bp_course_widget-4\";i:3;s:18:\"bp_course_widget-5\";i:4;s:18:\"bp_course_widget-7\";i:5;s:18:\"bp_course_widget-8\";i:6;s:22:\"bp_instructor_widget-2\";i:7;s:25:\"bp_course_search_widget-2\";i:8;s:25:\"bp_course_search_widget-3\";i:9;s:24:\"bp_course_stats_widget-3\";i:10;s:24:\"bp_course_stats_widget-4\";i:11;s:25:\"bp_course_filter_widget-2\";i:12;s:33:\"woocommerce_layered_nav_filters-3\";}s:15:\"student_sidebar\";a:11:{i:0;s:18:\"wplms_dash_stats-1\";i:1;s:18:\"wplms_dash_stats-2\";i:2;s:18:\"wplms_dash_stats-3\";i:3;s:18:\"wplms_dash_stats-4\";i:4;s:21:\"wplms_student_stats-1\";i:5;s:23:\"wplms_course_progress-1\";i:6;s:26:\"wplms_dash_contact_users-1\";i:7;s:18:\"wplms_line_break-1\";i:8;s:18:\"wplms_dash_tasks-1\";i:9;s:17:\"wplms_dash_news-1\";i:10;s:34:\"bp_course_related_courses_widget-1\";}s:18:\"instructor_sidebar\";a:15:{i:0;s:29:\"wplms_instructor_dash_stats-1\";i:1;s:29:\"wplms_instructor_dash_stats-2\";i:2;s:29:\"wplms_instructor_dash_stats-3\";i:3;s:29:\"wplms_instructor_dash_stats-4\";i:4;s:29:\"wplms_instructor_dash_stats-5\";i:5;s:29:\"wplms_instructor_dash_stats-6\";i:6;s:29:\"wplms_instructor_dash_stats-7\";i:7;s:35:\"wplms_instructor_commission_stats-1\";i:8;s:24:\"wplms_instructor_stats-1\";i:9;s:26:\"wplms_dash_contact_users-2\";i:10;s:18:\"wplms_dash_tasks-2\";i:11;s:18:\"wplms_line_break-2\";i:12;s:21:\"wplms_dash_activity-1\";i:13;s:17:\"wplms_dash_news-2\";i:14;s:17:\"wplms_dash_text-1\";}s:11:\"mainsidebar\";a:5:{i:0;s:10:\"vibetabs-2\";i:1;s:8:\"search-2\";i:2;s:31:\"woocommerce_product_tag_cloud-4\";i:3;s:13:\"vibegallery-2\";i:4;s:24:\"bp_course_stats_widget-5\";}s:7:\"bbpress\";a:0:{}s:13:\"coursesidebar\";a:4:{i:0;s:31:\"woocommerce_product_tag_cloud-3\";i:1;s:22:\"bp_instructor_widget-3\";i:2;s:25:\"bp_course_search_widget-4\";i:3;s:18:\"bp_course_widget-9\";}s:13:\"searchsidebar\";a:1:{i:0;s:28:\"vibe_woocommerce_carousels-2\";}s:11:\"shopsidebar\";a:2:{i:0;s:26:\"woocommerce_price_filter-2\";i:1;s:28:\"vibe_woocommerce_carousels-3\";}s:14:\"productsidebar\";a:4:{i:0;s:24:\"vibe_course_categories-2\";i:1;s:32:\"woocommerce_product_categories-2\";i:2;s:22:\"woocommerce_products-2\";i:3;s:19:\"bp_course_widget-10\";}s:10:\"buddypress\";a:4:{i:0;s:24:\"vibe_course_categories-3\";i:1;s:25:\"bp_course_filter_widget-3\";i:2;s:25:\"bp_course_search_widget-5\";i:3;s:19:\"bp_course_widget-11\";}s:8:\"checkout\";a:0:{}s:16:\"topfootersidebar\";a:4:{i:0;s:6:\"text-2\";i:1;s:19:\"bp_course_widget-12\";i:2;s:19:\"bp_course_widget-13\";i:3;s:6:\"text-3\";}s:19:\"bottomfootersidebar\";a:4:{i:0;s:10:\"nav_menu-2\";i:1;s:21:\"vibecertificatecode-2\";i:2;s:31:\"woocommerce_product_tag_cloud-2\";i:3;s:28:\"bp_core_whos_online_widget-2\";}s:8:\"MegaMenu\";a:5:{i:0;s:10:\"nav_menu-7\";i:1;s:10:\"nav_menu-6\";i:2;s:10:\"nav_menu-5\";i:3;s:6:\"text-4\";i:4;s:24:\"bp_course_stats_widget-6\";}s:9:\"MegaMenu2\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_nav_menu", "a:5:{i:2;a:2:{s:5:\"title\";s:33:\"دسته بندی های دوره\";s:8:\"nav_menu\";i:61;}i:5;a:2:{s:5:\"title\";s:17:\"ویژگی ها 3\";s:8:\"nav_menu\";i:67;}i:7;a:2:{s:5:\"title\";s:17:\"ویژگی ها 1\";s:8:\"nav_menu\";i:65;}i:6;a:2:{s:5:\"title\";s:17:\"ویژگی ها 2\";s:8:\"nav_menu\";i:66;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "cron", "a:18:{i:1572538630;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1572539046;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1572540753;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1572542628;a:1:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1572553428;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1572560597;a:3:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1572560617;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1572566400;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1572567677;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1572609653;a:1:{s:22:\"evo_cron_daily_actions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1572609678;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1572609855;a:1:{s:21:\"evo_trash_past_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1572611623;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1572618228;a:1:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1572618238;a:1:{s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1572912000;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2635200;}}}i:1573129708;a:1:{s:17:\"evo_check_updates\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("136", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:19:\"midiyaweb@gmail.com\";s:7:\"version\";s:5:\"4.9.3\";s:9:\"timestamp\";i:1517887418;}", "no");
INSERT INTO `wp_options` VALUES("147", "theme_mods_twentysixteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1463610405;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("148", "current_theme", "WPLMS", "yes");
INSERT INTO `wp_options` VALUES("149", "theme_mods_wplms", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:4:{s:8:\"top-menu\";i:60;s:9:\"main-menu\";i:59;s:11:\"mobile-menu\";i:64;s:11:\"footer-menu\";i:63;}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("150", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("151", "widget_vibecarousel", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("152", "widget_vibetabs", "a:2:{i:2;a:13:{s:5:\"theme\";s:5:\"light\";s:9:\"show_tab1\";s:1:\"1\";s:10:\"title_tab1\";s:19:\"مطالب تازه\";s:10:\"style_tab1\";s:9:\"thumbnail\";s:8:\"num_tab1\";s:2:\"10\";s:9:\"show_tab2\";s:1:\"1\";s:10:\"title_tab2\";s:17:\"دیدگاه ها\";s:10:\"style_tab2\";s:9:\"thumbnail\";s:8:\"num_tab2\";s:1:\"5\";s:9:\"show_tab3\";s:1:\"1\";s:10:\"title_tab3\";s:13:\"دوره ها\";s:10:\"style_tab3\";s:7:\"courses\";s:8:\"num_tab3\";s:1:\"5\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("153", "widget_vibeposts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("154", "widget_vibegallery", "a:2:{i:2;a:4:{s:5:\"title\";s:19:\"گالری ویژه\";s:4:\"size\";s:6:\"medium\";s:3:\"ids\";s:0:\"\";s:7:\"columns\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("155", "widget_vibetestimonials", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("156", "widget_vibe_twitter_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("157", "widget_quick-flickr-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("158", "wplms", "a:103:{s:8:\"last_tab\";s:1:\"1\";s:8:\"username\";s:5:\"admin\";s:6:\"apikey\";s:6:\"550055\";s:4:\"logo\";s:79:\"http://adourasoft.com/demo/wplms/wp-content/themes/wplms/assets/images/logo.png\";s:11:\"mobile_logo\";s:79:\"http://adourasoft.com/demo/wplms/wp-content/themes/wplms/assets/images/logo.png\";s:8:\"alt_logo\";s:79:\"http://adourasoft.com/demo/wplms/wp-content/themes/wplms/assets/images/logo.png\";s:7:\"favicon\";s:82:\"http://adourasoft.com/demo/wplms/wp-content/themes/wplms/assets/images/favicon.png\";s:10:\"header_fix\";s:1:\"0\";s:13:\"course_search\";s:1:\"0\";s:17:\"headertop_content\";s:66:\"با ما تماس بگیرید 09189408346 | info@yourdomain.com\";s:14:\"header_content\";s:66:\"با ما تماس بگیرید 09189408346 | info@yourdomain.com\";s:8:\"sidebars\";a:1:{i:0;s:8:\"MegaMenu\";}s:14:\"events_sidebar\";s:11:\"mainsidebar\";s:14:\"default_avatar\";s:81:\"http://adourasoft.com/demo/wplms/wp-content/themes/wplms/assets/images/avatar.jpg\";s:17:\"hide_wp_admin_bar\";s:0:\"\";s:15:\"wp_admin_access\";s:0:\"\";s:11:\"loop_number\";s:1:\"5\";s:12:\"members_view\";s:1:\"1\";s:18:\"single_member_view\";s:1:\"1\";s:22:\"single_member_controls\";s:0:\"\";s:16:\"members_redirect\";s:0:\"\";s:13:\"activity_view\";s:1:\"0\";s:16:\"student_activity\";s:0:\"\";s:17:\"activity_redirect\";s:0:\"\";s:10:\"group_view\";s:1:\"0\";s:14:\"group_redirect\";s:0:\"\";s:12:\"group_create\";s:1:\"1\";s:11:\"blog_create\";s:1:\"1\";s:16:\"members_activity\";s:1:\"0\";s:12:\"activity_tab\";s:1:\"0\";s:10:\"groups_tab\";s:1:\"0\";s:10:\"forums_tab\";s:1:\"0\";s:19:\"activation_redirect\";s:2:\"23\";s:25:\"enable_groups_join_button\";s:1:\"0\";s:13:\"student_field\";s:8:\"مکان\";s:22:\"instructor_field_group\";s:10:\"استاد\";s:16:\"instructor_field\";s:8:\"تخصص\";s:18:\"social_field_group\";s:36:\"پروفایل های اجتماعی\";s:23:\"instructor_paypal_field\";s:0:\"\";s:16:\"instructor_about\";s:12:\"درباره\";s:30:\"enable_ajax_registration_login\";s:0:\"\";s:24:\"custom_registration_page\";s:0:\"\";s:16:\"take_course_page\";s:2:\"12\";s:13:\"create_course\";s:2:\"13\";s:13:\"unit_comments\";s:0:\"\";s:18:\"sync_student_count\";s:1:\"0\";s:15:\"nextunit_access\";s:1:\"0\";s:15:\"unit_media_lock\";s:1:\"0\";s:18:\"assignment_locking\";s:1:\"0\";s:18:\"course_progressbar\";s:1:\"0\";s:23:\"instructor_add_students\";s:1:\"0\";s:24:\"instructor_change_status\";s:1:\"0\";s:24:\"instructor_assign_badges\";s:1:\"0\";s:30:\"instructor_extend_subscription\";s:1:\"0\";s:26:\"instructor_content_privacy\";s:1:\"0\";s:16:\"stats_visibility\";s:1:\"0\";s:12:\"teacher_form\";s:2:\"22\";s:16:\"certificate_page\";s:2:\"16\";s:21:\"default_course_avatar\";s:0:\"\";s:33:\"course_duration_display_parameter\";s:1:\"0\";s:22:\"finished_course_access\";s:0:\"\";s:11:\"notes_style\";s:0:\"\";s:9:\"show_news\";s:0:\"\";s:5:\"level\";s:0:\"\";s:8:\"location\";s:0:\"\";s:7:\"linkage\";s:1:\"0\";s:29:\"redirect_course_cat_directory\";s:0:\"\";s:20:\"google_fonts_api_key\";s:0:\"\";s:18:\"top_footer_columns\";s:17:\"col-md-3 col-sm-6\";s:21:\"bottom_footer_columns\";s:17:\"col-md-3 col-sm-6\";s:11:\"footer_logo\";s:79:\"http://adourasoft.com/demo/wplms/wp-content/themes/wplms/assets/images/logo.png\";s:9:\"copyright\";s:65:\"تمامی حقوق برای میدیا  وب محفوظ است!\";s:18:\"footerbottom_right\";s:0:\"\";s:16:\"google_analytics\";s:0:\"\";s:17:\"social_icons_type\";s:0:\"\";s:19:\"show_social_tooltip\";s:1:\"1\";s:6:\"tincan\";s:1:\"0\";s:15:\"tincan_endpoint\";s:1:\"0\";s:11:\"tincan_user\";s:1:\"0\";s:11:\"tincan_pass\";s:1:\"0\";s:11:\"page_loader\";s:0:\"\";s:9:\"site_lock\";s:0:\"\";s:23:\"site_lock_home_page_url\";s:0:\"\";s:12:\"security_key\";s:12:\"W68flrv@*u0p\";s:15:\"default_archive\";s:0:\"\";s:14:\"excerpt_length\";s:2:\"20\";s:13:\"page_comments\";s:0:\"\";s:21:\"instructor_commission\";s:2:\"70\";s:15:\"direct_checkout\";s:1:\"0\";s:17:\"thankyou_redirect\";s:1:\"0\";s:17:\"remove_woo_fields\";s:1:\"0\";s:14:\"cache_duration\";s:1:\"0\";s:25:\"google_captcha_public_key\";s:0:\"\";s:26:\"google_captcha_private_key\";s:0:\"\";s:21:\"google_apikey_contact\";s:0:\"\";s:10:\"contact_ll\";s:18:\"43.730325,7.422155\";s:13:\"contact_style\";s:9:\"SATELLITE\";s:8:\"map_zoom\";s:2:\"17\";s:8:\"error404\";s:0:\"\";s:6:\"xmlrpc\";s:0:\"\";s:18:\"disable_versioning\";s:0:\"\";s:15:\"wp_login_screen\";s:0:\"\";s:7:\"credits\";s:21:\"جواد محمودی\";}", "yes");
INSERT INTO `wp_options` VALUES("159", "wplms_version", "3.9.6", "yes");
INSERT INTO `wp_options` VALUES("163", "google_webfonts", "", "no");
INSERT INTO `wp_options` VALUES("164", "bp-deactivated-components", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("165", "bb-config-location", "/home/adouraso/domains/adourasoft.com/public_html/demo/wplms/bb-config.php", "yes");
INSERT INTO `wp_options` VALUES("166", "bp-xprofile-base-group-name", "پایه", "yes");
INSERT INTO `wp_options` VALUES("167", "bp-xprofile-fullname-field-name", "نام", "yes");
INSERT INTO `wp_options` VALUES("168", "bp-blogs-first-install", "", "yes");
INSERT INTO `wp_options` VALUES("169", "bp-disable-profile-sync", "0", "yes");
INSERT INTO `wp_options` VALUES("170", "hide-loggedout-adminbar", "1", "yes");
INSERT INTO `wp_options` VALUES("171", "bp-disable-avatar-uploads", "0", "yes");
INSERT INTO `wp_options` VALUES("172", "bp-disable-cover-image-uploads", "0", "yes");
INSERT INTO `wp_options` VALUES("173", "bp-disable-group-avatar-uploads", "0", "yes");
INSERT INTO `wp_options` VALUES("174", "bp-disable-group-cover-image-uploads", "0", "yes");
INSERT INTO `wp_options` VALUES("175", "bp-disable-account-deletion", "0", "yes");
INSERT INTO `wp_options` VALUES("176", "bp-disable-blogforum-comments", "0", "yes");
INSERT INTO `wp_options` VALUES("177", "_bp_theme_package_id", "legacy", "yes");
INSERT INTO `wp_options` VALUES("178", "bp_restrict_group_creation", "0", "yes");
INSERT INTO `wp_options` VALUES("179", "_bp_enable_akismet", "1", "yes");
INSERT INTO `wp_options` VALUES("180", "_bp_enable_heartbeat_refresh", "1", "yes");
INSERT INTO `wp_options` VALUES("181", "_bp_force_buddybar", "", "yes");
INSERT INTO `wp_options` VALUES("182", "_bp_retain_bp_default", "", "yes");
INSERT INTO `wp_options` VALUES("183", "widget_bp_core_login_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("184", "widget_bp_core_members_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("185", "widget_bp_core_whos_online_widget", "a:2:{i:2;a:2:{s:5:\"title\";s:26:\"چه کسی آنلاینه\";s:11:\"max_members\";s:2:\"15\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("186", "widget_bp_core_recently_active_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("187", "widget_bp_groups_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("188", "widget_bp_messages_sitewide_notices_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("194", "widget_wplms_course_codes", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("195", "widget_bp_course_widget", "a:12:{i:2;a:7:{s:5:\"title\";s:26:\"دوره های محبوب\";s:5:\"style\";s:5:\"list1\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:13:\"vibe_students\";s:5:\"order\";s:4:\"DESC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"3\";}i:3;a:7:{s:5:\"title\";s:29:\"پرامتیازترین ها\";s:5:\"style\";s:5:\"list1\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"3\";}i:4;a:7:{s:5:\"title\";s:8:\"دوره\";s:5:\"style\";s:4:\"list\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"5\";}i:5;a:7:{s:5:\"title\";s:26:\"دوره های محبوب\";s:5:\"style\";s:6:\"single\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"1\";}i:7;a:7:{s:5:\"title\";s:6:\"Course\";s:5:\"style\";s:6:\"single\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"5\";}i:8;a:7:{s:5:\"title\";s:8:\"دوره\";s:5:\"style\";s:8:\"carousel\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"5\";}i:9;a:7:{s:5:\"title\";s:26:\"دوره های محبوب\";s:5:\"style\";s:6:\"single\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"1\";}i:10;a:7:{s:5:\"title\";s:8:\"دوره\";s:5:\"style\";s:4:\"list\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"5\";}i:11;a:7:{s:5:\"title\";s:8:\"دوره\";s:5:\"style\";s:8:\"carousel\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"5\";}i:12;a:7:{s:5:\"title\";s:26:\"دوره های محبوب\";s:5:\"style\";s:5:\"list1\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:13:\"vibe_students\";s:5:\"order\";s:4:\"DESC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"3\";}i:13;a:7:{s:5:\"title\";s:29:\"پرامتیازترین ها\";s:5:\"style\";s:5:\"list1\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"3\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("196", "widget_bp_instructor_widget", "a:3:{i:2;a:3:{s:5:\"title\";s:23:\"جزییات استاد\";s:10:\"instructor\";s:1:\"1\";s:9:\"max_items\";s:1:\"5\";}i:3;a:3:{s:5:\"title\";s:23:\"جزییات استاد\";s:10:\"instructor\";s:1:\"1\";s:9:\"max_items\";s:1:\"5\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("197", "widget_bp_course_search_widget", "a:5:{i:2;a:5:{s:5:\"title\";s:27:\"جستجوی پیشرفته\";s:4:\"cats\";s:1:\"1\";s:11:\"instructors\";s:1:\"1\";s:8:\"location\";s:0:\"\";s:5:\"level\";s:0:\"\";}i:3;a:5:{s:5:\"title\";s:54:\"ابزارک جستجوی پیشرفته دوره ها\";s:4:\"cats\";s:1:\"1\";s:11:\"instructors\";s:1:\"1\";s:8:\"location\";s:0:\"\";s:5:\"level\";s:0:\"\";}i:4;a:5:{s:5:\"title\";s:54:\"ابزارک جستجوی پیشرفته دوره ها\";s:4:\"cats\";s:1:\"1\";s:11:\"instructors\";s:1:\"1\";s:8:\"location\";s:0:\"\";s:5:\"level\";s:0:\"\";}i:5;a:5:{s:5:\"title\";s:27:\"جستجوی پیشرفته\";s:4:\"cats\";s:1:\"1\";s:11:\"instructors\";s:1:\"1\";s:8:\"location\";s:0:\"\";s:5:\"level\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("198", "widget_bp_course_stats_widget", "a:5:{i:3;a:4:{s:5:\"title\";s:30:\"ابزارک آمار دوره\";s:6:\"course\";s:0:\"\";s:8:\"students\";s:1:\"1\";s:17:\"badgecertificates\";s:1:\"1\";}i:4;a:4:{s:5:\"title\";s:30:\"ابزارک آمار دوره\";s:6:\"course\";s:0:\"\";s:8:\"students\";s:1:\"1\";s:17:\"badgecertificates\";s:1:\"1\";}i:5;a:4:{s:5:\"title\";s:30:\"ابزارک آمار دوره\";s:6:\"course\";s:0:\"\";s:8:\"students\";s:1:\"1\";s:17:\"badgecertificates\";s:1:\"1\";}i:6;a:4:{s:5:\"title\";s:30:\"ابزارک آمار دوره\";s:6:\"course\";s:0:\"\";s:8:\"students\";s:1:\"1\";s:17:\"badgecertificates\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("199", "widget_bp_course_filter_widget", "a:3:{i:2;a:15:{s:8:\"category\";s:1:\"1\";s:14:\"category_label\";s:38:\"دسته بندی های دوره ها\";s:7:\"offline\";s:1:\"1\";s:13:\"offline_label\";s:6:\"نوع\";s:4:\"free\";s:0:\"\";s:10:\"free_label\";s:8:\"قیمت\";s:8:\"upcoming\";s:1:\"1\";s:14:\"upcoming_label\";s:19:\"تاریخ آغاز\";s:8:\"location\";s:0:\"\";s:14:\"location_label\";s:0:\"\";s:5:\"level\";s:0:\"\";s:11:\"level_label\";s:0:\"\";s:10:\"instructor\";s:1:\"1\";s:16:\"instructor_label\";s:10:\"استاد\";s:7:\"exclude\";s:0:\"\";}i:3;a:15:{s:8:\"category\";s:1:\"1\";s:14:\"category_label\";s:38:\"دسته بندی های دوره ها\";s:7:\"offline\";s:1:\"1\";s:13:\"offline_label\";s:6:\"نوع\";s:4:\"free\";s:0:\"\";s:10:\"free_label\";s:8:\"قیمت\";s:8:\"upcoming\";s:1:\"1\";s:14:\"upcoming_label\";s:19:\"تاریخ آغاز\";s:8:\"location\";s:0:\"\";s:14:\"location_label\";s:0:\"\";s:5:\"level\";s:0:\"\";s:11:\"level_label\";s:0:\"\";s:10:\"instructor\";s:1:\"1\";s:16:\"instructor_label\";s:10:\"استاد\";s:7:\"exclude\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("200", "widget_bp_course_reviews_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("201", "widget_bp_course_related_courses_widget", "a:2:{i:1;a:9:{s:5:\"title\";s:26:\"دوره های مرتبط\";s:8:\"category\";s:0:\"\";s:10:\"instructor\";s:0:\"\";s:8:\"location\";s:0:\"\";s:5:\"level\";s:0:\"\";s:7:\"linkage\";s:0:\"\";s:6:\"number\";s:1:\"3\";s:6:\"course\";s:0:\"\";s:5:\"style\";s:6:\"course\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("202", "widget_vibe_bp_login", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("203", "widget_vibe_course_categories", "a:3:{i:2;a:5:{s:5:\"title\";s:38:\"دسته بندی های دوره ها\";s:13:\"exclude_terms\";s:0:\"\";s:4:\"sort\";s:3:\"ASC\";s:5:\"order\";s:4:\"name\";s:11:\"hierarchial\";N;}i:3;a:5:{s:5:\"title\";s:38:\"دسته بندی های دوره ها\";s:13:\"exclude_terms\";s:0:\"\";s:4:\"sort\";s:4:\"DESC\";s:5:\"order\";s:4:\"name\";s:11:\"hierarchial\";N;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("204", "widget_vibecertificatecode", "a:2:{i:2;a:1:{s:5:\"title\";s:24:\"کد گواهی نامه\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("205", "widget_vibe_course_categories_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("206", "registration", "0", "yes");
INSERT INTO `wp_options` VALUES("207", "bp-active-components", "a:10:{s:7:\"friends\";s:1:\"1\";s:8:\"messages\";s:1:\"1\";s:6:\"groups\";s:1:\"1\";s:7:\"members\";i:1;s:8:\"activity\";i:1;s:8:\"settings\";i:1;s:8:\"xprofile\";i:1;s:13:\"notifications\";i:1;s:10:\"buddydrive\";s:1:\"1\";s:6:\"course\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("208", "bp-pages", "a:7:{s:7:\"members\";i:5;s:8:\"activity\";i:4;s:6:\"course\";i:10;s:8:\"register\";i:22;s:8:\"activate\";i:23;s:6:\"groups\";i:9;s:10:\"buddydrive\";i:2518;}", "yes");
INSERT INTO `wp_options` VALUES("209", "_bp_db_version", "12385", "yes");
INSERT INTO `wp_options` VALUES("216", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("217", "widget_bbp_login_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("218", "widget_bbp_views_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("219", "widget_bbp_search_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("220", "widget_bbp_forums_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("221", "widget_bbp_topics_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("222", "widget_bbp_replies_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("223", "widget_bbp_stats_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("224", "_bbp_private_forums", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("225", "_bbp_hidden_forums", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("226", "_bbp_db_version", "250", "yes");
INSERT INTO `wp_options` VALUES("227", "_buddydrive_version", "2.1.1", "yes");
INSERT INTO `wp_options` VALUES("228", "eventon_addon_urls", "a:2:{s:6:\"addons\";s:116:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms\\wp-content\\plugins\\eventON/classes/class-evo-addons.php\";s:4:\"date\";i:1463610630;}", "yes");
INSERT INTO `wp_options` VALUES("231", "ls-plugin-version", "6.9.2", "yes");
INSERT INTO `wp_options` VALUES("232", "ls-db-version", "6.9.0", "yes");
INSERT INTO `wp_options` VALUES("233", "ls-installed", "1", "yes");
INSERT INTO `wp_options` VALUES("234", "ls-google-fonts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("235", "ls-date-installed", "1463610631", "yes");
INSERT INTO `wp_options` VALUES("237", "revslider-update-check-short", "1572440789", "yes");
INSERT INTO `wp_options` VALUES("238", "revslider-templates-check", "1572207608", "yes");
INSERT INTO `wp_options` VALUES("239", "_evo_products", "a:2:{s:7:\"eventon\";a:18:{s:4:\"name\";s:7:\"eventON\";s:4:\"slug\";s:7:\"eventon\";s:7:\"version\";s:5:\"2.7.3\";s:14:\"remote_version\";s:5:\"2.5.4\";s:11:\"lastchecked\";s:0:\"\";s:6:\"status\";s:8:\"inactive\";s:8:\"instance\";s:0:\"\";s:15:\"remote_validity\";s:4:\"none\";s:5:\"email\";s:0:\"\";s:3:\"key\";s:0:\"\";s:7:\"siteurl\";s:32:\"http://adourasoft.com/demo/wplms\";s:10:\"guide_file\";N;s:6:\"tested\";s:5:\"4.7.4\";s:8:\"requires\";s:3:\"4.0\";s:12:\"last_updated\";s:9:\"2017-5-26\";s:7:\"package\";s:89:\"http://get.myeventon.com/download.php?plugin=eventon&key=5069c6773b0a22d6bdeed806c08c9460\";s:11:\"plugin_slug\";s:19:\"eventON/eventon.php\";s:2:\"ID\";s:3:\"EVO\";}s:13:\"wplms-eventon\";a:16:{s:4:\"name\";s:9:\"DailyView\";s:4:\"slug\";s:13:\"wplms-eventon\";s:7:\"version\";s:4:\"0.31\";s:14:\"remote_version\";s:0:\"\";s:11:\"lastchecked\";s:0:\"\";s:6:\"status\";s:8:\"inactive\";s:8:\"instance\";s:0:\"\";s:15:\"remote_validity\";s:4:\"none\";s:5:\"email\";s:0:\"\";s:3:\"key\";s:0:\"\";s:7:\"siteurl\";s:32:\"http://adourasoft.com/demo/wplms\";s:10:\"guide_file\";s:103:\"http://adourasoft.com/demo/wplms/wp-content/plugins/wplms-eventon/includes/eventon-daily-view/guide.php\";s:11:\"plugin_slug\";s:64:\"wplms-eventon/includes/eventon-daily-view/eventon-daily-view.php\";s:2:\"ID\";s:0:\"\";s:10:\"plugin_uri\";s:25:\"http://www.VibeThemes.com\";s:11:\"author_name\";s:7:\"Mr.Vibe\";}}", "yes");
INSERT INTO `wp_options` VALUES("240", "widget_evcalwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("241", "widget_evcalwidget_sc", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("242", "widget_evcalwidget_three", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("243", "widget_evcalwidget_four", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("249", "widget_layerslider_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("250", "eventon_events_page_id", "7", "yes");
INSERT INTO `wp_options` VALUES("251", "_eventon_create_pages", "1", "yes");
INSERT INTO `wp_options` VALUES("252", "revslider_checktables", "1", "yes");
INSERT INTO `wp_options` VALUES("253", "revslider_table_version", "1.0.8", "yes");
INSERT INTO `wp_options` VALUES("254", "revslider-global-settings", "{\"version\":\"6.0.0\",\"permission\":\"admin\",\"includeids\":\"\",\"script\":{\"footer\":false,\"defer\":false,\"full\":false},\"fonturl\":\"\",\"size\":{\"desktop\":1240,\"notebook\":1024,\"tablet\":778,\"mobile\":480}}", "yes");
INSERT INTO `wp_options` VALUES("255", "revslider_update_version", "6.0", "yes");
INSERT INTO `wp_options` VALUES("256", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("257", "widget_wplms_dash_activity", "a:2:{i:1;a:6:{s:5:\"title\";s:25:\"فعالیت دانشجو\";s:6:\"number\";s:1:\"6\";s:8:\"activity\";s:1:\"1\";s:8:\"messages\";s:1:\"1\";s:7:\"friends\";s:1:\"1\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("258", "widget_wplms_course_progress", "a:2:{i:1;a:4:{s:5:\"title\";s:21:\"پیشرفت دوره\";s:6:\"number\";s:1:\"6\";s:8:\"finished\";s:1:\"1\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("259", "widget_wplms_dash_contact_users", "a:3:{i:1;a:3:{s:5:\"title\";s:26:\"تماس با اساتید\";s:5:\"users\";s:1:\"1\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}i:2;a:3:{s:5:\"title\";s:16:\"فرم تماس \";s:5:\"users\";s:1:\"1\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("260", "widget_wplms_dash_text", "a:2:{i:1;a:3:{s:5:\"title\";s:19:\"گالری مربی\";s:7:\"content\";s:65:\"[gallery ids=\"1924,1922,1918,1916,1914,1926,1928,1930,1932,1956\"]\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("261", "widget_wplms_dash_tasks", "a:3:{i:1;a:4:{s:5:\"title\";s:19:\"لیست کارها\";s:4:\"date\";s:1:\"1\";s:8:\"priority\";s:1:\"1\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}i:2;a:4:{s:5:\"title\";s:19:\"لیست کارها\";s:4:\"date\";s:1:\"1\";s:8:\"priority\";s:1:\"1\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("262", "widget_wplms_student_stats", "a:2:{i:1;a:8:{s:5:\"title\";s:22:\"آمار دانشجو \";s:5:\"width\";s:9:\"col-md-12\";s:6:\"course\";s:1:\"1\";s:4:\"quiz\";s:1:\"1\";s:11:\"assignments\";s:1:\"1\";s:12:\"course_chart\";s:4:\"Area\";s:10:\"quiz_chart\";s:4:\"Line\";s:16:\"assignment_chart\";s:4:\"Line\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("263", "widget_wplms_dash_stats", "a:5:{i:1;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:7:\"courses\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:6:\"quizes\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:3;a:3:{s:5:\"title\";s:18:\"آمار ساده \";s:5:\"stats\";s:11:\"assignments\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:4;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:5:\"units\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("264", "widget_wplms_notes_discussion", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("265", "widget_wplms_dash_mymodules", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("266", "widget_wplms_dash_news", "a:3:{i:1;a:3:{s:5:\"title\";s:10:\"اخبار\";s:6:\"number\";s:1:\"6\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}i:2;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";s:1:\"5\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("267", "widget_wplms_line_break", "a:3:{i:1;a:0:{}i:2;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("268", "widget_wplms_instructor_dash_stats", "a:8:{i:1;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:14:\"woo_commission\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:7:\"courses\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:3;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:6:\"quizes\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:4;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:11:\"assignments\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:5;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:5:\"units\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:6;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:6:\"badges\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:7;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:12:\"certificates\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("269", "widget_wplms_instructor_stats", "a:2:{i:1;a:4:{s:5:\"title\";s:25:\"آمارهای استاد\";s:5:\"width\";s:9:\"col-md-12\";s:5:\"range\";s:2:\"10\";s:3:\"max\";s:2:\"10\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("270", "widget_wplms_instructor_commission_stats", "a:2:{i:1;a:2:{s:5:\"title\";s:25:\"کمیسیون استاد\";s:5:\"width\";s:9:\"col-md-12\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("271", "widget_wplms_announcement", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("272", "widget_wplms_dash_instructing_modules", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("273", "widget_wplms_dash_cal", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("276", "vc_version", "6.0.5", "yes");
INSERT INTO `wp_options` VALUES("277", "woocommerce_default_country", "IR:IL", "yes");
INSERT INTO `wp_options` VALUES("278", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("279", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("280", "woocommerce_default_customer_address", "geolocation", "yes");
INSERT INTO `wp_options` VALUES("281", "woocommerce_demo_store", "no", "yes");
INSERT INTO `wp_options` VALUES("282", "woocommerce_demo_store_notice", "This is a demo store for testing purposes &mdash; no orders shall be fulfilled.", "no");
INSERT INTO `wp_options` VALUES("283", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("284", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `wp_options` VALUES("285", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("286", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wp_options` VALUES("287", "woocommerce_price_num_decimals", "2", "yes");
INSERT INTO `wp_options` VALUES("288", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("289", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("290", "woocommerce_enable_review_rating", "yes", "no");
INSERT INTO `wp_options` VALUES("291", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("292", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("293", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("294", "woocommerce_shop_page_id", "2390", "yes");
INSERT INTO `wp_options` VALUES("295", "woocommerce_shop_page_display", "", "yes");
INSERT INTO `wp_options` VALUES("296", "woocommerce_category_archive_display", "", "yes");
INSERT INTO `wp_options` VALUES("297", "woocommerce_default_catalog_orderby", "menu_order", "yes");
INSERT INTO `wp_options` VALUES("298", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("299", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("300", "shop_catalog_image_size", "a:3:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("301", "shop_single_image_size", "a:3:{s:5:\"width\";s:3:\"460\";s:6:\"height\";s:3:\"999\";s:4:\"crop\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("302", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";s:3:\"180\";s:6:\"height\";s:3:\"180\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("303", "woocommerce_enable_lightbox", "yes", "yes");
INSERT INTO `wp_options` VALUES("304", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("305", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("306", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("307", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("308", "woocommerce_stock_email_recipient", "midiyaweb@gmail.com", "no");
INSERT INTO `wp_options` VALUES("309", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("310", "woocommerce_notify_no_stock_amount", "0", "no");
INSERT INTO `wp_options` VALUES("311", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("312", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("313", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("314", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("315", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("316", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("317", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("318", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("319", "woocommerce_shipping_tax_class", "title", "yes");
INSERT INTO `wp_options` VALUES("320", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("321", "woocommerce_tax_classes", "Reduced Rate\r\nZero Rate", "yes");
INSERT INTO `wp_options` VALUES("322", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("323", "woocommerce_tax_display_cart", "excl", "no");
INSERT INTO `wp_options` VALUES("324", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("325", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("326", "woocommerce_enable_coupons", "yes", "no");
INSERT INTO `wp_options` VALUES("327", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("328", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("329", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("330", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("331", "woocommerce_cart_page_id", "25", "yes");
INSERT INTO `wp_options` VALUES("332", "woocommerce_checkout_page_id", "26", "yes");
INSERT INTO `wp_options` VALUES("333", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("334", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("335", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("336", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("337", "woocommerce_calc_shipping", "no", "yes");
INSERT INTO `wp_options` VALUES("338", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("339", "woocommerce_shipping_cost_requires_address", "no", "no");
INSERT INTO `wp_options` VALUES("340", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("341", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("342", "woocommerce_specific_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("343", "woocommerce_myaccount_page_id", "27", "yes");
INSERT INTO `wp_options` VALUES("344", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("345", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("346", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("347", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("348", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("349", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("350", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `wp_options` VALUES("351", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `wp_options` VALUES("352", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("353", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `wp_options` VALUES("354", "woocommerce_email_from_name", "wplms", "no");
INSERT INTO `wp_options` VALUES("355", "woocommerce_email_from_address", "midiyaweb@gmail.com", "no");
INSERT INTO `wp_options` VALUES("356", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("357", "woocommerce_email_footer_text", "wplms - Powered by WooCommerce", "no");
INSERT INTO `wp_options` VALUES("358", "woocommerce_email_base_color", "#557da1", "no");
INSERT INTO `wp_options` VALUES("359", "woocommerce_email_background_color", "#f5f5f5", "no");
INSERT INTO `wp_options` VALUES("360", "woocommerce_email_body_background_color", "#fdfdfd", "no");
INSERT INTO `wp_options` VALUES("361", "woocommerce_email_text_color", "#505050", "no");
INSERT INTO `wp_options` VALUES("362", "woocommerce_api_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("372", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("373", "widget_woocommerce_layered_nav_filters", "a:2:{i:3;a:1:{s:5:\"title\";s:14:\"Active Filters\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("374", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("375", "widget_woocommerce_price_filter", "a:2:{i:2;a:1:{s:5:\"title\";s:32:\"فیلتر براساس قیمت\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("376", "widget_woocommerce_product_categories", "a:2:{i:2;a:7:{s:5:\"title\";s:39:\"دسته بندی های محصولات\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("377", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("378", "widget_woocommerce_product_tag_cloud", "a:4:{i:2;a:1:{s:5:\"title\";s:15:\"برچسب ها\";}i:3;a:1:{s:5:\"title\";s:31:\"برچسب های دوره ها\";}i:4;a:1:{s:5:\"title\";s:15:\"برچسب ها\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("379", "widget_woocommerce_products", "a:2:{i:2;a:7:{s:5:\"title\";s:14:\"محصولات\";s:6:\"number\";i:3;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("380", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("381", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("382", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("383", "widget_vibe_woocommerce_carousels", "a:3:{i:2;a:5:{s:5:\"title\";s:23:\"محصولات ویژه\";s:8:\"function\";s:17:\"featured_products\";s:7:\"columns\";s:1:\"1\";s:8:\"controls\";s:9:\"direction\";s:6:\"number\";s:0:\"\";}i:3;a:5:{s:5:\"title\";s:23:\"محصولات ویژه\";s:8:\"function\";s:15:\"recent_products\";s:7:\"columns\";s:1:\"1\";s:8:\"controls\";s:9:\"direction\";s:6:\"number\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("386", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("387", "layerslider_update_info", "O:8:\"stdClass\":5:{s:5:\"basic\";O:8:\"stdClass\":9:{s:4:\"slug\";s:11:\"LayerSlider\";s:6:\"plugin\";s:27:\"LayerSlider/layerslider.php\";s:7:\"version\";s:5:\"6.9.2\";s:5:\"icons\";a:3:{s:2:\"1x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png?ver=6.9.0\";s:2:\"2x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.0\";s:7:\"default\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.0\";}s:7:\"banners\";a:3:{s:3:\"low\";s:94:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png?ver=6.9.0\";s:4:\"high\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.0\";s:7:\"default\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.0\";}s:3:\"url\";s:79:\"http://codecanyon.net/item/layerslider-wp-the-wordpress-parallax-slider/1362246\";s:7:\"package\";s:0:\"\";s:6:\"tested\";s:5:\"5.2.2\";s:14:\"upgrade_notice\";s:56:\"This update contains various bug fixes and improvements.\";}s:4:\"full\";O:8:\"stdClass\":19:{s:4:\"name\";s:14:\"LayerSlider WP\";s:8:\"homepage\";s:72:\"http://kreaturamedia.com/layerslider-responsive-wordpress-slider-plugin/\";s:7:\"version\";s:5:\"6.9.2\";s:12:\"last_updated\";s:10:\"2019-09-03\";s:8:\"requires\";s:3:\"3.5\";s:6:\"tested\";s:5:\"5.2.2\";s:6:\"rating\";s:2:\"95\";s:11:\"num_ratings\";i:2806;s:14:\"upgrade_notice\";a:3:{s:6:\"stable\";s:56:\"This update contains various bug fixes and improvements.\";s:4:\"beta\";s:56:\"This update contains various bug fixes and improvements.\";s:4:\"edge\";s:56:\"This update contains various bug fixes and improvements.\";}s:6:\"author\";s:80:\"<a href=\"http://codecanyon.net/user/kreatura\" target=\"_blank\">Kreatura Media</a>\";s:3:\"url\";s:79:\"http://codecanyon.net/item/layerslider-wp-the-wordpress-parallax-slider/1362246\";s:8:\"external\";b:1;s:9:\"file_name\";s:10:\"plugin.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png?ver=6.9.0\";s:2:\"2x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.0\";s:7:\"default\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.0\";}s:7:\"banners\";a:3:{s:3:\"low\";s:94:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png?ver=6.9.0\";s:4:\"high\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.0\";s:7:\"default\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.0\";}s:8:\"sections\";a:3:{s:9:\"changelog\";s:130:\"<p style=\"text-align: justify;\">\n	See the release log in the \'LayerSlider News\' section at the bottom of its main admin page.\n</p>\";s:12:\"installation\";s:456:\"<p style=\"text-align: justify;\">\n	Updating the plugin won\'t touch your sliders and settings and the new version always has backward compatibility,\n	so you don\'t have to worry about losing your work. Depending of the default settings, you may\n	have to adjust some options to get the new features. If you are experience unwanted behavior changes, it is always a\n	good idea to check your settings, there are probably new options to control these changes.\n</p>\";s:3:\"faq\";s:595:\"<p style=\"text-align: justify;\">\n	Before contacting us, please read our <a href=\"http://support.kreaturamedia.com/faq/4/layerslider-for-wordpress/\" target=\"_blank\">online FAQs</a>, or check the built-in documentation in the contextual Help menu on the top-right corner of the page. Please note, these Help menus are contextual, they will show you different content on different pages.\n</p>\n\n<p style=\"text-align: justify;\">\n	If you couldn\'t find an answer for your question, you can write us a comment at the Item\'s page on CodeCanyon, or send us an email from our CodeCanyon profile page.\n</p>\n\";}s:4:\"slug\";s:11:\"LayerSlider\";s:7:\"package\";s:0:\"\";s:13:\"download_link\";s:0:\"\";}s:15:\"_latest_version\";s:5:\"6.9.2\";s:14:\"_not_activated\";b:1;s:7:\"checked\";i:1572537707;}", "yes");
INSERT INTO `wp_options` VALUES("419", "shop_catalog_image_sizes", "a:3:{s:5:\"width\";i:262;s:6:\"height\";i:999;s:4:\"crop\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("424", "vibe_course_permalinks", "a:12:{s:20:\"course_category_base\";s:0:\"\";s:11:\"course_base\";s:0:\"\";s:9:\"quiz_base\";s:0:\"\";s:9:\"unit_base\";s:0:\"\";s:15:\"curriculum_slug\";s:11:\"/curriculum\";s:12:\"members_slug\";s:8:\"/members\";s:13:\"activity_slug\";s:9:\"/activity\";s:10:\"admin_slug\";s:6:\"/admin\";s:16:\"submissions_slug\";s:12:\"/submissions\";s:10:\"stats_slug\";s:6:\"/stats\";s:11:\"events_slug\";s:7:\"/events\";s:10:\"drive_slug\";s:6:\"/drive\";}", "yes");
INSERT INTO `wp_options` VALUES("425", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("434", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("471", "account_page_options", "", "yes");
INSERT INTO `wp_options` VALUES("472", "account_endpoint_options", "", "yes");
INSERT INTO `wp_options` VALUES("473", "account_registration_options", "", "yes");
INSERT INTO `wp_options` VALUES("477", "checkout_process_options", "", "yes");
INSERT INTO `wp_options` VALUES("478", "checkout_page_options", "", "yes");
INSERT INTO `wp_options` VALUES("479", "checkout_endpoint_options", "", "yes");
INSERT INTO `wp_options` VALUES("480", "payment_gateways_options", "", "yes");
INSERT INTO `wp_options` VALUES("481", "woocommerce_gateway_order", "a:4:{s:4:\"bacs\";i:0;s:6:\"cheque\";i:1;s:3:\"cod\";i:2;s:6:\"paypal\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("499", "widgets_settings", "a:47:{s:15:\"widget_archives\";a:1:{s:12:\"_multiwidget\";i:1;}s:27:\"widget_bp_core_login_widget\";s:0:\"\";s:29:\"widget_bp_core_members_widget\";s:0:\"\";s:37:\"widget_bp_core_recently_active_widget\";s:0:\"\";s:33:\"widget_bp_core_whos_online_widget\";a:2:{i:2;a:2:{s:5:\"title\";s:12:\"Who\'s Online\";s:11:\"max_members\";s:2:\"15\";}s:12:\"_multiwidget\";i:1;}s:30:\"widget_bp_course_filter_widget\";a:2:{i:2;a:6:{s:8:\"category\";s:1:\"1\";s:14:\"category_label\";s:17:\"Course Categories\";s:4:\"free\";s:1:\"1\";s:10:\"free_label\";s:4:\"Type\";s:5:\"level\";s:0:\"\";s:11:\"level_label\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}s:30:\"widget_bp_course_search_widget\";a:4:{i:2;a:4:{s:5:\"title\";s:29:\"Advanced Course Search Widget\";s:4:\"cats\";s:1:\"1\";s:11:\"instructors\";s:1:\"1\";s:5:\"level\";s:0:\"\";}i:3;a:4:{s:5:\"title\";s:29:\"Advanced Course Search Widget\";s:4:\"cats\";s:1:\"1\";s:11:\"instructors\";s:1:\"1\";s:5:\"level\";s:0:\"\";}i:4;a:4:{s:5:\"title\";s:29:\"Advanced Course Search Widget\";s:4:\"cats\";s:1:\"1\";s:11:\"instructors\";s:1:\"1\";s:5:\"level\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}s:29:\"widget_bp_course_stats_widget\";a:2:{i:2;a:4:{s:5:\"title\";s:19:\"Course Stats Widget\";s:6:\"course\";s:0:\"\";s:8:\"students\";s:1:\"1\";s:17:\"badgecertificates\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}s:23:\"widget_bp_course_widget\";a:6:{i:2;a:7:{s:5:\"title\";s:15:\"Popular Courses\";s:5:\"style\";s:8:\"carousel\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:13:\"vibe_students\";s:5:\"order\";s:4:\"DESC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"5\";}i:3;a:7:{s:5:\"title\";s:6:\"Course\";s:5:\"style\";s:4:\"list\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:13:\"comment_count\";s:5:\"order\";s:4:\"DESC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"5\";}i:4;a:7:{s:5:\"title\";s:6:\"Course\";s:5:\"style\";s:8:\"carousel\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:13:\"vibe_students\";s:5:\"order\";s:4:\"DESC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"5\";}i:5;a:7:{s:5:\"title\";s:15:\"Popular Courses\";s:5:\"style\";s:5:\"list1\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:13:\"vibe_students\";s:5:\"order\";s:4:\"DESC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"3\";}i:6;a:7:{s:5:\"title\";s:10:\"Most Rated\";s:5:\"style\";s:5:\"list1\";s:8:\"category\";s:0:\"\";s:7:\"orderby\";s:13:\"comment_count\";s:5:\"order\";s:4:\"DESC\";s:3:\"ids\";s:0:\"\";s:9:\"max_items\";s:1:\"3\";}s:12:\"_multiwidget\";i:1;}s:23:\"widget_bp_groups_widget\";s:0:\"\";s:27:\"widget_bp_instructor_widget\";a:2:{i:2;a:3:{s:5:\"title\";s:18:\"Instructor Details\";s:10:\"instructor\";s:1:\"1\";s:9:\"max_items\";s:1:\"5\";}s:12:\"_multiwidget\";i:1;}s:42:\"widget_bp_messages_sitewide_notices_widget\";s:0:\"\";s:17:\"widget_categories\";a:1:{s:12:\"_multiwidget\";i:1;}s:11:\"widget_meta\";a:1:{s:12:\"_multiwidget\";i:1;}s:15:\"widget_nav_menu\";a:1:{s:12:\"_multiwidget\";i:1;}s:32:\"widget_reallysimpletwitterwidget\";a:1:{s:12:\"_multiwidget\";i:1;}s:22:\"widget_recent-comments\";a:1:{s:12:\"_multiwidget\";i:1;}s:19:\"widget_recent-posts\";a:1:{s:12:\"_multiwidget\";i:1;}s:10:\"widget_rss\";a:0:{}s:13:\"widget_search\";a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}s:16:\"widget_tag_cloud\";a:3:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:8:\"taxonomy\";s:8:\"post_tag\";}i:3;a:2:{s:5:\"title\";s:0:\"\";s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}s:11:\"widget_text\";a:3:{i:2;a:3:{s:5:\"title\";s:11:\"About WPLMS\";s:4:\"text\";s:261:\"There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. \r\n\r\n<h4>WPLMS : The Best LMS platform for WordPress</h4>\";s:6:\"filter\";b:0;}i:3;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:91:\"<img src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/banner-home.png\" />\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}s:26:\"widget_vibecertificatecode\";a:2:{i:2;a:1:{s:5:\"title\";s:16:\"Certificate Code\";}s:12:\"_multiwidget\";i:1;}s:18:\"widget_vibegallery\";a:2:{i:2;a:3:{s:5:\"title\";s:16:\"Featured Gallery\";s:4:\"size\";s:6:\"medium\";s:3:\"ids\";s:55:\"[gallery ids=\"1932,1922,1918,1930,1928,1916,1914,1926\"]\";}s:12:\"_multiwidget\";i:1;}s:16:\"widget_vibeposts\";a:2:{i:2;a:10:{s:5:\"title\";s:12:\"Recent Posts\";s:5:\"theme\";s:5:\"light\";s:4:\"type\";s:6:\"course\";s:8:\"taxonomy\";s:10:\"course-cat\";s:4:\"term\";s:8:\"business\";s:4:\"sort\";s:6:\"recent\";s:4:\"size\";s:5:\"small\";s:5:\"style\";s:4:\"post\";s:3:\"num\";s:1:\"3\";s:5:\"chars\";s:2:\"80\";}s:12:\"_multiwidget\";i:1;}s:15:\"widget_vibetabs\";a:2:{i:2;a:13:{s:5:\"theme\";s:5:\"light\";s:9:\"show_tab1\";s:1:\"1\";s:10:\"title_tab1\";s:5:\"Posts\";s:10:\"style_tab1\";s:9:\"thumbnail\";s:8:\"num_tab1\";s:1:\"5\";s:9:\"show_tab2\";s:1:\"1\";s:10:\"title_tab2\";s:7:\"Courses\";s:10:\"style_tab2\";s:7:\"courses\";s:8:\"num_tab2\";s:1:\"5\";s:9:\"show_tab3\";s:1:\"0\";s:10:\"title_tab3\";s:7:\"Courses\";s:10:\"style_tab3\";s:7:\"courses\";s:8:\"num_tab3\";s:1:\"5\";}s:12:\"_multiwidget\";i:1;}s:23:\"widget_vibetestimonials\";a:2:{i:2;a:3:{s:5:\"title\";s:20:\"Featured Testimonial\";s:2:\"id\";s:6:\"random\";s:6:\"length\";s:2:\"40\";}s:12:\"_multiwidget\";i:1;}s:29:\"widget_vibe_course_categories\";a:6:{i:2;a:4:{s:5:\"title\";s:17:\"Course Categories\";s:11:\"exclude_ids\";s:0:\"\";s:4:\"sort\";s:4:\"DESC\";s:5:\"order\";s:5:\"count\";}i:3;a:4:{s:5:\"title\";s:17:\"Course Categories\";s:11:\"exclude_ids\";s:0:\"\";s:4:\"sort\";s:4:\"DESC\";s:5:\"order\";s:4:\"name\";}i:4;a:4:{s:5:\"title\";s:17:\"Course Categories\";s:11:\"exclude_ids\";s:0:\"\";s:4:\"sort\";s:4:\"DESC\";s:5:\"order\";s:4:\"name\";}i:5;a:4:{s:5:\"title\";s:17:\"Course Categories\";s:11:\"exclude_ids\";s:0:\"\";s:4:\"sort\";s:4:\"DESC\";s:5:\"order\";s:5:\"count\";}i:6;a:4:{s:5:\"title\";s:17:\"Course Categories\";s:11:\"exclude_ids\";s:0:\"\";s:4:\"sort\";s:4:\"DESC\";s:5:\"order\";s:4:\"name\";}s:12:\"_multiwidget\";i:1;}s:33:\"widget_vibe_woocommerce_carousels\";a:3:{i:2;a:5:{s:5:\"title\";s:17:\"Featured Products\";s:8:\"function\";s:13:\"sale_products\";s:7:\"columns\";s:1:\"1\";s:8:\"controls\";s:9:\"direction\";s:6:\"number\";s:0:\"\";}i:3;a:5:{s:5:\"title\";s:17:\"Featured Products\";s:8:\"function\";s:15:\"recent_products\";s:7:\"columns\";s:1:\"1\";s:8:\"controls\";s:9:\"direction\";s:6:\"number\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}s:30:\"widget_woocommerce_layered_nav\";a:2:{i:2;a:3:{s:5:\"title\";s:9:\"Filter by\";s:12:\"display_type\";s:4:\"list\";s:10:\"query_type\";s:3:\"and\";}s:12:\"_multiwidget\";i:1;}s:38:\"widget_woocommerce_layered_nav_filters\";a:2:{i:2;a:1:{s:5:\"title\";s:14:\"Active Filters\";}s:12:\"_multiwidget\";i:1;}s:31:\"widget_woocommerce_price_filter\";a:2:{i:2;a:1:{s:5:\"title\";s:15:\"Filter by price\";}s:12:\"_multiwidget\";i:1;}s:27:\"widget_woocommerce_products\";a:3:{i:2;a:7:{s:5:\"title\";s:8:\"Products\";s:6:\"number\";s:1:\"5\";s:4:\"show\";s:8:\"featured\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:3;a:7:{s:5:\"title\";s:8:\"Products\";s:6:\"number\";s:1:\"5\";s:4:\"show\";s:6:\"onsale\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";s:1:\"1\";s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}s:37:\"widget_woocommerce_product_categories\";a:2:{i:2;a:6:{s:5:\"title\";s:18:\"Product Categories\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";s:1:\"1\";s:18:\"show_children_only\";i:0;}s:12:\"_multiwidget\";i:1;}s:24:\"widget_wplms_annoucement\";a:2:{i:2;a:2:{s:5:\"title\";s:11:\"Annoucement\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}s:12:\"_multiwidget\";i:1;}s:28:\"widget_wplms_course_progress\";a:2:{i:2;a:4:{s:5:\"title\";s:15:\"Course Progress\";s:6:\"number\";s:1:\"5\";s:8:\"finished\";s:1:\"1\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}s:12:\"_multiwidget\";i:1;}s:26:\"widget_wplms_dash_activity\";a:2:{i:2;a:6:{s:5:\"title\";s:0:\"\";s:6:\"number\";s:1:\"5\";s:8:\"activity\";s:1:\"1\";s:8:\"messages\";s:1:\"1\";s:7:\"friends\";s:1:\"1\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}s:12:\"_multiwidget\";i:1;}s:31:\"widget_wplms_dash_contact_users\";a:3:{i:2;a:3:{s:5:\"title\";s:19:\"Contact Instructors\";s:5:\"users\";s:1:\"1\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}i:3;a:3:{s:5:\"title\";s:19:\"Contact Instructors\";s:5:\"users\";s:1:\"1\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}s:12:\"_multiwidget\";i:1;}s:22:\"widget_wplms_dash_news\";a:3:{i:2;a:3:{s:5:\"title\";s:4:\"News\";s:6:\"number\";s:1:\"5\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}i:3;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";s:1:\"5\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}s:12:\"_multiwidget\";i:1;}s:23:\"widget_wplms_dash_stats\";a:5:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:7:\"courses\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:3;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:6:\"quizes\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:4;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:11:\"assignments\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:5;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:5:\"units\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}s:12:\"_multiwidget\";i:1;}s:23:\"widget_wplms_dash_tasks\";a:3:{i:2;a:4:{s:5:\"title\";s:10:\"To do List\";s:4:\"date\";s:1:\"1\";s:8:\"priority\";s:1:\"1\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}i:3;a:4:{s:5:\"title\";s:10:\"To do List\";s:4:\"date\";s:1:\"1\";s:8:\"priority\";s:1:\"1\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}s:12:\"_multiwidget\";i:1;}s:22:\"widget_wplms_dash_text\";a:2:{i:2;a:3:{s:5:\"title\";s:18:\"Instructor Gallery\";s:7:\"content\";s:65:\"[gallery ids=\"1924,1922,1918,1916,1914,1926,1928,1930,1932,1956\"]\";s:5:\"width\";s:18:\"col-md-6 col-sm-12\";}s:12:\"_multiwidget\";i:1;}s:40:\"widget_wplms_instructor_commission_stats\";a:2:{i:2;a:2:{s:5:\"title\";s:22:\"Instructor Commissions\";s:5:\"width\";s:9:\"col-md-12\";}s:12:\"_multiwidget\";i:1;}s:34:\"widget_wplms_instructor_dash_stats\";a:8:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:14:\"woo_commission\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:3;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:7:\"courses\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:4;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:6:\"quizes\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:5;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:11:\"assignments\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:7;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:5:\"units\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:8;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:6:\"badges\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}i:9;a:3:{s:5:\"title\";s:0:\"\";s:5:\"stats\";s:12:\"certificates\";s:5:\"width\";s:17:\"col-md-3 col-sm-6\";}s:12:\"_multiwidget\";i:1;}s:29:\"widget_wplms_instructor_stats\";a:2:{i:2;a:4:{s:5:\"title\";s:21:\"Instructor Statistics\";s:5:\"width\";s:9:\"col-md-12\";s:5:\"range\";s:2:\"10\";s:3:\"max\";s:2:\"10\";}s:12:\"_multiwidget\";i:1;}s:23:\"widget_wplms_line_break\";a:3:{i:2;a:0:{}i:3;a:0:{}s:12:\"_multiwidget\";i:1;}s:26:\"widget_wplms_student_stats\";a:2:{i:2;a:8:{s:5:\"title\";s:18:\"Student Statistics\";s:5:\"width\";s:9:\"col-md-12\";s:6:\"course\";s:1:\"1\";s:4:\"quiz\";s:1:\"1\";s:11:\"assignments\";s:1:\"1\";s:12:\"course_chart\";s:4:\"Area\";s:10:\"quiz_chart\";s:4:\"Line\";s:16:\"assignment_chart\";s:4:\"Line\";}s:12:\"_multiwidget\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("524", "ls-latest-version", "6.9.2", "yes");
INSERT INTO `wp_options` VALUES("602", "pw_delete_city_table_2_5", "2.5.1", "yes");
INSERT INTO `wp_options` VALUES("703", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("729", "general_options", "", "yes");
INSERT INTO `wp_options` VALUES("730", "pricing_options", "", "yes");
INSERT INTO `wp_options` VALUES("758", "event_type_2_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("763", "product_shipping_class_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("868", "category_children", "a:3:{i:8;a:2:{i:0;i:9;i:1;i:13;}i:7;a:1:{i:0;i:12;}i:13;a:1:{i:0;i:14;}}", "yes");
INSERT INTO `wp_options` VALUES("901", "widget_bp_core_friends_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("903", "bp_disable_blogforum_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("922", "vibe_builder_sample_layouts", "a:5:{i:0;a:2:{s:4:\"name\";s:10:\"About page\";s:7:\"content\";s:19673:\"<div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1; width: 672px;\" data-placeholder=\"Full-Width Resizable Column\" data-name=\"resizable\" class=\"module m_column m_column_resizable ui-draggable ui-resizable ui-droppable ui-sortable first\"><span class=\"module_name column_name\">Full-Width Resizable Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"Layer Slider\" data-name=\"layerslider\" class=\"module m_layerslider ui-draggable\"><span class=\"module_name\">LayerSlider : 1</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"id\" class=\"id module_setting\">1</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"2/3 Column\" data-name=\"2_3\" class=\"module m_column m_column_2_3 ui-draggable ui-resizable ui-droppable ui-sortable first\"><span class=\"module_name column_name\">2/3 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>[tabs style=\"tabs-left\" theme=] [tab title=\"Onine Learning\" icon=\"\"]Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).</p><p>Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy.[/tab] [tab title=\"Multi Media Learning\" icon=\"\"] There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don\'t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn\'t anything embarrassing hidden in the middle of text.</p><p>Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. [/tab] [tab title=\"Forums and Groups\" icon=\"\"] Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p><p>Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy.[/tab] [tab title=\"Badges and Certificates\" icon=\"\"] Lorem is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard&nbsp; since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. [/tab][tab title=\"Time Based Quizes\" icon=\"\"]Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p><p>Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. [/tab][tab title=\"Subscription Plans\" icon=\"\"] Lorem dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p><p>Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. [/tab][/tabs]</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/3 Column\" data-name=\"1_3\" class=\"module m_column m_column_1_3 ui-draggable ui-resizable ui-droppable ui-sortable\"><span class=\"module_name column_name\">1/3 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content<span class=\"unsaved\"> ( Unsaved )</span></span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>&nbsp;</p><p><a href=\"http://vibethemes.com/envato/wplms/course-cat/language/\"><img class=\"alignnone size-full wp-image-1442\" alt=\"banner3\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2008/09/banner3.jpg\" height=\"100\" width=\"300\"></a></p><p><a href=\"http://vibethemes.com/envato/wplms/course-cat/technology/\"><img class=\"alignnone size-full wp-image-1443\" alt=\"banner4\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2008/09/banner4.jpg\" height=\"100\" width=\"300\"></a></p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\">custombanner</div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\">.custombanner img{\nborder:5px solid #FFF;\nborder-radius:2px;\nbox-shadow:0 1px 2px #bbb;\n}</div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1; width: 672px;\" data-placeholder=\"Full-Width Resizable Column\" data-name=\"resizable\" class=\"module m_column m_column_resizable ui-draggable ui-resizable ui-droppable ui-sortable first\"><span class=\"module_name column_name\">Full-Width Resizable Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1; height: 18px;\" data-placeholder=\"Carousels/Rotating Blocks\" data-name=\"carousel\" class=\"module m_carousel ui-draggable ui-resizable first\"><span class=\"module_name\">Trending Course</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Trending Courses</div><div data-option_name=\"show_title\" class=\"show_title module_setting\">1</div><div data-option_name=\"show_more\" class=\"show_more module_setting\">0</div><div data-option_name=\"more_link\" class=\"more_link module_setting\"></div><div data-option_name=\"show_controls\" class=\"show_controls module_setting\">1</div><div data-option_name=\"post_type\" class=\"post_type module_setting\">course</div><div data-option_name=\"taxonomy\" class=\"taxonomy module_setting\"></div><div data-option_name=\"term\" class=\"term module_setting\"></div><div data-option_name=\"post_ids\" class=\"post_ids module_setting\"></div><div data-option_name=\"featured_style\" class=\"featured_style module_setting\">course</div><div data-option_name=\"auto_slide\" class=\"auto_slide module_setting\">0</div><div data-option_name=\"column_width\" class=\"column_width module_setting\">280</div><div data-option_name=\"carousel_max\" class=\"carousel_max module_setting\">4</div><div data-option_name=\"carousel_min\" class=\"carousel_min module_setting\">4</div><div data-option_name=\"carousel_number\" class=\"carousel_number module_setting\">8</div><div data-option_name=\"carousel_excerpt_length\" class=\"carousel_excerpt_length module_setting\">100</div><div data-option_name=\"carousel_lightbox\" class=\"carousel_lightbox module_setting\">1</div><div data-option_name=\"carousel_link\" class=\"carousel_link module_setting\">1</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div>								<div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1; width: 672px;\" data-placeholder=\"Full-Width Resizable Column\" data-name=\"resizable\" class=\"module m_column m_column_resizable ui-draggable ui-resizable ui-droppable ui-sortable first\"><span class=\"module_name column_name\">Full-Width Resizable Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>[heading]Instructors[/heading]</p><p>[one_half first=first] Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus porttitor interdum tempor. Phasellus quis nisl massa. Nullam facilisis ut orci ut porta. Aenean quis justo eu lorem pellentesque iaculis. Etiam at sem velit. Quisque ac iaculis purus. Nullam sodales at mauris quis tristique. [/one_half] [one_half first=] Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus porttitor interdum tempor. Phasellus quis nisl massa. Nullam facilisis ut orci ut porta. Aenean quis justo eu lorem pellentesque iaculis. Etiam at sem velit. Quisque ac iaculis purus. Nullam sodales at mauris quis tristique. [/one_half]</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable first\"><span class=\"module_name column_name\">1/4 Column</span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>[team_member pic=\'<img class=\"alignnone size-full wp-image-1435\" alt=\"team1\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2013/06/team1.png\" height=\"454\" width=\"452\">\' name=\"Linda Parker\" designation=\"Web Design\"][team_social url=\"http://www.twitter.com/vibethemes\" icon=\"icon-twitter\"][team_social url=\"http://www.facebook.com/vibethemes\" icon=\"icon-facebook-1\"] [team_social url=\"http://www.dribbble.com/vibethemes\" icon=\"icon-dribbble-2\"][/team_member]</p><p>&nbsp;</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div> <span style=\"display: block;\" class=\"delete_column delete\"></span><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\"><span class=\"module_name column_name\">1/4 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>[team_member pic=\'<a href=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2013/08/team3.png\"><img class=\"alignnone size-full wp-image-1434\" alt=\"team3\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2013/08/team3.png\" height=\"454\" width=\"452\"></a>\' name=\"Marry Parker\" designation=\"Web Design\"][team_social url=\"http://www.twitter.com/vibethemes\" icon=\"icon-twitter\"][team_social url=\"http://www.facebook.com/vibethemes\" icon=\"icon-facebook-1\"] [team_social url=\"http://www.dribbble.com/vibethemes\" icon=\"icon-dribbble-2\"][/team_member]</p><p>&nbsp;</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\"><span class=\"module_name column_name\">1/4 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>[team_member pic=\'<img class=\"alignnone size-full wp-image-1437\" alt=\"team4\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2013/06/team4.png\" height=\"454\" width=\"452\">\' name=\"James Parker\" designation=\"Web Design\"][team_social url=\"http://www.twitter.com/vibethemes\" icon=\"icon-twitter\"][team_social url=\"http://www.facebook.com/vibethemes\" icon=\"icon-facebook-1\"] [team_social url=\"http://www.dribbble.com/vibethemes\" icon=\"icon-dribbble-2\"][/team_member]</p><p>&nbsp;</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\"><span class=\"module_name column_name\">1/4 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>[team_member pic=\'<img class=\"alignnone size-full wp-image-1436\" alt=\"team2\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2013/06/team2.png\" height=\"454\" width=\"452\">\' name=\"Luke Parker\" designation=\"Web Design\"][team_social url=\"http://www.twitter.com/vibethemes\" icon=\"icon-twitter\"][team_social url=\"http://www.facebook.com/vibethemes\" icon=\"icon-facebook-1\"] [team_social url=\"http://www.dribbble.com/vibethemes\" icon=\"icon-dribbble-2\"][/team_member]</p><p>&nbsp;</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div>\";}i:1;a:2:{s:4:\"name\";s:21:\"become a teacher page\";s:7:\"content\";s:18134:\"<div data-placeholder=\"Full-Width Resizable Column\" data-name=\"resizable\" class=\"module m_column m_column_resizable ui-draggable ui-resizable ui-droppable ui-sortable first\" style=\"opacity: 1; display: inline-block; z-index: 1; width: 672px;\" aria-disabled=\"false\"><span class=\"module_name column_name\">Full-Width Resizable Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"FlexSlider\" data-name=\"slider\" class=\"module m_slider ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">FlexSlider</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">FlexSlider</div><div data-option_name=\"slide_style\" class=\"slide_style module_setting\">slide1</div><div data-option_name=\"animation\" class=\"animation module_setting\">fade</div><div data-option_name=\"auto_slide\" class=\"auto_slide module_setting\">1</div><div data-option_name=\"loop\" class=\"loop module_setting\">1</div><div data-option_name=\"randomize\" class=\"randomize module_setting\">1</div><div data-option_name=\"show_directionnav\" class=\"show_directionnav module_setting\">1</div><div data-option_name=\"show_controlnav\" class=\"show_controlnav module_setting\">1</div><div data-option_name=\"animation_duration\" class=\"animation_duration module_setting\">600</div><div data-option_name=\"auto_speed\" class=\"auto_speed module_setting\">7000</div><div data-option_name=\"pause_on_hover\" class=\"pause_on_hover module_setting\">1</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div><div data-option_name=\"slides\" class=\"slides module_setting\"><div class=\"attachment clearfix\" data-attachment=\"1985\"><img width=\"150\" height=\"150\" src=\"http://vibethemes.com/envato/wplms/skins/default/wp-content/uploads/2014/10/1-150x150.jpg\" class=\"attachment-thumbnail\" alt=\"1\"><div class=\"attachment_options\"><p class=\"clearfix\"><label>Description (HTML &amp; Shortcodes allowed): </label><textarea name=\"attachment_description[]\" class=\"attachment_description\"></textarea> </p><p class=\"clearfix\"><label>Link: </label><input name=\"attachment_link[]\" class=\"attachment_link\" value=\"\"> </p></div><a href=\"#\" class=\"delete_attachment\">Delete this slide</a><a href=\"#\" class=\"change_attachment_image\">Change image</a></div><div class=\"attachment clearfix\" data-attachment=\"1986\"><img width=\"150\" height=\"150\" src=\"http://vibethemes.com/envato/wplms/skins/default/wp-content/uploads/2014/10/2-150x150.jpg\" class=\"attachment-thumbnail\" alt=\"2\"><div class=\"attachment_options\"><p class=\"clearfix\"><label>Description (HTML &amp; Shortcodes allowed): </label><textarea name=\"attachment_description[]\" class=\"attachment_description\"></textarea> </p><p class=\"clearfix\"><label>Link: </label><input value=\"\" name=\"attachment_link[]\" class=\"attachment_link\"> </p></div><a href=\"#\" class=\"delete_attachment\">Delete this slide</a><a href=\"#\" class=\"change_attachment_image\">Change image</a></div><div class=\"attachment clearfix\" data-attachment=\"1984\"><img width=\"150\" height=\"150\" src=\"http://vibethemes.com/envato/wplms/skins/default/wp-content/uploads/2014/10/3-150x150.jpg\" class=\"attachment-thumbnail\" alt=\"3\"><div class=\"attachment_options\"><p class=\"clearfix\"><label>Description (HTML &amp; Shortcodes allowed): </label><textarea name=\"attachment_description[]\" class=\"attachment_description\"></textarea> </p><p class=\"clearfix\"><label>Link: </label><input value=\"\" name=\"attachment_link[]\" class=\"attachment_link\"> </p></div><a href=\"#\" class=\"delete_attachment\">Delete this slide</a><a href=\"#\" class=\"change_attachment_image\">Change image</a></div></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable first\"><span class=\"module_name column_name\">1/4 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p><a href=\"http://vibethemes.com/envato/wplms/course-cat/photography-2/\"><img class=\"alignnone size-full wp-image-1441\" alt=\"banner2\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2008/09/banner2.jpg\" height=\"100\" width=\"300\"></a></p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\">custom_banners</div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\">.custom_banners img{border:5px solid #FFF;border-radius:2px;box-shadow:0 1px 2px #bbb;}</div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\"><span class=\"module_name column_name\">1/4 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p><a href=\"http://vibethemes.com/envato/wplms/course-cat/technology/\"><img class=\"alignnone size-full wp-image-1443\" alt=\"banner4\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2008/09/banner4.jpg\" height=\"100\" width=\"300\"></a></p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\">custom_banners</div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\"><span class=\"module_name column_name\">1/4 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p><a href=\"http://vibethemes.com/envato/wplms/course-cat/business/\"><img class=\"alignnone size-full wp-image-1440\" alt=\"banner1\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2008/09/banner1.jpg\" height=\"100\" width=\"300\"></a></p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\">custom_banners</div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\"><span class=\"module_name column_name\">1/4 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p><a href=\"http://vibethemes.com/envato/wplms/course-cat/language/\"><img class=\"alignnone size-full wp-image-1442\" alt=\"banner3\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2008/09/banner3.jpg\" height=\"100\" width=\"300\"></a></p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\">custom_banners</div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div data-placeholder=\"1/3 Column\" data-name=\"1_3\" class=\"module m_column m_column_1_3 ui-draggable ui-resizable ui-droppable ui-sortable first\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">1/3 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">Content</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>[heading]How to become a Teacher[/heading]</p><p>It is a long established fact that a reader.</p><p>[form to=\"vibethemes@gmail.com\" subject=\"Instructor \"] [form_element type=\"text\" validate=\"\" options=\"\" placeholder=\"Name\"] [form_element type=\"text\" validate=\"email\" options=\"\" placeholder=\"Email\"] [form_element type=\"text\" validate=\"phone\" options=\"\" placeholder=\"Phone\"] [form_element type=\"submit\" validate=\"\" options=\"\" placeholder=\"Submit\"] [/form]</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div data-placeholder=\"2/3 Column\" data-name=\"2_3\" class=\"module m_column m_column_2_3 ui-draggable ui-resizable ui-droppable ui-sortable\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">2/3 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">Content</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>&nbsp;</p><p>[tabs style=\"\" theme=] [tab title=\"Become an Instructor \" icon=\"\"]</p><p><a href=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/photography2.jpg\"><img class=\"alignleft\" alt=\"photography2\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/photography2.jpg\" height=\"178\" width=\"298\"></a>Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy.</p><p>Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like). [/tab] [tab title=\"Instructor Role\" icon=\"\"]</p><p><a href=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/marketing.jpg\"><img class=\"alignleft\" alt=\"marketing\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/marketing-460x275.jpg\" height=\"179\" width=\"300\"></a>Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy.</p><p>Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like). [/tab] [tab title=\"Starting with Courses\" icon=\"\"]</p><p><img class=\"alignleft size-full wp-image-1211\" alt=\"free-60-icons-05\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/free-60-icons-05.png\" height=\"128\" width=\"128\"> Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy.</p><p>Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like). [/tab] [/tabs]</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div>				<div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1; width: 672px;\" data-placeholder=\"Full-Width Resizable Column\" data-name=\"resizable\" class=\"module m_column m_column_resizable ui-draggable ui-resizable ui-droppable ui-sortable first\"><span class=\"module_name column_name\">Full-Width Resizable Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"Carousels/Rotating Blocks\" data-name=\"carousel\" class=\"module m_carousel ui-draggable\"><span class=\"module_name\">Courses</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Courses</div><div data-option_name=\"show_title\" class=\"show_title module_setting\">1</div><div data-option_name=\"show_more\" class=\"show_more module_setting\">0</div><div data-option_name=\"more_link\" class=\"more_link module_setting\"></div><div data-option_name=\"show_controls\" class=\"show_controls module_setting\">1</div><div data-option_name=\"post_type\" class=\"post_type module_setting\">course</div><div data-option_name=\"taxonomy\" class=\"taxonomy module_setting\"></div><div data-option_name=\"term\" class=\"term module_setting\"></div><div data-option_name=\"post_ids\" class=\"post_ids module_setting\"></div><div data-option_name=\"course_style\" class=\"course_style module_setting\">recent</div><div data-option_name=\"featured_style\" class=\"featured_style module_setting\">course</div><div data-option_name=\"auto_slide\" class=\"auto_slide module_setting\">1</div><div data-option_name=\"column_width\" class=\"column_width module_setting\">268</div><div data-option_name=\"carousel_max\" class=\"carousel_max module_setting\">4</div><div data-option_name=\"carousel_min\" class=\"carousel_min module_setting\">1</div><div data-option_name=\"carousel_number\" class=\"carousel_number module_setting\">8</div><div data-option_name=\"carousel_excerpt_length\" class=\"carousel_excerpt_length module_setting\">100</div><div data-option_name=\"carousel_lightbox\" class=\"carousel_lightbox module_setting\">1</div><div data-option_name=\"carousel_link\" class=\"carousel_link module_setting\">1</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div>\";}i:2;a:2:{s:4:\"name\";s:12:\"contact page\";s:7:\"content\";s:3603:\"<div data-placeholder=\"1/2 Column\" data-name=\"1_2\" class=\"module m_column m_column_1_2 ui-draggable ui-resizable ui-droppable ui-sortable first\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">1/2 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">Content<span class=\"unsaved\"> ( Unsaved )</span></span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>[heading]Our Address[/heading]</p><p>It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.</p><ul><li><strong>CHRIS NISWANDEE </strong></li><li><strong>SMALLSYS INC 795 E </strong></li><li><strong>DRAGRAM TUCSON </strong></li><li><strong>ARIZONA - &nbsp;85705</strong></li></ul><p>&nbsp;</p><p>Email us at <strong>example@example.com</strong> or give a call at <strong>01 22 4455 6</strong></p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div data-placeholder=\"1/2 Column\" data-name=\"1_2\" class=\"module m_column m_column_1_2 ui-draggable ui-resizable ui-droppable ui-sortable\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">1/2 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">Content</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>[heading]Send us a message[/heading]</p><p>[form to=\"vibethemes@gmail.com\" subject=\"Contact from WPLMS\"] [form_element type=\"text\" validate=\"\" options=\"\" placeholder=\"Name\"] [form_element type=\"text\" validate=\"email\" options=\"\" placeholder=\"Email\"] [form_element type=\"textarea\" validate=\"\" options=\"\" placeholder=\"Message\"] [form_element type=\"submit\" validate=\"\" options=\"\" placeholder=\"Send Message\"] [/form]</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div>\";}i:3;a:2:{s:4:\"name\";s:9:\"home page\";s:7:\"content\";s:24770:\"<div data-placeholder=\"FullScreen Stripe\" data-name=\"stripe\" class=\"module m_column m_column_stripe ui-draggable ui-resizable ui-droppable ui-sortable first\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">FullScreen Stripe</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"Layer Slider\" data-name=\"layerslider\" class=\"module m_layerslider ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">LayerSlider : 2</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"id\" class=\"id module_setting\">2</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\">homepageslider</div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\">.homepageslider.stripe{margin-top:0;}</div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable first\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">1/4 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">Content<span class=\"unsaved\"> ( Unsaved )</span></span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-1430\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/4.png\" alt=\"4\" width=\"140\" height=\"140\"></p><h3 style=\"text-align: center;\">Online Courses&nbsp;</h3><p style=\"text-align: center;\">course management</p><p style=\"text-align: center;\">It is a long established fact that a reader will be distracted.</p><p style=\"text-align: center;\"><a class=\"link\" href=\"#\">more</a></p><p style=\"text-align: center;\">&nbsp;</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\">custom_block</div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\">.custom_block img{\nmax-width:80px;\npadding:30px 0;\n}\n.custom_block h3{font-weight: 600;\ntext-transform: uppercase;\nfont-size: 17px;margin-bottom:0;}\n.custom_block h3+p{color:#bbb;margin-top:0;font-size:11px;font-weight:600;text-transform:uppercase;}</div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">1/4 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">Content</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-1428\" alt=\"1\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/1.png\" height=\"140\" width=\"140\"></p><h3 style=\"text-align: center;\">Become an Instructor</h3><p style=\"text-align: center;\">teach online</p><p style=\"text-align: center;\">It is a long established fact that a reader will be distracted</p><p style=\"text-align: center;\"><a class=\"link\" href=\"#\">more</a></p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\">custom_block</div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">1/4 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">Content</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-1431\" alt=\"3\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/3.png\" height=\"140\" width=\"140\"></p><h3 style=\"text-align: center;\">Multi-Media Units</h3><p style=\"text-align: center;\">Audio, Video playback</p><p style=\"text-align: center;\">It is a long established fact that a reader will be distracted</p><p style=\"text-align: center;\"><a class=\"link\" href=\"#\">more</a></p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\">custom_block</div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">1/4 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">Content</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-1429\" alt=\"2\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/2.png\" height=\"140\" width=\"140\"></p><h3 style=\"text-align: center;\">subscribe courses</h3><p style=\"text-align: center;\">Sell Courses</p><p style=\"text-align: center;\">It is a long established fact that a reader will be distracted</p><p style=\"text-align: center;\"><a class=\"link\" href=\"#\">more</a></p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\">custom_block</div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable first\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">1/4 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">Content</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p><a href=\"http://vibethemes.com/envato/wplms/course-cat/language/\"><img alt=\"banner3\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2008/09/banner3.jpg\" height=\"100\" width=\"300\"></a></p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\">custom_banner</div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\">.custom_banner img{\nborder:5px solid #FFF;\nbox-shadow:0 1px 2px #bbb;\nborder-radius:2px;\n}</div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">1/4 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">Content</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p><a href=\"http://vibethemes.com/envato/wplms/course-cat/business/\"><img alt=\"banner1\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2008/09/banner1.jpg\" height=\"100\" width=\"300\"></a></p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\">custom_banner</div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">1/4 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">Content</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p><a href=\"http://vibethemes.com/envato/wplms/course-cat/technology/\"><img alt=\"banner4\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2008/09/banner4.jpg\" height=\"100\" width=\"300\"></a></p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\">custom_banner</div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">1/4 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">Content</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p><a href=\"http://vibethemes.com/envato/wplms/course-cat/photography-2/\"><img alt=\"banner2\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2008/09/banner2.jpg\" height=\"100\" width=\"300\"></a></p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\">custom_banner</div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div>				<div data-placeholder=\"FullScreen Stripe with Container\" data-name=\"stripe_container\" class=\"module m_column m_column_stripe_container ui-draggable ui-resizable ui-droppable ui-sortable first\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">FullScreen Stripe with Container</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"Carousels/Rotating Blocks\" data-name=\"carousel\" class=\"module m_carousel ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">Popular Courses</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Popular Courses</div><div data-option_name=\"show_title\" class=\"show_title module_setting\">1</div><div data-option_name=\"show_more\" class=\"show_more module_setting\">1</div><div data-option_name=\"more_link\" class=\"more_link module_setting\">http://vibethemes.com/envato/wplms/all-courses/</div><div data-option_name=\"show_controls\" class=\"show_controls module_setting\">1</div><div data-option_name=\"post_type\" class=\"post_type module_setting\">course</div><div data-option_name=\"taxonomy\" class=\"taxonomy module_setting\"></div><div data-option_name=\"term\" class=\"term module_setting\"></div><div data-option_name=\"post_ids\" class=\"post_ids module_setting\"></div><div data-option_name=\"featured_style\" class=\"featured_style module_setting\">course</div><div data-option_name=\"auto_slide\" class=\"auto_slide module_setting\">0</div><div data-option_name=\"column_width\" class=\"column_width module_setting\">262</div><div data-option_name=\"carousel_max\" class=\"carousel_max module_setting\">4</div><div data-option_name=\"carousel_min\" class=\"carousel_min module_setting\">2</div><div data-option_name=\"carousel_number\" class=\"carousel_number module_setting\">6</div><div data-option_name=\"carousel_excerpt_length\" class=\"carousel_excerpt_length module_setting\">100</div><div data-option_name=\"carousel_lightbox\" class=\"carousel_lightbox module_setting\">0</div><div data-option_name=\"carousel_link\" class=\"carousel_link module_setting\">0</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\">fullhomestripe</div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\">.fullhomestripe.stripe{\npadding:30px 0;\nbackground:#FFF;\n}</div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div data-placeholder=\"1/2 Column\" data-name=\"1_2\" class=\"module m_column m_column_1_2 ui-draggable ui-resizable ui-droppable ui-sortable first\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">1/2 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"Carousels/Rotating Blocks\" data-name=\"carousel\" class=\"module m_carousel ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1; height: 18px;\"><span class=\"module_name\">Recent Posts<span class=\"unsaved\"> ( Unsaved )</span><span class=\"unsaved\"> ( Unsaved )</span></span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Recent Posts</div><div data-option_name=\"show_title\" class=\"show_title module_setting\">1</div><div data-option_name=\"show_more\" class=\"show_more module_setting\">1</div><div data-option_name=\"more_link\" class=\"more_link module_setting\">http://vibethemes.com/envato/wplms/blog/</div><div data-option_name=\"show_controls\" class=\"show_controls module_setting\">1</div><div data-option_name=\"post_type\" class=\"post_type module_setting\">post</div><div data-option_name=\"taxonomy\" class=\"taxonomy module_setting\"></div><div data-option_name=\"term\" class=\"term module_setting\"></div><div data-option_name=\"post_ids\" class=\"post_ids module_setting\"></div><div data-option_name=\"course_style\" class=\"course_style module_setting\">recent</div><div data-option_name=\"featured_style\" class=\"featured_style module_setting\">side</div><div data-option_name=\"auto_slide\" class=\"auto_slide module_setting\">1</div><div data-option_name=\"column_width\" class=\"column_width module_setting\">600</div><div data-option_name=\"carousel_max\" class=\"carousel_max module_setting\">1</div><div data-option_name=\"carousel_min\" class=\"carousel_min module_setting\">1</div><div data-option_name=\"carousel_number\" class=\"carousel_number module_setting\">4</div><div data-option_name=\"carousel_excerpt_length\" class=\"carousel_excerpt_length module_setting\">180</div><div data-option_name=\"carousel_lightbox\" class=\"carousel_lightbox module_setting\">1</div><div data-option_name=\"carousel_link\" class=\"carousel_link module_setting\">1</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">1/4 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\"><span class=\"module_name\">Content</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>[heading]Apply for Instructor[/heading]</p><p>[form to=\"example@example.com\" subject=\"Subject\"] [form_element type=\"text\" validate=\"\" options=\"\" placeholder=\"Name\"] [form_element type=\"text\" validate=\"email\" options=\"\" placeholder=\"Email\"] [form_element type=\"text\" validate=\"numeric\" options=\"\" placeholder=\"Phone\"] [form_element type=\"submit\" validate=\"\" options=\"\" placeholder=\"Apply\"] [/form]</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\" style=\"opacity: 1; display: inline-block; z-index: 1;\" aria-disabled=\"false\"><span class=\"module_name column_name\">1/4 Column</span> <span class=\"delete_column delete\" style=\"display: block;\"></span><div data-placeholder=\"Carousels/Rotating Blocks\" data-name=\"carousel\" class=\"module m_carousel ui-draggable\" style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1; height: 18px;\"><span class=\"module_name\">Testimonials</span><span class=\"move\" style=\"display: block;\"></span><span class=\"delete\" style=\"display: block;\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Testimonials</div><div data-option_name=\"show_title\" class=\"show_title module_setting\">1</div><div data-option_name=\"show_more\" class=\"show_more module_setting\">0</div><div data-option_name=\"more_link\" class=\"more_link module_setting\"></div><div data-option_name=\"show_controls\" class=\"show_controls module_setting\">1</div><div data-option_name=\"post_type\" class=\"post_type module_setting\">testimonials</div><div data-option_name=\"taxonomy\" class=\"taxonomy module_setting\"></div><div data-option_name=\"term\" class=\"term module_setting\"></div><div data-option_name=\"post_ids\" class=\"post_ids module_setting\"></div><div data-option_name=\"featured_style\" class=\"featured_style module_setting\">testimonial</div><div data-option_name=\"auto_slide\" class=\"auto_slide module_setting\">1</div><div data-option_name=\"column_width\" class=\"column_width module_setting\">268</div><div data-option_name=\"carousel_max\" class=\"carousel_max module_setting\">1</div><div data-option_name=\"carousel_min\" class=\"carousel_min module_setting\">1</div><div data-option_name=\"carousel_number\" class=\"carousel_number module_setting\">3</div><div data-option_name=\"carousel_excerpt_length\" class=\"carousel_excerpt_length module_setting\">100</div><div data-option_name=\"carousel_lightbox\" class=\"carousel_lightbox module_setting\">1</div><div data-option_name=\"carousel_link\" class=\"carousel_link module_setting\">1</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div>\";}i:4;a:2:{s:4:\"name\";s:13:\"services page\";s:7:\"content\";s:14610:\"<div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable first\"><span class=\"module_name column_name\">1/4 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p style=\"text-align: center;\"><a href=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/free-60-icons-53.png\"><img class=\"alignnone size-full wp-image-1141\" alt=\"free-60-icons-53\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/free-60-icons-53.png\" height=\"128\" width=\"128\"></a></p><h4 style=\"text-align: center;\">WooCommerce Ready</h4><p style=\"text-align: center;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\"><span class=\"module_name column_name\">1/4 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p style=\"text-align: center;\"><a href=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/free-60-icons-031.png\"><img class=\"alignnone size-full wp-image-1253\" alt=\"free-60-icons-03\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/free-60-icons-031.png\" height=\"128\" width=\"128\"></a></p><h4 style=\"text-align: center;\">Multimedia Questions</h4><p style=\"text-align: center;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\"><span class=\"module_name column_name\">1/4 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p style=\"text-align: center;\"><a href=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/free-60-icons-12.png\"><img class=\"alignnone size-full wp-image-1407\" alt=\"free-60-icons-12\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/free-60-icons-12.png\" height=\"128\" width=\"128\"></a></p><h4 style=\"text-align: center;\">Badges &amp; Certificates</h4><p style=\"text-align: center;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/4 Column\" data-name=\"1_4\" class=\"module m_column m_column_1_4 ui-draggable ui-resizable ui-droppable ui-sortable\"><span class=\"module_name column_name\">1/4 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p style=\"text-align: center;\"><a href=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/free-60-icons-50.png\"><img class=\"alignnone size-full wp-image-1201\" alt=\"free-60-icons-50\" src=\"http://vibethemes.com/envato/wplms/wp-content/uploads/2014/02/free-60-icons-50.png\" height=\"128\" width=\"128\"></a></p><h4 style=\"text-align: center;\">BuddyPress &amp; BbPress</h4><p style=\"text-align: center;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div>				<div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/3 Column\" data-name=\"1_3\" class=\"module m_column m_column_1_3 ui-draggable ui-resizable ui-droppable ui-sortable first\"><span class=\"module_name column_name\">1/3 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1; height: 18px;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>[heading]How we do[/heading]</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus porttitor interdum tempor. Phasellus quis nisl massa. Nullam facilisis ut orci ut porta. Aenean quis justo eu lorem pellentesque iaculis. Etiam at sem velit. Quisque ac iaculis purus. Nullam sodales at mauris quis tristique.</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/3 Column\" data-name=\"1_3\" class=\"module m_column m_column_1_3 ui-draggable ui-resizable ui-droppable ui-sortable\"><span class=\"module_name column_name\">1/3 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1; height: 18px;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable ui-resizable first\"><span class=\"module_name\">Content</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>[heading]What we do[/heading]</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus porttitor interdum tempor. Phasellus quis nisl massa. Nullam facilisis ut orci ut porta. Aenean quis justo eu lorem pellentesque iaculis. Etiam at sem velit. Quisque ac iaculis purus. Nullam sodales at mauris quis tristique.</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1;\" data-placeholder=\"1/3 Column\" data-name=\"1_3\" class=\"module m_column m_column_1_3 ui-draggable ui-resizable ui-droppable ui-sortable\"><span class=\"module_name column_name\">1/3 Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"WP Editor\" data-name=\"text_block\" class=\"module m_text_block ui-draggable\"><span class=\"module_name\">Content<span class=\"unsaved\"> ( Unsaved )</span></span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Content</div><div data-option_name=\"text_block_content\" class=\"text_block_content module_setting v_module_content\"><p>[testimonial id=\"350\" length=100]</p><p>&nbsp;</p></div><div data-option_name=\"animation_effect\" class=\"animation_effect module_setting\">nothing_selected</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div><div aria-disabled=\"false\" style=\"opacity: 1; display: inline-block; z-index: 1; width: 672px;\" data-placeholder=\"Full-Width Resizable Column\" data-name=\"resizable\" class=\"module m_column m_column_resizable ui-draggable ui-resizable ui-droppable ui-sortable first\"><span class=\"module_name column_name\">Full-Width Resizable Column</span> <span style=\"display: block;\" class=\"delete_column delete\"></span><div style=\"opacity: 1; display: inline-block; width: 100%; margin-right: 0px; z-index: 1;\" data-placeholder=\"Carousels/Rotating Blocks\" data-name=\"carousel\" class=\"module m_carousel ui-draggable\"><span class=\"module_name\">Showcase Course</span><span style=\"display: block;\" class=\"move\"></span><span style=\"display: block;\" class=\"delete\"></span><span class=\"settings_arrow\"></span><div class=\"module_settings\"><div data-option_name=\"title\" class=\"title module_setting\">Showcase Courses</div><div data-option_name=\"show_title\" class=\"show_title module_setting\">1</div><div data-option_name=\"show_more\" class=\"show_more module_setting\">0</div><div data-option_name=\"more_link\" class=\"more_link module_setting\"></div><div data-option_name=\"show_controls\" class=\"show_controls module_setting\">1</div><div data-option_name=\"post_type\" class=\"post_type module_setting\">course</div><div data-option_name=\"taxonomy\" class=\"taxonomy module_setting\"></div><div data-option_name=\"term\" class=\"term module_setting\"></div><div data-option_name=\"post_ids\" class=\"post_ids module_setting\"></div><div data-option_name=\"featured_style\" class=\"featured_style module_setting\">course</div><div data-option_name=\"auto_slide\" class=\"auto_slide module_setting\">1</div><div data-option_name=\"column_width\" class=\"column_width module_setting\">268</div><div data-option_name=\"carousel_max\" class=\"carousel_max module_setting\">4</div><div data-option_name=\"carousel_min\" class=\"carousel_min module_setting\">4</div><div data-option_name=\"carousel_number\" class=\"carousel_number module_setting\">6</div><div data-option_name=\"carousel_excerpt_length\" class=\"carousel_excerpt_length module_setting\">100</div><div data-option_name=\"carousel_lightbox\" class=\"carousel_lightbox module_setting\">1</div><div data-option_name=\"carousel_link\" class=\"carousel_link module_setting\">1</div><div data-option_name=\"css_class\" class=\"css_class module_setting\"></div><div data-option_name=\"container_css\" class=\"container_css module_setting\"></div><div data-option_name=\"custom_css\" class=\"custom_css module_setting\"></div></div></div><div class=\"ui-resizable-handle ui-resizable-e\" style=\"z-index: 90;\"></div></div>\";}}", "yes");
INSERT INTO `wp_options` VALUES("934", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("935", "revslider-latest-version", "6.1.3", "yes");
INSERT INTO `wp_options` VALUES("936", "revslider-stable-version", "4.2", "yes");
INSERT INTO `wp_options` VALUES("937", "revslider-notices", "a:1:{i:0;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.9.9\";s:4:\"text\";s:478:\"<div style=\"width: 1000px; height: 390px;\"><a href=\"https://getsliderrevolution.com\" target=\"_blank\" style=\"float:left;\"><img alt=\"Buy Slider Revolution 6\" src=\"//updates.themepunch-ext-a.tools/banners/rs60/sixzero_left.jpg\" width=\"670\" height=\"390\"></a><a href=\"https://youtu.be/mn5hC07aGvE\" target=\"_blank\" style=\"float:right;\"><img alt=\"Watch Slider Revolution 6 Video\" src=\"//updates.themepunch-ext-a.tools/banners/rs60/sixzero_right.jpg\" width=\"330\" height=\"390\"></a></div>\";s:4:\"code\";s:10:\"TPRS600-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("938", "revslider-dashboard", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("939", "revslider-addons", "O:8:\"stdClass\":26:{s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:71:\"//updates.themepunch-ext-a.tools/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:63:\"//updates.themepunch-ext-a.tools/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"5.3.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"1.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"1.1.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch-ext-a.tools/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch-ext-a.tools/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:65:\"//updates.themepunch-ext-a.tools/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch-ext-a.tools/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:62:\"//updates.themepunch-ext-a.tools/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:63:\"//updates.themepunch-ext-a.tools/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"1.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch-ext-a.tools/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:64:\"//updates.themepunch-ext-a.tools/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:23:\"Display images in 360°\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:65:\"//updates.themepunch-ext-a.tools/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:64:\"//updates.themepunch-ext-a.tools/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:63:\"//updates.themepunch-ext-a.tools/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:63:\"//updates.themepunch-ext-a.tools/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch-ext-a.tools/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}}", "yes");
INSERT INTO `wp_options` VALUES("980", "catalog_options", "", "yes");
INSERT INTO `wp_options` VALUES("981", "image_options", "", "yes");
INSERT INTO `wp_options` VALUES("1042", "lms_settings", "a:1:{s:7:\"general\";a:15:{s:22:\"student_login_redirect\";s:4:\"home\";s:25:\"instructor_login_redirect\";s:4:\"home\";s:32:\"terms_conditions_in_registration\";s:0:\"\";s:27:\"vibe_display_course_members\";s:1:\"0\";s:30:\"vibe_display_course_curriculum\";s:1:\"0\";s:26:\"vibe_display_course_events\";s:1:\"0\";s:28:\"vibe_display_course_activity\";s:1:\"0\";s:25:\"vibe_display_course_drive\";s:1:\"0\";s:20:\"in_course_quiz_paged\";s:0:\"\";s:13:\"default_order\";s:4:\"date\";s:21:\"members_default_order\";s:0:\"\";s:31:\"instructor_signup_ninja_form_id\";s:0:\"\";s:12:\"course_limit\";s:0:\"\";s:10:\"unit_limit\";s:0:\"\";s:10:\"quiz_limit\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("1045", "evcal_options_evcal_2", "a:1:{s:2:\"L1\";a:106:{s:11:\"option_page\";s:17:\"evcal_field_group\";s:6:\"action\";s:6:\"update\";s:8:\"_wpnonce\";s:10:\"147f47a93c\";s:16:\"_wp_http_referer\";s:54:\"/wplms/wp-admin/admin.php?page=eventon&amp;tab=evcal_2\";s:15:\"evcal_noncename\";s:10:\"eceeb24567\";s:12:\"evcal_lang_1\";s:0:\"\";s:12:\"evcal_lang_2\";s:0:\"\";s:12:\"evcal_lang_3\";s:0:\"\";s:12:\"evcal_lang_4\";s:0:\"\";s:12:\"evcal_lang_5\";s:0:\"\";s:12:\"evcal_lang_6\";s:0:\"\";s:12:\"evcal_lang_7\";s:0:\"\";s:12:\"evcal_lang_8\";s:0:\"\";s:12:\"evcal_lang_9\";s:0:\"\";s:13:\"evcal_lang_10\";s:0:\"\";s:13:\"evcal_lang_11\";s:0:\"\";s:13:\"evcal_lang_12\";s:0:\"\";s:14:\"evo_lang_3Lm_1\";s:0:\"\";s:14:\"evo_lang_3Lm_2\";s:0:\"\";s:14:\"evo_lang_3Lm_3\";s:0:\"\";s:14:\"evo_lang_3Lm_4\";s:0:\"\";s:14:\"evo_lang_3Lm_5\";s:0:\"\";s:14:\"evo_lang_3Lm_6\";s:0:\"\";s:14:\"evo_lang_3Lm_7\";s:0:\"\";s:14:\"evo_lang_3Lm_8\";s:0:\"\";s:14:\"evo_lang_3Lm_9\";s:0:\"\";s:15:\"evo_lang_3Lm_10\";s:0:\"\";s:15:\"evo_lang_3Lm_11\";s:0:\"\";s:15:\"evo_lang_3Lm_12\";s:0:\"\";s:14:\"evo_lang_1Lm_1\";s:0:\"\";s:14:\"evo_lang_1Lm_2\";s:0:\"\";s:14:\"evo_lang_1Lm_3\";s:0:\"\";s:14:\"evo_lang_1Lm_4\";s:0:\"\";s:14:\"evo_lang_1Lm_5\";s:0:\"\";s:14:\"evo_lang_1Lm_6\";s:0:\"\";s:14:\"evo_lang_1Lm_7\";s:0:\"\";s:14:\"evo_lang_1Lm_8\";s:0:\"\";s:14:\"evo_lang_1Lm_9\";s:0:\"\";s:15:\"evo_lang_1Lm_10\";s:0:\"\";s:15:\"evo_lang_1Lm_11\";s:0:\"\";s:15:\"evo_lang_1Lm_12\";s:0:\"\";s:15:\"evcal_lang_day1\";s:0:\"\";s:15:\"evcal_lang_day2\";s:0:\"\";s:15:\"evcal_lang_day3\";s:0:\"\";s:15:\"evcal_lang_day4\";s:0:\"\";s:15:\"evcal_lang_day5\";s:0:\"\";s:15:\"evcal_lang_day6\";s:0:\"\";s:15:\"evcal_lang_day7\";s:0:\"\";s:14:\"evo_lang_3Ld_1\";s:0:\"\";s:14:\"evo_lang_3Ld_2\";s:0:\"\";s:14:\"evo_lang_3Ld_3\";s:0:\"\";s:14:\"evo_lang_3Ld_4\";s:0:\"\";s:14:\"evo_lang_3Ld_5\";s:0:\"\";s:14:\"evo_lang_3Ld_6\";s:0:\"\";s:14:\"evo_lang_3Ld_7\";s:0:\"\";s:11:\"evo_lang_am\";s:0:\"\";s:11:\"evo_lang_pm\";s:0:\"\";s:16:\"evcal_lang_noeve\";s:0:\"\";s:17:\"evcal_lang_allday\";s:0:\"\";s:16:\"evcal_lang_yrrnd\";s:0:\"\";s:17:\"evcal_lang_events\";s:0:\"\";s:14:\"evcal_lang_sme\";s:0:\"\";s:21:\"evcal_evcard_evcancel\";s:0:\"\";s:18:\"evo_lang_eventtags\";s:0:\"\";s:12:\"evo_lang_yes\";s:0:\"\";s:11:\"evo_lang_no\";s:0:\"\";s:13:\"evo_lang_more\";s:0:\"\";s:14:\"evcal_lang_et1\";s:0:\"\";s:14:\"evcal_lang_et2\";s:0:\"\";s:16:\"evcal_lang_evloc\";s:0:\"\";s:23:\"events-at-this-location\";s:0:\"\";s:16:\"evcal_lang_evorg\";s:0:\"\";s:24:\"events-by-this-organizer\";s:0:\"\";s:21:\"evcal_lang_jumpmonths\";s:0:\"\";s:22:\"evcal_lang_jumpmonthsM\";s:0:\"\";s:22:\"evcal_lang_jumpmonthsY\";s:0:\"\";s:15:\"evcal_lang_sopt\";s:0:\"\";s:15:\"evcal_lang_sort\";s:0:\"\";s:16:\"evcal_lang_sdate\";s:0:\"\";s:18:\"evcal_lang_sposted\";s:0:\"\";s:17:\"evcal_lang_stitle\";s:0:\"\";s:14:\"evcal_lang_all\";s:0:\"\";s:20:\"evcal_lang_gototoday\";s:0:\"\";s:24:\"evcal_lang_location_name\";s:0:\"\";s:16:\"evcal_evcard_loc\";s:0:\"\";s:25:\"evcalL_getdir_placeholder\";s:0:\"\";s:19:\"evcalL_getdir_title\";s:0:\"\";s:15:\"evcal_lang_time\";s:0:\"\";s:17:\"evcal_lang_scolor\";s:0:\"\";s:13:\"evcal_lang_at\";s:0:\"\";s:20:\"evcal_evcard_details\";s:0:\"\";s:16:\"evcal_evcard_org\";s:0:\"\";s:16:\"evcal_lang_close\";s:0:\"\";s:15:\"evcal_lang_more\";s:0:\"\";s:15:\"evcal_lang_less\";s:0:\"\";s:17:\"evcal_evcard_tix1\";s:0:\"\";s:17:\"evcal_evcard_btn1\";s:0:\"\";s:17:\"evcal_evcard_tix2\";s:0:\"\";s:17:\"evcal_evcard_btn2\";s:0:\"\";s:16:\"evcal_evcard_cap\";s:0:\"\";s:22:\"evcal_evcard_learnmore\";s:0:\"\";s:23:\"evcal_evcard_learnmore2\";s:0:\"\";s:20:\"evcal_evcard_calncal\";s:0:\"\";s:20:\"evcal_evcard_calgcal\";s:0:\"\";s:19:\"evcal_evcard_addics\";s:0:\"\";s:20:\"evcal_evcard_addgcal\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("1316", "widget_evcalwidget_next_month", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1341", "theme_mods_wplms-old", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:4:{s:8:\"top-menu\";i:60;s:9:\"main-menu\";i:59;s:11:\"mobile-menu\";i:64;s:11:\"footer-menu\";i:63;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1472990716;s:4:\"data\";a:14:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:33:\"woocommerce_layered_nav_filters-3\";}s:11:\"mainsidebar\";a:0:{}s:7:\"bbpress\";a:0:{}s:13:\"coursesidebar\";a:4:{i:0;s:10:\"vibetabs-2\";i:1;s:8:\"search-2\";i:2;s:31:\"woocommerce_product_tag_cloud-4\";i:3;s:13:\"vibegallery-2\";}s:13:\"searchsidebar\";a:0:{}s:11:\"shopsidebar\";a:1:{i:0;s:31:\"woocommerce_product_tag_cloud-3\";}s:14:\"productsidebar\";a:1:{i:0;s:28:\"vibe_woocommerce_carousels-2\";}s:10:\"buddypress\";a:2:{i:0;s:26:\"woocommerce_price_filter-2\";i:1;s:28:\"vibe_woocommerce_carousels-3\";}s:8:\"checkout\";a:3:{i:0;s:24:\"vibe_course_categories-2\";i:1;s:32:\"woocommerce_product_categories-2\";i:2;s:22:\"woocommerce_products-2\";}s:16:\"topfootersidebar\";a:1:{i:0;s:24:\"vibe_course_categories-3\";}s:19:\"bottomfootersidebar\";a:0:{}s:8:\"MegaMenu\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:18:\"orphaned_widgets_1\";a:4:{i:0;s:10:\"nav_menu-2\";i:1;s:21:\"vibecertificatecode-2\";i:2;s:31:\"woocommerce_product_tag_cloud-2\";i:3;s:28:\"bp_core_whos_online_widget-2\";}s:18:\"orphaned_widgets_2\";a:4:{i:0;s:10:\"nav_menu-7\";i:1;s:10:\"nav_menu-6\";i:2;s:10:\"nav_menu-5\";i:3;s:6:\"text-4\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("1543", "woocommerce_db_version", "2.5.5", "yes");
INSERT INTO `wp_options` VALUES("1545", "rewrite_rules", "a:1012:{s:9:\"forums/?$\";s:25:\"index.php?post_type=forum\";s:39:\"forums/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=forum&feed=$matches[1]\";s:34:\"forums/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=forum&feed=$matches[1]\";s:26:\"forums/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=forum&paged=$matches[1]\";s:9:\"topics/?$\";s:25:\"index.php?post_type=topic\";s:39:\"topics/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=topic&feed=$matches[1]\";s:34:\"topics/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=topic&feed=$matches[1]\";s:26:\"topics/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=topic&paged=$matches[1]\";s:28:\"forums/forum/([^/]+)/edit/?$\";s:34:\"index.php?forum=$matches[1]&edit=1\";s:28:\"forums/topic/([^/]+)/edit/?$\";s:34:\"index.php?topic=$matches[1]&edit=1\";s:28:\"forums/reply/([^/]+)/edit/?$\";s:34:\"index.php?reply=$matches[1]&edit=1\";s:32:\"forums/topic-tag/([^/]+)/edit/?$\";s:38:\"index.php?topic-tag=$matches[1]&edit=1\";s:47:\"forums/user/([^/]+)/topics/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_tops=1&paged=$matches[2]\";s:48:\"forums/user/([^/]+)/replies/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_reps=1&paged=$matches[2]\";s:50:\"forums/user/([^/]+)/favorites/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_favs=1&paged=$matches[2]\";s:54:\"forums/user/([^/]+)/subscriptions/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_subs=1&paged=$matches[2]\";s:29:\"forums/user/([^/]+)/topics/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_tops=1\";s:30:\"forums/user/([^/]+)/replies/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_reps=1\";s:32:\"forums/user/([^/]+)/favorites/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_favs=1\";s:36:\"forums/user/([^/]+)/subscriptions/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_subs=1\";s:27:\"forums/user/([^/]+)/edit/?$\";s:37:\"index.php?bbp_user=$matches[1]&edit=1\";s:22:\"forums/user/([^/]+)/?$\";s:30:\"index.php?bbp_user=$matches[1]\";s:40:\"forums/view/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?bbp_view=$matches[1]&paged=$matches[2]\";s:27:\"forums/view/([^/]+)/feed/?$\";s:47:\"index.php?bbp_view=$matches[1]&feed=$matches[2]\";s:22:\"forums/view/([^/]+)/?$\";s:30:\"index.php?bbp_view=$matches[1]\";s:34:\"forums/search/page/?([0-9]{1,})/?$\";s:27:\"index.php?paged=$matches[1]\";s:16:\"forums/search/?$\";s:20:\"index.php?bbp_search\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:9:\"events/?$\";s:31:\"index.php?post_type=ajde_events\";s:39:\"events/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=ajde_events&feed=$matches[1]\";s:34:\"events/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=ajde_events&feed=$matches[1]\";s:26:\"events/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=ajde_events&paged=$matches[1]\";s:14:\"all-courses/?$\";s:26:\"index.php?post_type=course\";s:44:\"all-courses/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=course&feed=$matches[1]\";s:39:\"all-courses/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=course&feed=$matches[1]\";s:31:\"all-courses/page/([0-9]{1,})/?$\";s:44:\"index.php?post_type=course&paged=$matches[1]\";s:13:\"assignment/?$\";s:36:\"index.php?post_type=wplms-assignment\";s:43:\"assignment/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=wplms-assignment&feed=$matches[1]\";s:38:\"assignment/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=wplms-assignment&feed=$matches[1]\";s:30:\"assignment/page/([0-9]{1,})/?$\";s:54:\"index.php?post_type=wplms-assignment&paged=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:20:\"نظر مشتری/?$\";s:32:\"index.php?post_type=testimonials\";s:50:\"نظر مشتری/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=testimonials&feed=$matches[1]\";s:45:\"نظر مشتری/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=testimonials&feed=$matches[1]\";s:37:\"نظر مشتری/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=testimonials&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:36:\"category/(.+?)/curriculum(/(.*))?/?$\";s:58:\"index.php?category_name=$matches[1]&curriculum=$matches[3]\";s:33:\"category/(.+?)/members(/(.*))?/?$\";s:55:\"index.php?category_name=$matches[1]&members=$matches[3]\";s:34:\"category/(.+?)/activity(/(.*))?/?$\";s:56:\"index.php?category_name=$matches[1]&activity=$matches[3]\";s:31:\"category/(.+?)/admin(/(.*))?/?$\";s:53:\"index.php?category_name=$matches[1]&admin=$matches[3]\";s:37:\"category/(.+?)/submissions(/(.*))?/?$\";s:59:\"index.php?category_name=$matches[1]&submissions=$matches[3]\";s:31:\"category/(.+?)/stats(/(.*))?/?$\";s:53:\"index.php?category_name=$matches[1]&stats=$matches[3]\";s:32:\"category/(.+?)/events(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&events=$matches[3]\";s:31:\"category/(.+?)/drive(/(.*))?/?$\";s:53:\"index.php?category_name=$matches[1]&drive=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:33:\"tag/([^/]+)/curriculum(/(.*))?/?$\";s:48:\"index.php?tag=$matches[1]&curriculum=$matches[3]\";s:30:\"tag/([^/]+)/members(/(.*))?/?$\";s:45:\"index.php?tag=$matches[1]&members=$matches[3]\";s:31:\"tag/([^/]+)/activity(/(.*))?/?$\";s:46:\"index.php?tag=$matches[1]&activity=$matches[3]\";s:28:\"tag/([^/]+)/admin(/(.*))?/?$\";s:43:\"index.php?tag=$matches[1]&admin=$matches[3]\";s:34:\"tag/([^/]+)/submissions(/(.*))?/?$\";s:49:\"index.php?tag=$matches[1]&submissions=$matches[3]\";s:28:\"tag/([^/]+)/stats(/(.*))?/?$\";s:43:\"index.php?tag=$matches[1]&stats=$matches[3]\";s:29:\"tag/([^/]+)/events(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&events=$matches[3]\";s:28:\"tag/([^/]+)/drive(/(.*))?/?$\";s:43:\"index.php?tag=$matches[1]&drive=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:38:\"forums/forum/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"forums/forum/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"forums/forum/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"forums/forum/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"forums/forum/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"forums/forum/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"forums/forum/(.+?)/embed/?$\";s:38:\"index.php?forum=$matches[1]&embed=true\";s:31:\"forums/forum/(.+?)/trackback/?$\";s:32:\"index.php?forum=$matches[1]&tb=1\";s:51:\"forums/forum/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:46:\"forums/forum/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:39:\"forums/forum/(.+?)/page/?([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&paged=$matches[2]\";s:46:\"forums/forum/(.+?)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&cpage=$matches[2]\";s:33:\"forums/forum/(.+?)/var(/(.*))?/?$\";s:43:\"index.php?forum=$matches[1]&var=$matches[3]\";s:36:\"forums/forum/(.+?)/wc-api(/(.*))?/?$\";s:46:\"index.php?forum=$matches[1]&wc-api=$matches[3]\";s:40:\"forums/forum/(.+?)/curriculum(/(.*))?/?$\";s:50:\"index.php?forum=$matches[1]&curriculum=$matches[3]\";s:37:\"forums/forum/(.+?)/members(/(.*))?/?$\";s:47:\"index.php?forum=$matches[1]&members=$matches[3]\";s:38:\"forums/forum/(.+?)/activity(/(.*))?/?$\";s:48:\"index.php?forum=$matches[1]&activity=$matches[3]\";s:35:\"forums/forum/(.+?)/admin(/(.*))?/?$\";s:45:\"index.php?forum=$matches[1]&admin=$matches[3]\";s:41:\"forums/forum/(.+?)/submissions(/(.*))?/?$\";s:51:\"index.php?forum=$matches[1]&submissions=$matches[3]\";s:35:\"forums/forum/(.+?)/stats(/(.*))?/?$\";s:45:\"index.php?forum=$matches[1]&stats=$matches[3]\";s:36:\"forums/forum/(.+?)/events(/(.*))?/?$\";s:46:\"index.php?forum=$matches[1]&events=$matches[3]\";s:35:\"forums/forum/(.+?)/drive(/(.*))?/?$\";s:45:\"index.php?forum=$matches[1]&drive=$matches[3]\";s:42:\"forums/forum/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"forums/forum/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:46:\"forums/forum/.+?/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:57:\"forums/forum/.+?/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:43:\"forums/forum/.+?/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:54:\"forums/forum/.+?/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:44:\"forums/forum/.+?/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:55:\"forums/forum/.+?/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:41:\"forums/forum/.+?/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:52:\"forums/forum/.+?/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:47:\"forums/forum/.+?/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:58:\"forums/forum/.+?/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:41:\"forums/forum/.+?/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:52:\"forums/forum/.+?/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:42:\"forums/forum/.+?/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:53:\"forums/forum/.+?/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:41:\"forums/forum/.+?/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:52:\"forums/forum/.+?/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:35:\"forums/forum/(.+?)(?:/([0-9]+))?/?$\";s:44:\"index.php?forum=$matches[1]&page=$matches[2]\";s:40:\"forums/topic/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"forums/topic/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"forums/topic/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"forums/topic/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"forums/topic/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"forums/topic/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"forums/topic/([^/]+)/embed/?$\";s:38:\"index.php?topic=$matches[1]&embed=true\";s:33:\"forums/topic/([^/]+)/trackback/?$\";s:32:\"index.php?topic=$matches[1]&tb=1\";s:53:\"forums/topic/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:48:\"forums/topic/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:41:\"forums/topic/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&paged=$matches[2]\";s:48:\"forums/topic/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&cpage=$matches[2]\";s:35:\"forums/topic/([^/]+)/var(/(.*))?/?$\";s:43:\"index.php?topic=$matches[1]&var=$matches[3]\";s:38:\"forums/topic/([^/]+)/wc-api(/(.*))?/?$\";s:46:\"index.php?topic=$matches[1]&wc-api=$matches[3]\";s:42:\"forums/topic/([^/]+)/curriculum(/(.*))?/?$\";s:50:\"index.php?topic=$matches[1]&curriculum=$matches[3]\";s:39:\"forums/topic/([^/]+)/members(/(.*))?/?$\";s:47:\"index.php?topic=$matches[1]&members=$matches[3]\";s:40:\"forums/topic/([^/]+)/activity(/(.*))?/?$\";s:48:\"index.php?topic=$matches[1]&activity=$matches[3]\";s:37:\"forums/topic/([^/]+)/admin(/(.*))?/?$\";s:45:\"index.php?topic=$matches[1]&admin=$matches[3]\";s:43:\"forums/topic/([^/]+)/submissions(/(.*))?/?$\";s:51:\"index.php?topic=$matches[1]&submissions=$matches[3]\";s:37:\"forums/topic/([^/]+)/stats(/(.*))?/?$\";s:45:\"index.php?topic=$matches[1]&stats=$matches[3]\";s:38:\"forums/topic/([^/]+)/events(/(.*))?/?$\";s:46:\"index.php?topic=$matches[1]&events=$matches[3]\";s:37:\"forums/topic/([^/]+)/drive(/(.*))?/?$\";s:45:\"index.php?topic=$matches[1]&drive=$matches[3]\";s:44:\"forums/topic/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"forums/topic/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"forums/topic/[^/]+/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:59:\"forums/topic/[^/]+/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:45:\"forums/topic/[^/]+/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:56:\"forums/topic/[^/]+/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:46:\"forums/topic/[^/]+/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:57:\"forums/topic/[^/]+/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:43:\"forums/topic/[^/]+/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:54:\"forums/topic/[^/]+/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:49:\"forums/topic/[^/]+/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:60:\"forums/topic/[^/]+/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:43:\"forums/topic/[^/]+/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:54:\"forums/topic/[^/]+/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:44:\"forums/topic/[^/]+/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:55:\"forums/topic/[^/]+/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:43:\"forums/topic/[^/]+/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:54:\"forums/topic/[^/]+/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:37:\"forums/topic/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?topic=$matches[1]&page=$matches[2]\";s:29:\"forums/topic/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"forums/topic/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"forums/topic/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"forums/topic/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"forums/topic/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"forums/topic/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"forums/reply/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"forums/reply/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"forums/reply/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"forums/reply/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"forums/reply/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"forums/reply/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"forums/reply/([^/]+)/embed/?$\";s:38:\"index.php?reply=$matches[1]&embed=true\";s:33:\"forums/reply/([^/]+)/trackback/?$\";s:32:\"index.php?reply=$matches[1]&tb=1\";s:41:\"forums/reply/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&paged=$matches[2]\";s:48:\"forums/reply/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&cpage=$matches[2]\";s:35:\"forums/reply/([^/]+)/var(/(.*))?/?$\";s:43:\"index.php?reply=$matches[1]&var=$matches[3]\";s:38:\"forums/reply/([^/]+)/wc-api(/(.*))?/?$\";s:46:\"index.php?reply=$matches[1]&wc-api=$matches[3]\";s:42:\"forums/reply/([^/]+)/curriculum(/(.*))?/?$\";s:50:\"index.php?reply=$matches[1]&curriculum=$matches[3]\";s:39:\"forums/reply/([^/]+)/members(/(.*))?/?$\";s:47:\"index.php?reply=$matches[1]&members=$matches[3]\";s:40:\"forums/reply/([^/]+)/activity(/(.*))?/?$\";s:48:\"index.php?reply=$matches[1]&activity=$matches[3]\";s:37:\"forums/reply/([^/]+)/admin(/(.*))?/?$\";s:45:\"index.php?reply=$matches[1]&admin=$matches[3]\";s:43:\"forums/reply/([^/]+)/submissions(/(.*))?/?$\";s:51:\"index.php?reply=$matches[1]&submissions=$matches[3]\";s:37:\"forums/reply/([^/]+)/stats(/(.*))?/?$\";s:45:\"index.php?reply=$matches[1]&stats=$matches[3]\";s:38:\"forums/reply/([^/]+)/events(/(.*))?/?$\";s:46:\"index.php?reply=$matches[1]&events=$matches[3]\";s:37:\"forums/reply/([^/]+)/drive(/(.*))?/?$\";s:45:\"index.php?reply=$matches[1]&drive=$matches[3]\";s:44:\"forums/reply/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"forums/reply/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"forums/reply/[^/]+/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:59:\"forums/reply/[^/]+/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:45:\"forums/reply/[^/]+/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:56:\"forums/reply/[^/]+/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:46:\"forums/reply/[^/]+/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:57:\"forums/reply/[^/]+/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:43:\"forums/reply/[^/]+/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:54:\"forums/reply/[^/]+/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:49:\"forums/reply/[^/]+/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:60:\"forums/reply/[^/]+/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:43:\"forums/reply/[^/]+/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:54:\"forums/reply/[^/]+/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:44:\"forums/reply/[^/]+/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:55:\"forums/reply/[^/]+/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:43:\"forums/reply/[^/]+/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:54:\"forums/reply/[^/]+/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:37:\"forums/reply/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?reply=$matches[1]&page=$matches[2]\";s:29:\"forums/reply/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"forums/reply/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"forums/reply/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"forums/reply/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"forums/reply/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"forums/reply/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"forums/topic-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:52:\"forums/topic-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:33:\"forums/topic-tag/([^/]+)/embed/?$\";s:42:\"index.php?topic-tag=$matches[1]&embed=true\";s:45:\"forums/topic-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?topic-tag=$matches[1]&paged=$matches[2]\";s:27:\"forums/topic-tag/([^/]+)/?$\";s:31:\"index.php?topic-tag=$matches[1]\";s:42:\"forums/search/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?bbp_search=$matches[1]&paged=$matches[2]\";s:24:\"forums/search/([^/]+)/?$\";s:32:\"index.php?bbp_search=$matches[1]\";s:55:\"event-location/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?event_location=$matches[1]&feed=$matches[2]\";s:50:\"event-location/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?event_location=$matches[1]&feed=$matches[2]\";s:31:\"event-location/([^/]+)/embed/?$\";s:47:\"index.php?event_location=$matches[1]&embed=true\";s:43:\"event-location/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?event_location=$matches[1]&paged=$matches[2]\";s:25:\"event-location/([^/]+)/?$\";s:36:\"index.php?event_location=$matches[1]\";s:56:\"event-organizer/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?event_organizer=$matches[1]&feed=$matches[2]\";s:51:\"event-organizer/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?event_organizer=$matches[1]&feed=$matches[2]\";s:32:\"event-organizer/([^/]+)/embed/?$\";s:48:\"index.php?event_organizer=$matches[1]&embed=true\";s:44:\"event-organizer/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?event_organizer=$matches[1]&paged=$matches[2]\";s:26:\"event-organizer/([^/]+)/?$\";s:37:\"index.php?event_organizer=$matches[1]\";s:51:\"event-type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?event_type=$matches[1]&feed=$matches[2]\";s:46:\"event-type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?event_type=$matches[1]&feed=$matches[2]\";s:27:\"event-type/([^/]+)/embed/?$\";s:43:\"index.php?event_type=$matches[1]&embed=true\";s:39:\"event-type/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?event_type=$matches[1]&paged=$matches[2]\";s:21:\"event-type/([^/]+)/?$\";s:32:\"index.php?event_type=$matches[1]\";s:53:\"event-type-2/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?event_type_2=$matches[1]&feed=$matches[2]\";s:48:\"event-type-2/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?event_type_2=$matches[1]&feed=$matches[2]\";s:29:\"event-type-2/([^/]+)/embed/?$\";s:45:\"index.php?event_type_2=$matches[1]&embed=true\";s:41:\"event-type-2/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?event_type_2=$matches[1]&paged=$matches[2]\";s:23:\"event-type-2/([^/]+)/?$\";s:34:\"index.php?event_type_2=$matches[1]\";s:34:\"events/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"events/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"events/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"events/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"events/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"events/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"events/([^/]+)/embed/?$\";s:44:\"index.php?ajde_events=$matches[1]&embed=true\";s:27:\"events/([^/]+)/trackback/?$\";s:38:\"index.php?ajde_events=$matches[1]&tb=1\";s:47:\"events/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?ajde_events=$matches[1]&feed=$matches[2]\";s:42:\"events/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?ajde_events=$matches[1]&feed=$matches[2]\";s:35:\"events/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?ajde_events=$matches[1]&paged=$matches[2]\";s:42:\"events/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?ajde_events=$matches[1]&cpage=$matches[2]\";s:29:\"events/([^/]+)/var(/(.*))?/?$\";s:49:\"index.php?ajde_events=$matches[1]&var=$matches[3]\";s:32:\"events/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?ajde_events=$matches[1]&wc-api=$matches[3]\";s:36:\"events/([^/]+)/curriculum(/(.*))?/?$\";s:56:\"index.php?ajde_events=$matches[1]&curriculum=$matches[3]\";s:33:\"events/([^/]+)/members(/(.*))?/?$\";s:53:\"index.php?ajde_events=$matches[1]&members=$matches[3]\";s:34:\"events/([^/]+)/activity(/(.*))?/?$\";s:54:\"index.php?ajde_events=$matches[1]&activity=$matches[3]\";s:31:\"events/([^/]+)/admin(/(.*))?/?$\";s:51:\"index.php?ajde_events=$matches[1]&admin=$matches[3]\";s:37:\"events/([^/]+)/submissions(/(.*))?/?$\";s:57:\"index.php?ajde_events=$matches[1]&submissions=$matches[3]\";s:31:\"events/([^/]+)/stats(/(.*))?/?$\";s:51:\"index.php?ajde_events=$matches[1]&stats=$matches[3]\";s:32:\"events/([^/]+)/events(/(.*))?/?$\";s:52:\"index.php?ajde_events=$matches[1]&events=$matches[3]\";s:31:\"events/([^/]+)/drive(/(.*))?/?$\";s:51:\"index.php?ajde_events=$matches[1]&drive=$matches[3]\";s:38:\"events/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"events/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"events/[^/]+/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:53:\"events/[^/]+/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:39:\"events/[^/]+/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:50:\"events/[^/]+/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:40:\"events/[^/]+/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:51:\"events/[^/]+/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:37:\"events/[^/]+/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:48:\"events/[^/]+/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:43:\"events/[^/]+/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:54:\"events/[^/]+/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:37:\"events/[^/]+/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:48:\"events/[^/]+/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:38:\"events/[^/]+/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:49:\"events/[^/]+/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:37:\"events/[^/]+/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:48:\"events/[^/]+/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:31:\"events/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?ajde_events=$matches[1]&page=$matches[2]\";s:23:\"events/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"events/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"events/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"events/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"events/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"events/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:49:\"course-cat/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?course-cat=$matches[1]&feed=$matches[2]\";s:44:\"course-cat/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?course-cat=$matches[1]&feed=$matches[2]\";s:25:\"course-cat/(.+?)/embed/?$\";s:43:\"index.php?course-cat=$matches[1]&embed=true\";s:37:\"course-cat/(.+?)/page/?([0-9]{1,})/?$\";s:50:\"index.php?course-cat=$matches[1]&paged=$matches[2]\";s:19:\"course-cat/(.+?)/?$\";s:32:\"index.php?course-cat=$matches[1]\";s:32:\"course/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"course/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"course/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"course/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"course/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"course/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"course/(.+?)/embed/?$\";s:39:\"index.php?course=$matches[1]&embed=true\";s:25:\"course/(.+?)/trackback/?$\";s:33:\"index.php?course=$matches[1]&tb=1\";s:45:\"course/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?course=$matches[1]&feed=$matches[2]\";s:40:\"course/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?course=$matches[1]&feed=$matches[2]\";s:33:\"course/(.+?)/page/?([0-9]{1,})/?$\";s:46:\"index.php?course=$matches[1]&paged=$matches[2]\";s:40:\"course/(.+?)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?course=$matches[1]&cpage=$matches[2]\";s:27:\"course/(.+?)/var(/(.*))?/?$\";s:44:\"index.php?course=$matches[1]&var=$matches[3]\";s:30:\"course/(.+?)/wc-api(/(.*))?/?$\";s:47:\"index.php?course=$matches[1]&wc-api=$matches[3]\";s:34:\"course/(.+?)/curriculum(/(.*))?/?$\";s:51:\"index.php?course=$matches[1]&curriculum=$matches[3]\";s:31:\"course/(.+?)/members(/(.*))?/?$\";s:48:\"index.php?course=$matches[1]&members=$matches[3]\";s:32:\"course/(.+?)/activity(/(.*))?/?$\";s:49:\"index.php?course=$matches[1]&activity=$matches[3]\";s:29:\"course/(.+?)/admin(/(.*))?/?$\";s:46:\"index.php?course=$matches[1]&admin=$matches[3]\";s:35:\"course/(.+?)/submissions(/(.*))?/?$\";s:52:\"index.php?course=$matches[1]&submissions=$matches[3]\";s:29:\"course/(.+?)/stats(/(.*))?/?$\";s:46:\"index.php?course=$matches[1]&stats=$matches[3]\";s:30:\"course/(.+?)/events(/(.*))?/?$\";s:47:\"index.php?course=$matches[1]&events=$matches[3]\";s:29:\"course/(.+?)/drive(/(.*))?/?$\";s:46:\"index.php?course=$matches[1]&drive=$matches[3]\";s:36:\"course/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"course/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"course/.+?/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:51:\"course/.+?/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:37:\"course/.+?/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:48:\"course/.+?/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:38:\"course/.+?/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:49:\"course/.+?/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:35:\"course/.+?/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:46:\"course/.+?/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:41:\"course/.+?/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:52:\"course/.+?/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:35:\"course/.+?/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:46:\"course/.+?/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:36:\"course/.+?/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:47:\"course/.+?/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:35:\"course/.+?/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:46:\"course/.+?/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:29:\"course/(.+?)(?:/([0-9]+))?/?$\";s:45:\"index.php?course=$matches[1]&page=$matches[2]\";s:30:\"unit/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"unit/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"unit/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"unit/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"unit/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"unit/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:19:\"unit/(.+?)/embed/?$\";s:37:\"index.php?unit=$matches[1]&embed=true\";s:23:\"unit/(.+?)/trackback/?$\";s:31:\"index.php?unit=$matches[1]&tb=1\";s:31:\"unit/(.+?)/page/?([0-9]{1,})/?$\";s:44:\"index.php?unit=$matches[1]&paged=$matches[2]\";s:38:\"unit/(.+?)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?unit=$matches[1]&cpage=$matches[2]\";s:25:\"unit/(.+?)/var(/(.*))?/?$\";s:42:\"index.php?unit=$matches[1]&var=$matches[3]\";s:28:\"unit/(.+?)/wc-api(/(.*))?/?$\";s:45:\"index.php?unit=$matches[1]&wc-api=$matches[3]\";s:32:\"unit/(.+?)/curriculum(/(.*))?/?$\";s:49:\"index.php?unit=$matches[1]&curriculum=$matches[3]\";s:29:\"unit/(.+?)/members(/(.*))?/?$\";s:46:\"index.php?unit=$matches[1]&members=$matches[3]\";s:30:\"unit/(.+?)/activity(/(.*))?/?$\";s:47:\"index.php?unit=$matches[1]&activity=$matches[3]\";s:27:\"unit/(.+?)/admin(/(.*))?/?$\";s:44:\"index.php?unit=$matches[1]&admin=$matches[3]\";s:33:\"unit/(.+?)/submissions(/(.*))?/?$\";s:50:\"index.php?unit=$matches[1]&submissions=$matches[3]\";s:27:\"unit/(.+?)/stats(/(.*))?/?$\";s:44:\"index.php?unit=$matches[1]&stats=$matches[3]\";s:28:\"unit/(.+?)/events(/(.*))?/?$\";s:45:\"index.php?unit=$matches[1]&events=$matches[3]\";s:27:\"unit/(.+?)/drive(/(.*))?/?$\";s:44:\"index.php?unit=$matches[1]&drive=$matches[3]\";s:34:\"unit/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:45:\"unit/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:38:\"unit/.+?/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:49:\"unit/.+?/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:35:\"unit/.+?/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:46:\"unit/.+?/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:36:\"unit/.+?/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:47:\"unit/.+?/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:33:\"unit/.+?/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:44:\"unit/.+?/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:39:\"unit/.+?/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:50:\"unit/.+?/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:33:\"unit/.+?/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:44:\"unit/.+?/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:34:\"unit/.+?/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:45:\"unit/.+?/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:33:\"unit/.+?/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:44:\"unit/.+?/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:27:\"unit/(.+?)(?:/([0-9]+))?/?$\";s:43:\"index.php?unit=$matches[1]&page=$matches[2]\";s:51:\"module-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?module-tag=$matches[1]&feed=$matches[2]\";s:46:\"module-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?module-tag=$matches[1]&feed=$matches[2]\";s:27:\"module-tag/([^/]+)/embed/?$\";s:43:\"index.php?module-tag=$matches[1]&embed=true\";s:39:\"module-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?module-tag=$matches[1]&paged=$matches[2]\";s:21:\"module-tag/([^/]+)/?$\";s:32:\"index.php?module-tag=$matches[1]\";s:30:\"quiz/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"quiz/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"quiz/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"quiz/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"quiz/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"quiz/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:19:\"quiz/(.+?)/embed/?$\";s:37:\"index.php?quiz=$matches[1]&embed=true\";s:23:\"quiz/(.+?)/trackback/?$\";s:31:\"index.php?quiz=$matches[1]&tb=1\";s:31:\"quiz/(.+?)/page/?([0-9]{1,})/?$\";s:44:\"index.php?quiz=$matches[1]&paged=$matches[2]\";s:38:\"quiz/(.+?)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?quiz=$matches[1]&cpage=$matches[2]\";s:25:\"quiz/(.+?)/var(/(.*))?/?$\";s:42:\"index.php?quiz=$matches[1]&var=$matches[3]\";s:28:\"quiz/(.+?)/wc-api(/(.*))?/?$\";s:45:\"index.php?quiz=$matches[1]&wc-api=$matches[3]\";s:32:\"quiz/(.+?)/curriculum(/(.*))?/?$\";s:49:\"index.php?quiz=$matches[1]&curriculum=$matches[3]\";s:29:\"quiz/(.+?)/members(/(.*))?/?$\";s:46:\"index.php?quiz=$matches[1]&members=$matches[3]\";s:30:\"quiz/(.+?)/activity(/(.*))?/?$\";s:47:\"index.php?quiz=$matches[1]&activity=$matches[3]\";s:27:\"quiz/(.+?)/admin(/(.*))?/?$\";s:44:\"index.php?quiz=$matches[1]&admin=$matches[3]\";s:33:\"quiz/(.+?)/submissions(/(.*))?/?$\";s:50:\"index.php?quiz=$matches[1]&submissions=$matches[3]\";s:27:\"quiz/(.+?)/stats(/(.*))?/?$\";s:44:\"index.php?quiz=$matches[1]&stats=$matches[3]\";s:28:\"quiz/(.+?)/events(/(.*))?/?$\";s:45:\"index.php?quiz=$matches[1]&events=$matches[3]\";s:27:\"quiz/(.+?)/drive(/(.*))?/?$\";s:44:\"index.php?quiz=$matches[1]&drive=$matches[3]\";s:34:\"quiz/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:45:\"quiz/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:38:\"quiz/.+?/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:49:\"quiz/.+?/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:35:\"quiz/.+?/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:46:\"quiz/.+?/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:36:\"quiz/.+?/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:47:\"quiz/.+?/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:33:\"quiz/.+?/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:44:\"quiz/.+?/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:39:\"quiz/.+?/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:50:\"quiz/.+?/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:33:\"quiz/.+?/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:44:\"quiz/.+?/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:34:\"quiz/.+?/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:45:\"quiz/.+?/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:33:\"quiz/.+?/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:44:\"quiz/.+?/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:27:\"quiz/(.+?)(?:/([0-9]+))?/?$\";s:43:\"index.php?quiz=$matches[1]&page=$matches[2]\";s:48:\"quiz-type/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?quiz-type=$matches[1]&feed=$matches[2]\";s:43:\"quiz-type/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?quiz-type=$matches[1]&feed=$matches[2]\";s:24:\"quiz-type/(.+?)/embed/?$\";s:42:\"index.php?quiz-type=$matches[1]&embed=true\";s:36:\"quiz-type/(.+?)/page/?([0-9]{1,})/?$\";s:49:\"index.php?quiz-type=$matches[1]&paged=$matches[2]\";s:18:\"quiz-type/(.+?)/?$\";s:31:\"index.php?quiz-type=$matches[1]\";s:34:\"question/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"question/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"question/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"question/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"question/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"question/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"question/(.+?)/embed/?$\";s:41:\"index.php?question=$matches[1]&embed=true\";s:27:\"question/(.+?)/trackback/?$\";s:35:\"index.php?question=$matches[1]&tb=1\";s:35:\"question/(.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?question=$matches[1]&paged=$matches[2]\";s:42:\"question/(.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?question=$matches[1]&cpage=$matches[2]\";s:29:\"question/(.+?)/var(/(.*))?/?$\";s:46:\"index.php?question=$matches[1]&var=$matches[3]\";s:32:\"question/(.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?question=$matches[1]&wc-api=$matches[3]\";s:36:\"question/(.+?)/curriculum(/(.*))?/?$\";s:53:\"index.php?question=$matches[1]&curriculum=$matches[3]\";s:33:\"question/(.+?)/members(/(.*))?/?$\";s:50:\"index.php?question=$matches[1]&members=$matches[3]\";s:34:\"question/(.+?)/activity(/(.*))?/?$\";s:51:\"index.php?question=$matches[1]&activity=$matches[3]\";s:31:\"question/(.+?)/admin(/(.*))?/?$\";s:48:\"index.php?question=$matches[1]&admin=$matches[3]\";s:37:\"question/(.+?)/submissions(/(.*))?/?$\";s:54:\"index.php?question=$matches[1]&submissions=$matches[3]\";s:31:\"question/(.+?)/stats(/(.*))?/?$\";s:48:\"index.php?question=$matches[1]&stats=$matches[3]\";s:32:\"question/(.+?)/events(/(.*))?/?$\";s:49:\"index.php?question=$matches[1]&events=$matches[3]\";s:31:\"question/(.+?)/drive(/(.*))?/?$\";s:48:\"index.php?question=$matches[1]&drive=$matches[3]\";s:38:\"question/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"question/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"question/.+?/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:53:\"question/.+?/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:39:\"question/.+?/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:50:\"question/.+?/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:40:\"question/.+?/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:51:\"question/.+?/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:37:\"question/.+?/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:48:\"question/.+?/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:43:\"question/.+?/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:54:\"question/.+?/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:37:\"question/.+?/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:48:\"question/.+?/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:38:\"question/.+?/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:49:\"question/.+?/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:37:\"question/.+?/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:48:\"question/.+?/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:31:\"question/(.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?question=$matches[1]&page=$matches[2]\";s:53:\"question-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?question-tag=$matches[1]&feed=$matches[2]\";s:48:\"question-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?question-tag=$matches[1]&feed=$matches[2]\";s:29:\"question-tag/([^/]+)/embed/?$\";s:45:\"index.php?question-tag=$matches[1]&embed=true\";s:41:\"question-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?question-tag=$matches[1]&paged=$matches[2]\";s:23:\"question-tag/([^/]+)/?$\";s:34:\"index.php?question-tag=$matches[1]\";s:36:\"assignment/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"assignment/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"assignment/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"assignment/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"assignment/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"assignment/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"assignment/(.+?)/embed/?$\";s:49:\"index.php?wplms-assignment=$matches[1]&embed=true\";s:29:\"assignment/(.+?)/trackback/?$\";s:43:\"index.php?wplms-assignment=$matches[1]&tb=1\";s:49:\"assignment/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?wplms-assignment=$matches[1]&feed=$matches[2]\";s:44:\"assignment/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?wplms-assignment=$matches[1]&feed=$matches[2]\";s:37:\"assignment/(.+?)/page/?([0-9]{1,})/?$\";s:56:\"index.php?wplms-assignment=$matches[1]&paged=$matches[2]\";s:44:\"assignment/(.+?)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?wplms-assignment=$matches[1]&cpage=$matches[2]\";s:31:\"assignment/(.+?)/var(/(.*))?/?$\";s:54:\"index.php?wplms-assignment=$matches[1]&var=$matches[3]\";s:34:\"assignment/(.+?)/wc-api(/(.*))?/?$\";s:57:\"index.php?wplms-assignment=$matches[1]&wc-api=$matches[3]\";s:38:\"assignment/(.+?)/curriculum(/(.*))?/?$\";s:61:\"index.php?wplms-assignment=$matches[1]&curriculum=$matches[3]\";s:35:\"assignment/(.+?)/members(/(.*))?/?$\";s:58:\"index.php?wplms-assignment=$matches[1]&members=$matches[3]\";s:36:\"assignment/(.+?)/activity(/(.*))?/?$\";s:59:\"index.php?wplms-assignment=$matches[1]&activity=$matches[3]\";s:33:\"assignment/(.+?)/admin(/(.*))?/?$\";s:56:\"index.php?wplms-assignment=$matches[1]&admin=$matches[3]\";s:39:\"assignment/(.+?)/submissions(/(.*))?/?$\";s:62:\"index.php?wplms-assignment=$matches[1]&submissions=$matches[3]\";s:33:\"assignment/(.+?)/stats(/(.*))?/?$\";s:56:\"index.php?wplms-assignment=$matches[1]&stats=$matches[3]\";s:34:\"assignment/(.+?)/events(/(.*))?/?$\";s:57:\"index.php?wplms-assignment=$matches[1]&events=$matches[3]\";s:33:\"assignment/(.+?)/drive(/(.*))?/?$\";s:56:\"index.php?wplms-assignment=$matches[1]&drive=$matches[3]\";s:40:\"assignment/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"assignment/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:44:\"assignment/.+?/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:55:\"assignment/.+?/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:41:\"assignment/.+?/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:52:\"assignment/.+?/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:42:\"assignment/.+?/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:53:\"assignment/.+?/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:39:\"assignment/.+?/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:50:\"assignment/.+?/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:45:\"assignment/.+?/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:56:\"assignment/.+?/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:39:\"assignment/.+?/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:50:\"assignment/.+?/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:40:\"assignment/.+?/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:51:\"assignment/.+?/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:39:\"assignment/.+?/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:50:\"assignment/.+?/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:33:\"assignment/(.+?)(?:/([0-9]+))?/?$\";s:55:\"index.php?wplms-assignment=$matches[1]&page=$matches[2]\";s:54:\"Assignment-type/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?assignment-type=$matches[1]&feed=$matches[2]\";s:49:\"Assignment-type/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?assignment-type=$matches[1]&feed=$matches[2]\";s:30:\"Assignment-type/(.+?)/embed/?$\";s:48:\"index.php?assignment-type=$matches[1]&embed=true\";s:42:\"Assignment-type/(.+?)/page/?([0-9]{1,})/?$\";s:55:\"index.php?assignment-type=$matches[1]&paged=$matches[2]\";s:24:\"Assignment-type/(.+?)/?$\";s:37:\"index.php?assignment-type=$matches[1]\";s:36:\"payments/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"payments/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"payments/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"payments/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"payments/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"payments/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"payments/([^/]+)/embed/?$\";s:56:\"index.php?post_type=payments&name=$matches[1]&embed=true\";s:29:\"payments/([^/]+)/trackback/?$\";s:50:\"index.php?post_type=payments&name=$matches[1]&tb=1\";s:37:\"payments/([^/]+)/page/?([0-9]{1,})/?$\";s:63:\"index.php?post_type=payments&name=$matches[1]&paged=$matches[2]\";s:44:\"payments/([^/]+)/comment-page-([0-9]{1,})/?$\";s:63:\"index.php?post_type=payments&name=$matches[1]&cpage=$matches[2]\";s:31:\"payments/([^/]+)/var(/(.*))?/?$\";s:61:\"index.php?post_type=payments&name=$matches[1]&var=$matches[3]\";s:34:\"payments/([^/]+)/wc-api(/(.*))?/?$\";s:64:\"index.php?post_type=payments&name=$matches[1]&wc-api=$matches[3]\";s:38:\"payments/([^/]+)/curriculum(/(.*))?/?$\";s:68:\"index.php?post_type=payments&name=$matches[1]&curriculum=$matches[3]\";s:35:\"payments/([^/]+)/members(/(.*))?/?$\";s:65:\"index.php?post_type=payments&name=$matches[1]&members=$matches[3]\";s:36:\"payments/([^/]+)/activity(/(.*))?/?$\";s:66:\"index.php?post_type=payments&name=$matches[1]&activity=$matches[3]\";s:33:\"payments/([^/]+)/admin(/(.*))?/?$\";s:63:\"index.php?post_type=payments&name=$matches[1]&admin=$matches[3]\";s:39:\"payments/([^/]+)/submissions(/(.*))?/?$\";s:69:\"index.php?post_type=payments&name=$matches[1]&submissions=$matches[3]\";s:33:\"payments/([^/]+)/stats(/(.*))?/?$\";s:63:\"index.php?post_type=payments&name=$matches[1]&stats=$matches[3]\";s:34:\"payments/([^/]+)/events(/(.*))?/?$\";s:64:\"index.php?post_type=payments&name=$matches[1]&events=$matches[3]\";s:33:\"payments/([^/]+)/drive(/(.*))?/?$\";s:63:\"index.php?post_type=payments&name=$matches[1]&drive=$matches[3]\";s:40:\"payments/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"payments/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:44:\"payments/[^/]+/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:55:\"payments/[^/]+/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:41:\"payments/[^/]+/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:52:\"payments/[^/]+/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:42:\"payments/[^/]+/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:53:\"payments/[^/]+/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:39:\"payments/[^/]+/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:50:\"payments/[^/]+/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:45:\"payments/[^/]+/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:56:\"payments/[^/]+/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:39:\"payments/[^/]+/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:50:\"payments/[^/]+/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:40:\"payments/[^/]+/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:51:\"payments/[^/]+/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:39:\"payments/[^/]+/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:50:\"payments/[^/]+/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:33:\"payments/([^/]+)(?:/([0-9]+))?/?$\";s:62:\"index.php?post_type=payments&name=$matches[1]&page=$matches[2]\";s:25:\"payments/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"payments/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"payments/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"payments/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"payments/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"payments/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"certificates/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"certificates/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"certificates/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"certificates/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"certificates/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"certificates/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"certificates/([^/]+)/embed/?$\";s:44:\"index.php?certificate=$matches[1]&embed=true\";s:33:\"certificates/([^/]+)/trackback/?$\";s:38:\"index.php?certificate=$matches[1]&tb=1\";s:41:\"certificates/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?certificate=$matches[1]&paged=$matches[2]\";s:48:\"certificates/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?certificate=$matches[1]&cpage=$matches[2]\";s:35:\"certificates/([^/]+)/var(/(.*))?/?$\";s:49:\"index.php?certificate=$matches[1]&var=$matches[3]\";s:38:\"certificates/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?certificate=$matches[1]&wc-api=$matches[3]\";s:42:\"certificates/([^/]+)/curriculum(/(.*))?/?$\";s:56:\"index.php?certificate=$matches[1]&curriculum=$matches[3]\";s:39:\"certificates/([^/]+)/members(/(.*))?/?$\";s:53:\"index.php?certificate=$matches[1]&members=$matches[3]\";s:40:\"certificates/([^/]+)/activity(/(.*))?/?$\";s:54:\"index.php?certificate=$matches[1]&activity=$matches[3]\";s:37:\"certificates/([^/]+)/admin(/(.*))?/?$\";s:51:\"index.php?certificate=$matches[1]&admin=$matches[3]\";s:43:\"certificates/([^/]+)/submissions(/(.*))?/?$\";s:57:\"index.php?certificate=$matches[1]&submissions=$matches[3]\";s:37:\"certificates/([^/]+)/stats(/(.*))?/?$\";s:51:\"index.php?certificate=$matches[1]&stats=$matches[3]\";s:38:\"certificates/([^/]+)/events(/(.*))?/?$\";s:52:\"index.php?certificate=$matches[1]&events=$matches[3]\";s:37:\"certificates/([^/]+)/drive(/(.*))?/?$\";s:51:\"index.php?certificate=$matches[1]&drive=$matches[3]\";s:44:\"certificates/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"certificates/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"certificates/[^/]+/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:59:\"certificates/[^/]+/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:45:\"certificates/[^/]+/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:56:\"certificates/[^/]+/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:46:\"certificates/[^/]+/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:57:\"certificates/[^/]+/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:43:\"certificates/[^/]+/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:54:\"certificates/[^/]+/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:49:\"certificates/[^/]+/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:60:\"certificates/[^/]+/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:43:\"certificates/[^/]+/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:54:\"certificates/[^/]+/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:44:\"certificates/[^/]+/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:55:\"certificates/[^/]+/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:43:\"certificates/[^/]+/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:54:\"certificates/[^/]+/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:37:\"certificates/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?certificate=$matches[1]&page=$matches[2]\";s:29:\"certificates/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"certificates/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"certificates/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"certificates/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"certificates/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"certificates/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:30:\"product/([^/]+)/var(/(.*))?/?$\";s:45:\"index.php?product=$matches[1]&var=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:37:\"product/([^/]+)/curriculum(/(.*))?/?$\";s:52:\"index.php?product=$matches[1]&curriculum=$matches[3]\";s:34:\"product/([^/]+)/members(/(.*))?/?$\";s:49:\"index.php?product=$matches[1]&members=$matches[3]\";s:35:\"product/([^/]+)/activity(/(.*))?/?$\";s:50:\"index.php?product=$matches[1]&activity=$matches[3]\";s:32:\"product/([^/]+)/admin(/(.*))?/?$\";s:47:\"index.php?product=$matches[1]&admin=$matches[3]\";s:38:\"product/([^/]+)/submissions(/(.*))?/?$\";s:53:\"index.php?product=$matches[1]&submissions=$matches[3]\";s:32:\"product/([^/]+)/stats(/(.*))?/?$\";s:47:\"index.php?product=$matches[1]&stats=$matches[3]\";s:33:\"product/([^/]+)/events(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&events=$matches[3]\";s:32:\"product/([^/]+)/drive(/(.*))?/?$\";s:47:\"index.php?product=$matches[1]&drive=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"product/[^/]+/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:54:\"product/[^/]+/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:40:\"product/[^/]+/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:51:\"product/[^/]+/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:41:\"product/[^/]+/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:52:\"product/[^/]+/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:38:\"product/[^/]+/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:49:\"product/[^/]+/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:44:\"product/[^/]+/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:55:\"product/[^/]+/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:38:\"product/[^/]+/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:49:\"product/[^/]+/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:38:\"product/[^/]+/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:49:\"product/[^/]+/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"bp_member_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?bp_member_type=$matches[1]&feed=$matches[2]\";s:50:\"bp_member_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?bp_member_type=$matches[1]&feed=$matches[2]\";s:31:\"bp_member_type/([^/]+)/embed/?$\";s:47:\"index.php?bp_member_type=$matches[1]&embed=true\";s:43:\"bp_member_type/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?bp_member_type=$matches[1]&paged=$matches[2]\";s:25:\"bp_member_type/([^/]+)/?$\";s:36:\"index.php?bp_member_type=$matches[1]\";s:54:\"bp_group_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?bp_group_type=$matches[1]&feed=$matches[2]\";s:49:\"bp_group_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?bp_group_type=$matches[1]&feed=$matches[2]\";s:30:\"bp_group_type/([^/]+)/embed/?$\";s:46:\"index.php?bp_group_type=$matches[1]&embed=true\";s:42:\"bp_group_type/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?bp_group_type=$matches[1]&paged=$matches[2]\";s:24:\"bp_group_type/([^/]+)/?$\";s:35:\"index.php?bp_group_type=$matches[1]\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/([^/]+)/var(/(.*))?/?$\";s:50:\"index.php?vc_grid_item=$matches[1]&var=$matches[3]\";s:38:\"vc_grid_item/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?vc_grid_item=$matches[1]&wc-api=$matches[3]\";s:42:\"vc_grid_item/([^/]+)/curriculum(/(.*))?/?$\";s:57:\"index.php?vc_grid_item=$matches[1]&curriculum=$matches[3]\";s:39:\"vc_grid_item/([^/]+)/members(/(.*))?/?$\";s:54:\"index.php?vc_grid_item=$matches[1]&members=$matches[3]\";s:40:\"vc_grid_item/([^/]+)/activity(/(.*))?/?$\";s:55:\"index.php?vc_grid_item=$matches[1]&activity=$matches[3]\";s:37:\"vc_grid_item/([^/]+)/admin(/(.*))?/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&admin=$matches[3]\";s:43:\"vc_grid_item/([^/]+)/submissions(/(.*))?/?$\";s:58:\"index.php?vc_grid_item=$matches[1]&submissions=$matches[3]\";s:37:\"vc_grid_item/([^/]+)/stats(/(.*))?/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&stats=$matches[3]\";s:38:\"vc_grid_item/([^/]+)/events(/(.*))?/?$\";s:53:\"index.php?vc_grid_item=$matches[1]&events=$matches[3]\";s:37:\"vc_grid_item/([^/]+)/drive(/(.*))?/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&drive=$matches[3]\";s:44:\"vc_grid_item/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"vc_grid_item/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"vc_grid_item/[^/]+/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:59:\"vc_grid_item/[^/]+/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:45:\"vc_grid_item/[^/]+/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:56:\"vc_grid_item/[^/]+/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:46:\"vc_grid_item/[^/]+/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:57:\"vc_grid_item/[^/]+/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:43:\"vc_grid_item/[^/]+/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:54:\"vc_grid_item/[^/]+/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:49:\"vc_grid_item/[^/]+/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:60:\"vc_grid_item/[^/]+/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:43:\"vc_grid_item/[^/]+/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:54:\"vc_grid_item/[^/]+/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:44:\"vc_grid_item/[^/]+/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:55:\"vc_grid_item/[^/]+/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:43:\"vc_grid_item/[^/]+/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:54:\"vc_grid_item/[^/]+/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"نظر مشتری/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"نظر مشتری/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"نظر مشتری/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"نظر مشتری/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"نظر مشتری/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"نظر مشتری/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"نظر مشتری/([^/]+)/embed/?$\";s:45:\"index.php?testimonials=$matches[1]&embed=true\";s:38:\"نظر مشتری/([^/]+)/trackback/?$\";s:39:\"index.php?testimonials=$matches[1]&tb=1\";s:58:\"نظر مشتری/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?testimonials=$matches[1]&feed=$matches[2]\";s:53:\"نظر مشتری/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?testimonials=$matches[1]&feed=$matches[2]\";s:46:\"نظر مشتری/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?testimonials=$matches[1]&paged=$matches[2]\";s:53:\"نظر مشتری/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?testimonials=$matches[1]&cpage=$matches[2]\";s:40:\"نظر مشتری/([^/]+)/var(/(.*))?/?$\";s:50:\"index.php?testimonials=$matches[1]&var=$matches[3]\";s:43:\"نظر مشتری/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?testimonials=$matches[1]&wc-api=$matches[3]\";s:47:\"نظر مشتری/([^/]+)/curriculum(/(.*))?/?$\";s:57:\"index.php?testimonials=$matches[1]&curriculum=$matches[3]\";s:44:\"نظر مشتری/([^/]+)/members(/(.*))?/?$\";s:54:\"index.php?testimonials=$matches[1]&members=$matches[3]\";s:45:\"نظر مشتری/([^/]+)/activity(/(.*))?/?$\";s:55:\"index.php?testimonials=$matches[1]&activity=$matches[3]\";s:42:\"نظر مشتری/([^/]+)/admin(/(.*))?/?$\";s:52:\"index.php?testimonials=$matches[1]&admin=$matches[3]\";s:48:\"نظر مشتری/([^/]+)/submissions(/(.*))?/?$\";s:58:\"index.php?testimonials=$matches[1]&submissions=$matches[3]\";s:42:\"نظر مشتری/([^/]+)/stats(/(.*))?/?$\";s:52:\"index.php?testimonials=$matches[1]&stats=$matches[3]\";s:43:\"نظر مشتری/([^/]+)/events(/(.*))?/?$\";s:53:\"index.php?testimonials=$matches[1]&events=$matches[3]\";s:42:\"نظر مشتری/([^/]+)/drive(/(.*))?/?$\";s:52:\"index.php?testimonials=$matches[1]&drive=$matches[3]\";s:49:\"نظر مشتری/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:60:\"نظر مشتری/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"نظر مشتری/[^/]+/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:64:\"نظر مشتری/[^/]+/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:50:\"نظر مشتری/[^/]+/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:61:\"نظر مشتری/[^/]+/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:51:\"نظر مشتری/[^/]+/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:62:\"نظر مشتری/[^/]+/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:48:\"نظر مشتری/[^/]+/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:59:\"نظر مشتری/[^/]+/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:54:\"نظر مشتری/[^/]+/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:65:\"نظر مشتری/[^/]+/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:48:\"نظر مشتری/[^/]+/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:59:\"نظر مشتری/[^/]+/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:49:\"نظر مشتری/[^/]+/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:60:\"نظر مشتری/[^/]+/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:48:\"نظر مشتری/[^/]+/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:59:\"نظر مشتری/[^/]+/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:42:\"نظر مشتری/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?testimonials=$matches[1]&page=$matches[2]\";s:34:\"نظر مشتری/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"نظر مشتری/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"نظر مشتری/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"نظر مشتری/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"نظر مشتری/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"نظر مشتری/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"popup/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"popup/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"popup/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"popup/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"popup/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"popup/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"popup/([^/]+)/embed/?$\";s:39:\"index.php?popups=$matches[1]&embed=true\";s:26:\"popup/([^/]+)/trackback/?$\";s:33:\"index.php?popups=$matches[1]&tb=1\";s:34:\"popup/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?popups=$matches[1]&paged=$matches[2]\";s:41:\"popup/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?popups=$matches[1]&cpage=$matches[2]\";s:28:\"popup/([^/]+)/var(/(.*))?/?$\";s:44:\"index.php?popups=$matches[1]&var=$matches[3]\";s:31:\"popup/([^/]+)/wc-api(/(.*))?/?$\";s:47:\"index.php?popups=$matches[1]&wc-api=$matches[3]\";s:35:\"popup/([^/]+)/curriculum(/(.*))?/?$\";s:51:\"index.php?popups=$matches[1]&curriculum=$matches[3]\";s:32:\"popup/([^/]+)/members(/(.*))?/?$\";s:48:\"index.php?popups=$matches[1]&members=$matches[3]\";s:33:\"popup/([^/]+)/activity(/(.*))?/?$\";s:49:\"index.php?popups=$matches[1]&activity=$matches[3]\";s:30:\"popup/([^/]+)/admin(/(.*))?/?$\";s:46:\"index.php?popups=$matches[1]&admin=$matches[3]\";s:36:\"popup/([^/]+)/submissions(/(.*))?/?$\";s:52:\"index.php?popups=$matches[1]&submissions=$matches[3]\";s:30:\"popup/([^/]+)/stats(/(.*))?/?$\";s:46:\"index.php?popups=$matches[1]&stats=$matches[3]\";s:31:\"popup/([^/]+)/events(/(.*))?/?$\";s:47:\"index.php?popups=$matches[1]&events=$matches[3]\";s:30:\"popup/([^/]+)/drive(/(.*))?/?$\";s:46:\"index.php?popups=$matches[1]&drive=$matches[3]\";s:37:\"popup/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"popup/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"popup/[^/]+/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:52:\"popup/[^/]+/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:38:\"popup/[^/]+/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:49:\"popup/[^/]+/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:39:\"popup/[^/]+/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:50:\"popup/[^/]+/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:36:\"popup/[^/]+/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:47:\"popup/[^/]+/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:42:\"popup/[^/]+/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:53:\"popup/[^/]+/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:36:\"popup/[^/]+/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:47:\"popup/[^/]+/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:37:\"popup/[^/]+/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:48:\"popup/[^/]+/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:36:\"popup/[^/]+/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:47:\"popup/[^/]+/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:30:\"popup/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?popups=$matches[1]&page=$matches[2]\";s:22:\"popup/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"popup/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"popup/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"popup/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"popup/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"popup/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1427&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:21:\"curriculum(/(.*))?/?$\";s:33:\"index.php?&curriculum=$matches[2]\";s:18:\"members(/(.*))?/?$\";s:30:\"index.php?&members=$matches[2]\";s:19:\"activity(/(.*))?/?$\";s:31:\"index.php?&activity=$matches[2]\";s:16:\"admin(/(.*))?/?$\";s:28:\"index.php?&admin=$matches[2]\";s:22:\"submissions(/(.*))?/?$\";s:34:\"index.php?&submissions=$matches[2]\";s:16:\"stats(/(.*))?/?$\";s:28:\"index.php?&stats=$matches[2]\";s:17:\"events(/(.*))?/?$\";s:29:\"index.php?&events=$matches[2]\";s:16:\"drive(/(.*))?/?$\";s:28:\"index.php?&drive=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:30:\"comments/curriculum(/(.*))?/?$\";s:33:\"index.php?&curriculum=$matches[2]\";s:27:\"comments/members(/(.*))?/?$\";s:30:\"index.php?&members=$matches[2]\";s:28:\"comments/activity(/(.*))?/?$\";s:31:\"index.php?&activity=$matches[2]\";s:25:\"comments/admin(/(.*))?/?$\";s:28:\"index.php?&admin=$matches[2]\";s:31:\"comments/submissions(/(.*))?/?$\";s:34:\"index.php?&submissions=$matches[2]\";s:25:\"comments/stats(/(.*))?/?$\";s:28:\"index.php?&stats=$matches[2]\";s:26:\"comments/events(/(.*))?/?$\";s:29:\"index.php?&events=$matches[2]\";s:25:\"comments/drive(/(.*))?/?$\";s:28:\"index.php?&drive=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:33:\"search/(.+)/curriculum(/(.*))?/?$\";s:46:\"index.php?s=$matches[1]&curriculum=$matches[3]\";s:30:\"search/(.+)/members(/(.*))?/?$\";s:43:\"index.php?s=$matches[1]&members=$matches[3]\";s:31:\"search/(.+)/activity(/(.*))?/?$\";s:44:\"index.php?s=$matches[1]&activity=$matches[3]\";s:28:\"search/(.+)/admin(/(.*))?/?$\";s:41:\"index.php?s=$matches[1]&admin=$matches[3]\";s:34:\"search/(.+)/submissions(/(.*))?/?$\";s:47:\"index.php?s=$matches[1]&submissions=$matches[3]\";s:28:\"search/(.+)/stats(/(.*))?/?$\";s:41:\"index.php?s=$matches[1]&stats=$matches[3]\";s:29:\"search/(.+)/events(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&events=$matches[3]\";s:28:\"search/(.+)/drive(/(.*))?/?$\";s:41:\"index.php?s=$matches[1]&drive=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:36:\"author/([^/]+)/curriculum(/(.*))?/?$\";s:56:\"index.php?author_name=$matches[1]&curriculum=$matches[3]\";s:33:\"author/([^/]+)/members(/(.*))?/?$\";s:53:\"index.php?author_name=$matches[1]&members=$matches[3]\";s:34:\"author/([^/]+)/activity(/(.*))?/?$\";s:54:\"index.php?author_name=$matches[1]&activity=$matches[3]\";s:31:\"author/([^/]+)/admin(/(.*))?/?$\";s:51:\"index.php?author_name=$matches[1]&admin=$matches[3]\";s:37:\"author/([^/]+)/submissions(/(.*))?/?$\";s:57:\"index.php?author_name=$matches[1]&submissions=$matches[3]\";s:31:\"author/([^/]+)/stats(/(.*))?/?$\";s:51:\"index.php?author_name=$matches[1]&stats=$matches[3]\";s:32:\"author/([^/]+)/events(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&events=$matches[3]\";s:45:\"author/([^/]+)/instructing-courses(/(.*))?/?$\";s:65:\"index.php?author_name=$matches[1]&instructing-courses=$matches[3]\";s:31:\"author/([^/]+)/drive(/(.*))?/?$\";s:51:\"index.php?author_name=$matches[1]&drive=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:58:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/curriculum(/(.*))?/?$\";s:86:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&curriculum=$matches[5]\";s:55:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/members(/(.*))?/?$\";s:83:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&members=$matches[5]\";s:56:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/activity(/(.*))?/?$\";s:84:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&activity=$matches[5]\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/admin(/(.*))?/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&admin=$matches[5]\";s:59:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/submissions(/(.*))?/?$\";s:87:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&submissions=$matches[5]\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/stats(/(.*))?/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&stats=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/events(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&events=$matches[5]\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/drive(/(.*))?/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&drive=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/curriculum(/(.*))?/?$\";s:70:\"index.php?year=$matches[1]&monthnum=$matches[2]&curriculum=$matches[4]\";s:42:\"([0-9]{4})/([0-9]{1,2})/members(/(.*))?/?$\";s:67:\"index.php?year=$matches[1]&monthnum=$matches[2]&members=$matches[4]\";s:43:\"([0-9]{4})/([0-9]{1,2})/activity(/(.*))?/?$\";s:68:\"index.php?year=$matches[1]&monthnum=$matches[2]&activity=$matches[4]\";s:40:\"([0-9]{4})/([0-9]{1,2})/admin(/(.*))?/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&admin=$matches[4]\";s:46:\"([0-9]{4})/([0-9]{1,2})/submissions(/(.*))?/?$\";s:71:\"index.php?year=$matches[1]&monthnum=$matches[2]&submissions=$matches[4]\";s:40:\"([0-9]{4})/([0-9]{1,2})/stats(/(.*))?/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&stats=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/events(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&events=$matches[4]\";s:40:\"([0-9]{4})/([0-9]{1,2})/drive(/(.*))?/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&drive=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:32:\"([0-9]{4})/curriculum(/(.*))?/?$\";s:49:\"index.php?year=$matches[1]&curriculum=$matches[3]\";s:29:\"([0-9]{4})/members(/(.*))?/?$\";s:46:\"index.php?year=$matches[1]&members=$matches[3]\";s:30:\"([0-9]{4})/activity(/(.*))?/?$\";s:47:\"index.php?year=$matches[1]&activity=$matches[3]\";s:27:\"([0-9]{4})/admin(/(.*))?/?$\";s:44:\"index.php?year=$matches[1]&admin=$matches[3]\";s:33:\"([0-9]{4})/submissions(/(.*))?/?$\";s:50:\"index.php?year=$matches[1]&submissions=$matches[3]\";s:27:\"([0-9]{4})/stats(/(.*))?/?$\";s:44:\"index.php?year=$matches[1]&stats=$matches[3]\";s:28:\"([0-9]{4})/events(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&events=$matches[3]\";s:27:\"([0-9]{4})/drive(/(.*))?/?$\";s:44:\"index.php?year=$matches[1]&drive=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:29:\"(.?.+?)/curriculum(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&curriculum=$matches[3]\";s:26:\"(.?.+?)/members(/(.*))?/?$\";s:50:\"index.php?pagename=$matches[1]&members=$matches[3]\";s:27:\"(.?.+?)/activity(/(.*))?/?$\";s:51:\"index.php?pagename=$matches[1]&activity=$matches[3]\";s:24:\"(.?.+?)/admin(/(.*))?/?$\";s:48:\"index.php?pagename=$matches[1]&admin=$matches[3]\";s:30:\"(.?.+?)/submissions(/(.*))?/?$\";s:54:\"index.php?pagename=$matches[1]&submissions=$matches[3]\";s:24:\"(.?.+?)/stats(/(.*))?/?$\";s:48:\"index.php?pagename=$matches[1]&stats=$matches[3]\";s:25:\"(.?.+?)/events(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&events=$matches[3]\";s:24:\"(.?.+?)/drive(/(.*))?/?$\";s:48:\"index.php?pagename=$matches[1]&drive=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\".?.+?/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:46:\".?.+?/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:32:\".?.+?/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:43:\".?.+?/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:33:\".?.+?/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:44:\".?.+?/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:30:\".?.+?/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:41:\".?.+?/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:36:\".?.+?/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:47:\".?.+?/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:30:\".?.+?/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:41:\".?.+?/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:31:\".?.+?/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:30:\".?.+?/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:41:\".?.+?/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:22:\"([^/]+)/var(/(.*))?/?$\";s:42:\"index.php?name=$matches[1]&var=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:29:\"([^/]+)/curriculum(/(.*))?/?$\";s:49:\"index.php?name=$matches[1]&curriculum=$matches[3]\";s:26:\"([^/]+)/members(/(.*))?/?$\";s:46:\"index.php?name=$matches[1]&members=$matches[3]\";s:27:\"([^/]+)/activity(/(.*))?/?$\";s:47:\"index.php?name=$matches[1]&activity=$matches[3]\";s:24:\"([^/]+)/admin(/(.*))?/?$\";s:44:\"index.php?name=$matches[1]&admin=$matches[3]\";s:30:\"([^/]+)/submissions(/(.*))?/?$\";s:50:\"index.php?name=$matches[1]&submissions=$matches[3]\";s:24:\"([^/]+)/stats(/(.*))?/?$\";s:44:\"index.php?name=$matches[1]&stats=$matches[3]\";s:25:\"([^/]+)/events(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&events=$matches[3]\";s:24:\"([^/]+)/drive(/(.*))?/?$\";s:44:\"index.php?name=$matches[1]&drive=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"[^/]+/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:46:\"[^/]+/attachment/([^/]+)/curriculum(/(.*))?/?$\";s:55:\"index.php?attachment=$matches[1]&curriculum=$matches[3]\";s:32:\"[^/]+/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:43:\"[^/]+/attachment/([^/]+)/members(/(.*))?/?$\";s:52:\"index.php?attachment=$matches[1]&members=$matches[3]\";s:33:\"[^/]+/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:44:\"[^/]+/attachment/([^/]+)/activity(/(.*))?/?$\";s:53:\"index.php?attachment=$matches[1]&activity=$matches[3]\";s:30:\"[^/]+/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:41:\"[^/]+/attachment/([^/]+)/admin(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&admin=$matches[3]\";s:36:\"[^/]+/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:47:\"[^/]+/attachment/([^/]+)/submissions(/(.*))?/?$\";s:56:\"index.php?attachment=$matches[1]&submissions=$matches[3]\";s:30:\"[^/]+/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:41:\"[^/]+/attachment/([^/]+)/stats(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&stats=$matches[3]\";s:31:\"[^/]+/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/events(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&events=$matches[3]\";s:30:\"[^/]+/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:41:\"[^/]+/attachment/([^/]+)/drive(/(.*))?/?$\";s:50:\"index.php?attachment=$matches[1]&drive=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("1546", "woocommerce_admin_notices", "a:2:{i:0;s:6:\"update\";i:1;s:20:\"no_secure_connection\";}", "yes");
INSERT INTO `wp_options` VALUES("1618", "wp_get_version", "6h8w7ca1nu", "yes");
INSERT INTO `wp_options` VALUES("1622", "arf_update_token", "", "yes");
INSERT INTO `wp_options` VALUES("1744", "revslider-valid-notice", "false", "yes");
INSERT INTO `wp_options` VALUES("2033", "illegal_names", "a:19:{i:0;s:3:\"www\";i:1;s:3:\"web\";i:2;s:4:\"root\";i:3;s:5:\"admin\";i:4;s:4:\"main\";i:5;s:6:\"invite\";i:6;s:13:\"administrator\";i:7;s:6:\"groups\";i:8;s:7:\"members\";i:9;s:6:\"forums\";i:10;s:5:\"blogs\";i:11;s:8:\"activity\";i:12;s:7:\"profile\";i:13;s:7:\"friends\";i:14;s:6:\"search\";i:15;s:8:\"settings\";i:16;s:13:\"notifications\";i:17;s:8:\"register\";i:18;s:8:\"activate\";}", "yes");
INSERT INTO `wp_options` VALUES("2055", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `wp_options` VALUES("2887", "assignment-type_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("3121", "wplms_bp_emails", "3.9.4", "yes");
INSERT INTO `wp_options` VALUES("4282", "revslider-library-check", "1572181809", "yes");
INSERT INTO `wp_options` VALUES("4283", "rs-library", "a:2:{s:7:\"objects\";a:179:{i:238;a:14:{s:2:\"id\";s:3:\"238\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:237;a:14:{s:2:\"id\";s:3:\"237\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:236;a:14:{s:2:\"id\";s:3:\"236\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:235;a:14:{s:2:\"id\";s:3:\"235\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:234;a:14:{s:2:\"id\";s:3:\"234\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:233;a:14:{s:2:\"id\";s:3:\"233\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:232;a:14:{s:2:\"id\";s:3:\"232\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:231;a:14:{s:2:\"id\";s:3:\"231\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:230;a:14:{s:2:\"id\";s:3:\"230\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:229;a:14:{s:2:\"id\";s:3:\"229\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:198;a:13:{s:2:\"id\";s:3:\"198\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";}i:197;a:13:{s:2:\"id\";s:3:\"197\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:196;a:13:{s:2:\"id\";s:3:\"196\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:195;a:13:{s:2:\"id\";s:3:\"195\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:194;a:13:{s:2:\"id\";s:3:\"194\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:193;a:13:{s:2:\"id\";s:3:\"193\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:192;a:13:{s:2:\"id\";s:3:\"192\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:191;a:13:{s:2:\"id\";s:3:\"191\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:190;a:13:{s:2:\"id\";s:3:\"190\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:189;a:13:{s:2:\"id\";s:3:\"189\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:188;a:13:{s:2:\"id\";s:3:\"188\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:187;a:13:{s:2:\"id\";s:3:\"187\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:186;a:13:{s:2:\"id\";s:3:\"186\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:185;a:13:{s:2:\"id\";s:3:\"185\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:184;a:13:{s:2:\"id\";s:3:\"184\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:183;a:13:{s:2:\"id\";s:3:\"183\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:182;a:13:{s:2:\"id\";s:3:\"182\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:181;a:13:{s:2:\"id\";s:3:\"181\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:180;a:13:{s:2:\"id\";s:3:\"180\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:179;a:13:{s:2:\"id\";s:3:\"179\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:177;a:13:{s:2:\"id\";s:3:\"177\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:175;a:13:{s:2:\"id\";s:3:\"175\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:174;a:13:{s:2:\"id\";s:3:\"174\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:173;a:13:{s:2:\"id\";s:3:\"173\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:172;a:13:{s:2:\"id\";s:3:\"172\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:171;a:13:{s:2:\"id\";s:3:\"171\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:170;a:13:{s:2:\"id\";s:3:\"170\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:169;a:13:{s:2:\"id\";s:3:\"169\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:168;a:13:{s:2:\"id\";s:3:\"168\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:167;a:13:{s:2:\"id\";s:3:\"167\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:166;a:13:{s:2:\"id\";s:3:\"166\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:165;a:13:{s:2:\"id\";s:3:\"165\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:164;a:13:{s:2:\"id\";s:3:\"164\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:163;a:13:{s:2:\"id\";s:3:\"163\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:162;a:13:{s:2:\"id\";s:3:\"162\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:161;a:13:{s:2:\"id\";s:3:\"161\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:160;a:13:{s:2:\"id\";s:3:\"160\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:159;a:13:{s:2:\"id\";s:3:\"159\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:158;a:13:{s:2:\"id\";s:3:\"158\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:157;a:13:{s:2:\"id\";s:3:\"157\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:156;a:13:{s:2:\"id\";s:3:\"156\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:155;a:13:{s:2:\"id\";s:3:\"155\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:154;a:13:{s:2:\"id\";s:3:\"154\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:153;a:13:{s:2:\"id\";s:3:\"153\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:152;a:13:{s:2:\"id\";s:3:\"152\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:151;a:13:{s:2:\"id\";s:3:\"151\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:150;a:13:{s:2:\"id\";s:3:\"150\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:149;a:13:{s:2:\"id\";s:3:\"149\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:148;a:13:{s:2:\"id\";s:3:\"148\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:147;a:13:{s:2:\"id\";s:3:\"147\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:146;a:13:{s:2:\"id\";s:3:\"146\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:145;a:13:{s:2:\"id\";s:3:\"145\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:144;a:13:{s:2:\"id\";s:3:\"144\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:143;a:13:{s:2:\"id\";s:3:\"143\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:142;a:13:{s:2:\"id\";s:3:\"142\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:141;a:13:{s:2:\"id\";s:3:\"141\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:140;a:13:{s:2:\"id\";s:3:\"140\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:139;a:13:{s:2:\"id\";s:3:\"139\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:138;a:13:{s:2:\"id\";s:3:\"138\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:137;a:13:{s:2:\"id\";s:3:\"137\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:136;a:13:{s:2:\"id\";s:3:\"136\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:135;a:13:{s:2:\"id\";s:3:\"135\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:134;a:13:{s:2:\"id\";s:3:\"134\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:133;a:13:{s:2:\"id\";s:3:\"133\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:132;a:13:{s:2:\"id\";s:3:\"132\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:131;a:13:{s:2:\"id\";s:3:\"131\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:130;a:13:{s:2:\"id\";s:3:\"130\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:129;a:13:{s:2:\"id\";s:3:\"129\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:128;a:13:{s:2:\"id\";s:3:\"128\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:127;a:13:{s:2:\"id\";s:3:\"127\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:126;a:13:{s:2:\"id\";s:3:\"126\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:125;a:13:{s:2:\"id\";s:3:\"125\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:124;a:13:{s:2:\"id\";s:3:\"124\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:123;a:13:{s:2:\"id\";s:3:\"123\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:122;a:13:{s:2:\"id\";s:3:\"122\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:121;a:13:{s:2:\"id\";s:3:\"121\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:120;a:13:{s:2:\"id\";s:3:\"120\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:119;a:13:{s:2:\"id\";s:3:\"119\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:118;a:13:{s:2:\"id\";s:3:\"118\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:117;a:13:{s:2:\"id\";s:3:\"117\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:116;a:13:{s:2:\"id\";s:3:\"116\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:115;a:13:{s:2:\"id\";s:3:\"115\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:114;a:13:{s:2:\"id\";s:3:\"114\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:113;a:13:{s:2:\"id\";s:3:\"113\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:112;a:13:{s:2:\"id\";s:3:\"112\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:111;a:13:{s:2:\"id\";s:3:\"111\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:110;a:13:{s:2:\"id\";s:3:\"110\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:109;a:13:{s:2:\"id\";s:3:\"109\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:108;a:13:{s:2:\"id\";s:3:\"108\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:107;a:13:{s:2:\"id\";s:3:\"107\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:106;a:13:{s:2:\"id\";s:3:\"106\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:105;a:13:{s:2:\"id\";s:3:\"105\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:104;a:13:{s:2:\"id\";s:3:\"104\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:103;a:13:{s:2:\"id\";s:3:\"103\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:102;a:13:{s:2:\"id\";s:3:\"102\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:101;a:13:{s:2:\"id\";s:3:\"101\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:100;a:13:{s:2:\"id\";s:3:\"100\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:99;a:13:{s:2:\"id\";s:2:\"99\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:98;a:13:{s:2:\"id\";s:2:\"98\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:97;a:13:{s:2:\"id\";s:2:\"97\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:96;a:13:{s:2:\"id\";s:2:\"96\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:95;a:13:{s:2:\"id\";s:2:\"95\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:94;a:13:{s:2:\"id\";s:2:\"94\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:93;a:13:{s:2:\"id\";s:2:\"93\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:92;a:13:{s:2:\"id\";s:2:\"92\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:91;a:13:{s:2:\"id\";s:2:\"91\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:90;a:13:{s:2:\"id\";s:2:\"90\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:89;a:13:{s:2:\"id\";s:2:\"89\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:88;a:13:{s:2:\"id\";s:2:\"88\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:87;a:13:{s:2:\"id\";s:2:\"87\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:86;a:13:{s:2:\"id\";s:2:\"86\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:85;a:13:{s:2:\"id\";s:2:\"85\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:84;a:13:{s:2:\"id\";s:2:\"84\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:83;a:13:{s:2:\"id\";s:2:\"83\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:82;a:13:{s:2:\"id\";s:2:\"82\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:81;a:13:{s:2:\"id\";s:2:\"81\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:80;a:13:{s:2:\"id\";s:2:\"80\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:79;a:13:{s:2:\"id\";s:2:\"79\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:78;a:13:{s:2:\"id\";s:2:\"78\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:77;a:13:{s:2:\"id\";s:2:\"77\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:76;a:13:{s:2:\"id\";s:2:\"76\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:75;a:13:{s:2:\"id\";s:2:\"75\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:74;a:13:{s:2:\"id\";s:2:\"74\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:73;a:13:{s:2:\"id\";s:2:\"73\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:72;a:13:{s:2:\"id\";s:2:\"72\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:71;a:13:{s:2:\"id\";s:2:\"71\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:70;a:13:{s:2:\"id\";s:2:\"70\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:69;a:13:{s:2:\"id\";s:2:\"69\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:68;a:13:{s:2:\"id\";s:2:\"68\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:67;a:13:{s:2:\"id\";s:2:\"67\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:66;a:13:{s:2:\"id\";s:2:\"66\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:65;a:13:{s:2:\"id\";s:2:\"65\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:64;a:13:{s:2:\"id\";s:2:\"64\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:63;a:13:{s:2:\"id\";s:2:\"63\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:62;a:13:{s:2:\"id\";s:2:\"62\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:49;a:13:{s:2:\"id\";s:2:\"49\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:48;a:13:{s:2:\"id\";s:2:\"48\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:47;a:13:{s:2:\"id\";s:2:\"47\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:46;a:13:{s:2:\"id\";s:2:\"46\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:45;a:13:{s:2:\"id\";s:2:\"45\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:44;a:13:{s:2:\"id\";s:2:\"44\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:43;a:13:{s:2:\"id\";s:2:\"43\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:42;a:13:{s:2:\"id\";s:2:\"42\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:41;a:13:{s:2:\"id\";s:2:\"41\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:40;a:13:{s:2:\"id\";s:2:\"40\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:39;a:13:{s:2:\"id\";s:2:\"39\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:38;a:13:{s:2:\"id\";s:2:\"38\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:37;a:13:{s:2:\"id\";s:2:\"37\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:36;a:13:{s:2:\"id\";s:2:\"36\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:35;a:13:{s:2:\"id\";s:2:\"35\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:34;a:13:{s:2:\"id\";s:2:\"34\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:33;a:13:{s:2:\"id\";s:2:\"33\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:32;a:13:{s:2:\"id\";s:2:\"32\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:31;a:13:{s:2:\"id\";s:2:\"31\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:30;a:13:{s:2:\"id\";s:2:\"30\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:29;a:13:{s:2:\"id\";s:2:\"29\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:28;a:13:{s:2:\"id\";s:2:\"28\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:27;a:13:{s:2:\"id\";s:2:\"27\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:26;a:13:{s:2:\"id\";s:2:\"26\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:25;a:13:{s:2:\"id\";s:2:\"25\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:24;a:13:{s:2:\"id\";s:2:\"24\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:23;a:13:{s:2:\"id\";s:2:\"23\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:22;a:13:{s:2:\"id\";s:2:\"22\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:21;a:13:{s:2:\"id\";s:2:\"21\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:20;a:13:{s:2:\"id\";s:2:\"20\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:11;a:13:{s:2:\"id\";s:2:\"11\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:10;a:13:{s:2:\"id\";s:2:\"10\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:9;a:13:{s:2:\"id\";s:1:\"9\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:8;a:13:{s:2:\"id\";s:1:\"8\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "no");
INSERT INTO `wp_options` VALUES("4284", "rs_tables_created", "1", "yes");
INSERT INTO `wp_options` VALUES("4357", "ls-store-last-updated", "1568231834", "yes");
INSERT INTO `wp_options` VALUES("4358", "ls-store-data", "a:2:{s:12:\"last_updated\";s:10:\"2017-12-22\";s:7:\"sliders\";a:67:{s:20:\"catering-xmas-slider\";a:7:{s:8:\"released\";s:10:\"2017-12-22\";s:4:\"name\";s:25:\"Catering Christmas Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:29:\"premium,new,static,text,blend\";s:3:\"url\";s:72:\"https://layerslider.kreaturamedia.com/sliders/catering-christmas-slider/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/catering-xmas-slider.jpg\";}s:20:\"discover-the-details\";a:7:{s:8:\"released\";s:10:\"2017-12-19\";s:4:\"name\";s:20:\"Discover the Details\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:50:\"premium,new,loop,parallax,blendmode,specialeffects\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/sliders/discover-the-details/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/discover-the-details.jpg\";}s:10:\"rainforest\";a:7:{s:8:\"released\";s:10:\"2017-12-17\";s:4:\"name\";s:10:\"Rainforest\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:48:\"premium,new,loop,filter,blendmode,specialeffects\";s:3:\"url\";s:57:\"https://layerslider.kreaturamedia.com/sliders/rainforest/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/rainforest.jpg\";}s:30:\"ecommerce-global-hover-example\";a:7:{s:8:\"released\";s:10:\"2017-12-15\";s:4:\"name\";s:30:\"eCommerce Global Hover Example\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:23:\"premium,new,experiments\";s:3:\"url\";s:77:\"https://layerslider.kreaturamedia.com/sliders/ecommerce-global-hover-example/\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/ecommerce-global-hover-example.jpg\";}s:20:\"3d-canyon-experience\";a:7:{s:8:\"released\";s:10:\"2017-12-13\";s:4:\"name\";s:20:\"3D Canyon Experience\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:37:\"premium,new,parallax,experiments,text\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/sliders/3d-canyon-experience/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/3d-canyon-experience.jpg\";}s:14:\"discount-popup\";a:7:{s:8:\"released\";s:10:\"2017-12-10\";s:4:\"name\";s:14:\"Discount Popup\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:21:\"premium,premium,popup\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/discount-popup/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/discount-popup.jpg\";}s:14:\"vintage-photos\";a:7:{s:8:\"released\";s:10:\"2017-12-08\";s:4:\"name\";s:14:\"Vintage Photos\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:47:\"premium,new,fullsize,loop,filter,specialeffects\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/vintage-photos/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/vintage-photos.jpg\";}s:18:\"social-share-popup\";a:7:{s:8:\"released\";s:10:\"2017-12-06\";s:4:\"name\";s:18:\"Social Share Popup\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:21:\"premium,new,popup,api\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/social-share-popup/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/social-share-popup.jpg\";}s:8:\"aquarium\";a:7:{s:8:\"released\";s:10:\"2017-12-04\";s:4:\"name\";s:8:\"Aquarium\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:59:\"premium,new,parallax,loop,filter,experiments,specialeffects\";s:3:\"url\";s:55:\"https://layerslider.kreaturamedia.com/sliders/aquarium/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/aquarium.jpg\";}s:16:\"what-is-the-time\";a:7:{s:8:\"released\";s:10:\"2017-08-25\";s:4:\"name\";s:17:\"What is the time?\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:51:\"premium,new,parallax,text,blendmode,experiments,api\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/what-is-the-time/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/what-is-the-time.jpg\";}s:18:\"personal-page-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-23\";s:4:\"name\";s:18:\"Personal Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:58:\"premium,new,fullsize,fullwidth,landing,text,parallax,packs\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/personal-page-pack/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/personal-page-pack.jpg\";}s:19:\"marketing-page-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-21\";s:4:\"name\";s:19:\"Marketing Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:65:\"premium,new,fullsize,fullwidth,landing,parallax,static,loop,packs\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/sliders/marketing-page-pack/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/marketing-page-pack.jpg\";}s:14:\"dynamic-slider\";a:7:{s:8:\"released\";s:10:\"2017-08-18\";s:4:\"name\";s:14:\"Dynamic Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:36:\"premium,new,fullwidth,landing,static\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/dynamic-slider/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/dynamic-slider.jpg\";}s:14:\"colorful-cases\";a:7:{s:8:\"released\";s:10:\"2017-08-16\";s:4:\"name\";s:14:\"Colorful Cases\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:47:\"premium,new,text,loop,parallax,static,blendmode\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/colorful-cases/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/colorful-cases.jpg\";}s:16:\"beauty-shop-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-14\";s:4:\"name\";s:16:\"Beauty Shop PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:40:\"premium,new,fullwidth,text,landing,packs\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/beauty-shop-pack/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/beauty-shop-pack.jpg\";}s:16:\"popup-guide-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Guide Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:31:\"premium,new,popup,parallax,text\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/popup-guide-demo/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-guide-demo.jpg\";}s:18:\"popup-welcome-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Welcome Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:31:\"premium,new,popup,parallax,text\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/popup-welcome-demo/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-welcome-demo.jpg\";}s:22:\"popup-transparent-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:22:\"Popup Transparent Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:31:\"premium,new,popup,parallax,loop\";s:3:\"url\";s:69:\"https://layerslider.kreaturamedia.com/sliders/popup-transparent-demo/\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-transparent-demo.jpg\";}s:18:\"popup-sidebar-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Sidebar Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:40:\"premium,popup,experiments,blendmode,text\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/popup-sidebar-demo/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-sidebar-demo.jpg\";}s:19:\"popup-photo-gallery\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:19:\"Popup Photo Gallery\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:26:\"premium,new,popup,kenburns\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/sliders/popup-photo-gallery/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-photo-gallery.jpg\";}s:16:\"popup-modal-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Modal Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:24:\"premium,new,popup,static\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/popup-modal-demo/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-modal-demo.jpg\";}s:18:\"popup-infobar-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Infobar Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:34:\"premium,new,popup,experiments,text\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/popup-infobar-demo/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-infobar-demo.jpg\";}s:24:\"popup-fullsize-desk-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:24:\"Popup Fullsize Desk Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:47:\"premium,new,popup,experiments,fullsize,parallax\";s:3:\"url\";s:71:\"https://layerslider.kreaturamedia.com/sliders/popup-fullsize-desk-demo/\";s:7:\"preview\";s:85:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-fullsize-desk-demo.jpg\";}s:18:\"conversation-popup\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Conversation Popup\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:29:\"premium,new,popup,experiments\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/conversation-popup/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/conversation-popup.jpg\";}s:20:\"global-hover-example\";a:7:{s:8:\"released\";s:10:\"2017-05-02\";s:4:\"name\";s:20:\"Global Hover Example\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.4.0\";s:6:\"groups\";s:52:\"premium,new,experiments,specialeffects,parallax,text\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/sliders/global-hover-example/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/global-hover-example.jpg\";}s:10:\"gastronomy\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:10:\"Gastronomy\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:28:\"premium,kenburns,filter,text\";s:3:\"url\";s:57:\"https://layerslider.kreaturamedia.com/sliders/gastronomy/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/gastronomy.jpg\";}s:13:\"police-lights\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:13:\"Police Lights\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:46:\"premium,specialeffects,loop,blendmode,parallax\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/police-lights/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/police-lights.jpg\";}s:16:\"beautiful-sunset\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:16:\"Beautiful Sunset\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:37:\"premium,specialeffects,loop,blendmode\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/beautiful-sunset/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/beautiful-sunset.jpg\";}s:23:\"blend-mode-experiment-1\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:23:\"Blend Mode Experiment 1\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:63:\"premium,specialeffects,text,blendmode,experiments,loop,parallax\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/sliders/blend-mode-experiment-1/\";s:7:\"preview\";s:84:\"https://repository.kreaturamedia.com/v4/sliders/packages/blend-mode-experiment-1.jpg\";}s:16:\"flying-banners-2\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:16:\"Flying Banners 2\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:40:\"premium,parallax,specialeffects,fullsize\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/flying-banners-2/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/flying-banners-2.jpg\";}s:14:\"layerslider-v6\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:14:\"LayerSlider v6\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.6\";s:6:\"groups\";s:68:\"premium,specialeffects,parallax,fullsize,landing,loop,text,media,api\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/layerslider-v6/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/layerslider-v6.jpg\";}s:16:\"flying-banners-1\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:16:\"Flying Banners 1\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:38:\"free,parallax,loop,text,specialeffects\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/flying-banners-1/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/flying-banners-1.jpg\";}s:18:\"anniversary-slider\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:18:\"Anniversary Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:40:\"free,parallax,experiments,specialeffects\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/anniversary-slider/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/anniversary-slider.jpg\";}s:7:\"origami\";a:7:{s:8:\"released\";s:10:\"2016-12-07\";s:4:\"name\";s:7:\"Origami\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:47:\"premium,experiments,specialeffects,3dtransition\";s:3:\"url\";s:54:\"https://layerslider.kreaturamedia.com/sliders/origami/\";s:7:\"preview\";s:68:\"https://repository.kreaturamedia.com/v4/sliders/packages/origami.jpg\";}s:17:\"origami-buildings\";a:7:{s:8:\"released\";s:10:\"2016-12-07\";s:4:\"name\";s:17:\"Origami Buildings\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:56:\"premium,experiments,specialeffects,kenburns,3dtransition\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/sliders/origami-buildings/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/origami-buildings.jpg\";}s:17:\"autumn-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:17:\"Autumn Experiment\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:45:\"experiments,free,loop,parallax,specialeffects\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/sliders/autumn-experiment/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/autumn-experiment.jpg\";}s:28:\"features-parallax-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:32:\"Features | A Parallax Experiment\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:40:\"experiments,free,parallax,specialeffects\";s:3:\"url\";s:75:\"https://layerslider.kreaturamedia.com/sliders/features-parallax-experiment/\";s:7:\"preview\";s:89:\"https://repository.kreaturamedia.com/v4/sliders/packages/features-parallax-experiment.jpg\";}s:16:\"furniture-slider\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:16:\"Furniture Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:33:\"fullwidth,parallax,premium,static\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/furniture-slider/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/furniture-slider.jpg\";}s:15:\"room-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:15:\"Room Experiment\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.6\";s:6:\"groups\";s:65:\"api,experiments,media,parallax,premium,specialeffects,static,text\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/room-experiment/\";s:7:\"preview\";s:76:\"https://repository.kreaturamedia.com/v4/sliders/packages/room-experiment.jpg\";}s:11:\"drag-n-drop\";a:6:{s:4:\"name\";s:11:\"Drag & Drop\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:37:\"premium,fullwidth,specialeffects,text\";s:3:\"url\";s:58:\"https://layerslider.kreaturamedia.com/sliders/drag-n-drop/\";s:7:\"preview\";s:72:\"https://repository.kreaturamedia.com/v4/sliders/packages/drag-n-drop.jpg\";}s:10:\"headphones\";a:6:{s:4:\"name\";s:10:\"Headphones\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:14:\"premium,static\";s:3:\"url\";s:57:\"https://layerslider.kreaturamedia.com/sliders/headphones/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/headphones.jpg\";}s:14:\"play-by-scroll\";a:6:{s:4:\"name\";s:19:\"Play By Scroll demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:66:\"premium,fullsize,text,experiments,specialeffects,playbyscroll,loop\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/play-by-scroll/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/play-by-scroll.jpg\";}s:3:\"sky\";a:6:{s:4:\"name\";s:14:\"Sky Experience\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:63:\"premium,fullwidth,text,experiments,parallax,specialeffects,loop\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/sky-experience/\";s:7:\"preview\";s:64:\"https://repository.kreaturamedia.com/v4/sliders/packages/sky.jpg\";}s:9:\"halloween\";a:6:{s:4:\"name\";s:16:\"Happy Halloween!\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:35:\"free,fullsize,text,experiments,loop\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/happy-halloween/\";s:7:\"preview\";s:70:\"https://repository.kreaturamedia.com/v4/sliders/packages/halloween.jpg\";}s:15:\"creative-agency\";a:6:{s:4:\"name\";s:6:\"Agency\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:49:\"premium,fullsize,kenburns,parallax,landing,filter\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/creative-agency/\";s:7:\"preview\";s:76:\"https://repository.kreaturamedia.com/v4/sliders/packages/creative-agency.jpg\";}s:18:\"interactive-slider\";a:6:{s:4:\"name\";s:18:\"Interactive Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:47:\"premium,fullsize,parallax,kenburns,text,landing\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/interactive-slider/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/interactive-slider.jpg\";}s:9:\"ecommerce\";a:6:{s:4:\"name\";s:9:\"eCommerce\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:56:\"https://layerslider.kreaturamedia.com/sliders/ecommerce/\";s:7:\"preview\";s:70:\"https://repository.kreaturamedia.com/v4/sliders/packages/ecommerce.jpg\";}s:17:\"landing-page-pack\";a:6:{s:4:\"name\";s:17:\"Landing Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:54:\"premium,fullsize,fullwidth,landing,parallax,text,packs\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/landing-page/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/landing-page-pack.jpg\";}s:6:\"hiking\";a:6:{s:4:\"name\";s:6:\"Hiking\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:53:\"https://layerslider.kreaturamedia.com/sliders/hiking/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/hiking.jpg\";}s:12:\"movie-slider\";a:6:{s:4:\"name\";s:12:\"Movie Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/movie-slider/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/movie-slider.jpg\";}s:12:\"photo-studio\";a:6:{s:4:\"name\";s:12:\"Photo Studio\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:62:\"premium,fullsize,filter,text,parallax,specialeffects,blendmode\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/photo-studio/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/photo-studio.jpg\";}s:5:\"shoes\";a:6:{s:4:\"name\";s:5:\"Shoes\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:35:\"premium,fullwidth,parallax,carousel\";s:3:\"url\";s:52:\"https://layerslider.kreaturamedia.com/sliders/shoes/\";s:7:\"preview\";s:66:\"https://repository.kreaturamedia.com/v4/sliders/packages/shoes.jpg\";}s:11:\"mini-cooper\";a:6:{s:4:\"name\";s:18:\"Mini Cooper Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:40:\"premium,fullsize,parallax,specialeffects\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/mini-cooper-slider/\";s:7:\"preview\";s:72:\"https://repository.kreaturamedia.com/v4/sliders/packages/mini-cooper.jpg\";}s:4:\"xmas\";a:6:{s:4:\"name\";s:16:\"Merry Christmas!\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:60:\"premium,parallax,filter,experiments,specialeffects,text,loop\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/merry-christmas/\";s:7:\"preview\";s:65:\"https://repository.kreaturamedia.com/v4/sliders/packages/xmas.jpg\";}s:5:\"clock\";a:6:{s:4:\"name\";s:32:\"Vintage Clock | shows valid time\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:37:\"premium,fullsize,api,experiments,loop\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/vintage-clock/\";s:7:\"preview\";s:66:\"https://repository.kreaturamedia.com/v4/sliders/packages/clock.jpg\";}s:8:\"car-show\";a:6:{s:4:\"name\";s:8:\"Car Show\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:38:\"premium,fullwidth,experiments,api,loop\";s:3:\"url\";s:55:\"https://layerslider.kreaturamedia.com/sliders/car-show/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/car-show.jpg\";}s:8:\"carousel\";a:6:{s:4:\"name\";s:8:\"Carousel\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:13:\"free,carousel\";s:3:\"url\";s:55:\"https://layerslider.kreaturamedia.com/sliders/carousel/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/carousel.jpg\";}s:14:\"fancy-parallax\";a:6:{s:4:\"name\";s:21:\"Fancy Parallax Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:26:\"premium,fullwidth,parallax\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/parallax-slider/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/fancy-parallax.jpg\";}s:13:\"simple-slider\";a:6:{s:4:\"name\";s:13:\"Simple Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:4:\"free\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/simple-slider/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/simple-slider.jpg\";}s:12:\"image-slider\";a:6:{s:4:\"name\";s:12:\"Image Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:4:\"free\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/image-slideshow/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/image-slider.jpg\";}s:19:\"client-testimonials\";a:6:{s:4:\"name\";s:19:\"Client Testimonials\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/sliders/client-testimonials/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/client-testimonials.jpg\";}s:8:\"fixed-bg\";a:6:{s:4:\"name\";s:16:\"Fixed Background\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:23:\"premium,fullwidth,media\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/fixed-background/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/fixed-bg.jpg\";}s:22:\"dynamic-content-slider\";a:6:{s:4:\"name\";s:22:\"Dynamic Content Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:4:\"free\";s:3:\"url\";s:69:\"https://layerslider.kreaturamedia.com/sliders/dynamic-content-slider/\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/dynamic-content-slider.jpg\";}s:6:\"old-3d\";a:6:{s:4:\"name\";s:14:\"LayerSlider v4\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:23:\"free,3dtransition,media\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/3d-demo-slider/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/old-3d.jpg\";}s:2:\"v5\";a:6:{s:4:\"name\";s:14:\"LayerSlider v5\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:19:\"free,parallax,media\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/layerslider-v5/\";s:7:\"preview\";s:63:\"https://repository.kreaturamedia.com/v4/sliders/packages/v5.jpg\";}s:12:\"video-slider\";a:6:{s:4:\"name\";s:12:\"Video Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:10:\"free,media\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/video-slider/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/video-slider.jpg\";}s:6:\"resort\";a:6:{s:4:\"name\";s:6:\"Resort\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:54:\"https://layerslider.kreaturamedia.com/sliders/restort/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/resort.jpg\";}}}", "no");
INSERT INTO `wp_options` VALUES("4360", "_buddydrive_default_privacy", "buddydrive_private", "yes");
INSERT INTO `wp_options` VALUES("4366", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4367", "woocommerce_all_except_countries", "", "yes");
INSERT INTO `wp_options` VALUES("4368", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("4369", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("4370", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("4371", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("4372", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("4409", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("4817", "woocommerce_shipping_debug_mode", "no", "no");
INSERT INTO `wp_options` VALUES("4900", "fs_active_plugins", "O:8:\"stdClass\":2:{s:7:\"plugins\";a:1:{s:19:\"buddydrive/freemius\";O:8:\"stdClass\":3:{s:7:\"version\";s:9:\"1.2.1.6.1\";s:9:\"timestamp\";i:1496918889;s:11:\"plugin_path\";s:25:\"buddydrive/buddydrive.php\";}}s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:25:\"buddydrive/buddydrive.php\";s:8:\"sdk_path\";s:19:\"buddydrive/freemius\";s:7:\"version\";s:9:\"1.2.1.6.1\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1496918889;}}", "yes");
INSERT INTO `wp_options` VALUES("4901", "fs_debug_mode", "", "yes");
INSERT INTO `wp_options` VALUES("4902", "fs_accounts", "a:5:{s:11:\"plugin_data\";a:1:{s:10:\"buddydrive\";a:15:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:105:\"/home/adouraso/domains/adourasoft.com/public_html/demo/wplms/wp-content/plugins/buddydrive/buddydrive.php\";}s:17:\"install_timestamp\";i:1496918889;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:9:\"1.2.1.6.1\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"2.1.1\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:13:\"midiyaweb.com\";s:9:\"server_ip\";s:14:\"164.132.156.83\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1496918893;s:7:\"version\";s:5:\"2.1.1\";}s:15:\"prev_is_premium\";b:0;s:18:\"sticky_optin_added\";b:1;}}s:13:\"file_slug_map\";a:1:{s:25:\"buddydrive/buddydrive.php\";s:10:\"buddydrive\";}s:7:\"plugins\";a:1:{s:10:\"buddydrive\";O:9:\"FS_Plugin\":16:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:10:\"BuddyDrive\";s:4:\"slug\";s:10:\"buddydrive\";s:4:\"type\";N;s:4:\"file\";s:25:\"buddydrive/buddydrive.php\";s:7:\"version\";s:5:\"2.1.1\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:7:\"is_live\";b:1;s:10:\"public_key\";s:32:\"pk_c302f2a54e3a828af10c04778ebc5\";s:10:\"secret_key\";N;s:2:\"id\";s:3:\"619\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:9:\"unique_id\";s:32:\"f135d5122ecc0ed6a3d9fb4623e7687e\";s:13:\"admin_notices\";a:1:{s:10:\"buddydrive\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("4909", "bp-emails-unsubscribe-salt", "NW19SmVIQyZVc3g2USBAJShjJURCR1VVflQxKS9lajRCbjQ5JFpKTCg7d2hUUi4gX31UISAsaEp0by5GWGJsQA==", "yes");
INSERT INTO `wp_options` VALUES("4910", "_bp_ignore_deprecated_code", "", "yes");
INSERT INTO `wp_options` VALUES("5082", "eventon_plugin_version", "2.7.3", "no");
INSERT INTO `wp_options` VALUES("5089", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5090", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5091", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5095", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("5987", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6492", "widget_member_types", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6493", "widget_group_types", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6524", "wplms_api_tracker", "a:10:{s:5:\"posts\";a:109:{i:2710;i:1502807920;i:2642;i:1502831683;i:2717;i:1503143376;i:2720;i:1503359702;i:2722;i:1504009279;i:2733;i:1504862694;i:2739;i:1505741291;i:2740;i:1506500667;i:2745;i:1507346998;i:2756;i:1507987065;i:2776;i:1508939383;i:2793;i:1509336939;i:2798;i:1509901826;i:2803;i:1510656604;i:2812;i:1511246120;i:2816;i:1511620134;i:2823;i:1512573967;i:2863;i:1512650271;i:2879;i:1512822826;i:2883;i:1513424952;i:2892;i:1514365104;i:2897;i:1515142241;i:2904;i:1515956692;i:2908;i:1516705178;i:2909;i:1516729171;i:2912;i:1517475767;i:2922;i:1518689973;i:2923;i:1518699368;i:2932;i:1520361559;i:2936;i:1521149422;i:2947;i:1521298260;i:2951;i:1522057479;i:2954;i:1522750769;i:2955;i:1523333031;i:2958;i:1523900729;i:2966;i:1524650606;i:2981;i:1525362129;i:2990;i:1526129600;i:2992;i:1526982756;i:2993;i:1536768527;i:3004;i:1537436245;i:3014;i:1541259997;i:3017;i:1542322399;i:3025;i:1542992143;i:3030;i:1543226589;i:3046;i:1544088209;i:3052;i:1544215552;i:3055;i:1544435684;i:3056;i:1544435687;i:3057;i:1544435723;i:3059;i:1547116180;i:3062;i:1544438883;i:3066;i:1544440766;i:3067;i:1544441158;i:3068;i:1544441174;i:3072;i:1544460706;i:3077;i:1544862350;i:3090;i:1545900894;i:3095;i:1546430430;i:3101;i:1546621611;i:3102;i:1547112767;i:3115;i:1547279979;i:3118;i:1547303945;i:3120;i:1548172820;i:3123;i:1548870625;i:3130;i:1549549643;i:3149;i:1551267932;i:3155;i:1551533747;i:3156;i:1551971381;i:3157;i:1551971627;i:3159;i:1551971629;i:3161;i:1552048713;i:3162;i:1552695008;i:3165;i:1552901937;i:3171;i:1552903394;i:3177;i:1553728275;i:3186;i:1554876230;i:3188;i:1555504300;i:3190;i:1558528059;i:3191;i:1556466061;i:3201;i:1556638202;i:3205;i:1557257017;i:3218;i:1557990861;i:3219;i:1558183193;i:3245;i:1558947296;i:3250;i:1559611733;i:3254;i:1559655562;i:3263;i:1560695806;i:3266;i:1561383981;i:3271;i:1562671519;i:3277;i:1563995047;i:3279;i:1563995455;i:3280;i:1563995515;i:3286;i:1563995698;i:3289;i:1564159665;i:3290;i:1564160151;i:3291;i:1564160153;i:3293;i:1564233587;i:3300;i:1565267368;i:3308;i:1565329416;i:3314;i:1565760704;i:3316;i:1566380404;i:3326;i:1567538545;i:3331;i:1567794954;i:3338;i:1568712216;i:3339;i:1569830748;i:3344;i:1570029150;i:3345;i:1570618875;i:3347;i:1571632865;}s:4:\"blog\";i:11;s:7:\"counter\";i:2217;s:11:\"statusitems\";a:87:{i:2711;i:1502811538;i:2714;i:1510400727;i:2728;i:1510400903;i:2748;i:1507742954;i:2751;i:1507936898;i:2752;i:1507936939;i:2760;i:1510400727;i:2761;i:1510400727;i:2762;i:1510400903;i:2768;i:1508037471;i:2769;i:1508038792;i:2785;i:1509335615;i:2787;i:1509335897;i:2792;i:1510400727;i:2818;i:1511620639;i:2820;i:1512648644;i:2825;i:1512648710;i:2862;i:1512631483;i:2884;i:1513424991;i:2886;i:1518699878;i:2893;i:1514803438;i:2900;i:1515142451;i:2902;i:1515413541;i:2915;i:1518699878;i:2919;i:1518699711;i:2928;i:1524737623;i:2941;i:1524737623;i:2943;i:1524737776;i:2946;i:1521298108;i:2965;i:1524377454;i:1346;i:1525342743;i:2989;i:1525714571;i:3001;i:1537281736;i:3007;i:1537436247;i:3010;i:1537436249;i:3021;i:1547113577;i:3028;i:1547113635;i:3031;i:1543226999;i:3032;i:1543478361;i:3038;i:1547113577;i:3042;i:1547113560;i:3045;i:1547113635;i:3050;i:1547113560;i:3070;i:1544460573;i:3082;i:1545386881;i:3086;i:1547113560;i:3087;i:1547113560;i:3096;i:1546430440;i:3098;i:1546430577;i:3099;i:1546591275;i:3128;i:1549490164;i:3129;i:1549490354;i:3131;i:1551269725;i:3135;i:1551269566;i:3136;i:1551269566;i:3137;i:1551269566;i:3166;i:1552901939;i:3167;i:1552902204;i:3168;i:1552902206;i:3175;i:1558527086;i:3178;i:1553767442;i:3181;i:1558527086;i:3182;i:1558527086;i:3192;i:1556521596;i:3194;i:1556553436;i:3199;i:1556578672;i:3202;i:1556638206;i:3214;i:1558527530;i:3223;i:1558527086;i:3229;i:1558527086;i:3230;i:1558527530;i:3243;i:1565270859;i:3246;i:1559316965;i:3247;i:1559373819;i:3248;i:1559373821;i:3258;i:1565270869;i:3273;i:1565270869;i:1247;i:1562925056;i:3281;i:1563995519;i:3287;i:1563995714;i:3292;i:1564232614;i:3313;i:1565604779;i:3317;i:1566380442;i:3323;i:1572534981;i:3335;i:1572534965;i:3336;i:1572534981;i:3341;i:1572534981;}s:10:\"allcourses\";i:11;s:7:\"courses\";a:125:{i:2700;i:1502818143;i:2715;i:1502968915;i:2716;i:1502997079;i:2718;i:1504864880;i:2721;i:1503359773;i:2723;i:1504864880;i:2725;i:1504420331;i:2726;i:1504420337;i:2731;i:1504599190;i:2734;i:1505297803;i:2735;i:1505297824;i:2736;i:1510400634;i:1260;i:1551971151;i:1127;i:1551970938;i:2747;i:1507742873;i:2749;i:1507936592;i:2750;i:1507936828;i:2754;i:1507951357;i:2755;i:1507951417;i:2757;i:1510400634;i:2765;i:1508037065;i:2772;i:1510400634;i:2779;i:1509334651;i:2788;i:1509336049;i:2789;i:1509336328;i:2790;i:1509336544;i:2791;i:1509336934;i:2796;i:1509338067;i:2797;i:1510400634;i:2804;i:1512648515;i:2815;i:1511591552;i:2817;i:1511620343;i:2819;i:1512648515;i:2870;i:1512648515;i:2880;i:1518699586;i:2894;i:1514804914;i:2895;i:1515101910;i:2914;i:1518699586;i:2918;i:1518699586;i:2927;i:1524737059;i:2931;i:1519654604;i:2934;i:1524737059;i:2935;i:1520930226;i:2938;i:1524737059;i:2956;i:1523334621;i:2959;i:1524737059;i:2961;i:1524737059;i:2972;i:1524737059;i:2978;i:1525295094;i:2983;i:1525630928;i:2991;i:1526129691;i:2996;i:1537026122;i:2997;i:1537026166;i:2998;i:1537182225;i:2999;i:1537026995;i:3015;i:1541969002;i:3016;i:1541969027;i:3020;i:1547113503;i:3026;i:1542992158;i:3027;i:1547113502;i:3036;i:1547113502;i:3047;i:1547113503;i:3053;i:1544215659;i:3061;i:1544438709;i:3063;i:1547113503;i:3065;i:1544439560;i:3069;i:1547113503;i:3071;i:1544460655;i:3074;i:1544609227;i:3075;i:1544632625;i:3081;i:1545386770;i:3085;i:1547113503;i:3091;i:1546336710;i:3093;i:1547113503;i:3116;i:1547303926;i:3117;i:1547303929;i:3119;i:1547498333;i:3127;i:1549490160;i:3133;i:1551269492;i:3141;i:1551269492;i:3146;i:1550328980;i:3150;i:1551269500;i:1250;i:1551971142;i:1155;i:1551971321;i:1242;i:1551971360;i:1188;i:1551971399;i:1216;i:1551971645;i:1176;i:1551971779;i:1235;i:1551971937;i:1139;i:1551972017;i:1204;i:1551972096;i:3163;i:1552695346;i:3172;i:1552903397;i:3173;i:1552903398;i:3174;i:1558526976;i:3180;i:1558526976;i:3195;i:1556556318;i:3196;i:1556556474;i:3197;i:1556556625;i:3198;i:1556556747;i:3200;i:1556606448;i:3213;i:1558526976;i:3220;i:1558183196;i:3221;i:1558526976;i:3225;i:1558526976;i:3226;i:1558333079;i:3227;i:1558526976;i:3242;i:1565270822;i:3249;i:1559612118;i:3255;i:1565270832;i:3264;i:1560695867;i:3265;i:1560695870;i:3267;i:1561922828;i:3268;i:1561922831;i:3269;i:1561922983;i:3272;i:1562733140;i:3310;i:1565604705;i:3311;i:1565604717;i:3312;i:1565604768;i:3315;i:1565760715;i:3321;i:1572534957;i:3327;i:1567538549;i:3332;i:1572534957;i:3340;i:1572534957;i:3346;i:1571054570;}s:7:\"popular\";i:1562932120;s:13:\"course_status\";a:18:{i:2736;i:1505735361;i:2757;i:1508037451;i:2870;i:1512633172;i:2914;i:1517645270;i:2927;i:1519224749;i:2938;i:1521151587;i:2961;i:1524279001;i:2972;i:1524727223;i:3020;i:1542882827;i:3027;i:1542992380;i:3036;i:1543824071;i:3047;i:1544214849;i:3133;i:1549657466;i:3174;i:1553155355;i:3227;i:1558524232;i:3242;i:1558946775;i:3321;i:1566766061;i:3332;i:1568201316;}s:19:\"allcoursecategories\";i:1565271030;s:11:\"assignments\";a:9:{i:3169;i:1552902235;i:3170;i:1552902265;i:3193;i:1556521635;i:3270;i:1561923232;i:3275;i:1562927998;i:3278;i:1563995052;i:3283;i:1563995597;i:3295;i:1564251713;i:3319;i:1566380450;}}", "yes");
INSERT INTO `wp_options` VALUES("6539", "persian_woo_notice_number_1", "true", "yes");
INSERT INTO `wp_options` VALUES("9162", "logged_in_profile_menu", "a:7:{s:9:\"dashboard\";a:4:{s:5:\"label\";s:14:\"داشبورد\";s:4:\"icon\";s:10:\"icon-meter\";s:4:\"link\";s:24:\"{{userprofile}}dashboard\";s:7:\"privacy\";s:3:\"all\";}s:7:\"courses\";a:4:{s:5:\"label\";s:13:\"دوره ها\";s:4:\"icon\";s:16:\"icon-book-open-1\";s:4:\"link\";s:21:\"{{userprofile}}course\";s:7:\"privacy\";s:3:\"all\";}s:5:\"stats\";a:4:{s:5:\"label\";s:8:\"آمار\";s:4:\"icon\";s:26:\"icon-analytics-chart-graph\";s:4:\"link\";s:34:\"{{userprofile}}course/course-stats\";s:7:\"privacy\";s:3:\"all\";}s:8:\"messages\";a:4:{s:5:\"label\";s:36:\"صندوق ورودی{{inbox_count}}\";s:4:\"icon\";s:18:\"icon-letter-mail-1\";s:4:\"link\";s:23:\"{{userprofile}}messages\";s:7:\"privacy\";s:3:\"all\";}s:13:\"notifications\";a:4:{s:5:\"label\";s:37:\"اعلانات {{notification_count}}\";s:4:\"icon\";s:16:\"icon-exclamation\";s:4:\"link\";s:28:\"{{userprofile}}notifications\";s:7:\"privacy\";s:3:\"all\";}s:6:\"groups\";a:4:{s:5:\"label\";s:13:\"گروه ها\";s:4:\"icon\";s:16:\"icon-myspace-alt\";s:4:\"link\";s:21:\"{{userprofile}}groups\";s:7:\"privacy\";s:3:\"all\";}s:8:\"settings\";a:4:{s:5:\"label\";s:14:\"تنظیمات\";s:4:\"icon\";s:13:\"icon-settings\";s:4:\"link\";s:23:\"{{userprofile}}settings\";s:7:\"privacy\";s:3:\"all\";}}", "yes");
INSERT INTO `wp_options` VALUES("11643", "revslider_servers", "a:7:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-b.tools\";i:3;s:22:\"themepunch-ext-b.tools\";i:4;s:22:\"themepunch-ext-b.tools\";i:5;s:16:\"themepunch.tools\";i:6;s:22:\"themepunch-ext-a.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("11644", "revslider_server_refresh", "1571874194", "yes");
INSERT INTO `wp_options` VALUES("11647", "woocommerce_store_address", "", "yes");
INSERT INTO `wp_options` VALUES("11648", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_options` VALUES("11649", "woocommerce_store_city", "", "yes");
INSERT INTO `wp_options` VALUES("11650", "woocommerce_store_postcode", "", "yes");
INSERT INTO `wp_options` VALUES("11794", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("15317", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("15322", "default_product_cat", "170", "yes");
INSERT INTO `wp_options` VALUES("15340", "woocommerce_catalog_columns", "3", "yes");
INSERT INTO `wp_options` VALUES("18021", "wplms_course_templates", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("18619", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("18653", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("19606", "_transient_woocommerce_webhook_ids", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("19646", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("19647", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("19648", "wp_page_for_privacy_policy", "", "yes");
INSERT INTO `wp_options` VALUES("19649", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای بهبود تجربه شما در این سایت و برای مدیریت دسترسی به حساب کاربری و یا دیگر اهداف ذکر شده در [privacy_policy] استفاده می گردد.", "yes");
INSERT INTO `wp_options` VALUES("19650", "woocommerce_checkout_privacy_policy_text", "داده های شخصی شما برای پردازش سفارش شما مورد استفاده قرار می گیرد، تجربه شما را در این وب سایت و سایر موارد ذکر شده در [privacy_policy] ما پشتیبانی می کند", "yes");
INSERT INTO `wp_options` VALUES("19651", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("19652", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `wp_options` VALUES("19653", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `wp_options` VALUES("19654", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `wp_options` VALUES("19655", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("19656", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wp_options` VALUES("19657", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `wp_options` VALUES("19658", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("19675", "_transient_product_query-transient-version", "1572535792", "yes");
INSERT INTO `wp_options` VALUES("19692", "_transient_shipping-transient-version", "1536719671", "yes");
INSERT INTO `wp_options` VALUES("20267", "widget_wplms_instructor_students_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("21537", "_transient_orders-transient-version", "1566405801", "yes");
INSERT INTO `wp_options` VALUES("23636", "wpb_js_templates", "a:13:{s:15:\"demo1_219322655\";a:2:{s:4:\"name\";s:5:\"demo1\";s:8:\"template\";s:11589:\"[vc_row full_width=\"stretch_row_content_no_spaces\"][vc_column][rev_slider_vc alias=\"classicslider1\"][vc_raw_html]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[/vc_raw_html][/vc_column][/vc_row][vc_row][vc_column][vc_column_text el_class=\"introdemo\"]\n<h4>IS YOUR LEARNING MANAGEMENT SYSTEM SOCIAL.</h4>\n<h2>LEARNING IS A SOCIAL ACTIVITY.</h2>\n&nbsp;\n\nLearning is a social activity, so the Learning management systems must be social.\n\nIntroducing WPLMS the first Social Learning Management system.[/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" css=\".vc_custom_1527241360210{background-color: #fafafa !important;}\"][vc_column][vc_row_inner][vc_column_inner width=\"1/3\"][vc_column_text el_class=\"homesixblocks\"][icon icon=\"fa fa-fort-awesome\" size=\"24px\" color=\"rgba(255,255,255,0.8)\" bg=\"#9ac6e9\" hovercolor=\"\" hoverbg=\"\" padding=\"20px\" radius=\"50%\"]\n\n&nbsp;\n\n<strong>Social Login </strong>\n\nLogin and register accounts from social networks[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_column_text el_class=\"homesixblocks\"][icon icon=\"fa fa-desktop\" size=\"24px\" color=\"rgba(255,255,255,0.8)\" bg=\"#D1D7B3\" hovercolor=\"\" hoverbg=\"\" padding=\"20px\" radius=\"50%\"]\n\n&nbsp;\n\n<strong>Header Styles</strong>\n\nWPLMS comes with 8 prebuilt header styles.[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_column_text el_class=\"homesixblocks\"][icon icon=\"fa fa-eye\" size=\"24px\" color=\"rgba(255,255,255,0.8)\" bg=\"#E4D6ED\" hovercolor=\"\" hoverbg=\"\" padding=\"20px\" radius=\"50%\"]\n\n&nbsp;\n\n<strong>Layout Options</strong>\n\n300+ possible Inbuilt layout options for elements.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width=\"1/3\"][vc_column_text el_class=\"homesixblocks\"][icon icon=\"fa fa-arrows-alt\" size=\"24px\" color=\"rgba(255,255,255,0.8)\" bg=\"#C2D6B3\" hovercolor=\"\" hoverbg=\"\" padding=\"20px\" radius=\"50%\"]\n\n&nbsp;\n\n<strong>Scalable Architechture</strong>\n\nUsed by companies with more than 100k users.[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_column_text el_class=\"homesixblocks\"][icon icon=\"fa fa-flag\" size=\"24px\" color=\"rgba(255,255,255,0.8)\" bg=\"#68D7A2\" hovercolor=\"\" hoverbg=\"\" padding=\"20px\" radius=\"50%\"]\n\n&nbsp;\n\n<strong>Theme Skins</strong>\n\nThe theme comes with 3  theme skins.[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_column_text el_class=\"homesixblocks\"][icon icon=\"fa fa-gamepad\" size=\"24px\" color=\"rgba(255,255,255,0.8)\" bg=\"#D67E6A\" hovercolor=\"\" hoverbg=\"\" padding=\"20px\" radius=\"50%\"]\n\n&nbsp;\n\n<strong>Activity based Learning</strong>\n\nActivity recording for Learning statistics.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\" el_class=\"fullblocks\"][vc_column][vc_column_text][one_fifth first=\"first\"]<img class=\"alignnone size-full wp-image-1958\" src=\"http://wplms.io/demos/demo1/wp-content/uploads/2016/02/user1.jpg\" alt=\"user1\" width=\"600\" height=\"600\" />\n[/one_fifth][one_fifth]<img class=\"alignnone size-full wp-image-1954\" src=\"http://wplms.io/demos/demo1/wp-content/uploads/2016/02/t6.jpg\" alt=\"t6\" width=\"600\" height=\"600\" />\n[/one_fifth][one_fifth]<img class=\"alignnone size-full wp-image-1956\" src=\"http://wplms.io/demos/demo1/wp-content/uploads/2016/02/t1.jpg\" alt=\"t1\" width=\"600\" height=\"600\" />\n[/one_fifth][one_fifth]<img class=\"alignnone size-full wp-image-1953\" src=\"http://wplms.io/demos/demo1/wp-content/uploads/2017/12/t7.jpg\" alt=\"t7\" width=\"600\" height=\"600\" />\n[/one_fifth][one_fifth]<img class=\"alignnone size-full wp-image-1955\" src=\"http://wplms.io/demos/demo1/wp-content/uploads/2016/02/t5.jpg\" alt=\"t5\" width=\"600\" height=\"600\" />\n[/one_fifth][/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/2\" el_class=\"hometextblockimage\"][vc_column_text]<img class=\"alignleft size-full wp-image-2113\" src=\"http://wplms.io/demos/demo1/wp-content/uploads/2017/12/create_course.jpg\" alt=\"create_course\" width=\"800\" height=\"600\" />[/vc_column_text][/vc_column][vc_column width=\"1/2\" el_class=\"hometextblock\"][vc_column_text]<strong style=\"color: #bbb; margin: 0;\">Create Courses Online</strong>\n<h3 style=\"color: #222; margin: 0 0 30px;\">FRONT END COURSE CREATION</h3>\nIt is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.\n\n<a class=\"link\" href=\"#\">Learn more</a>[/vc_column_text][/vc_column][/vc_row][vc_row el_class=\"hometextblockimage\"][vc_column width=\"1/2\" el_class=\"hometextblock\"][vc_column_text]<strong style=\"color: #bbb;\">Manage Courses Live</strong>\n<h3 style=\"color: #222; margin: 0 0 10px;\">EASY COURSE MANAGEMENT</h3>\n<span style=\"line-height: 1.5;\">It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. </span>\n\n<a class=\"link\" href=\"#\">Learn more</a>[/vc_column_text][/vc_column][vc_column width=\"1/2\"][vc_column_text]<img class=\"size-full wp-image-2114 alignright\" src=\"http://wplms.io/demos/demo1/wp-content/uploads/2017/12/notes_discussion.png\" alt=\"notes_discussion\" width=\"800\" height=\"600\" />[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column el_class=\"homecourses\"][v_carousel show_controlnav=\"1\" post_type=\"course\" featured_style=\"postblock\" auto_slide=\"1\" column_width=\"262\" carousel_min=\"2\" carousel_move=\"1\" carousel_number=\"6\" carousel_excerpt_length=\"100\" carousel_link=\"1\"][/vc_column][/vc_row][vc_row css_animation=\"fadeIn\" el_class=\"hometestimonials\"][vc_column][v_carousel show_controlnav=\"1\" post_type=\"testimonials\" featured_style=\"testimonial2\" auto_slide=\"1\" carousel_max=\"1\" carousel_min=\"1\" carousel_move=\"1\" carousel_number=\"4\" carousel_excerpt_length=\"120\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" el_class=\"ourinstructors\"][vc_column][vc_column_text el_class=\"ourinstructors\"]\n<h3 style=\"color: #222;\"><span style=\"font-size: 11px; display: block; color: #bbb;\">INDUSTRY EXPERTS</span>Meet Our Instructors</h3>\n[v_1_4_2]\n<img class=\"alignnone size-full wp-image-1964\" src=\"http://wplms.io/demos/demo1/wp-content/uploads/2017/12/prof1.jpg\" alt=\"prof1\" width=\"633\" height=\"594\" />\n\n<strong>Severus Snape</strong>\n\n[icon icon=\"fa fa-facebook\"][icon icon=\"fa fa-twitter\"][icon icon=\"fa fa-dribble\"]\n\n[/v_1_4_2][v_1_4_2]\n<img class=\"alignnone size-full wp-image-1965\" src=\"http://wplms.io/demos/demo1/wp-content/uploads/2017/12/prof2.jpg\" alt=\"prof2\" width=\"634\" height=\"597\" />\n\n<strong>Severus Snape</strong>\n\n[icon icon=\"fa fa-facebook\"][icon icon=\"fa fa-twitter\"][icon icon=\"fa fa-dribble\"]\n\n[/v_1_4_2][v_1_4_2]\n<img class=\"alignnone size-full wp-image-1966\" src=\"http://wplms.io/demos/demo1/wp-content/uploads/2017/12/prof3.jpg\" alt=\"prof3\" width=\"636\" height=\"590\" />\n\n<strong>Severus Snape</strong>\n\n[icon icon=\"fa fa-facebook\"][icon icon=\"fa fa-twitter\"][icon icon=\"fa fa-dribble\"]\n\n[/v_1_4_2][v_1_4_2]\n<img class=\"alignnone size-full wp-image-1967\" src=\"http://wplms.io/demos/demo1/wp-content/uploads/2017/12/prof4.jpg\" alt=\"prof4\" width=\"623\" height=\"586\" />\n\n<strong>Severus Snape</strong>\n\n[icon icon=\"fa fa-facebook\"][icon icon=\"fa fa-twitter\"][icon icon=\"fa fa-dribble\"]\n\n[/v_1_4_2][/vc_column_text][/vc_column][/vc_row]\";}s:16:\"demo2_1253270116\";a:2:{s:4:\"name\";s:5:\"demo2\";s:8:\"template\";s:5522:\"[vc_row full_width=\"stretch_row\" el_class=\"no-content\"][vc_column][rev_slider_vc alias=\"search-form-hero2\"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\"><strong>Most Trusted Educator Online</strong></h3>\n<p style=\"text-align: center;\">We are the most trusted online educator worldwide. Learn from more than 100 of courses at the comfort of sitting at your home.</p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row css=\".vc_custom_1527241124940{margin-bottom: 60px !important;}\"][vc_column][vc_row_inner][vc_column_inner width=\"1/4\"][vc_column_text]<a href=\"http://wplms.io/demos/demo2/course-cat/technology\" rel=\"attachment wp-att-1849\"><img class=\"alignnone size-medium wp-image-1849\" src=\"http://wplms.io/demos/demo2/wp-content/uploads/2017/12/banner4.jpg\" alt=\"banner4\" width=\"300\" height=\"180\" /></a>[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/4\"][vc_column_text]\n\n<a href=\"../course-cat/photography-2/\" rel=\"attachment wp-att-1848\"><img class=\"alignnone size-medium wp-image-1848\" src=\"../wp-content/uploads/2016/02/banner1-1.jpg\" alt=\"banner1\" width=\"300\" height=\"180\" /></a>\n\n[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/4\"][vc_column_text]\n\n<a href=\"../course-cat/business\" rel=\"attachment wp-att-1847\"><img class=\"alignnone size-medium wp-image-1847\" src=\"../wp-content/uploads/2016/02/banner3.jpg\" alt=\"banner3\" width=\"300\" height=\"180\" /></a>\n\n[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/4\"][vc_column_text]\n\n<a href=\"../course-cat/language\" rel=\"attachment wp-att-1846\"><img class=\"alignnone size-medium wp-image-1846\" src=\"../wp-content/uploads/2016/02/banner2.jpg\" alt=\"banner2\" width=\"300\" height=\"180\" /></a>\n\n[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content\"][vc_column][rev_slider_vc alias=\"news-hero4\" el_class=\"homenewsrev, stripe\"][/vc_column][/vc_row][vc_row el_class=\"paratoppad\"][vc_column width=\"1/3\"][vc_column_text]\n<h5 style=\"text-align: right;\"> <strong>\"I think this is the best thing that </strong></h5>\n<h5 style=\"text-align: right;\"><strong>can happen to anyone</strong>\"</h5>\n<p style=\"text-align: right;\"><em><strong>Words by abc.com</strong></em></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]\n<p style=\"text-align: left;\">Lorem ipsum dolor sit amet, te aliquid reformidans his. Ipsum viderer complectitur an vix, mea dolor nostrum at, at affert impetus meliore per. Nam lorem graeci eirmod te, mei nusquam lucilius eleifend no, putent constituam et mei.</p>\n<p style=\"text-align: left;\">Lorem ipsum dolor sit amet, te aliquid reformidans his. Ipsum viderer complectitur an vix, mea dolor nostrum at, at affert impetus meliore per. Nam lorem graeci eirmod te, mei nusquam lucilius eleifend no, putent constituam et mei.</p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]\n<p style=\"text-align: left;\"><strong>Lorem ipsum dolor sit amet, te aliquid reformidans his. Ipsum viderer complectitur an vix, mea dolor nostrum at, at affert impetus meliore per. Nam lorem graeci eirmod te, mei nusquam lucilius eleifend no, putent constituam et mei.</strong></p>\n\n\n<hr />\n<p style=\"text-align: left;\"><em> <strong>Eu nam quidam dissentias, agam dicat cu has, has partiendo posidonium adversarium et. has ei, molestie recteque pro in.</strong></em></p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]\n\n<hr />\n\n&nbsp;\n<h3 style=\"text-align: center;\"><strong>Courses from renowned Instructors</strong></h3>\n<p style=\"text-align: center;\">Best courses from best Instructors on the worlds favorite site</p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][v_grid show_title=\"1\" post_type=\"course\" featured_style=\"course3\" grid_columns=\"clear4 col-md-3\" grid_number=\"8\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" el_class=\"footerlogos\" css=\".vc_custom_1527241201290{padding-bottom: 30px !important;}\"][vc_column][vc_column_text][one_fifth first=\"first\"]\n\n<img src=\"http://wplms.io/demos/demo2/wp-content/uploads/2016/02/logo5.jpg\" alt=\"\" />\n\n[/one_fifth][one_fifth]\n\n<img src=\"http://wplms.io/demos/demo2/wp-content/uploads/2016/02/logo4.jpg\" alt=\"\" />\n\n[/one_fifth][one_fifth]\n\n<img src=\"http://wplms.io/demos/demo2/wp-content/uploads/2016/02/logo3.jpg\" alt=\"\" />\n[/one_fifth][one_fifth]\n\n<img src=\"http://wplms.io/demos/demo2/wp-content/uploads/2017/12/logo2.jpg\" alt=\"\" />\n\n[/one_fifth][one_fifth]\n\n<img src=\"http://wplms.io/demos/demo2/wp-content/uploads/2017/12/logo1.jpg\" alt=\"\" />\n\n[/one_fifth][/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_raw_html]JTNDc3R5bGUlM0UlMEElMEEuaG9tZW5ld3NyZXYlN0JtYXJnaW4tdG9wJTNBJTIwNjBweCUzQiU3RCUwQS5wYXJhdG9wcGFkJTdCJTIwcGFkZGluZyUzQTkwcHglMjAwJTIwMCUzQiUyMCU3RCUwQSUwQS5mb290ZXJsb2dvcyU3QiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMG1hcmdpbiUzQSUyMDYwcHglMjAwJTIwLTMwcHglM0IlMEElMjAlMjAlMjAlMjBiYWNrZ3JvdW5kJTNBJTIwJTIzZmNmY2ZjJTNCJTBBJTdEJTBBLmZvb3RlcmxvZ29zJTIwLm9uZV9maWZ0aCUyMGltZyUyMCU3Qm1heC13aWR0aCUzQTgwJTI1JTdEJTBBLnN0cmlwZSUyMCU3QiUwQSUyMCUyMCUyMCUyMG1hcmdpbiUzQSUyMDAlM0IlMEElMjAlMjAlMjAlMjB6LWluZGV4JTNBJTIwMyUzQiUwQSUyMCUyMCUyMCUyMG92ZXJmbG93JTNBJTIwaGlkZGVuJTNCJTBBJTdEJTBBLmZvb3RlcmxvZ29zJTIwJTIwLm9uZV9maWZ0aCUyMCU3QiUwQSUyMCUyMCUyMCUyMG9wYWNpdHklM0ElMjAwLjQlM0IlMEElN0QlMEEuZm9vdGVybG9nb3MlMjAud3BiX3dyYXBwZXIlMjAuY29sdW1uX2NvbnRlbnQuZmlyc3QlMjAlN0JtYXJnaW4tdG9wJTNBMTBweCUzQiU3RCUwQSUwQSUzQyUyRnN0eWxlJTNF[/vc_raw_html][/vc_column][/vc_row]\";}s:16:\"demo3_1337166228\";a:2:{s:4:\"name\";s:5:\"demo3\";s:8:\"template\";s:11498:\"[vc_row full_width=\"stretch_row_content\"][vc_column][rev_slider_vc alias=\"highlight-showcase4\"][/vc_column][/vc_row][vc_row el_class=\"hometrioblock \"][vc_column width=\"1/3\"][vc_column_text]\n\n[icon icon=\"fa fa-fort-awesome\"]\n\n<strong>Activity based Learning</strong>\n\n<hr />\n\nCurabitur consectetur ligula nunc, ac convallis purus blandit elementum. Integer ante est, cursus elementum semper non\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]\n\n[icon icon=\"fa fa-flag\"]\n\n<strong>Social Network</strong>\n\n<hr />\n\nCurabitur consectetur ligula nunc, ac convallis purus blandit elementum. Integer ante est, cursus elementum semper non\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]\n\n[icon icon=\"fa fa-balance-scale\"]\n\n<strong>Scalable Architechture</strong>\n\n<hr />\n\nCurabitur consectetur ligula nunc, ac convallis purus blandit elementum. Integer ante est, cursus elementum semper non\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column el_class=\"punchline\"][vc_column_text]\n\n[icon icon=\"fa fa-users\" size=\"32px\" color=\"#ffffff\" bg=\"#009dd8\" hovercolor=\"#222222\" hoverbg=\"#eeeeee\" padding=\"20px\" radius=\"50%\"]\n<p style=\"color: #009dd8;\">Social LMS</p>\n\n<h2>Social Learning Management System,</h2>\n<h2>Learning is Social so why should\'t your LMS be social.</h2>\n[/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" el_class=\"homepopularcourse \"][vc_column][v_carousel show_controlnav=\"1\" post_type=\"course\" course_style=\"popular\" featured_style=\"postblock\" column_width=\"338\" carousel_max=\"3\" carousel_min=\"1\" carousel_move=\"1\" carousel_number=\"6\" carousel_excerpt_length=\"100\"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text css=\".vc_custom_1527490397107{margin-top: 60px !important;}\"]\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\"><strong>OUR TEAM</strong></h3>\n<h6 style=\"text-align: center;\"><span style=\"color: #808080;\">What keep us going</span></h6>\n[/vc_column_text][/vc_column][/vc_row][vc_row el_class=\"team1\"][vc_column width=\"1/4\"][vc_column_text]<a href=\"http://wplms.io/demos/demo3/wp-content/uploads/2016/02/t6.jpg\" rel=\"attachment wp-att-1957\"><img class=\"alignnone size-full wp-image-1957\" src=\"http://wplms.io/demos/demo3/wp-content/uploads/2016/02/t6.jpg\" alt=\"t6\" width=\"600\" height=\"600\" /></a>\n<h6 style=\"text-align: center;\"><span style=\"color: #444444;\"><strong>NATASHA JILL</strong></span></h6>\n<p style=\"text-align: center;\"><span style=\"color: #999999;\"><strong>Professor, Harvard College</strong></span></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text]\n\n<a href=\"http://wplms.io/demos/demo3/wp-content/uploads/2016/02/t1.jpg\" rel=\"attachment wp-att-1952\"><img class=\"alignnone size-full wp-image-1952\" src=\"http://wplms.io/demos/demo3/wp-content/uploads/2016/02/t1.jpg\" alt=\"t1\" width=\"600\" height=\"600\" /></a>\n<h6 style=\"text-align: center;\"><strong><span style=\"color: #444444;\">JOHNATHAN</span></strong></h6>\n<p style=\"text-align: center;\"><strong><span style=\"color: #999999;\">CEO, somesite.com</span></strong></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text]\n\n<a href=\"http://wplms.io/demos/demo3/wp-content/uploads/2016/02/t5.jpg\" rel=\"attachment wp-att-1956\"><img class=\"alignnone size-full wp-image-1956\" src=\"http://wplms.io/demos/demo3/wp-content/uploads/2016/02/t5.jpg\" alt=\"t5\" width=\"600\" height=\"600\" /></a>\n<h6 style=\"text-align: center;\"><span style=\"color: #444444;\"><strong>ARYA STARK</strong></span></h6>\n<p style=\"text-align: center;\"><strong><span style=\"color: #999999;\">Student, Oxford College</span></strong></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text]\n\n<a href=\"http://wplms.io/demos/demo3/wp-content/uploads/2017/12/t7.jpg\" rel=\"attachment wp-att-1958\"><img class=\"alignnone size-full wp-image-1958\" src=\"http://wplms.io/demos/demo3/wp-content/uploads/2017/12/t7.jpg\" alt=\"t7\" width=\"600\" height=\"600\" /></a>\n<h6 style=\"text-align: center;\"><span style=\"color: #444444;\"><strong>JON SNOW</strong></span></h6>\n<p style=\"text-align: center;\"><span style=\"color: #999999;\"><strong>Professor, MIT</strong></span></p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" el_class=\"hometestiomonial_block\"][vc_column][v_carousel show_controls=\"1\" post_type=\"testimonials\" featured_style=\"testimonial2\" auto_slide=\"1\" column_width=\"1\" carousel_max=\"1\" carousel_min=\"1\" carousel_move=\"1\" carousel_number=\"6\" carousel_excerpt_length=\"100\"][/vc_column][/vc_row][vc_row el_class=\"nextstripe\"][vc_column width=\"1/3\"][vc_column_text]\n\n[heading]About Us[/heading]\n\n<img class=\"alignnone size-full wp-image-1975\" src=\"http://wplms.io/demos/demo3/wp-content/uploads/2017/12/blog3.jpg\" alt=\"blog3\" width=\"960\" height=\"576\" />\n\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean pellentesque a ex sed bibendum. Aliquam tempor lacus non quam pellentesque elementum.\n\n<a class=\"link\" href=\"http://wplms.io/demos/demo3/blog-layout-3/\">read more</a>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]\n\n[heading]FAQ[/heading]\n\n[agroup first=\"1\" connect=\"803\"] [accordion title=\"Lorem ipsum dolor sit amet,\" connect=\"803\"] Consectetur adipiscing elit. Aenean pellentesque a ex sed bibendum. Aliquam tempor lacus non quam pellentesque elementum. [/accordion] [accordion title=\"Quisque semper neque non leo\" connect=\"803\"] Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Nullam rhoncus, metus id dictum aliquam, nibh diam tincidunt dolor, sit amet imperdiet quam tortor vel nulla ornare pharetra. Aliquam cursus metus nec metus sagittis varius. Ut quis vehicula urna. Class aptent taciti sociosqu ad litora torquent per conubia [/accordion] [accordion title=\"Nostra, per inceptos himenaeos. \" connect=\"803\"] Donec faucibus imperdiet mauris, ut malesuada nibh. Etiam pharetra ante nisi, eget consequat nisi ornare vel. Aliquam convallis, ante in accumsan malesuada, mauris enim pharetra tellus, lobortis tempus mauris nisi quis mauris. Aenean odio ligula, eleifend eu iaculis sed, mollis ac erat. Maecenas sagittis nulla quis mauris aliquet feugiat. [/accordion] [accordion title=\"Etiam vel nunc augue.\" connect=\"803\"] Aenean pharetra turpis purus, sit amet molestie felis suscipit fermentum. Morbi tincidunt mi vel urna tincidunt, in finibus diam varius. [/accordion] [/agroup]\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]\n\n[heading]Skills[/heading]\n\n[progressbar color=\"other\" percentage=\"100\" bg=#fafafa bar_color=#F55443] User Experience [/progressbar]\n\n[progressbar color=\"other\" percentage=\"40\" bg=#fafafa bar_color=#FFCC33] Interface [/progressbar]\n\n[progressbar color=\"other\" percentage=\"88\" bg=#fafafa bar_color=#235B66] Instructor Skills [/progressbar]\n\n[progressbar color=\"other\" percentage=\"68\" bg=#fafafa bar_color=#10A5BA] Student Skills [/progressbar]\n\n[progressbar color=\"other\" percentage=\"91\" bg=#fafafa bar_color=#96BD2C] Course Skills[/progressbar]\n\n&nbsp;\n\n[/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" el_class=\"footerlogos\"][vc_column][vc_column_text][one_fifth first=\"first\"]<img class=\"alignnone size-full wp-image-2096\" src=\"http://wplms.io/demos/demo3/wp-content/uploads/2017/12/logo2.jpg\" alt=\"logo2\" width=\"300\" height=\"100\" />[/one_fifth][one_fifth]<img class=\"alignnone size-full wp-image-2098\" src=\"http://wplms.io/demos/demo3/wp-content/uploads/2016/02/logo4.jpg\" alt=\"logo4\" width=\"300\" height=\"100\" />[/one_fifth][one_fifth]<img class=\"alignnone size-full wp-image-2097\" src=\"http://wplms.io/demos/demo3/wp-content/uploads/2016/02/logo3.jpg\" alt=\"logo3\" width=\"300\" height=\"100\" />[/one_fifth][one_fifth]<img class=\"alignnone size-full wp-image-2095\" src=\"http://wplms.io/demos/demo3/wp-content/uploads/2016/02/logo1.jpg\" alt=\"logo1\" width=\"300\" height=\"100\" />[/one_fifth][one_fifth]<img class=\"alignnone size-full wp-image-2095\" src=\"http://wplms.io/demos/demo3/wp-content/uploads/2016/02/logo5.jpg\" alt=\"logo5\" width=\"300\" height=\"100\" />[/one_fifth][/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_raw_html]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[/vc_raw_html][/vc_column][/vc_row]\";}s:15:\"demo4_618635361\";a:2:{s:4:\"name\";s:5:\"demo4\";s:8:\"template\";s:5796:\"[vc_row full_width=\"stretch_row_content\"][vc_column][rev_slider_vc alias=\"homeslider1\"][/vc_column][/vc_row][vc_row css=\".vc_custom_1527505656802{margin-left: 50px !important;}\"][vc_column][vc_row_inner][vc_column_inner el_class=\"sixblocks\" width=\"1/3\"][vc_column_text]\n<h3 style=\"text-align: center;\"><a href=\"http://wplms.io/demos/demo4/wp-content/uploads/2016/02/icon1.png\"><img class=\"aligncenter size-mini wp-image-2010\" src=\"http://wplms.io/demos/demo4/wp-content/uploads/2016/02/icon1.png\" alt=\"icon1\" width=\"120\" height=\"120\" /></a>Top selling Education Theme</h3>\n<p style=\"text-align: center;\">With over 10k customers, WPLMS is the top selling WordPress Education theme of all time in Education sector.</p>\n\n[/vc_column_text][/vc_column_inner][vc_column_inner el_class=\"sixblocks\" width=\"1/3\"][vc_column_text]\n<h3 style=\"text-align: center;\"><a href=\"http://wplms.io/demos/demo4/wp-content/uploads/2016/02/icon2.png\"><img class=\"aligncenter size-mini wp-image-2011\" src=\"http://wplms.io/demos/demo4/wp-content/uploads/2016/02/icon2.png\" alt=\"icon2\" width=\"120\" height=\"120\" /></a>Superb Quiz platform</h3>\n<p style=\"text-align: center;\">WPLMS has the most amazing and advanced quizzing platform with 8 supported question types.</p>\n\n[/vc_column_text][/vc_column_inner][vc_column_inner el_class=\"sixblocks\" width=\"1/3\"][vc_column_text]\n<h3 style=\"text-align: center;\"><a href=\"http://wplms.io/demos/demo4/wp-content/uploads/2016/02/icon3.png\"><img class=\"aligncenter size-mini wp-image-2012\" src=\"http://wplms.io/demos/demo4/wp-content/uploads/2016/02/icon3-104x120.png\" alt=\"icon3\" width=\"104\" height=\"120\" /></a>User Friendly Interface</h3>\n<p style=\"text-align: center;\">With Front Course creation and management, everything in WPLMS is managed from the front end.</p>\n\n[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner el_class=\"sixblocks\" width=\"1/3\"][vc_column_text]\n<h3 style=\"text-align: center;\"><a href=\"http://http://wplms.io/demos/demo4/wp-content/uploads/2016/02/icon4.png\"><img class=\"aligncenter size-mini wp-image-2014\" src=\"http://wplms.io/demos/demo4/wp-content/uploads/2016/02/icon4.png\" alt=\"icon4\" width=\"120\" height=\"120\" /></a>Unlimited Design options</h3>\n<p style=\"text-align: center;\">Besides unlimited color &amp; font management. Layouts in WPLMS have 1000+ options.</p>\n\n[/vc_column_text][/vc_column_inner][vc_column_inner el_class=\"sixblocks\" width=\"1/3\"][vc_column_text]\n<h3 style=\"text-align: center;\"><a href=\"http://wplms.io/demos/demo4/wp-content/uploads/2016/02/icon5.png\"><img class=\"aligncenter size-full wp-image-33\" src=\"http://wplms.io/demos/demo4/wp-content/uploads/2016/02/icon5.png\" alt=\"\" width=\"120\" height=\"120\" /></a>Secure &amp; Scalable</h3>\n<p style=\"text-align: center;\">After 3 years of continuous regression, WPLMS is the most robust, secure and scalable platform for Education sites.</p>\n\n[/vc_column_text][/vc_column_inner][vc_column_inner el_class=\"sixblocks\" width=\"1/3\"][vc_column_text]\n<h3 style=\"text-align: center;\"><a href=\"http://wplms.io/demos/demo4/wp-content/uploads/2016/02/icon6.png\"><img class=\"aligncenter size-full wp-image-32\" src=\"http://wplms.io/demos/demo4/wp-content/uploads/2016/02/icon6.png\" alt=\"\" width=\"120\" height=\"120\" /></a>Reliable Customer support</h3>\n<p style=\"text-align: center;\">Last but not the least we\'re dedicated and committed to WPLMS, that\'s why we have only 1 product in our portfolio.</p>\n\n[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\".vc_custom_1527505873366{margin-top: 150px !important;margin-bottom: 30px !important;}\"][vc_column][vc_column_text]\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\">Complete solution for Creating &amp; Selling courses</h3>\n<p style=\"text-align: center;\">Create courses and sell with Front end course creation with Buddpress &amp; BBPress.</p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][rev_slider_vc alias=\"categories\"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]\n\n[one_fifth first=first] <img class=\"alignnone\" src=\"http://wplms.io/demos/demo2/wp-content/uploads/2017/12/logo5.jpg\" width=\"300\" height=\"100\" />[/one_fifth][one_fifth first=] <img class=\"alignnone\" src=\"http://wplms.io/demos/demo2/wp-content/uploads/2017/12/logo4.jpg\" width=\"300\" height=\"100\" />[/one_fifth][one_fifth first=] <img class=\"alignnone\" src=\"http://wplms.io/demos/demo2/wp-content/uploads/2017/12/logo3.jpg\" width=\"300\" height=\"100\" />[/one_fifth][one_fifth first=] <img class=\"alignnone\" src=\"http://wplms.io/demos/demo2/wp-content/uploads/2017/12/logo2.jpg\" width=\"300\" height=\"100\" />[/one_fifth][one_fifth first=]<img class=\"alignnone\" src=\"http://wplms.io/demos/demo2/wp-content/uploads/2017/12/logo1.jpg\" width=\"300\" height=\"100\" /> [/one_fifth]\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_raw_html]JTNDc3R5bGUlM0UlMEEuc2l4YmxvY2tzJTIwJTdCJTBBJTIwJTIwJTIwJTIwdGV4dC1hbGlnbiUzQSUyMGNlbnRlciUzQiUwQSUyMCUyMCUyMCUyMG1hcmdpbiUzQSUyMDIwcHglMjAyMHB4JTIwMjBweCUyMDIwcHglM0IlMEElMjAlMjAlMjAlMjBib3JkZXIlM0ElMjAxcHglMjBzb2xpZCUyMCUyM2VlZSUzQiUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0ElMjAyMHB4JTNCJTBBJTIwJTIwJTIwJTIwd2lkdGglM0ElMjAyOSUyNSUzQiUwQSU3RCUwQSUyMCUyMCUyMCUyMCUwQS5zaXhibG9ja3MlMjBpbWclN0JoZWlnaHQlM0E4MHB4JTNCd2lkdGglM0FhdXRvJTNCbWFyZ2luLWJvdHRvbSUzQTIwcHglMjAlMjFpbXBvcnRhbnQlM0IlN0QlMEElMEEuc2l4YmxvY2tzJTIwaDMlN0Jmb250LXNpemUlM0ElMjAxNnB4JTNCdGV4dC10cmFuc2Zvcm0lM0ElMjB1cHBlcmNhc2UlM0Jmb250LXdlaWdodCUzQSUyMDYwMCUzQm1hcmdpbiUzQSUyMDE1cHglMjAwJTIwMCUzQiU3RCUwQSUwQS5zaXhibG9ja3MlM0Fob3ZlciU3QmJhY2tncm91bmQlM0ElMjNmYWZhZmElM0IlN0QlMEEuYW5pbWF0ZSUyMCU3QiUwQSUyMCUyMCUyMCUyMG9wYWNpdHklM0ElMjAxJTIwJTIxaW1wb3J0YW50JTNCJTBBJTdEJTBBJTBBJTBBJTNDJTJGc3R5bGUlM0U=[/vc_raw_html][/vc_column][/vc_row]\";}s:16:\"demo-5_488954929\";a:2:{s:4:\"name\";s:6:\"Demo 5\";s:8:\"template\";s:15571:\"[vc_row][vc_column][rev_slider_vc alias=\"demo5\"][/vc_column][/vc_row][vc_row css=\".vc_custom_1527254904663{margin-top: 60px !important;}\"][vc_column el_class=\"homeheading \"][vc_column_text]\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\">OUR SERVICES</h3>\n<p style=\"text-align: center;\"><em>Our services &amp; offers</em></p>\n\n\n<hr />\n\n[/vc_column_text][/vc_column][/vc_row][vc_row css=\".vc_custom_1527254932914{margin-top: 30px !important;margin-bottom: 30px !important;}\"][vc_column width=\"1/4\"][vc_column_text]\n\n<img class=\"aligncenter size-medium wp-image-2340\" src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/work4-460x263.jpg\" alt=\"work4\" width=\"300\" height=\"172\" />\n<h4 style=\"text-align: center;\"> Online &amp; Offline courses</h4>\n<p style=\"text-align: center;\">Teach students online as well as offline with units, quizzes &amp; assignments</p>\n\n&nbsp;\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text]\n\n<img class=\"aligncenter size-medium wp-image-2338\" src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/work2-460x263.jpg\" alt=\"work2\" width=\"300\" height=\"172\" />\n<h4 style=\"text-align: center;\">Notification &amp; Emails</h4>\n<p style=\"text-align: center;\">Send automatic notifications, emails &amp; messages to Instructors, Students</p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text]\n<p style=\"text-align: center;\"><img class=\"aligncenter size-medium wp-image-2339\" src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/work3-460x263.jpg\" alt=\"work3\" width=\"300\" height=\"172\" /></p>\n\n<h4 style=\"text-align: center;\">Advanced Statistics</h4>\n<p style=\"text-align: center;\">Get simple &amp; advanced statistics for students and courses.</p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text]\n\n<img class=\"aligncenter size-medium wp-image-2337\" src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/work1-460x263.jpg\" alt=\"work1\" width=\"300\" height=\"172\" />\n<h4 style=\"text-align: center;\">Social LMS</h4>\n<p style=\"text-align: center;\">Built over BuddyPress social network for WordPress</p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row css=\".vc_custom_1527254918275{margin-top: 60px !important;}\"][vc_column el_class=\"homeheading \"][vc_column_text el_class=\"homeheading \"]\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\">OUR COURSES</h3>\n<p style=\"text-align: center;\"><em>We build awesome courses for your learning</em></p>\n\n\n<hr />\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][v_grid post_type=\"course\" featured_style=\"course4\" grid_columns=\"clear4 col-md-3\" grid_number=\"8\" grid_excerpt_length=\"100\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content\" el_class=\"halfblocks\" css=\".vc_custom_1527254824908{margin-top: 30px !important;margin-bottom: 30px !important;}\"][vc_column width=\"1/2\"][vc_column_text]\n\n<img class=\"alignleft size-full wp-image-2343\" src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/stripeimg.jpg\" alt=\"stripeimg\" width=\"1000\" height=\"667\" />\n\n[/vc_column_text][/vc_column][vc_column width=\"1/2\" el_class=\"homeheading numscroller\" css=\".vc_custom_1527511865908{margin-top: 60px !important;}\"][vc_column_text]\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\"> WE BUILD AWESOMENESS</h3>\n<p style=\"text-align: center;\"><em>Be your own Boss</em></p>\n\n\n<hr />\n\n&nbsp;\n<p style=\"text-align: center;\"><span style=\"color: #ffffff;\">Global leaders around the world have joined hands with WPLMS.</span></p>\n\n<h5>[one_third]\n[number_counter min=\"0\" max=\"345\" delay=\"3\" increment=\"15\"]\n<span style=\"color: #ffffff;\">Courses</span> [/one_third]</h5>\n<h5>[one_third]\n[number_counter min=\"0\" max=\"52\" delay=\"3\" increment=\"15\"]\n<span style=\"color: #ffffff;\">Instructors</span> [/one_third]</h5>\n<h5>[one_third]\n[number_counter min=\"0\" max=\"90\" delay=\"3\" increment=\"15\"]\n<span style=\"color: #ffffff;\">Events</span> [/one_third]</h5>\n[/vc_column_text][/vc_column][/vc_row][vc_row css=\".vc_custom_1527254776790{margin-top: 60px !important;}\"][vc_column el_class=\"homeheading \"][vc_column_text]\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\">OUR TRAINERS</h3>\n<p style=\"text-align: center;\"><em>Learn from world\'s best Instructors</em></p>\n\n\n<hr />\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/4\"][vc_column_text]\n\n<img class=\"aligncenter size-full wp-image-2347\" src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/trainer1.jpg\" alt=\"trainer1\" width=\"440\" height=\"440\" />\n<h4 style=\"text-align: center;\">ANNA THOMAS</h4>\n<p style=\"text-align: center;\"><em>Marketing Instructor</em></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text]\n\n<img class=\"aligncenter size-full wp-image-2350\" src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/trainer4.jpg\" alt=\"trainer4\" width=\"440\" height=\"440\" />\n<h4 style=\"text-align: center;\">JEREMY LAWSON</h4>\n<p style=\"text-align: center;\"><em>Graphic Designer</em></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text]\n\n<img class=\"aligncenter size-full wp-image-2349\" src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/trainer3.jpg\" alt=\"trainer3\" width=\"440\" height=\"440\" />\n<h4 style=\"text-align: center;\">MIKE SANDERS</h4>\n<p style=\"text-align: center;\"><em>Marketing Analyst</em></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text]<img class=\"aligncenter size-full wp-image-2348\" src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/trainer2.jpg\" alt=\"trainer2\" width=\"440\" height=\"440\" />\n<h4 style=\"text-align: center;\">KEVIN ANDREWS</h4>\n<p style=\"text-align: center;\"><em>Business Development</em></p>\n\n&nbsp;\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/2\" el_class=\"saleblock \"][vc_column_text]\n<h3 style=\"text-align: center;\"></h3>\n<h2 style=\"text-align: center;\"><span style=\"color: #ffffff;\">SUMMER SALE</span></h2>\n<h5 style=\"text-align: center;\"><strong>ENTER YOUR EMAIL TO UNLOCK</strong></h5>\n<p style=\"text-align: center;\"><strong>Where should we send you 30% off?</strong></p>\n<p style=\"text-align: center;\">[form to=\"example@example.com\" subject=\"Subject\"] [form_element type=\"text\" validate=\"email\" options=\"\" placeholder=\"Email\"] [form_element type=\"submit\" validate=\"\" options=\"\" placeholder=\"Submit\"] [/form]</p>\n\n<h5 style=\"text-align: center;\">GRAB BEFORE OFFER EXPIRES</h5>\n<p style=\"text-align: center;\"><strong><em>Multiple courses with globally recognized </em><em>instructors</em></strong></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/2\" el_class=\"homeform\"][vc_column_text]\n<h3>Become an Instructor</h3>\n<em>Tell us about yourself</em>\n\n[form to=\"example@example.com\" subject=\"Subject\"] [form_element type=\"text\" validate=\"\" options=\"\" placeholder=\"Name\"] [form_element type=\"text\" validate=\"email\" options=\"\" placeholder=\"Email\"] [form_element type=\"textarea\" validate=\"required\" options=\"\" placeholder=\"Tell us about yourself\"][form_element type=\"submit\" validate=\"\" options=\"\" placeholder=\"Submit\"] [/form][/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" parallax=\"content-moving\" parallax_image=\"569\" css=\".vc_custom_1527254679227{margin-top: 60px !important;margin-bottom: 60px !important;}\"][vc_column][vc_row_inner el_class=\"homeheading \"][vc_column_inner][vc_column_text]\n\n&nbsp;\n<h3 style=\"text-align: center;\"><span style=\"color: #ffffff;\">MEET OUR PARTNERS</span></h3>\n<p style=\"text-align: center;\"><span style=\"color: #ffffff;\"><em>Globally recognized worldwide </em></span></p>\n\n\n<hr />\n\n[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner el_class=\"homeheading \"][vc_column_inner][vc_column_text][one_fifth first=\"first\"]\n\n<img src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/logo2-1-460x460.png\" alt=\"\" />\n\n[/one_fifth][one_fifth]\n\n<img src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/logo3-2-460x460.png\" alt=\"\" />\n\n[/one_fifth][one_fifth]\n\n<img src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/logo1-1-460x460.png\" alt=\"\" />\n[/one_fifth][one_fifth]\n\n<img src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/logo4-2-460x460.png\" alt=\"\" />\n\n[/one_fifth][one_fifth]\n\n<img src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/logo2-1-460x460.png\" alt=\"\" />\n\n[/one_fifth][/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][vc_column_text el_class=\"homeheading\"]\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\">HAPPY CUSTOMERS</h3>\n<p style=\"text-align: center;\"><em>See what our customers say about us</em></p>\n\n\n<hr />\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/3\" el_class=\"testimonialnew \" css=\".vc_custom_1527258856088{margin-right: 10px !important;}\"][vc_column_text]\n\n<em>I have been using this platform for almost 2 years and i must say the support is mind blowing, above all the features are added which is great and important for a product to survive. </em>\n<h5 style=\"text-align: left;\">Anthony Wilson</h5>\n<p style=\"text-align: left;\"><em>somesite.com</em></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\" el_class=\"testimonialnew \" css=\".vc_custom_1527255709978{padding-right: 20px !important;}\"][vc_column_text]\n\n<em>Superb..!! I have been using this platform for almost 2 years and i must say the support is mind blowing, i don\'t think you will ever find a product comparable to WPLMS. Best of Luck WPLMS.</em>\n<h5>Gaba Lawson</h5>\n<em>somesite.com</em>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\" el_class=\"testimonialnew \"][vc_column_text]\n\n<em>I have absolutely no words. The support is way above others, i don\'t think you will ever find a product comparable to WPLMS and yes the team is doing a great job. I am absolutely satisfied with WPLMS.</em>\n<h5>Mira Newman</h5>\n<em>somesite.com</em>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column el_class=\"homeheading \" css=\".vc_custom_1527255556358{margin-top: 60px !important;}\"][vc_column_text]\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\"></h3>\n<h3 style=\"text-align: center;\">FROM OUR BLOG</h3>\n<p style=\"text-align: center;\"><em>News &amp; Happenings about WPLMS</em></p>\n\n\n<hr />\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][v_carousel show_controlnav=\"1\" post_type=\"post\" featured_style=\"\" auto_slide=\"1\" column_width=\"270\" carousel_max=\"5\" carousel_min=\"4\" carousel_move=\"1\" carousel_number=\"99\" carousel_excerpt_length=\"150\" carousel_link=\"1\"][/vc_column][/vc_row][vc_row][vc_column][vc_raw_html]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[/vc_raw_html][/vc_column][/vc_row]\";}s:16:\"demo7_1287518728\";a:2:{s:4:\"name\";s:5:\"demo7\";s:8:\"template\";s:5346:\"[vc_row][vc_column][rev_slider_vc alias=\"demo7\"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text el_class=\"punchline\"]\n<h2 style=\"text-align: center; font-size: 3.5em; letter-spacing: -2px; text-transform: uppercase; font-weight: 800;\">Education on Social Platform !</h2>\n<p style=\"text-align: center; font-size: 1.5em;\">Learning is social, so why should your Learning management platform not be social.\nBuy WPLMS and make learning social again.\n\n[/vc_column_text][/vc_column][/vc_row][vc_row el_class=\"threeblocks\"][vc_column width=\"1/3\" el_class=\"block_new\"][vc_column_text el_class=\"threeblock\"]<a href=\"http://wplms.io/demos/demo7/wp-content/uploads/2018/05/Online-Analytical.png\"><img class=\"size-full wp-image-515 alignleft\" src=\"http://wplms.io/demos/demo7/wp-content/uploads/2018/05/Online-Analytical.png\" alt=\"\" width=\"120\" height=\"120\" /></a>\n\n&nbsp;\n\n&nbsp;\n\n&nbsp;\n<p style=\"text-align: center;\">[heading]LMS on WP[/heading]</p>\n<p style=\"text-align: center;\">It is a long established fact that a reader will be distracted by the readable content of a page when looking.</p>\n<p style=\"text-align: center;\"><a class=\"link\">Link</a></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text el_class=\"threeblock\"]<a href=\"http://wplms.io/demos/demo7/wp-content/uploads/2017/12/Motivation.png\"><img class=\"alignleft size-full wp-image-457\" src=\"http://wplms.io/demos/demo7/wp-content/uploads/2017/12/Motivation.png\" alt=\"\" width=\"120\" height=\"114\" /></a>\n\n&nbsp;\n\n&nbsp;\n\n&nbsp;\n<p style=\"text-align: center;\">[heading]Social Learning[/heading]</p>\n<p style=\"text-align: center;\">It is a long established fact that a reader will be distracted by the readable content of a page when looking.</p>\n\n<a class=\"link\">Link</a>[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text el_class=\"threeblock\"]<a href=\"http://wplms.io/demos/demo7/wp-content/uploads/2017/12/Know-Your-Customer.png\"><img class=\"alignleft size-full wp-image-458\" src=\"http://wplms.io/demos/demo7/wp-content/uploads/2017/12/Know-Your-Customer.png\" alt=\"\" width=\"108\" height=\"120\" /></a>\n\n&nbsp;\n\n&nbsp;\n\n&nbsp;\n<p style=\"text-align: center;\">[heading]Online Education[/heading]</p>\n<p style=\"text-align: center;\">It is a long established fact that a reader will be distracted by the readable content of a page when looking.</p>\n\n<a class=\"link\">Link</a>[/vc_column_text][/vc_column][/vc_row][vc_row el_class=\"cc_cats\"][vc_column][v_taxonomy_carousel orderby=\"name\" show_controls=\"1\" auto_slide=\"1\" column_width=\"128\" carousel_max=\"6\" carousel_min=\"2\" carousel_move=\"1\" carousel_number=\"6\"][/vc_column][/vc_row][vc_row el_class=\"dark\"][vc_column][v_filterable post_type=\"course\" taxonomy=\"course-cat\" term=\"course-cat\" featured_style=\"postblock\" show_all=\"1\" column_width=\"252\" filterable_number=\"8\" filterable_excerpt_length=\"100\"][/vc_column][/vc_row][vc_row][vc_column][vc_raw_html]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[/vc_raw_html][/vc_column][/vc_row]\";}s:15:\"demo8_158126514\";a:2:{s:4:\"name\";s:5:\"demo8\";s:8:\"template\";s:5307:\"[vc_row][vc_column][rev_slider_vc alias=\"demo8\" el_class=\"mainheader\"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text el_class=\"punchline\"]\n<h2 style=\"text-align: center;\"><strong>Corporate Training Center.</strong></h2>\n<p style=\"text-align: center;\">Enable companies to manage their custom groups of students, courses and view statistics.\nCompanies can register themselves on this portal and show selected courses to their employees and track their performances.\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/4\"][vc_column_text el_class=\"serviceblockhome \"]<img class=\"aligncenter size-small\" src=\"http://wplms.io/demos/demo5/wp-content/uploads/2017/12/work2-460x263.jpg\" width=\"460\" height=\"263\" />\n<h4 style=\"text-align: center;\">Notification &amp; Emails</h4>\n<p style=\"text-align: center;\">Send automatic notifications, emails &amp; messages to Instructors, Students</p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text el_class=\"serviceblockhome \"]<img class=\"aligncenter size-small\" src=\"http://wplms.io/demos/demo8/wp-content/uploads/2017/12/work1-460x263.jpg\" width=\"460\" height=\"263\" />\n<h4 style=\"text-align: center;\"> Online &amp; Offline courses</h4>\n<p style=\"text-align: center;\">Teach students online as well as offline with units, quizzes &amp; assignments</p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text el_class=\"serviceblockhome \"]<img class=\"aligncenter size-full wp-image-439\" src=\"http://wplms.io/demos/demo8/wp-content/uploads/2017/12/slideblock3.jpg\" alt=\"\" width=\"460\" height=\"263\" />\n<h4 style=\"text-align: center;\">Notification &amp; Emails</h4>\n<p style=\"text-align: center;\">Send automatic notifications, emails &amp; messages to Instructors, Students</p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text el_class=\"serviceblockhome\"]<img class=\"aligncenter size-full wp-image-438\" src=\"http://wplms.io/demos/demo8/wp-content/uploads/2017/12/slideblock2.jpg\" alt=\"\" width=\"460\" height=\"263\" />\n<h4 style=\"text-align: center;\">Notification &amp; Emails</h4>\n<p style=\"text-align: center;\">Send automatic notifications, emails &amp; messages to Instructors, Students</p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/3\"][vc_column_text el_class=\"registrationformleft\"]\n<h3 style=\"text-align: center;\">Steps to register :</h3>\n<ul>\n	<li>Register a member in this site.</li>\n	<li>Select the courses for your employees.</li>\n	<li>Reserve the number of seats.</li>\n	<li>Get price and make payment.</li>\n	<li>Add members and track performance.</li>\n</ul>\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]<img class=\"aligncenter size-full wp-image-440\" src=\"http://wplms.io/demos/demo8/wp-content/uploads/2016/02/man2.png\" alt=\"\" width=\"214\" height=\"400\" />[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text el_class=\"instructorregistration\"]\n<h3 style=\"text-align: center;\">Register as Instructor</h3>\n<p style=\"text-align: center;\">[wplms_registration_form name=\"instructor\" field_meta=1]</p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_column_text el_class=\"popularheadline\"]\n<h2 style=\"text-align: center; font-size: 3rem;\">Get started with our popular courses</h2>\n<p style=\"text-align: center;\">Select courses to get started with our corporate packages.</p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][v_grid post_type=\"course\" featured_style=\"generic\" grid_columns=\"clear4 col-md-3\" grid_number=\"8\" infinite=\"1\" grid_excerpt_length=\"100\"][/vc_column][/vc_row][vc_row][vc_column][vc_raw_html]JTNDc3R5bGUlM0UlMEFoZWFkZXIuZml4JTNBbm90JTI4LmZpeGVkJTI5JTdCcG9zaXRpb24lM0FmaXhlZCUzQmJhY2tncm91bmQlM0Fub25lJTNCdG9wJTNBMCUzQmxlZnQlM0EwJTNCJTdEJTBBLnB1bmNobGluZSU3QnBhZGRpbmclM0E5MHB4JTIwMCUyMDQ1cHglM0Jmb250LXNpemUlM0ExNnB4JTNCJTdELnB1bmNobGluZSUyMGgyJTdCZm9udC1zaXplJTNBNHJlbSUzQiU3RCUwQS5zZXJ2aWNlYmxvY2tob21lJTdCbWFyZ2luJTNBNjBweCUyMDAlM0IlN0Quc2VydmljZWJsb2NraG9tZSUyMGg0JTdCbWFyZ2luLXRvcCUzQTI1cHglM0IlN0QlMEEuc2VydmljZWJsb2NraG9tZSUyMGltZyU3QmJvcmRlci1yYWRpdXMlM0E2cHglM0IlN0QlMEEucmVnaXN0cmF0aW9uZm9ybWxlZnQlN0Jjb3VudGVyLXJlc2V0JTNBJTIwc3RlcHMlM0IlN0QucmVnaXN0cmF0aW9uZm9ybWxlZnQlMjBoMyU3QmZvbnQtc2l6ZSUzQTNyZW0lM0IlN0QlMEEucmVnaXN0cmF0aW9uZm9ybWxlZnQlMjBsaSUyMCU3QmxpbmUtaGVpZ2h0JTNBNHJlbSUzQiU3RCUwQS5yZWdpc3RyYXRpb25mb3JtbGVmdCUyMGxpJTNBYmVmb3JlJTdCY291bnRlci1pbmNyZW1lbnQlM0FzdGVwcyUzQmNvbnRlbnQlM0Fjb3VudGVyJTI4c3RlcHMlMjklM0IlMEFwYWRkaW5nJTNBMTBweCUyMDE1cHglM0Jib3JkZXItcmFkaXVzJTNBNTAlMjUlM0Jib3JkZXIlM0EycHglMjBzb2xpZCUyMCUyMzU3Y2E4NSUzQmNvbG9yJTNBJTIzNTdjYTg1JTNCJTBBbWFyZ2luLXJpZ2h0JTNBMTVweCUzQiU3RCUwQS5pbnN0cnVjdG9ycmVnaXN0cmF0aW9uJTIwJTdCYmFja2dyb3VuZCUzQSUyMzU3Y2E4NSUzQnBhZGRpbmclM0EzMHB4JTIwMzBweCUyMDEwcHglM0Jib3JkZXItcmFkaXVzJTNBNXB4JTNCY29sb3IlM0ElMjNmZmYlM0IlN0QlMEEuc3VibWl0X3JlZ2lzdHJhdGlvbl9mb3JtJTdCY29sb3IlM0ElMjNmZmYlMjAlMjFpbXBvcnRhbnQlM0Jib3JkZXItY29sb3IlM0ElMjNmZmYlMjAlMjFpbXBvcnRhbnQlM0IlMEF3aWR0aCUzQTEwMCUyNSUzQnRleHQtYWxpZ24lM0FjZW50ZXIlM0IlN0RpbnB1dCU3QndpZHRoJTNBMTAwJTI1JTNCJTdEJTBBLmluc3RydWN0b3JyZWdpc3RyYXRpb24lMjAlMjBoMyU3QmNvbG9yJTNBJTIzZmZmJTNCJTdEJTBBLmZpZWxkLXZpc2liaWxpdHktc2V0dGluZ3MtdG9nZ2xlJTdCZGlzcGxheSUzQW5vbmUlM0IlN0QlMEEucG9wdWxhcmhlYWRsaW5lJTdCbWFyZ2luJTNBNjBweCUyMDAlM0IlN0QlMEElM0MlMkZzdHlsZSUzRQ==[/vc_raw_html][/vc_column][/vc_row]\";}s:16:\"demo9_1322246864\";a:2:{s:4:\"name\";s:5:\"demo9\";s:8:\"template\";s:9308:\"[vc_row el_class=\"revolution_slider\"][vc_column][rev_slider_vc alias=\"demo9\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" el_class=\"stripeitems\"][vc_column][vc_column_text]<strong style=\"color: #5b11b8;\">Let our numbers speak for themserlves</strong>\n\n[one_third]\n\n[icon icon=\"icon-radar-2\" color=\"#5b11b8\"]\n<h3>500+</h3>\n<strong>Certified</strong>\n\nProfessional Instructors\n\n[/one_third][one_third][icon icon=\"icon-golf-24\" color=\"#5b11b8\"]\n<h3>25000+</h3>\n<strong>Enrolled</strong>\n\nStudents in Courses\n\n[/one_third][one_third]\n\n[icon icon=\"icon-email-plane\" color=\"#5b11b8\"]\n<h3>24</h3>\n<strong>Countries</strong>\n\naround the world\n\n[/one_third][/vc_column_text][/vc_column][/vc_row][vc_row el_class=\"mainstripe\"][vc_column width=\"1/3\" el_class=\"onethree\"][vc_column_text]\n<h2>Dream Big</h2>\n<h3 style=\"color: #5b11b8;\">Inspire the world</h3>\nA Social eLearning platform for your WordPress site. For corporate training and Education centers around the world.\n<ul>\n	<li>Activity tracking &amp; Spec compliance</li>\n	<li>Assured design &amp; code quality</li>\n	<li>Improved architechture</li>\n	<li>Unparalleled support</li>\n</ul>\n[/vc_column_text][/vc_column][vc_column width=\"2/3\" el_class=\"twothree\"][vc_column_text][one_third]\n<h2>Social</h2>\n<h3>eLearning</h3>\nJoin our award-winning platform, and enjoy a creative, dynamic and inclusive culture focused on one goal.\n\n[button bg=\"#ffffff\" hover_bg=\"#5b11b8\"]Learn more[/button]\n\n&nbsp;\n\n[/one_third][two_third]\n\n<img class=\"alignnone wp-image-534 size-full\" src=\"http://wplms.io/demos/demo9/wp-content/uploads/2018/01/prof.png\" alt=\"\" width=\"800\" height=\"533\" />[/two_third][/vc_column_text][/vc_column][/vc_row][vc_row el_class=\"punchline\"][vc_column][vc_column_text]\n<h2 style=\"text-align: center;\"><strong style=\"color: #5b11b8;\">Corporate Training Center.</strong></h2>\n<p style=\"text-align: center;\">Enable companies to manage their custom groups of students, courses and view statistics.\nCompanies can register themselves on this portal and show selected courses to their employees and track their performances.\n\n[/vc_column_text][/vc_column][/vc_row][vc_row css=\".vc_custom_1527595741302{margin-top: 30px !important;margin-bottom: 30px !important;}\"][vc_column width=\"1/4\"][vc_column_text]<img class=\"aligncenter size-small\" src=\"http://wplms.io/demos/demo9/wp-content/uploads/2018/01/work2-460x263.jpg\" width=\"460\" height=\"263\" />\n<h4 style=\"text-align: center; color: #5b11b8;\">Notification &amp; Emails</h4>\n<p style=\"text-align: center;\">Send automatic notifications, emails &amp; messages to Instructors, Students</p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text]<img class=\"aligncenter size-small\" src=\"http://wplms.io/demos/demo9/wp-content/uploads/2018/01/work1-460x263.jpg\" width=\"460\" height=\"263\" />\n<h4 style=\"text-align: center; color: #5b11b8;\"> Online &amp; Offline courses</h4>\n<p style=\"text-align: center;\">Teach students online as well as offline with units, quizzes &amp; assignments</p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text]<img class=\"aligncenter size-full wp-image-439\" src=\"http://wplms.io/demos/demo9/wp-content/uploads/2018/01/slideblock3.jpg\" alt=\"\" width=\"460\" height=\"263\" />\n<h4 style=\"text-align: center; color: #5b11b8;\">Notification &amp; Emails</h4>\n<p style=\"text-align: center;\">Send automatic notifications, emails &amp; messages to Instructors, Students</p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text]<img class=\"aligncenter size-full wp-image-438\" src=\"http://wplms.io/demos/demo9/wp-content/uploads/2018/01/slideblock2.jpg\" alt=\"\" width=\"460\" height=\"263\" />\n<h4 style=\"text-align: center; color: #5b11b8;\">Notification &amp; Emails</h4>\n<p style=\"text-align: center;\">Send automatic notifications, emails &amp; messages to Instructors, Students</p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\"][vc_column][rev_slider_vc alias=\"demo9_parallax\"][/vc_column][/vc_row][vc_row][vc_column width=\"1/3\" el_class=\"headingblock\"][vc_column_text]\n<h3 style=\"color: #5b11b8; font-size: 32px; text-align: left;\">Social eLearning experience</h3>\nIn the eyeball there is a clash between creation and reflection. The two-way globes of sight are magical revolving doors where the creative spirit meets itself in the created spirit.\n\n[button class=\"regular\"]Learn more →[/button][/vc_column_text][/vc_column][vc_column width=\"2/3\" el_class=\"vibe_carousel\"][v_carousel show_controlnav=\"1\" post_type=\"post\" featured_style=\"\" column_width=\"120\" carousel_max=\"3\" carousel_min=\"1\" carousel_move=\"1\" carousel_number=\"6\" carousel_excerpt_length=\"100\" carousel_link=\"1\"][/vc_column][/vc_row][vc_row css=\".vc_custom_1527594981773{margin-top: 60px !important;margin-bottom: 30px !important;}\"][vc_column][vc_column_text]\n<h2 style=\"text-align: center; font-size: 3rem;\">Get started with our popular courses</h2>\n<p style=\"text-align: center;\">Select courses to get started with our corporate packages.</p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][v_grid post_type=\"course\" featured_style=\"postblock\" grid_columns=\"clear4 col-md-3\" grid_number=\"8\" infinite=\"1\" grid_excerpt_length=\"100\"][/vc_column][/vc_row][vc_row][vc_column][vc_raw_html]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[/vc_raw_html][/vc_column][/vc_row]\";}s:19:\"childone_1475461475\";a:2:{s:4:\"name\";s:8:\"childone\";s:8:\"template\";s:7669:\"[vc_row full_width=\"stretch_row_content_no_spaces\" css=\".vc_custom_1527574948325{background-image: url(http://wplms.io/demos/childone/wp-content/uploads/2017/12/bg.jpg?id=2192) !important;}\" el_class=\"parallaxhome\"][vc_column][vc_column_text]\n<h2 style=\"text-align: center;\">Get Started</h2>\n<h3 style=\"text-align: center;\">With Online Education</h3>\n<p style=\"text-align: center;\"><a href=\"#\">Start now ›</a></p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/3\"][vc_column_text el_class=\"homethreesteps\"][icon icon=\"icon-light-bulb animate zoom load\"]\n<h4>Free Updates &amp; Support</h4>\nWe provide you not only with a clean and well coded theme but also with top notch support.[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text el_class=\"homethreesteps\"][icon icon=\"icon-share animate zoom load\"]\n<h4>Highly Customisable</h4>\nWPLMS comes packed with inbuilt child themes and tons of built-in options for customising it.[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text el_class=\"homethreesteps\"][icon icon=\"icon-beaker-alt animate zoom load\"]\n<h4>Easy to Use</h4>\nWPLMS intuitive interface allows it to use from Class room coaching to online classes and variety of other purposes.[/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\" css=\".vc_custom_1527579071957{background-image: url(http://wplms.io/demos/childone/wp-content/uploads/2017/12/collection.jpg?id=2193) !important;}\" el_class=\"homecounter\"][vc_column][vc_column_text][vibe_container]\n<h3 style=\"text-align: center;\">Why you\'ll love us ?</h3>\n<p style=\"text-align: center;\">[one_third first=first]</p>\n\n<h4 style=\"text-align: center;\">[number_counter max=330]</h4>\n<p style=\"text-align: center;\">Number of Courses</p>\n<p style=\"text-align: center;\">[/one_third] [one_third first=]</p>\n\n<h4 style=\"text-align: center;\">[number_counter max=16]</h4>\n<p style=\"text-align: center;\">Number of Instructors</p>\n<p style=\"text-align: center;\">[/one_third] [one_third first=]</p>\n\n<h4 style=\"text-align: center;\">[number_counter max=9290 increment=100]</h4>\n<p style=\"text-align: center;\">Number of students</p>\n<p style=\"text-align: center;\">[/one_third]</p>\n\n[/vibe_container][/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\"][vc_column][vc_column_text el_class=\"homemain\"]\n<h2 style=\"text-align: center;\">You\'ll love us</h2>\n<p style=\"text-align: center;\">Total is our most advanced, best selling and highest rated theme to date.\nEverything you would expect and more from one of the most popular WordPress related websites out there!\n[button]Why coose us ›[/button]\n<img class=\"alignnone size-full wp-image-2740 aligncenter\" src=\"http://wplms.io/demos/childone/wp-content/uploads/2017/12/wplms.jpg\" alt=\"wplms\" width=\"1098\" height=\"380\" />\n\n[/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" el_class=\"homesixsections\"][vc_column][vc_column_text el_class=\"homesixsectionss\"]\n<h2>Top selling theme</h2>\nWith over 5000 sales, it is #1 selling theme in education category for WordPress themes.\n\n[one_third first=first]\n\n[icon icon=\"icon-feather-1\"]\n<h4>Design Quality</h4>\nGreat design, lots of options and the author continues to update this awesome system and theme. It´s so worth it!!\n\n[/one_third] [one_third first=]\n\n[icon icon=\"icon-portfolio\"]\n<h4>Feature Availability</h4>\nThere is not a WordPress theme equivalent that surpasses the instant functionality and capability of WPLMS.\n\n[/one_third][one_third first=]\n\n[icon icon=\"icon-letter\"]\n<h4>Code Quality</h4>\nIf it cost 10x the price, the capable corporate training &amp; development manager would buy it ten times over. It is worth 100x more than it is sold for.\n\n[/one_third][one_third first=first]\n\n[icon icon=\"icon-users\"]\n<h4>Customer support</h4>\nThey continuously update the theme and it is easy to get answers in the support forums. Best purchase EVER!\n\n[/one_third] [one_third first=]\n\n[icon icon=\"icon-light-bulb\"]\n<h4>Flexibility</h4>\nBecause all business are differents. They understand that and they made a nice plugin that for sure suit your need. Thanks a lot!\n\n[/one_third][one_third first=]\n\n[icon icon=\"icon-newspaper\"]\n<h4>Documentation quality</h4>\nAn excellent product, full of features, with great documentation (including video tutorials) and online support. Thank you for your good work!\n\n[/one_third][/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/2\"][vc_column_text el_class=\"fullwidthwhite\"]<a href=\"http://wplms.io/demos/childone/wp-content/uploads/2014/02/students.jpg\"><img class=\"alignnone size-full wp-image-2048\" src=\"http://wplms.io/demos/childone/wp-content/uploads/2014/02/students.jpg\" alt=\"students\" width=\"400\" height=\"580\" /></a>[/vc_column_text][/vc_column][vc_column width=\"1/2\"][vc_column_text el_class=\"fullwidthwhite\" el_id=\"fullwidthwhitee\"][heading]Why choose us ?[/heading]\n<ul>\n	<li>[icon icon=\"icon-rocket animate zoom\"]<strong>Popular Courses</strong>\nAenean vulputate eleifend tellus.</li>\n	<li>[icon icon=\"icon-hat-magician animate zoom\"]<strong>Best Instructors</strong>\nAenean leo ligula, porttitor eu, consequat.</li>\n	<li>[icon icon=\"icon-steering-wheel animate zoom\"]<strong>Variety of Subjects</strong>\nPorttitor eu, consequat vitae, eleifend ac, enim.</li>\n	<li>[icon icon=\"icon-pin-alt animate zoom\"]<strong>Leaderboards &amp; Contests</strong>\nLeo ligula, porttitor eu, consequat vitae, eleifend ac, enim.</li>\n	<li>[icon icon=\"icon-medal-outline-star animate zoom\"]<strong>Badges &amp; Certificates</strong>\nAliquam lorem ante, dapibus in</li>\n</ul>\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_raw_html]JTNDc3R5bGUlM0UlMEEucGFyYWxsYXhob21lJTdCJTIwJTIwJTIwJTIwcG9zaXRpb24lM0ElMjByZWxhdGl2ZSUzQiUwQSUyMCUyMCUyMCUyMGJhY2tncm91bmQtc2l6ZSUzQSUyMGNvdmVyJTNCJTBBJTIwJTIwJTIwJTIwbWluLWhlaWdodCUzQSUyMDcyMHB4JTNCJTBBJTIwJTIwJTIwJTIwYmFja2dyb3VuZC1wb3NpdGlvbiUzQSUyMDUwJTI1JTIwLTUwcHglM0IlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNBJTIwMTE5cHglMjAwJTIwNjBweCUzQiUwQSUyMCUyMCUyMCUyMG1hcmdpbi10b3AlM0ElMjAtOTBweCUzQiUwQSUyMCUyMCUyMCUyMGJhY2tncm91bmQlM0ElMjBmaXhlZCUzQiUwQSU3RCUwQS5ob21lc2l4c2VjdGlvbnMlMjAlN0IlMEElMjAlMjAlMjAlMjBtYXJnaW4tdG9wJTNBJTIwLTM1cHglM0IlMEElMjAlMjAlMjAlMjB0ZXh0LWFsaWduJTNBJTIwY2VudGVyJTNCJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzQSUyMDYwcHglMjAwJTNCJTBBJTIwJTIwJTIwJTIwYmFja2dyb3VuZCUzQSUyMCUyM2YzZjNmMyUzQiUwQSUyMCUyMCUyMCUyMGRpc3BsYXklM0ElMjBpbmxpbmUtYmxvY2slM0IlMEElMjAlMjAlMjAlMjB3aWR0aCUzQSUyMDEwMCUyNSUzQiUwQSU3RCUwQSUwQS5ob21ldGhyZWVzdGVwcyUyMCU3QiUwQSUyMCUyMCUyMCUyMHBvc2l0aW9uJTNBJTIwcmVsYXRpdmUlM0IlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNBJTIwNjBweCUyMDBweCUyMDU1cHglMjA1NXB4JTNCJTBBJTIwJTIwJTIwJTIwZm9udC1zaXplJTNBJTIwMTNweCUzQiUwQSUyMCUyMCUyMCUyMHBhZGRpbmctdG9wJTNBJTIwLTEwcHglMjAlMjFpbXBvcnRhbnQlM0IlMEElMjAlMjAlMjAlMjBtYXJnaW4tdG9wJTNBJTIwLTI1cHglM0IlMEElN0QlMEEuaG9tZWNvdW50ZXIlMjAlN0JtYXgtaGVpZ2h0JTNBJTIwMzIwcHglM0IlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNBJTIwMHB4JTIwMCUzQiUwQSU3RCUwQSUwQS5mdWxsd2lkdGh3aGl0ZSUyMCU3QnBhZGRpbmclM0ElMjA2MHB4JTIwMCUyMDEwcHglM0IlMEElMjAlMjAlMjAlMjAlN0QlMEElMEEuZnVsbHdpZHRod2hpdGUlMjBsaSU3QnBhZGRpbmclM0ElMjAxNXB4JTIwMHB4JTNCJTBBJTIwJTIwJTIwJTIwY2xlYXIlM0ElMjBib3RoJTNCJTdEJTBBJTBBLmZ1bGx3aWR0aHdoaXRlJTIwbGklMjBpJTIwJTdCJTBBJTIwJTIwJTIwJTIwZm9udC1zaXplJTNBJTIwMzJweCUzQiUwQSUyMCUyMCUyMCUyMGZsb2F0JTNBJTIwbGVmdCUzQiUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0ElMjAwcHglMjAzMHB4JTIwMHB4JTIwMHB4JTNCJTBBJTIwJTIwJTIwJTIwY29sb3IlM0ElMjAlMjMyMjk5ZGMlM0IlMEElN0QlMEElMEElMjNmdWxsd2lkdGh3aGl0ZWUlMjAlN0JtYXJnaW4tdG9wJTNBNDBweCUzQiU3RCUwQS5mdWxsd2lkdGh3aGl0ZSUyMCU3Qm1hcmdpbi10b3AlM0EtMjBweCUzQm1hcmdpbi1ib3R0b20lM0EtMTBweCUzQiU3RCUwQSUzQyUyRnN0eWxlJTNF[/vc_raw_html][/vc_column][/vc_row]\";}s:17:\"modern_1890560547\";a:2:{s:4:\"name\";s:6:\"modern\";s:8:\"template\";s:10564:\"[vc_row full_width=\"stretch_row_content_no_spaces\"][vc_column][vc_column_text el_class=\"homesearch\" css=\".vc_custom_1527508117936{background-image: url(http://wplms.io/demos/modern/wp-content/uploads/2018/05/student_college-1024x683.jpg?id=2389) !important;}\"][one_fifth]\n\n[/one_fifth][three_fifth]\n<h1 style=\"color: #009dd8;\"><strong>Online Education.</strong></h1>\n<h1>Learn skills online.</h1>\n[course_search]\n\n[one_third]\n<h4>[number_counter][vibe_site_stats courses=1 number=1][/number_counter]</h4>\nCourses\n\n[/one_third][one_third]\n<h4>[number_counter][vibe_site_stats instructor=1 number=1][/number_counter]</h4>\nInstructors\n\n[/one_third][one_third]\n<h4>[number_counter][vibe_site_stats total=1 number=1][/number_counter]</h4>\nStudents\n\n[/one_third][/three_fifth][one_fifth]\n\n[/one_fifth][/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/3\"][vc_column_text el_class=\"homeblocks\"]\n<p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-2125\" src=\"../wp-content/uploads/2014/02/ladder-1.png\" alt=\"ladder\" width=\"150\" height=\"150\" /></p>\n<p style=\"text-align: center;\">[heading style=\"center\"]Quizzes and Assignments[/heading]</p>\n<p style=\"text-align: center;\">Integrated Quizzes with 8 question types and upload type assignments.</p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text el_class=\"homeblocks\"]\n<p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-2126\" src=\"../wp-content/uploads/2014/02/study-1.png\" alt=\"study\" width=\"150\" height=\"150\" /></p>\n<p style=\"text-align: center;\">[heading style=\"center\"]Learning Paths[/heading]</p>\n<p style=\"text-align: center;\">Define learning paths for students. Award badges on achievements.</p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text el_class=\"homeblocks\"]\n<p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-2127\" src=\"../wp-content/uploads/2014/02/book-1.png\" alt=\"book\" width=\"150\" height=\"150\" /></p>\n<p style=\"text-align: center;\">[heading style=\"center\"]Track Activity[/heading]</p>\n<p style=\"text-align: center;\">Track every activity of your students. Check their performance and graphs.</p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\"][vc_column][vc_column_text el_class=\"homemainblocks\"][v_1_4_2]\n\n[icon icon=\"icon-college-24\" size=\"44px\"]\n\n[heading style=\"white\"]Online courses[/heading]\n\nCreate unlimited courses using the easy to use front end course creation interface.\n\n[/v_1_4_2][v_1_4_2]\n\n[icon icon=\"icon-town-hall-24\" size=\"44px\"]\n\n[heading style=\"white\"]Student Management[/heading]\n\nStudent management for every course. Manage courses and students using easy to use interface.\n\n[/v_1_4_2][v_1_4_2]\n\n[icon icon=\"icon-certificate-file\" size=\"44px\"]\n\n[heading style=\"white\"]Award Certificates[/heading]\n\nAward passing certificates to students. Validate certificates using certificate codes.\n\n[/v_1_4_2][v_1_4_2]\n\n[icon icon=\"icon-sheriff-badge\" size=\"44px\"]\n\n[heading style=\"white\"]Award Badges[/heading]\n\nAward excellence badges to deserving students in course. Integrate with Mozilla open Badges.\n\n[/v_1_4_2][/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/2\"][vc_column_text el_class=\"featureblock\"]<a href=\"http://wplms.io/demos/modern/wp-content/uploads/2017/12/tutorials-460x369.png\"><img class=\"alignleft size-full wp-image-2277\" src=\"http://wplms.io/demos/modern/wp-content/uploads/2017/12/tutorials-460x369.png\" alt=\"tutorials\" width=\"300\" height=\"241\" /></a>[/vc_column_text][/vc_column][vc_column width=\"1/2\"][vc_column_text el_class=\"featureblock\"]\n<p style=\"text-align: left;\">[heading]E-Learning Portal[/heading]</p>\n<p style=\"text-align: left;\">With wplms you get a lot powerful features yo start your online business.</p>\n\n<ul>\n	<li style=\"text-align: left;\">[icon icon=\"icon-check-alt zoom animate\"] Create courses online</li>\n	<li style=\"text-align: left;\">[icon icon=\"icon-check-alt zoom animate\"] Sell courses online</li>\n	<li style=\"text-align: left;\">[icon icon=\"icon-check-alt zoom animate\"] Earn commissions online</li>\n	<li style=\"text-align: left;\">[icon icon=\"icon-check-alt zoom animate\"] Filters and search courses online</li>\n	<li style=\"text-align: left;\">[icon icon=\"icon-check-alt zoom animate\"] Drip content, Unit specific drip, Section-wise drip</li>\n	<li style=\"text-align: left;\">[icon icon=\"icon-check-alt zoom animate\"] Course start date, Course Seats</li>\n	<li style=\"text-align: left;\">[icon icon=\"icon-check-alt zoom animate\"] Unit Start date and time</li>\n</ul>\n[/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\"][vc_column][vc_column_text css=\".vc_custom_1527589970800{background-image: url(http://wplms.io/demos/modern/wp-content/uploads/2017/12/talent-1.jpg?id=2279) !important;}\" el_class=\"getstarteed\"]\n<h2 style=\"text-align: center;\"><span style=\"font-size: 48px;\">Get started with Online Education !</span></h2>\n<p style=\"text-align: center;\"><span style=\"font-size: 20px;\"><strong><span style=\"color: #999999;\">Reach more users, generate more content, earn more commissions</span> !</strong></span></p>\n<p style=\"text-align: center;\">[button]Learn More[/button] [button class=\"primary\"]Get Started[/button]</p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row el_class=\"infinite_load_courses\"][vc_column][v_grid post_type=\"course\" course_style=\"rated\" featured_style=\"course3\" masonry=\"1\" column_width=\"282\" grid_number=\"4\" infinite=\"1\" grid_excerpt_length=\"100\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\"][vc_column][vc_column_text el_class=\"footerblock\"][heading style=\"white\"]Get started with online education[/heading]\n\n[button class=\"border right\"]Get started now  [icon icon=\"icon-arrow-1-right zoom animate\"][/button]Online courses, create and sell courses, students, course stats, student stats, reports, import export and much more..[/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\"][vc_column][vc_raw_html]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[/vc_raw_html][/vc_column][/vc_row]\";}s:18:\"default_1139433910\";a:2:{s:4:\"name\";s:7:\"default\";s:8:\"template\";s:5578:\"[vc_row][vc_column][layerslider_vc id=\"5\" el_class=\"homepageslider\"][/vc_column][/vc_row][vc_row][vc_column width=\"1/4\"][vc_column_text el_class=\"custom_block\"]\n<p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-1430\" src=\"../wp-content/uploads/2017/12/4.png\" alt=\"4\" width=\"140\" height=\"140\" /></p>\n\n<h3 style=\"text-align: center;\">Online Courses</h3>\n<p style=\"text-align: center;\">course management</p>\n<p style=\"text-align: center;\">It is a long established fact that a reader will be distracted.</p>\n<p style=\"text-align: center;\"><a class=\"link\" href=\"#\">more</a></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text el_class=\"custom_block\"]\n<p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-1428\" src=\"../wp-content/uploads/2017/12/1.png\" alt=\"1\" width=\"140\" height=\"140\" /></p>\n\n<h3 style=\"text-align: center;\">Become an Instructor</h3>\n<p style=\"text-align: center;\">teach online</p>\n<p style=\"text-align: center;\">It is a long established fact that a reader will be distracted</p>\n<p style=\"text-align: center;\"><a class=\"link\" href=\"#\">more</a></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text el_class=\"custom_block\"]\n<p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-1431\" src=\"../wp-content/uploads/2017/12/3.png\" alt=\"3\" width=\"140\" height=\"140\" /></p>\n\n<h3 style=\"text-align: center;\">Multi-Media Units</h3>\n<p style=\"text-align: center;\">Audio, Video playback</p>\n<p style=\"text-align: center;\">It is a long established fact that a reader will be distracted</p>\n<p style=\"text-align: center;\"><a class=\"link\" href=\"#\">more</a></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text el_class=\"custom_block\"]\n<p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-1429\" src=\"../wp-content/uploads/2017/12/2.png\" alt=\"2\" width=\"140\" height=\"140\" /></p>\n\n<h3 style=\"text-align: center;\">subscribe courses</h3>\n<p style=\"text-align: center;\">Sell Courses</p>\n<p style=\"text-align: center;\">It is a long established fact that a reader will be distracted</p>\n<p style=\"text-align: center;\"><a class=\"link\" href=\"#\">more</a></p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/4\"][vc_column_text el_class=\"custom_banner\"]<a href=\"../course-cat/language/\"><img src=\"../wp-content/uploads/2017/12/banner3-2.jpg\" alt=\"banner3\" width=\"300\" height=\"100\" /></a>[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text el_class=\"custom_banner\"]<a href=\"../course-cat/business/\"><img src=\"../wp-content/uploads/2017/12/banner1-1.jpg\" alt=\"banner1\" width=\"300\" height=\"100\" /></a>[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text el_class=\"custom_banner\"]<a href=\"../course-cat/technology/\"><img src=\"../wp-content/uploads/2017/12/banner4-1.jpg\" alt=\"banner4\" width=\"300\" height=\"100\" /></a>[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text el_class=\"custom_banner\"]<a href=\"../wplms/course-cat/photography-2/\"><img src=\"../wp-content/uploads/2017/12/banner2-1.jpg\" alt=\"banner2\" width=\"300\" height=\"100\" /></a>[/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" el_class=\"fullhomestripe\"][vc_column][v_carousel show_title=\"1\" title=\"Popular Courses\" show_more=\"1\" more_link=\"http://wplms.io/demos/default/all-courses/\" show_controls=\"1\" post_type=\"course\" featured_style=\"course2\" column_width=\"262\" carousel_min=\"2\" carousel_move=\"1\" carousel_number=\"6\" carousel_excerpt_length=\"100\"][/vc_column][/vc_row][vc_row][vc_column width=\"1/2\"][v_carousel show_title=\"1\" title=\"Recent Posts\" show_more=\"1\" more_link=\"http://vibethemes.com/envato/wplms/blog/\" show_controls=\"1\" show_controlnav=\"1\" post_type=\"post\" featured_style=\"side\" auto_slide=\"1\" column_width=\"600\" carousel_max=\"1\" carousel_min=\"1\" carousel_move=\"1\" carousel_number=\"4\" carousel_excerpt_length=\"100\" carousel_link=\"1\"][/vc_column][vc_column width=\"1/4\"][vc_column_text][heading]Apply for Instructor[/heading]\n\n[form to=\"example@example.com\" subject=\"Subject\"] [form_element type=\"text\" validate=\"\" options=\"\" placeholder=\"Name\"] [form_element type=\"text\" validate=\"email\" options=\"\" placeholder=\"Email\"] [form_element type=\"text\" validate=\"numeric\" options=\"\" placeholder=\"Phone\"] [form_element type=\"submit\" validate=\"\" options=\"\" placeholder=\"Apply\"] [/form][/vc_column_text][/vc_column][vc_column width=\"1/4\"][v_carousel show_title=\"1\" title=\"Testimonials\" show_controls=\"1\" post_type=\"testimonials\" featured_style=\"testimonial\" auto_slide=\"1\" carousel_max=\"1\" carousel_min=\"1\" carousel_move=\"1\" carousel_number=\"3\" carousel_excerpt_length=\"100\" carousel_link=\"1\"][/vc_column][/vc_row][vc_row][vc_column][vc_raw_html]JTNDc3R5bGUlM0UlMEEuaG9tZXBhZ2VzbGlkZXIlN0JtYXJnaW4tdG9wJTNBMCUzQiU3RCUwQS5jdXN0b21fYmxvY2slMjBpbWclN0IlMEFtYXgtd2lkdGglM0E4MHB4JTNCJTBBcGFkZGluZyUzQTMwcHglMjAwJTNCJTBBJTdEJTBBLmN1c3RvbV9ibG9jayUyMGgzJTdCZm9udC13ZWlnaHQlM0ElMjA2MDAlM0IlMEF0ZXh0LXRyYW5zZm9ybSUzQSUyMHVwcGVyY2FzZSUzQiUwQWZvbnQtc2l6ZSUzQSUyMDE3cHglM0JtYXJnaW4tYm90dG9tJTNBMCUzQiU3RCUwQS5jdXN0b21fYmxvY2slMjBoMyUyQnAlN0Jjb2xvciUzQSUyM2JiYiUzQm1hcmdpbi10b3AlM0EwJTNCZm9udC1zaXplJTNBMTFweCUzQmZvbnQtd2VpZ2h0JTNBNjAwJTNCdGV4dC10cmFuc2Zvcm0lM0F1cHBlcmNhc2UlM0IlN0QlMEEuY3VzdG9tX2Jhbm5lciUyMGltZyU3QiUwQWJvcmRlciUzQTVweCUyMHNvbGlkJTIwJTIzRkZGJTNCJTBBYm94LXNoYWRvdyUzQTAlMjAxcHglMjAycHglMjAlMjNiYmIlM0IlMEFib3JkZXItcmFkaXVzJTNBMnB4JTNCJTBBJTdEJTBBLmZ1bGxob21lc3RyaXBlJTdCJTBBcGFkZGluZyUzQTMwcHglMjAwJTNCJTBBYmFja2dyb3VuZCUzQSUyM0ZGRiUzQiUwQSU3RCUwQSUwQSUzQyUyRnN0eWxlJTNF[/vc_raw_html][/vc_column][/vc_row]\";}s:20:\"onecourse_1534448751\";a:2:{s:4:\"name\";s:9:\"onecourse\";s:8:\"template\";s:19775:\"[vc_row full_width=\"stretch_row\" parallax=\"content-moving\" parallax_image=\"313\" el_class=\"homescreen\"][vc_column][vc_row_inner][vc_column_inner][vc_column_text el_class=\"one_half \"]<em>Get started with </em>\n<h1>Online Education.</h1>\n<h2><em>This is a one course demo, in this demo the user is selling a ebook with a online course.</em></h2>\n<p style=\"text-align: left;\">Join our prestigious course with over 200 students from all around the world. Compete with top students, best brains in this course area, get connected with students and professors in this course.</p>\n\n<h4 style=\"text-align: center;\"><span style=\"color: #ffffff;\">Buy full course for $19</span></h4>\n<p style=\"text-align: center;\">[button url=\"http://wplms.io/demos/onecourse/course/one-course/\" class=\"button hero full\"]Join us now ›[/button]</p>\n<p style=\"text-align: right;\">[wplms_login]</p>\n\n[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\"][vc_column][vc_column_text]\n<h2 class=\"av-special-heading-tag\" style=\"text-align: center;\">TAUGHT BY HIGHLY <strong>EXPERIENCED INSTRUCTORS</strong></h2>\n<h2 class=\"av-special-heading-tag\" style=\"text-align: center;\">&amp; LOVED BY <strong>THOUSANDS OF STUDENTS.</strong></h2>\n[/vc_column_text][/vc_column][/vc_row][vc_row el_class=\"homeinstructors\"][vc_column width=\"1/3\"][vc_column_text]\n<p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-43\" src=\"http://wplms.io/demos/onecourse/wp-content/uploads/2015/04/jobs.jpg\" alt=\"jobs\" width=\"460\" height=\"460\" /></p>\n<p style=\"text-align: center;\">[heading style=\"center\"]Lupin Remus[/heading]<em>Michigan University</em></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]\n<p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-43\" src=\"http://wplms.io/demos/onecourse/wp-content/uploads/2015/04/col.jpg\" alt=\"jobs\" width=\"460\" height=\"460\" /></p>\n<p style=\"text-align: center;\">[heading style=\"center\"]Lupin Remus[/heading]<em>Michigan University</em></p>\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]\n<p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-43\" src=\"http://wplms.io/demos/onecourse/wp-content/uploads/2015/04/steve.jpg\" alt=\"jobs\" width=\"460\" height=\"460\" /></p>\n<p style=\"text-align: center;\">[heading style=\"center\"]Lupin Remus[/heading]<em>Michigan University</em></p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row css=\".vc_custom_1526555986928{margin-top: 80px !important;}\"][vc_column width=\"1/2\"][vc_column_text][iframevideo] <iframe src=\"https://player.vimeo.com/video/100656498?color=ffffff&amp;title=0&amp;byline=0&amp;portrait=0\" width=\"500\" height=\"264\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe> [/iframevideo][/vc_column_text][/vc_column][vc_column width=\"1/2\"][vc_row_inner][vc_column_inner][vc_column_text]\n<h1>Why You should take this Course?</h1>\nThat’s why we created the <strong>This Course</strong> course. We’ve seen people talk about courses but never take any course. And that’s where we want to help you. We want you to join us on the course taken side.\n\n<strong>As mentioned by</strong>\n[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width=\"1/4\"][vc_column_text]<a href=\"http://wplms.io/demos/onecourse/wp-content/uploads/2015/04/logo1.png\"><img class=\"alignnone size-full wp-image-56\" src=\"http://wplms.io/demos/onecourse/wp-content/uploads/2015/04/logo1.png\" alt=\"logo5\" width=\"298\" height=\"207\" /></a>[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/4\"][vc_column_text]<a href=\"http://wplms.io/demos/onecourse/wp-content/uploads/2015/04/logo1.png\"><img class=\"alignnone size-full wp-image-56\" src=\"http://wplms.io/demos/onecourse/wp-content/uploads/2015/04/logo1.png\" alt=\"logo5\" width=\"298\" height=\"207\" /></a>[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/4\"][vc_column_text]<a href=\"http://wplms.io/demos/onecourse/wp-content/uploads/2015/04/logo1.png\"><img class=\"alignnone size-full wp-image-56\" src=\"http://wplms.io/demos/onecourse/wp-content/uploads/2015/04/logo1.png\" alt=\"logo5\" width=\"298\" height=\"207\" /></a>[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/4\"][vc_column_text]<a href=\"http://wplms.io/demos/onecourse/wp-content/uploads/2015/04/logo1.png\"><img class=\"alignnone size-full wp-image-56\" src=\"http://wplms.io/demos/onecourse/wp-content/uploads/2015/04/logo1.png\" alt=\"logo5\" width=\"298\" height=\"207\" /></a>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]\n<p style=\"text-align: center;\">[heading style=\"center\"]Course <span style=\"color: #ff6600;\">Key Features</span>[/heading]</p>\n<p style=\"text-align: center;\"><em>This course covers all the aspect of this subject. From basic fundamental training to expert level tutorials!</em>\n<em> The curriculum has been designed by <strong>experienced faculty</strong> and feedback from students.</em>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row el_class=\"keyfeatures\"][vc_column width=\"1/2\" el_class=\"one_half\"][vc_column_text]\n<ul style=\"text-align: left;\">\n	<li style=\"text-align: right;\">[icon icon=\"icon-anchor zoom animate\"] <strong>Strong Fundamentals</strong>  Focussed on fundamentals to set a strong foundation of the course.</li>\n	<li style=\"text-align: right;\">[icon icon=\"icon-elusive-icons-2 zoom animate\"]<strong> Video Training</strong>  Course is taught via videos and screencasts</li>\n	<li style=\"text-align: right;\">[icon icon=\"icon-scooter zoom animate\"] <strong>Planned Curriculum</strong> Built by experienced faculty, it is a time bound course</li>\n	<li style=\"text-align: right;\">[icon icon=\"icon-check zoom animate\"] <strong>Task Oriented</strong> Focus on overall learning experience, this course is task based.</li>\n	<li style=\"text-align: right;\">[icon icon=\"icon-pin-alt zoom animate\"]<strong>Event based</strong> Various events are organised in the course for an overall learning experience.</li>\n	<li style=\"text-align: right;\">[icon icon=\"icon-light-bulb zoom animate\"]<strong>Learning  Exposure</strong> This is not just a course but an overall learning experience.</li>\n	<li style=\"text-align: right;\">[icon icon=\"icon-alarm zoom animate\"]<strong>Test Exercises</strong>  Advanced level exercises are built in the course.</li>\n</ul>\n[/vc_column_text][/vc_column][vc_column width=\"1/2\" el_class=\"one_half\"][vc_column_text]\n<ul style=\"text-align: left;\">\n	<li>[icon icon=\"icon-umbrella zoom animate\"] <strong>Overall Learning </strong> This is not just a course but an overall learning experience.</li>\n	<li>[icon icon=\"icon-star zoom animate\"]<strong> Advanced Exercises</strong>  Advanced level exercises are built in the course.</li>\n	<li>[icon icon=\"icon-bubbles-talk-1 zoom animate\"] <strong>One to One interaction</strong> Student Instructor one to one interaction in the course.</li>\n	<li>[icon icon=\"icon-beaker-alt zoom animate\"] <strong>Live Experiments</strong> Students are exposed to live experimentation and learning from practicals.</li>\n	<li>[icon icon=\"icon-microscope zoom animate\"] <strong>Focus on Details</strong> Course specialises in focussing on minute details in the subject.</li>\n	<li>[icon icon=\"icon-share zoom animate\"]<strong>Experiential Learning</strong> Focus on overall learning experience, this course is task based.</li>\n	<li>[icon icon=\"icon-users zoom animate\"]<strong>Student Focussed</strong> Built by experienced faculty, it is a time bound course</li>\n</ul>\n[/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" css=\".vc_custom_1526560302879{background-color: #ff6600 !important;}\" el_class=\"homecounter\"][vc_column parallax=\"content-moving\" parallax_image=\"498\"][vc_column_text]\n<h3 style=\"text-align: center;\">Why you\'ll love us ?</h3>\n[/vc_column_text][vc_row_inner][vc_column_inner width=\"1/3\"][vc_column_text]\n<h4 style=\"text-align: center;\">[number_counter increment=10][vibe_site_stats number=1 total=1][/number_counter]</h4>\n<p style=\"text-align: center;\">Number of Sales</p>\n\n[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_column_text]\n<h4 style=\"text-align: center;\">[number_counter][vibe_site_stats number=1 courses=1][/number_counter]</h4>\n<p style=\"text-align: center;\">5 star ratings</p>\n\n[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_column_text]\n<h4 style=\"text-align: center;\">[number_counter][vibe_site_stats number=1 instructor=1][/number_counter]</h4>\n<p style=\"text-align: center;\">Free updates &amp; Support</p>\n\n[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]\n<p style=\"text-align: center;\">[heading style=\"center\"]Learning <span style=\"color: #ff6600;\">Objectives</span>[/heading]</p>\n<p style=\"text-align: center;\"><em>This course covers all the aspect of this subject. From basic fundamental training to expert level tutorials!</em></p>\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/3\"][vc_column_text]\n\n[icon icon=\"icon-beaker-alt animate zoom\"]\n<h4>Easy to Use</h4>\nWPLMS intuitive interface allows it to use from Class room coaching to online classes and variety of other purposes.\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]\n\n[icon icon=\"icon-share animate zoom\"]\n<h4>Highly Customisable</h4>\nWPLMS comes packed with inbuilt child themes and tons of built-in options for customising it.\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]\n\n[icon icon=\"icon-light-bulb animate zoom\"]\n<h4>Free Updates &amp; Support</h4>\nWe provide you not only with a clean and well coded theme but also with top notch support.\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/3\"][vc_column_text]\n\n[icon icon=\"icon-paw animate zoom\"]\n<h4>One click setup</h4>\nWPLMS can be setup with one click. Just upload the theme and click on the \"setup\" button, the theme would be exactly setup as the demo.\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]\n\n[icon icon=\"icon-phone-2 animate zoom\"]\n<h4>Mobile ready</h4>\nBuilt on popular Bootstrap 3 template, WPLMS is flexible and mobile optimised, it looks great equally on desktops, tablets and mobiles.\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]\n\n[icon icon=\"icon-elusive-icons-2 animate zoom\"]\n<h4>Front end course creator</h4>\nWPLMS comes with a Front end course creator, using which users with almost no experience with WordPress can use WPLMS and create courses.\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/3\"][vc_column_text]\n\n[icon icon=\"icon-elusive-icons-2 animate zoom\"]\n<h4>User Dashboards</h4>\nCustomisable Student and Instructor dashboards are available for users to track their courses and notifications at only one place.\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]\n\n[icon icon=\"icon-grid animate zoom\"]\n<h4>Course Filters</h4>\nCourse directory can be filtered out by using the inbuilt course filter widget. The widget includes course categories, instructors and levels.\n\n[/vc_column_text][/vc_column][vc_column width=\"1/3\"][vc_column_text]\n\n[icon icon=\"icon-moon animate zoom\"]\n<h4>Course Timeline</h4>\nBeautiful Course timeline is shown to the users when they\'re pursuing any course. Course timeline shows the users the units/quizzes which are completed in the course along with the progressbar.\n\n[/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" parallax=\"content-moving\" parallax_image=\"502\" css=\".vc_custom_1526567816101{background-image: url(http://wplms.io/demos/onecourse/wp-content/uploads/2015/04/people.jpg?id=47) !important;}\"][vc_column el_class=\"homebottomparallax\"][vc_column_text]\n<h1><span style=\"color: #ffffff;\">Join the elite group of students !</span></h1>\n<span style=\"color: #ffffff;\">Vestibulum tempus, justo at tincidunt tempor, purus sem aliquam dui, nec dictum eros mauris ut nisl.</span>\n\n<span style=\"color: #ffffff;\">[button url=\"http://vibethemes.com/envato/wplms/skins/onecourse/course/one-course/\"]Join us now ›[/button]</span>[/vc_column_text][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" el_class=\"hometestomonials\"][vc_column][vc_column_text][v_carousel first_class=\"1\" title=\"Testimonials\" show_title=\"0\" show_more=\"0\" more_link=\"\" show_controls=\"1\" show_controlnav=\"0\" post_type=\"testimonials\" taxonomy=\"\" term=\"\" post_ids=\"\" course_style=\"recent\" featured_style=\"testimonial\" auto_slide=\"0\" column_width=\"268\" carousel_max=\"1\" carousel_min=\"1\" carousel_move=\"1\" carousel_number=\"6\" carousel_excerpt_length=\"320\" carousel_link=\"0\" css_class=\"\" container_css=\"hometestomonials\" custom_css=\"\"][/v_carousel][/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_raw_html]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[/vc_raw_html][/vc_column][/vc_row]\";}s:21:\"pointsystem_259108125\";a:2:{s:4:\"name\";s:11:\"pointsystem\";s:8:\"template\";s:7701:\"[vc_row full_width=\"stretch_row\" parallax=\"content-moving\" parallax_image=\"2068\" el_class=\"homesearch \"][vc_column el_class=\"parallax_content\"][vc_column_text][one_fifth]\n\n[/one_fifth][three_fifth]\n<h1 style=\"text-align: center;\">YOUR FAVORITE PLACE TO LEARN ONLINE</h1>\n<h3 style=\"text-align: center;\">LEARN FROM OVER 1000+ COURSES</h3>\n<input name=\"s\" type=\"text\" placeholder=\"What do you want to learn today ?\" />\n<input name=\"post_type\" type=\"hidden\" value=\"course\" />\n\n[/three_fifth][one_fifth]\n\n[/one_fifth][/vc_column_text][/vc_column][/vc_row][vc_row el_class=\"intropoints\"][vc_column][vc_column_text]\n<h4 style=\"text-align: center;\">WPLMS LEARNING MANAGEMENT SYSTEM</h4>\n<h5 style=\"text-align: center;\"><span style=\"color: #808080;\">THE MOST ADVANCED LMS</span></h5>\n[/vc_column_text][/vc_column][/vc_row][vc_row el_class=\"threehomeblocks\" css=\".vc_custom_1527577717302{margin-top: 30px !important;margin-bottom: 60px !important;}\"][vc_column][vc_row_inner][vc_column_inner width=\"1/3\"][vc_column_text]<img class=\"alignnone size-full wp-image-2079 aligncenter animate zoom\" src=\"http://vibethemes.com/envato/wplms/skins/points_system/wp-content/uploads/2014/02/i5.png\" alt=\"i5\" width=\"125\" height=\"129\" />\n<h4 class=\"animate ltr\" style=\"text-align: center;\">MyCred Points System</h4>\n<p style=\"text-align: center;\">WPLMS can be setup with MyCred points system.</p>\n<p style=\"text-align: center;\"><a class=\"link animate rtl\" href=\"#\">more</a></p>\n\n[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_column_text]\n\n<img class=\"alignnone size-full wp-image-2081 aligncenter animate zoom\" src=\"http://vibethemes.com/envato/wplms/skins/points_system/wp-content/uploads/2014/02/I7.png\" alt=\"I7\" width=\"136\" height=\"125\" />\n<h4 class=\"animate ltr\" style=\"text-align: center;\">Buy Course with Points</h4>\n<p style=\"text-align: center;\">Enable users to purchase courses via points</p>\n<p style=\"text-align: center;\"><a class=\"link animate rtl\" href=\"#\">more</a></p>\n\n[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_column_text]\n\n<img class=\"alignnone size-full wp-image-2082 aligncenter animate zoom\" src=\"http://vibethemes.com/envato/wplms/skins/points_system/wp-content/uploads/2014/02/i8.png\" alt=\"i8\" width=\"164\" height=\"130\" />\n<h4 class=\"animate ltr\" style=\"text-align: center;\">Instructor Commissions</h4>\n<p style=\"text-align: center;\">Instructors earn commissions in points for every purchase of course</p>\n<p style=\"text-align: center;\"><a class=\"link animate rtl\" href=\"#\">more</a></p>\n\n[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width=\"1/3\"][vc_column_text]\n\n<img class=\"alignnone size-full wp-image-2077 aligncenter animate zoom\" src=\"http://vibethemes.com/envato/wplms/skins/points_system/wp-content/uploads/2014/02/i3.png\" alt=\"i3\" width=\"127\" height=\"154\" />\n<h4 class=\"animate ltr\" style=\"text-align: center;\">Referral System</h4>\n<p style=\"text-align: center;\">Award points to users for referring new users.</p>\n<p style=\"text-align: center;\"><a class=\"link animate rtl\" href=\"#\">more</a></p>\n\n[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_column_text]\n\n<img class=\" size-full wp-image-2078 aligncenter animate zoom\" src=\"http://vibethemes.com/envato/wplms/skins/points_system/wp-content/uploads/2014/02/i4.png\" alt=\"i4\" width=\"122\" height=\"168\" />\n<h4 class=\"animate ltr\" style=\"text-align: center;\">MyCred Addons</h4>\n<p style=\"text-align: center;\">Exposure to several MyCred addons like Banking, Coupons etc.</p>\n<p style=\"text-align: center;\"><a class=\"link animate rtl\" href=\"#\">more</a></p>\n\n[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_column_text]\n<p style=\"text-align: center;\"><img class=\"aligncenter animate zoom\" src=\"http://vibethemes.com/envato/wplms/skins/points_system/wp-content/uploads/2014/02/i10.png\" alt=\"i10\" width=\"142\" height=\"141\" /></p>\n\n<h4 class=\"animate ltr\" style=\"text-align: center;\">Custom rules</h4>\n<p style=\"text-align: center;\">Create unlimited custom rules for awarding points</p>\n<p style=\"text-align: center;\"><a class=\"link animate rtl\" href=\"#\">more</a></p>\n\n[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" parallax=\"content-moving\" parallax_image=\"2219\" el_id=\"parallax558\" el_class=\"homecounter\"][vc_column el_class=\"homecounter\"][vc_column_text]\n\n[vibe_container]\n<h3 style=\"text-align: center;\">Why you\'ll love us ?</h3>\n<p style=\"text-align: center;\">[one_third first=first]</p>\n\n<h4 style=\"text-align: center;\">[number_counter increment=10][vibe_site_stats number=1 total=1][/number_counter]</h4>\n<p style=\"text-align: center;\">Total Members</p>\n<p style=\"text-align: center;\">[/one_third] [one_third first=]</p>\n\n<h4 style=\"text-align: center;\">[number_counter][vibe_site_stats number=1 courses=1][/number_counter]</h4>\n<p style=\"text-align: center;\">Total Courses</p>\n<p style=\"text-align: center;\">[/one_third] [one_third first=]</p>\n\n<h4 style=\"text-align: center;\">[number_counter][vibe_site_stats number=1 instructor=1][/number_counter]</h4>\n<p style=\"text-align: center;\">Total Instructors</p>\n<p style=\"text-align: center;\">[/one_third]</p>\n\n[/vibe_container]\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][v_grid post_type=\"course\" featured_style=\"course3\" grid_columns=\"clear4 col-md-3\" grid_number=\"8\" grid_excerpt_length=\"100\" grid_link=\"1\"][/vc_column][/vc_row][vc_row][vc_column width=\"1/4\"][/vc_column][vc_column width=\"1/2\"][vc_column_text][button url=\"<a href=\"http://wplms.io/demos/points_system/all-courses/\">http://wplms.io/demos/points_system/all-courses/</a>\" class=\"animate btt full\"] View all Courses [/button][/vc_column_text][/vc_column][vc_column width=\"1/4\"][/vc_column][/vc_row][vc_row][vc_column][vc_raw_html]JTNDc3R5bGUlM0UlMEEuaG9tZXNlYXJjaCUyMC50aHJlZV9maWZ0aCUyMC5jb2x1bW5fY29udGVudCUyMCU3QiUwQSUyMCUyMCUyMCUyMGJhY2tncm91bmQlM0ElMjByZ2JhJTI4MCUyQzAlMkMwJTJDMC41JTI5JTNCJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzQSUyMDMwcHglMjAzMHB4JTIwNjBweCUzQiUwQSU3RCUwQS5ob21lc2VhcmNoJTIwLnBhcmFsbGF4X2NvbnRlbnQlMjAlN0IlMEElMjAlMjAlMjAlMjBtYXJnaW4tdG9wJTNBJTIwMzBweCUzQiUwQSUyMCUyMCUyMCUyMG1hcmdpbi1sZWZ0JTNBJTIwMTAwcHglM0IlMEElMjAlMjAlMjAlMjBtYXJnaW4tYm90dG9tJTNBJTIwMTAwcHglM0IlMEElMjAlMjAlMjAlMjB3aWR0aCUzQSUyMDEzOSUyNSUzQiUwQSU3RCUwQS5ob21lY291bnRlciUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhZGRpbmctdG9wJTNBMHB4JTNCJTBBJTIwJTIwJTIwJTIwcGFkZGluZy1ib3R0b20lM0ElMjAzMHB4JTNCJTBBJTIwJTIwJTIwJTIwdGV4dC1hbGlnbiUzQSUyMGNlbnRlciUzQiUwQSUyMCUyMCUyMCUyMGNvbG9yJTNBJTIwJTIzRkZGJTNCJTBBJTdEJTBBLmludHJvcG9pbnRzJTIwaDQlMjAlN0IlMEElMjAlMjAlMjAlMjBmb250LXNpemUlM0ElMjAyNXB4JTNCJTBBJTIwJTIwJTIwJTIwZm9udC13ZWlnaHQlM0ElMjA2MDAlM0IlMEElMjAlMjAlMjAlMjBtYXJnaW4tdG9wJTNBJTIwNTBweCUzQiUwQSU3RCUwQSUyM3BhcmFsbGF4NTU4JTIwJTdCJTBBJTIwJTIwJTIwJTIwYmFja2dyb3VuZCUzQSUyMHVybCUyOGh0dHAlM0ElMkYlMkZ3cGxtcy5pbyUyRmRlbW9zJTJGcG9pbnRzX3N5c3RlbSUyRndwLWNvbnRlbnQlMkZ1cGxvYWRzJTJGMjAxNyUyRjEyJTJGYmx1cnJlZF9saW5lcy0xMDI0eDY4My5qcGVnJTI5JTIwNTAlMjUlMjAtNTBweCUzQiUwQSUyMCUyMCUyMCUyMHBvc2l0aW9uJTNBJTIwcmVsYXRpdmUlM0IlMEElMjAlMjAlMjAlMjBiYWNrZ3JvdW5kLXNpemUlM0ElMjBjb3ZlciUzQiUwQSUyMCUyMCUyMCUyMG1pbi1oZWlnaHQlM0ElMjAyMjBweCUzQiUwQSU3RCUwQS5ob21lY291bnRlciUyMC52Y19wYXJhbGxheC1pbm5lciU3QiUwQSUyMCUyMCUyMCUyMGJhY2tncm91bmQlM0F1cmwlMjglMjdodHRwJTNBJTJGJTJGdmliZXRoZW1lcy5jb20lMkZlbnZhdG8lMkZ3cGxtcyUyRnNraW5zJTJGcG9pbnRzX3N5c3RlbSUyRndwLWNvbnRlbnQlMkZ1cGxvYWRzJTJGMjAxNCUyRjAyJTJGb3ZlcmxheS1wYXR0ZXJuLnBuZyUyNyUyOSUyMHJlcGVhdCUyMCUyMWltcG9ydGFudCUzQiUwQSU3RCUwQS50aHJlZWhvbWVibG9ja3MlMjAud3BiX3dyYXBwZXIlMjBpbWclN0IlMEElMjAlMjAlMjAlMjBtYXgtd2lkdGglM0ElMjA2NHB4JTNCJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNBJTIwNjRweCUzQiUwQSU3RCUyMCUwQSUzQyUyRnN0eWxlJTNF[/vc_raw_html][/vc_column][/vc_row]\";}}", "yes");
INSERT INTO `wp_options` VALUES("30613", "show_comments_cookies_opt_in", "0", "yes");
INSERT INTO `wp_options` VALUES("30646", "woocommerce_placeholder_image", "3301", "yes");
INSERT INTO `wp_options` VALUES("30657", "persian_woocommerce_dismissed_notices", "a:3:{i:0;b:0;i:1;s:13:\"novin-booster\";i:2;s:14:\"checkout-tools\";}", "yes");
INSERT INTO `wp_options` VALUES("36878", "_transient_product-transient-version", "1563142644", "yes");
INSERT INTO `wp_options` VALUES("46529", "widget_bp_course_certificates_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("46548", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("46551", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("46552", "woocommerce_allow_tracking", "no", "no");
INSERT INTO `wp_options` VALUES("46553", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `wp_options` VALUES("46569", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("46570", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("46571", "_transient_timeout_wc_product_loop_921e803c5f00cbfacc14ff7781fc5713", "1575128270", "no");
INSERT INTO `wp_options` VALUES("46572", "_transient_wc_product_loop_921e803c5f00cbfacc14ff7781fc5713", "a:2:{s:7:\"version\";s:10:\"1572535792\";s:5:\"value\";O:8:\"stdClass\":5:{s:3:\"ids\";a:10:{i:0;i:1321;i:1;i:1320;i:2;i:1310;i:3;i:1308;i:4;i:1306;i:5;i:1304;i:6;i:1303;i:7;i:1302;i:8;i:1301;i:9;i:1298;}s:5:\"total\";i:10;s:11:\"total_pages\";i:1;s:8:\"per_page\";i:10;s:12:\"current_page\";i:1;}}", "no");
INSERT INTO `wp_options` VALUES("55213", "course-cat_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("55215", "quiz-type_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("55236", "event_type_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("55252", "layerslider-gdpr-consent", "1", "yes");
INSERT INTO `wp_options` VALUES("55253", "layerslider-google-fonts-enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("62332", "_transient_timeout_wc_term_counts", "1573659031", "no");
INSERT INTO `wp_options` VALUES("62333", "_transient_wc_term_counts", "a:12:{i:58;s:1:\"8\";i:72;s:0:\"\";i:71;s:0:\"\";i:56;s:1:\"3\";i:46;s:1:\"1\";i:29;s:1:\"1\";i:69;s:0:\"\";i:68;s:0:\"\";i:70;s:0:\"\";i:53;s:0:\"\";i:57;s:0:\"\";i:170;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("63200", "_transient_timeout_external_ip_address_5.233.82.170", "1572535358", "no");
INSERT INTO `wp_options` VALUES("63201", "_transient_external_ip_address_5.233.82.170", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63206", "_transient_timeout_external_ip_address_83.120.34.47", "1572541492", "no");
INSERT INTO `wp_options` VALUES("63207", "_transient_external_ip_address_83.120.34.47", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63211", "_transient_timeout_external_ip_address_198.71.241.2", "1572561003", "no");
INSERT INTO `wp_options` VALUES("63212", "_transient_external_ip_address_198.71.241.2", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63219", "_transient_timeout_external_ip_address_91.147.77.240", "1572580173", "no");
INSERT INTO `wp_options` VALUES("63220", "_transient_external_ip_address_91.147.77.240", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63222", "_transient_timeout_external_ip_address_188.211.105.164", "1572601093", "no");
INSERT INTO `wp_options` VALUES("63223", "_transient_external_ip_address_188.211.105.164", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63227", "_transient_timeout_external_ip_address_198.147.27.52", "1572607275", "no");
INSERT INTO `wp_options` VALUES("63228", "_transient_external_ip_address_198.147.27.52", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63234", "_transient_timeout_external_ip_address_46.245.78.64", "1572609775", "no");
INSERT INTO `wp_options` VALUES("63235", "_transient_external_ip_address_46.245.78.64", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63238", "_transient_timeout_external_ip_address_5.121.219.145", "1572615478", "no");
INSERT INTO `wp_options` VALUES("63239", "_transient_external_ip_address_5.121.219.145", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63249", "_transient_timeout_external_ip_address_86.57.33.67", "1572623085", "no");
INSERT INTO `wp_options` VALUES("63250", "_transient_external_ip_address_86.57.33.67", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63254", "_transient_timeout_external_ip_address_95.82.35.140", "1572623494", "no");
INSERT INTO `wp_options` VALUES("63255", "_transient_external_ip_address_95.82.35.140", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63277", "_transient_timeout_external_ip_address_40.77.191.33", "1572658651", "no");
INSERT INTO `wp_options` VALUES("63278", "_transient_external_ip_address_40.77.191.33", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63281", "_transient_timeout_external_ip_address_3.95.37.22", "1572660765", "no");
INSERT INTO `wp_options` VALUES("63282", "_transient_external_ip_address_3.95.37.22", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63287", "_transient_timeout_external_ip_address_203.133.170.221", "1572665770", "no");
INSERT INTO `wp_options` VALUES("63288", "_transient_external_ip_address_203.133.170.221", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63298", "_transient_timeout_external_ip_address_78.39.199.8", "1572685177", "no");
INSERT INTO `wp_options` VALUES("63299", "_transient_external_ip_address_78.39.199.8", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63303", "_transient_timeout_external_ip_address_185.11.88.197", "1572686370", "no");
INSERT INTO `wp_options` VALUES("63304", "_transient_external_ip_address_185.11.88.197", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63307", "_transient_timeout_external_ip_address_5.52.242.207", "1572687795", "no");
INSERT INTO `wp_options` VALUES("63308", "_transient_external_ip_address_5.52.242.207", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63310", "_transient_timeout_external_ip_address_93.119.216.97", "1572689510", "no");
INSERT INTO `wp_options` VALUES("63311", "_transient_external_ip_address_93.119.216.97", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63315", "_transient_timeout_external_ip_address_40.77.189.17", "1572690724", "no");
INSERT INTO `wp_options` VALUES("63316", "_transient_external_ip_address_40.77.189.17", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63322", "_transient_timeout_external_ip_address_188.212.247.61", "1572693221", "no");
INSERT INTO `wp_options` VALUES("63323", "_transient_external_ip_address_188.212.247.61", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63334", "_transient_timeout_external_ip_address_91.106.199.104", "1572707716", "no");
INSERT INTO `wp_options` VALUES("63335", "_transient_external_ip_address_91.106.199.104", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63337", "_transient_timeout_external_ip_address_5.200.229.159", "1572714038", "no");
INSERT INTO `wp_options` VALUES("63338", "_transient_external_ip_address_5.200.229.159", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63342", "_transient_timeout_external_ip_address_212.103.50.163", "1572714591", "no");
INSERT INTO `wp_options` VALUES("63343", "_transient_external_ip_address_212.103.50.163", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63349", "_transient_timeout_external_ip_address_50.62.177.187", "1572723201", "no");
INSERT INTO `wp_options` VALUES("63350", "_transient_external_ip_address_50.62.177.187", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63352", "_transient_timeout_external_ip_address_5.126.3.24", "1572724596", "no");
INSERT INTO `wp_options` VALUES("63353", "_transient_external_ip_address_5.126.3.24", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63355", "_transient_timeout_external_ip_address_37.148.77.180", "1572729219", "no");
INSERT INTO `wp_options` VALUES("63356", "_transient_external_ip_address_37.148.77.180", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63361", "_transient_timeout_external_ip_address_77.111.246.176", "1572735307", "no");
INSERT INTO `wp_options` VALUES("63362", "_transient_external_ip_address_77.111.246.176", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63369", "_transient_timeout_external_ip_address_46.62.250.232", "1572742098", "no");
INSERT INTO `wp_options` VALUES("63370", "_transient_external_ip_address_46.62.250.232", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63381", "_transient_timeout_external_ip_address_83.122.11.19", "1572765238", "no");
INSERT INTO `wp_options` VALUES("63382", "_transient_external_ip_address_83.122.11.19", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63387", "_transient_timeout_external_ip_address_5.122.4.113", "1572769165", "no");
INSERT INTO `wp_options` VALUES("63388", "_transient_external_ip_address_5.122.4.113", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63391", "_transient_timeout_external_ip_address_5.119.103.193", "1572772331", "no");
INSERT INTO `wp_options` VALUES("63392", "_transient_external_ip_address_5.119.103.193", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63394", "_transient_timeout_external_ip_address_81.19.218.232", "1572773964", "no");
INSERT INTO `wp_options` VALUES("63395", "_transient_external_ip_address_81.19.218.232", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63402", "_transient_timeout_external_ip_address_2.181.81.60", "1572780423", "no");
INSERT INTO `wp_options` VALUES("63403", "_transient_external_ip_address_2.181.81.60", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63405", "_transient_timeout_external_ip_address_95.179.133.202", "1572780427", "no");
INSERT INTO `wp_options` VALUES("63406", "_transient_external_ip_address_95.179.133.202", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63416", "_transient_timeout_external_ip_address_147.135.204.124", "1572786995", "no");
INSERT INTO `wp_options` VALUES("63417", "_transient_external_ip_address_147.135.204.124", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63422", "_transient_timeout_wc_shipping_method_count_legacy", "1574774256", "no");
INSERT INTO `wp_options` VALUES("63423", "_transient_wc_shipping_method_count_legacy", "a:2:{s:7:\"version\";s:10:\"1536719671\";s:5:\"value\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("63425", "_site_transient_timeout_browser_289d30a4d23579d26a05a8aa808752b5", "1572787180", "no");
INSERT INTO `wp_options` VALUES("63426", "_site_transient_browser_289d30a4d23579d26a05a8aa808752b5", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"77.0.3865.120\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("63434", "_transient_timeout_external_ip_address_46.245.98.87", "1572788436", "no");
INSERT INTO `wp_options` VALUES("63435", "_transient_external_ip_address_46.245.98.87", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63450", "_transient_timeout_external_ip_address_198.16.70.53", "1572796416", "no");
INSERT INTO `wp_options` VALUES("63451", "_transient_external_ip_address_198.16.70.53", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63456", "_transient_timeout_external_ip_address_93.119.214.92", "1572801851", "no");
INSERT INTO `wp_options` VALUES("63457", "_transient_external_ip_address_93.119.214.92", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63461", "_transient_timeout_external_ip_address_173.252.127.33", "1572806490", "no");
INSERT INTO `wp_options` VALUES("63462", "_transient_external_ip_address_173.252.127.33", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63464", "_transient_timeout_external_ip_address_142.118.9.132", "1572806711", "no");
INSERT INTO `wp_options` VALUES("63465", "_transient_external_ip_address_142.118.9.132", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63467", "_transient_timeout_external_ip_address_173.252.87.33", "1572811946", "no");
INSERT INTO `wp_options` VALUES("63468", "_transient_external_ip_address_173.252.87.33", "51.254.198.135", "no");
INSERT INTO `wp_options` VALUES("63473", "rs-templates-new", "", "no");
INSERT INTO `wp_options` VALUES("63474", "rs-templates", "a:2:{s:6:\"slider\";a:389:{i:0;a:21:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/carousel-slider-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:21:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:21:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:21:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-facebook-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:21:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:65:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:21:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-flickr-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\" <span class=\"ttm_content\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:413:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Flickr Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:6;a:21:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:3:\"Gym\";s:5:\"alias\";s:3:\"gym\";s:3:\"zip\";s:7:\"gym.zip\";s:3:\"uid\";s:32:\"e4d81f13f96fb9bc905f4ad89615032b\";s:3:\"img\";s:14:\"gym/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/one-page-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:189:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:7;a:21:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:18:\"Highlight Carousel\";s:5:\"alias\";s:18:\"highlight-carousel\";s:3:\"zip\";s:22:\"highlight-carousel.zip\";s:3:\"uid\";s:32:\"ada52163f723a942f782351fa0396b3d\";s:3:\"img\";s:29:\"highlight-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-swipe-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:138:\"  <span class=\"ttm_content\">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:8;a:21:{s:2:\"id\";s:1:\"9\";s:5:\"title\";s:18:\"Highlight Showcase\";s:5:\"alias\";s:18:\"highlight-showcase\";s:3:\"zip\";s:22:\"highlight-showcase.zip\";s:3:\"uid\";s:32:\"2bfe0bd410fb48fec9d942eab1e21530\";s:3:\"img\";s:29:\"highlight-showcase/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-parallax-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:9;a:21:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:10:\"Image Hero\";s:5:\"alias\";s:10:\"image-hero\";s:3:\"zip\";s:13:\"imagehero.zip\";s:3:\"uid\";s:32:\"7db18781d44f2adc28c962440894aac1\";s:3:\"img\";s:20:\"imagehero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-image/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:121:\"<span class=\"ttm_content\">A commonly used full-width image hero block with texts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:10;a:21:{s:2:\"id\";s:2:\"11\";s:5:\"title\";s:17:\"Instagram Gallery\";s:5:\"alias\";s:13:\"insta-gallery\";s:3:\"zip\";s:17:\"insta-gallery.zip\";s:3:\"uid\";s:32:\"711732b0d42ec2b57818a2b9b1d86cba\";s:3:\"img\";s:24:\"insta-gallery/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-instagram-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"640\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:174:\"<span class=\"ttm_content\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:416:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Instagram Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:11;a:21:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:21:\"Levano Restaurant Bar\";s:5:\"alias\";s:19:\"levanorestaurantbar\";s:3:\"zip\";s:23:\"levanorestaurantbar.zip\";s:3:\"uid\";s:32:\"4178f837db67d1b2eb6cb5840bbd0b42\";s:3:\"img\";s:30:\"levanorestaurantbar/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-front-page-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:12;a:21:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:19:\"Main Feature Slider\";s:5:\"alias\";s:11:\"mainfeature\";s:3:\"zip\";s:15:\"mainfeature.zip\";s:3:\"uid\";s:32:\"1e002a3230ab00095bedc6f60393ee7f\";s:3:\"img\";s:22:\"mainfeature/slider.jpg\";s:7:\"preview\";s:33:\"http://revolution.themepunch.com/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"750\";s:11:\"description\";s:127:\" <span class=\"ttm_content\">A slightly stripped down version of the main preview slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:13;a:21:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:17:\"Media Gallery Two\";s:5:\"alias\";s:17:\"media-gallery-two\";s:3:\"zip\";s:21:\"media-gallery-two.zip\";s:3:\"uid\";s:32:\"d002f1b1b55805f9322c264c5504ba5a\";s:3:\"img\";s:28:\"media-gallery-two/slider.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-media-gallery-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:127:\"<span class=\"ttm_content\">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:14;a:21:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:23:\"Media Carousel Autoplay\";s:5:\"alias\";s:23:\"media-carousel-autoplay\";s:3:\"zip\";s:27:\"media-carousel-autoplay.zip\";s:3:\"uid\";s:32:\"393d7875b1cc9d933378b35e4f645d76\";s:3:\"img\";s:34:\"media-carousel-autoplay/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-media-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"405\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A media carousel with \"autoplay\" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:15;a:21:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:21:\"News Background Video\";s:5:\"alias\";s:21:\"news-background-video\";s:3:\"zip\";s:17:\"news-bg-video.zip\";s:3:\"uid\";s:32:\"a0efe44ac3af0f958b3f84c816a08272\";s:3:\"img\";s:24:\"news-bg-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:16;a:21:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:12:\"News Gallery\";s:5:\"alias\";s:12:\"news-gallery\";s:3:\"zip\";s:16:\"news-gallery.zip\";s:3:\"uid\";s:32:\"3a069c3b286dbb9ee435563f747e3300\";s:3:\"img\";s:23:\"news-gallery/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-news-rotator/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:17;a:21:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:23:\"News Gallery Post Based\";s:5:\"alias\";s:23:\"news-gallery-post-based\";s:3:\"zip\";s:27:\"news-gallery-post-based.zip\";s:3:\"uid\";s:32:\"32fe05b1039c29ab9420bfd15aec5488\";s:3:\"img\";s:34:\"news-gallery-post-based/slider.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-post-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:18;a:21:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:9:\"News Hero\";s:5:\"alias\";s:9:\"news-hero\";s:3:\"zip\";s:13:\"news-hero.zip\";s:3:\"uid\";s:32:\"96a0385538a17c8c81ed8175740f70ea\";s:3:\"img\";s:20:\"news-hero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:107:\"<span class=\"ttm_content\">A image hero block with ken burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:19;a:21:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:10:\"News Video\";s:5:\"alias\";s:10:\"news-video\";s:3:\"zip\";s:14:\"news-video.zip\";s:3:\"uid\";s:32:\"f901e9e16e0363248156c2209eb584e9\";s:3:\"img\";s:21:\"news-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:128:\"<span class=\"ttm_content\">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:20;a:21:{s:2:\"id\";s:2:\"21\";s:5:\"title\";s:15:\"Newsletter Hero\";s:5:\"alias\";s:15:\"newsletter-hero\";s:3:\"zip\";s:19:\"newsletter-hero.zip\";s:3:\"uid\";s:32:\"6290a9864d8c4c6311784586ed1cc5fe\";s:3:\"img\";s:26:\"newsletter-hero/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-newsletter-signup/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:435:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\"https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/\" target=\"_blank\">Mailchimp code</a>.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:21;a:21:{s:2:\"id\";s:2:\"22\";s:5:\"title\";s:11:\"Not Generic\";s:5:\"alias\";s:10:\"notgeneric\";s:3:\"zip\";s:14:\"notgeneric.zip\";s:3:\"uid\";s:32:\"9d87ba95e02210a9f82387add2ceadf9\";s:3:\"img\";s:21:\"notgeneric/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:22;a:21:{s:2:\"id\";s:2:\"23\";s:5:\"title\";s:11:\"Photography\";s:5:\"alias\";s:11:\"photography\";s:3:\"zip\";s:15:\"photography.zip\";s:3:\"uid\";s:32:\"1b2072547afb75e49f33b016751ed360\";s:3:\"img\";s:22:\"photography/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-photography-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:23;a:21:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:20:\"Photography Carousel\";s:5:\"alias\";s:20:\"photography-carousel\";s:3:\"zip\";s:24:\"photography-carousel.zip\";s:3:\"uid\";s:32:\"9a84b859ba23dc49ba8784e3a86545fa\";s:3:\"img\";s:31:\"photography-carousel/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-photo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:24;a:21:{s:2:\"id\";s:2:\"25\";s:5:\"title\";s:16:\"Search Form Hero\";s:5:\"alias\";s:16:\"search-form-hero\";s:3:\"zip\";s:20:\"search-form-hero.zip\";s:3:\"uid\";s:32:\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\";s:3:\"img\";s:27:\"search-form-hero/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-search-form-hero/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:25;a:21:{s:2:\"id\";s:2:\"26\";s:5:\"title\";s:17:\"Showcase Carousel\";s:5:\"alias\";s:16:\"showcasecarousel\";s:3:\"zip\";s:20:\"showcasecarousel.zip\";s:3:\"uid\";s:32:\"c5ca218398331bd2c064efc2f62eae56\";s:3:\"img\";s:27:\"showcasecarousel/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-cover-flow-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:26;a:21:{s:2:\"id\";s:2:\"27\";s:5:\"title\";s:11:\"Sports Hero\";s:5:\"alias\";s:11:\"sports-hero\";s:3:\"zip\";s:14:\"sportshero.zip\";s:3:\"uid\";s:32:\"8de7a145f32a362d618d2595ffa2f724\";s:3:\"img\";s:21:\"sportshero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-image-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:113:\"<span class=\"ttm_content\">An sports themed image hero block with buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:27;a:21:{s:2:\"id\";s:2:\"28\";s:5:\"title\";s:12:\"Twitter Feed\";s:5:\"alias\";s:12:\"twitter-feed\";s:3:\"zip\";s:16:\"twitter-feed.zip\";s:3:\"uid\";s:32:\"efbfc2af5da5258e7b7bed8598e483cc\";s:3:\"img\";s:23:\"twitter-feed/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-twitter-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a Twitter stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Twitter Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:28;a:21:{s:2:\"id\";s:2:\"29\";s:5:\"title\";s:13:\"Vimeo Gallery\";s:5:\"alias\";s:13:\"vimeo-gallery\";s:3:\"zip\";s:17:\"vimeo-gallery.zip\";s:3:\"uid\";s:32:\"fa824ce1ff3942ec268fc9eda60df539\";s:3:\"img\";s:24:\"vimeo-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-vimeo-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:170:\"<span class=\"ttm_content\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:412:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Vimeo Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:29;a:21:{s:2:\"id\";s:2:\"30\";s:5:\"title\";s:10:\"Vimeo Hero\";s:5:\"alias\";s:9:\"vimeohero\";s:3:\"zip\";s:13:\"vimeohero.zip\";s:3:\"uid\";s:32:\"c575575f96173d88589cddcb06120b77\";s:3:\"img\";s:20:\"vimeohero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-vimeo/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:116:\"<span class=\"ttm_content\">A commonly used Vimeo video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:30;a:21:{s:2:\"id\";s:2:\"31\";s:5:\"title\";s:16:\"Web Product Dark\";s:5:\"alias\";s:16:\"web-product-dark\";s:3:\"zip\";s:20:\"web-product-dark.zip\";s:3:\"uid\";s:32:\"39b872cf0608e63c3a503e58374dc30a\";s:3:\"img\";s:27:\"web-product-dark/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-frontpage-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:31;a:21:{s:2:\"id\";s:2:\"32\";s:5:\"title\";s:21:\"Web Product Dark Hero\";s:5:\"alias\";s:21:\"web-product-dark-hero\";s:3:\"zip\";s:25:\"web-product-dark-hero.zip\";s:3:\"uid\";s:32:\"b6784e8925221f36677217979d26e6f0\";s:3:\"img\";s:32:\"web-product-dark-hero/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-header-image/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:32;a:21:{s:2:\"id\";s:2:\"33\";s:5:\"title\";s:22:\"Web Product Light Hero\";s:5:\"alias\";s:22:\"web-product-light-hero\";s:3:\"zip\";s:26:\"web-product-light-hero.zip\";s:3:\"uid\";s:32:\"428e65d6aaa6ef775429989d50516492\";s:3:\"img\";s:33:\"web-product-light-hero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/hero-image-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:33;a:21:{s:2:\"id\";s:2:\"34\";s:5:\"title\";s:17:\"Web Product Light\";s:5:\"alias\";s:15:\"webproductlight\";s:3:\"zip\";s:19:\"webproductlight.zip\";s:3:\"uid\";s:32:\"fa23dab5bf1139c6393828647a9de4e0\";s:3:\"img\";s:26:\"webproductlight/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-cover-page/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:34;a:21:{s:2:\"id\";s:2:\"35\";s:5:\"title\";s:15:\"Youtube Gallery\";s:5:\"alias\";s:15:\"youtube-gallery\";s:3:\"zip\";s:19:\"youtube-gallery.zip\";s:3:\"uid\";s:32:\"ee9e4928ac74f5f0c0b697ce708f5aa7\";s:3:\"img\";s:26:\"youtube-gallery/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/wordpress-youtube-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"YouTube Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:35;a:21:{s:2:\"id\";s:2:\"36\";s:5:\"title\";s:12:\"Youtube Hero\";s:5:\"alias\";s:11:\"youtubehero\";s:3:\"zip\";s:15:\"youtubehero.zip\";s:3:\"uid\";s:32:\"e0b2c12a45841bdf21cb96305f2c85bf\";s:3:\"img\";s:22:\"youtubehero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-youtube-header/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:104:\"<span class=\"ttm_content\">A YouTube video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:633:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/\" target=\"_blank\">enable sound for the background video</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:36;a:21:{s:2:\"id\";s:2:\"37\";s:5:\"title\";s:13:\"Scroll Effect\";s:5:\"alias\";s:13:\"scroll-effect\";s:3:\"zip\";s:17:\"scroll-effect.zip\";s:3:\"uid\";s:32:\"417f59e9db87aa7e47c8509eb88d4af6\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/big-bold-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:37;a:21:{s:2:\"id\";s:2:\"38\";s:5:\"title\";s:12:\"Content Zoom\";s:5:\"alias\";s:12:\"content-zoom\";s:3:\"zip\";s:16:\"content-zoom.zip\";s:3:\"uid\";s:32:\"42ef8cdb70d42ec6ff6fa3b69a027b5f\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/content-zoom-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:243:\"<span class=\"ttm_content\">A very unique full-width slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:38;a:21:{s:2:\"id\";s:2:\"39\";s:5:\"title\";s:13:\"Food Carousel\";s:5:\"alias\";s:13:\"food-carousel\";s:3:\"zip\";s:17:\"food-carousel.zip\";s:3:\"uid\";s:32:\"a7bf54527b6658a0a308c70c729779fe\";s:3:\"img\";s:29:\"foodcarousel/slider_cover.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/food-carousel-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:267:\"<span class=\"ttm_content\">A fancy carousel with detail content on each slide. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to show and hide layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:39;a:21:{s:2:\"id\";s:2:\"40\";s:5:\"title\";s:14:\"Rotating Words\";s:5:\"alias\";s:14:\"rotating-words\";s:3:\"zip\";s:18:\"rotating-words.zip\";s:3:\"uid\";s:32:\"70190463d9376f278c8197b7b2ef6c1b\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/rotating-words-hero/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen hero block with unique animated text and blur effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:495:\"<span class=\"ttm_content\">This is a \"Default\" hero slider. Edit the slide to change the background media and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:40;a:21:{s:2:\"id\";s:2:\"41\";s:5:\"title\";s:22:\"Travel Static Captions\";s:5:\"alias\";s:22:\"travel-static-captions\";s:3:\"zip\";s:26:\"travel-static-captions.zip\";s:3:\"uid\";s:32:\"bbe7d61c7c741ebc7aa1ce1082b0cb71\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";s:7:\"preview\";s:50:\"http://revolution.themepunch.com/travel-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:41;a:21:{s:2:\"id\";s:2:\"42\";s:5:\"title\";s:7:\"Concept\";s:5:\"alias\";s:7:\"concept\";s:3:\"zip\";s:11:\"concept.zip\";s:3:\"uid\";s:32:\"47cb06083e87503762f6746725117a3c\";s:3:\"img\";s:18:\"concept/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/fullscreen-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">A full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:42;a:21:{s:2:\"id\";s:2:\"43\";s:5:\"title\";s:15:\"True Fullscreen\";s:5:\"alias\";s:17:\"fullscreen-button\";s:3:\"zip\";s:21:\"fullscreen-button.zip\";s:3:\"uid\";s:32:\"618a43bdf89333b555531f6d6ecde359\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-sidebar-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A slider with a full-screen button that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:297:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:43;a:21:{s:2:\"id\";s:2:\"44\";s:5:\"title\";s:16:\"Creative Freedom\";s:5:\"alias\";s:15:\"creativefreedom\";s:3:\"zip\";s:19:\"creativefreedom.zip\";s:3:\"uid\";s:32:\"8902bf6c93126c2c6323626b9e872621\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-touch-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:290:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:44;a:21:{s:2:\"id\";s:2:\"45\";s:5:\"title\";s:17:\"3D Parallax Scene\";s:5:\"alias\";s:13:\"parallaxscene\";s:3:\"zip\";s:17:\"parallaxscene.zip\";s:3:\"uid\";s:32:\"51566f1ce649708e97a0f5dfaf05ea19\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-3d-parallax/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:328:\"<span class=\"ttm_content\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:45;a:21:{s:2:\"id\";s:2:\"46\";s:5:\"title\";s:10:\"Wow Factor\";s:5:\"alias\";s:15:\"slidingoverlays\";s:3:\"zip\";s:19:\"slidingoverlays.zip\";s:3:\"uid\";s:32:\"18002d17e8bc7ca61b0951f5305a759e\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/responsive-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:106:\"<span class=\"ttm_content\">A 3D-parallax effect full-screen slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:46;a:21:{s:2:\"id\";s:2:\"47\";s:5:\"title\";s:14:\"3D Web Product\";s:5:\"alias\";s:25:\"web-product-light-hero-3d\";s:3:\"zip\";s:29:\"web-product-light-hero-3d.zip\";s:3:\"uid\";s:32:\"efd345c5da805414093e46066cefd751\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/wordpress-3d-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"668\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:47;a:21:{s:2:\"id\";s:2:\"48\";s:5:\"title\";s:15:\"WooCommerce Big\";s:5:\"alias\";s:6:\"woobig\";s:3:\"zip\";s:10:\"woobig.zip\";s:3:\"uid\";s:32:\"bfb09a39656c7c80e86b468fc5b3403c\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:48;a:21:{s:2:\"id\";s:2:\"49\";s:5:\"title\";s:17:\"WooCommerce Small\";s:5:\"alias\";s:16:\"woocommercesmall\";s:3:\"zip\";s:20:\"woocommercesmall.zip\";s:3:\"uid\";s:32:\"b17c2adcc5c4c4b68a7ac6fee32fa030\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"266\";s:11:\"description\";s:174:\" <span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:49;a:21:{s:2:\"id\";s:2:\"50\";s:5:\"title\";s:17:\"Restaurant Header\";s:5:\"alias\";s:10:\"finedining\";s:3:\"zip\";s:14:\"finedining.zip\";s:3:\"uid\";s:32:\"03481a9e258501fbe3888b48830ea845\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/restaurant-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:275:\"<span class=\"ttm_content\">A full-screen hero block slider that shows different background layers on button hover using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:50;a:21:{s:2:\"id\";s:2:\"51\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:12:\"agency-intro\";s:3:\"zip\";s:16:\"agency-intro.zip\";s:3:\"uid\";s:32:\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/agency-website-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:302:\" <span class=\"ttm_content\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:51;a:21:{s:2:\"id\";s:2:\"52\";s:5:\"title\";s:11:\"Team Slider\";s:5:\"alias\";s:7:\"ourteam\";s:3:\"zip\";s:11:\"ourteam.zip\";s:3:\"uid\";s:32:\"d8eb1fec07a79202d1118bb17f70c233\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";s:7:\"preview\";s:74:\"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:303:\"<span class=\"ttm_content\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:657:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:52;a:21:{s:2:\"id\";s:2:\"53\";s:5:\"title\";s:13:\"Team Carousel\";s:5:\"alias\";s:17:\"our-team-carousel\";s:3:\"zip\";s:21:\"our-team-carousel.zip\";s:3:\"uid\";s:32:\"37656d5dcab1f265c025cb2a3d669809\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";s:7:\"preview\";s:83:\"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:306:\" <span class=\"ttm_content\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:659:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:53;a:21:{s:2:\"id\";s:2:\"54\";s:5:\"title\";s:17:\"4K Youtube Slider\";s:5:\"alias\";s:13:\"betteryoutube\";s:3:\"zip\";s:17:\"betteryoutube.zip\";s:3:\"uid\";s:32:\"d7c5fef9f257037d7a148038aa2a1857\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";s:7:\"preview\";s:94:\"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"675\";s:11:\"description\";s:293:\" <span class=\"ttm_content\">A full-screen youtube gallery with 4K videos as an example. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to breathe life into navigation elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:535:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:54;a:21:{s:2:\"id\";s:2:\"55\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:19:\"agencywebsiteheader\";s:3:\"zip\";s:23:\"agencywebsiteheader.zip\";s:3:\"uid\";s:32:\"c11d272c87277a7a38d9e7fd13e27947\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/fullscreen-hero-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:245:\" <span class=\"ttm_content\">A very unique full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:509:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:55;a:21:{s:2:\"id\";s:2:\"56\";s:5:\"title\";s:11:\"Coming Soon\";s:5:\"alias\";s:10:\"comingsoon\";s:3:\"zip\";s:14:\"comingsoon.zip\";s:3:\"uid\";s:32:\"0f89edf995512e6d6e864a2ee7221829\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";s:7:\"preview\";s:79:\"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:299:\"<span class=\"ttm_content\">A full-screen slider that can be used as a \"Coming Soon\" page. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve various interaction possibilities.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:638:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href=\"https://www.themepunch.com/faq/change-date-for-coming-soon-template/\" target=\"_blank\">how to change the date.</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:56;a:21:{s:2:\"id\";s:2:\"57\";s:5:\"title\";s:20:\"Christmas Snow Scene\";s:5:\"alias\";s:9:\"snowscene\";s:3:\"zip\";s:13:\"snowscene.zip\";s:3:\"uid\";s:32:\"a747bf0837caff86c62419a746690209\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/christmas-snow-scene/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:57;a:21:{s:2:\"id\";s:2:\"58\";s:5:\"title\";s:15:\"Rock Band Music\";s:5:\"alias\";s:8:\"rockband\";s:3:\"zip\";s:12:\"rockband.zip\";s:3:\"uid\";s:32:\"5f557a5fad2fd6ca982a6ae6e9619637\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";s:7:\"preview\";s:80:\"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\" <span class=\"ttm_content\">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:58;a:21:{s:2:\"id\";s:2:\"59\";s:5:\"title\";s:18:\"Sleek Landing Page\";s:5:\"alias\";s:16:\"sleeklandingpage\";s:3:\"zip\";s:20:\"sleeklandingpage.zip\";s:3:\"uid\";s:32:\"07f7f2608936a8ae226213b7d99eee3f\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";s:7:\"preview\";s:70:\"http://revolution.themepunch.com/landing-page-free-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:59;a:21:{s:2:\"id\";s:2:\"60\";s:5:\"title\";s:16:\"App Landing Page\";s:5:\"alias\";s:14:\"applandingpage\";s:3:\"zip\";s:18:\"applandingpage.zip\";s:3:\"uid\";s:32:\"38eb600893c1484ab8fd2a3dce3678d7\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/app-landing-page-free-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:60;a:21:{s:2:\"id\";s:2:\"61\";s:5:\"title\";s:10:\"Desk Scene\";s:5:\"alias\";s:9:\"deskscene\";s:3:\"zip\";s:13:\"deskscene.zip\";s:3:\"uid\";s:32:\"172a1a89a3e3b333cb4dbeb238f534c5\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";s:7:\"preview\";s:49:\"http://revolution.themepunch.com/hero-desk-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:135:\"<span class=\"ttm_content\">A beautiful desk scene with a cool reveal effect when scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:61;a:21:{s:2:\"id\";s:2:\"62\";s:5:\"title\";s:17:\"Clean News Slider\";s:5:\"alias\";s:15:\"cleannewsslider\";s:3:\"zip\";s:19:\"cleannewsslider.zip\";s:3:\"uid\";s:32:\"82c3f521fe31b80984be0f19e1a9899e\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:132:\"<span class=\"ttm_content\">A slideshow example with clean content and thumbnail navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:62;a:21:{s:2:\"id\";s:2:\"63\";s:5:\"title\";s:13:\"Image Gallery\";s:5:\"alias\";s:12:\"imagegallery\";s:3:\"zip\";s:16:\"imagegallery.zip\";s:3:\"uid\";s:32:\"cef1d75357df2cb53b990c74a214813e\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">A photo gallery suitable to display your images using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:63;a:21:{s:2:\"id\";s:2:\"64\";s:5:\"title\";s:19:\"Standard WP Gallery\";s:5:\"alias\";s:19:\"standard-wp-gallery\";s:3:\"zip\";s:23:\"standard-wp-gallery.zip\";s:3:\"uid\";s:32:\"632035b8a27652d8081dbdfa343dc93d\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A photo gallery that uses the \"Standard WP Gallery\" add-on to display images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:407:\"<span class=\"ttm_content\">Please follow the setup guide on the \"Standard WP Gallery\" add-on page.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";s:166:\"[{\"path\":\"revslider-gallery-addon\\/revslider-gallery-addon.php\",\"name\":\"WP Gallery AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:64;a:21:{s:2:\"id\";s:2:\"65\";s:5:\"title\";s:21:\"Clean News Post Based\";s:5:\"alias\";s:21:\"clean-news-post-based\";s:3:\"zip\";s:25:\"clean-news-post-based.zip\";s:3:\"uid\";s:32:\"f4cf5bbe51afa5a361754bb081cbabf2\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:65;a:21:{s:2:\"id\";s:2:\"66\";s:5:\"title\";s:22:\"Interactive Whiteboard\";s:5:\"alias\";s:21:\"interactivewhiteboard\";s:3:\"zip\";s:25:\"interactivewhiteboard.zip\";s:3:\"uid\";s:32:\"058b4af535d6c6c7bcec5225845e3eb4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";s:7:\"preview\";s:77:\"http://revolution.themepunch.com/interactive-whiteboard-animation-free-addon/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:269:\"<span class=\"ttm_content\">This is the example slider from the Whiteboard add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used to achieve certain effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:541:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/whiteboard-addon/\" target=\"_blank\">Whiteboard add-on</a> to be installed. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-whiteboard-addon\\/revslider-whiteboard-addon.php\",\"name\":\"Whiteboard AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:66;a:21:{s:2:\"id\";s:2:\"68\";s:5:\"title\";s:17:\"Innovation Slider\";s:5:\"alias\";s:10:\"innovation\";s:3:\"zip\";s:14:\"innovation.zip\";s:3:\"uid\";s:32:\"d3440b69126d9c186fddc713b18b0002\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2016/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:7:\"5.2.3.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:258:\"<span class=\"ttm_content\">A full-screen slider with an elegant fade-out parallax effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:493:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images, videos and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-03-29 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:67;a:24:{s:2:\"id\";s:2:\"69\";s:5:\"title\";s:25:\"Dark Content Block - Menu\";s:5:\"alias\";s:24:\"dark-fullsite-block-menu\";s:3:\"zip\";s:34:\"packs/dark-fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"bf4bd226719d3c3d3146592976e31ca1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:68;a:24:{s:2:\"id\";s:2:\"70\";s:5:\"title\";s:25:\"Dark Content Block - Hero\";s:5:\"alias\";s:21:\"dark-fullsite-block-1\";s:3:\"zip\";s:31:\"packs/dark-fullsite-block-1.zip\";s:3:\"uid\";s:32:\"d8859245fe600288ca932dc29aca751f\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:69;a:24:{s:2:\"id\";s:2:\"71\";s:5:\"title\";s:26:\"Dark Content Block - About\";s:5:\"alias\";s:27:\"dark-fullsite-block-2-about\";s:3:\"zip\";s:37:\"packs/dark-fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"298401901521a197a8294c1b4f73df3e\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:70;a:24:{s:2:\"id\";s:2:\"72\";s:5:\"title\";s:29:\"Dark Content Block - Services\";s:5:\"alias\";s:30:\"dark-fullsite-block-3-services\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"8da3ed605472ed6a26c745fb52f85f82\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:71;a:24:{s:2:\"id\";s:2:\"73\";s:5:\"title\";s:29:\"Dark Content Block - Products\";s:5:\"alias\";s:30:\"dark-fullsite-block-4-products\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"99e4f40399d20261a6131043d0e50b0c\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:422:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\r\n\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:72;a:24:{s:2:\"id\";s:2:\"74\";s:5:\"title\";s:33:\"Dark Content Block - Testimonials\";s:5:\"alias\";s:34:\"dark-fullsite-block-5-testimonials\";s:3:\"zip\";s:44:\"packs/dark-fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"2f9121e0eedd51afe85e233d0743acab\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:73;a:24:{s:2:\"id\";s:2:\"75\";s:5:\"title\";s:28:\"Dark Content Block - Callout\";s:5:\"alias\";s:29:\"dark-fullsite-block-6-callout\";s:3:\"zip\";s:39:\"packs/dark-fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"55fbecb113ff21f050be7adc08637329\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:74;a:24:{s:2:\"id\";s:2:\"76\";s:5:\"title\";s:27:\"Dark Content Block - Footer\";s:5:\"alias\";s:28:\"dark-fullsite-block-7-footer\";s:3:\"zip\";s:38:\"packs/dark-fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"2ff517f5c7c54e3e0c2dd733cfd3400e\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:75;a:24:{s:2:\"id\";s:2:\"77\";s:5:\"title\";s:26:\"Light Content Block - Menu\";s:5:\"alias\";s:19:\"fullsite-block-menu\";s:3:\"zip\";s:29:\"packs/fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"8010971f34387d5f94a1f4e577ef382a\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:76;a:24:{s:2:\"id\";s:2:\"78\";s:5:\"title\";s:26:\"Light Content Block - Hero\";s:5:\"alias\";s:15:\"fullsite-block1\";s:3:\"zip\";s:25:\"packs/fullsite-block1.zip\";s:3:\"uid\";s:32:\"45bf7179843e01ce112e8ec754b0455c\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:77;a:24:{s:2:\"id\";s:2:\"79\";s:5:\"title\";s:27:\"Light Content Block - About\";s:5:\"alias\";s:22:\"fullsite-block-2-about\";s:3:\"zip\";s:32:\"packs/fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"8402b460638a746d36433cb161440b7d\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:78;a:24:{s:2:\"id\";s:2:\"80\";s:5:\"title\";s:30:\"Light Content Block - Services\";s:5:\"alias\";s:25:\"fullsite-block-3-services\";s:3:\"zip\";s:35:\"packs/fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"7b8cea27f4d6ae17c5e1eae12457bd06\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:79;a:24:{s:2:\"id\";s:2:\"81\";s:5:\"title\";s:30:\"Light Content Block - Products\";s:5:\"alias\";s:25:\"fullsite-block-4-products\";s:3:\"zip\";s:35:\"packs/fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"d148935362d7122636cda0635eae4be7\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:80;a:24:{s:2:\"id\";s:2:\"82\";s:5:\"title\";s:34:\"Light Content Block - Testimonials\";s:5:\"alias\";s:29:\"fullsite-block-5-testimonials\";s:3:\"zip\";s:39:\"packs/fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"06255bfd421e40f71fa8197b839dbf03\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:81;a:24:{s:2:\"id\";s:2:\"83\";s:5:\"title\";s:29:\"Light Content Block - Callout\";s:5:\"alias\";s:24:\"fullsite-block-6-callout\";s:3:\"zip\";s:34:\"packs/fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"8a88c3447676b613ec5db2fe5d63315c\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:82;a:24:{s:2:\"id\";s:2:\"84\";s:5:\"title\";s:28:\"Light Content Block - Footer\";s:5:\"alias\";s:23:\"fullsite-block-7-footer\";s:3:\"zip\";s:33:\"packs/fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"34300b4407a2093eb2e1e08868fa8319\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:83;a:21:{s:2:\"id\";s:2:\"85\";s:5:\"title\";s:12:\"Tech Journal\";s:5:\"alias\";s:11:\"techjournal\";s:3:\"zip\";s:15:\"techjournal.zip\";s:3:\"uid\";s:32:\"7f92d70d1c108378f915b18c2ceb71d6\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:84;a:21:{s:2:\"id\";s:2:\"86\";s:5:\"title\";s:14:\"Car Dealership\";s:5:\"alias\";s:13:\"cardealership\";s:3:\"zip\";s:17:\"cardealership.zip\";s:3:\"uid\";s:32:\"bb010838855a8ae4d1dd68e139bf169e\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/car-dealership-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"650\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:85;a:21:{s:2:\"id\";s:2:\"87\";s:5:\"title\";s:22:\"FullScreen Menu Slider\";s:5:\"alias\";s:14:\"fullscreenmenu\";s:3:\"zip\";s:18:\"fullscreenmenu.zip\";s:3:\"uid\";s:32:\"6de81d74c4bf193e2e274d43038adc85\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-fullscreen-menu/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A full-screen slider that contains a menu with slide blur effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:86;a:21:{s:2:\"id\";s:2:\"88\";s:5:\"title\";s:18:\"Creative Frontpage\";s:5:\"alias\";s:17:\"creativefrontpage\";s:3:\"zip\";s:21:\"creativefrontpage.zip\";s:3:\"uid\";s:32:\"0636cb368af3bcaa2f68eb0ebefe6439\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/best-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A full-screen slider with hidden slides that are triggered via  <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:87;a:24:{s:2:\"id\";s:2:\"89\";s:5:\"title\";s:20:\"Website Builder Menu\";s:5:\"alias\";s:19:\"websitebuilder-menu\";s:3:\"zip\";s:29:\"packs/websitebuilder-menu.zip\";s:3:\"uid\";s:32:\"d9e6d9c961f123a3a4847b51fc3ba3a2\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:88;a:24:{s:2:\"id\";s:2:\"90\";s:5:\"title\";s:20:\"Website Builder Hero\";s:5:\"alias\";s:19:\"websitebuilder-hero\";s:3:\"zip\";s:29:\"packs/websitebuilder-hero.zip\";s:3:\"uid\";s:32:\"6cb2df9a41ad2e7865bb9bbea7e39cb5\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:89;a:24:{s:2:\"id\";s:2:\"91\";s:5:\"title\";s:23:\"Website Builder Clients\";s:5:\"alias\";s:22:\"websitebuilder-clients\";s:3:\"zip\";s:32:\"packs/websitebuilder-clients.zip\";s:3:\"uid\";s:32:\"050e59c43c9a693510d01f29532088cf\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"120\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:90;a:24:{s:2:\"id\";s:2:\"92\";s:5:\"title\";s:24:\"Website Builder Services\";s:5:\"alias\";s:23:\"websitebuilder-services\";s:3:\"zip\";s:33:\"packs/websitebuilder-services.zip\";s:3:\"uid\";s:32:\"48d56d67615efce619ae973ab4358c07\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"558\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:91;a:24:{s:2:\"id\";s:2:\"93\";s:5:\"title\";s:24:\"Website Builder Discover\";s:5:\"alias\";s:23:\"websitebuilder-discover\";s:3:\"zip\";s:33:\"packs/websitebuilder-discover.zip\";s:3:\"uid\";s:32:\"425a08a7be338daea3df02a07ff5c316\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"955\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:92;a:24:{s:2:\"id\";s:2:\"94\";s:5:\"title\";s:22:\"Website Builder Slider\";s:5:\"alias\";s:21:\"websitebuilder-slider\";s:3:\"zip\";s:31:\"packs/websitebuilder-slider.zip\";s:3:\"uid\";s:32:\"9d670b7335016accb590dc8d52bfb6f0\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:93;a:24:{s:2:\"id\";s:2:\"95\";s:5:\"title\";s:28:\"Website Builder CallToAction\";s:5:\"alias\";s:27:\"websitebuilder-calltoaction\";s:3:\"zip\";s:37:\"packs/websitebuilder-calltoaction.zip\";s:3:\"uid\";s:32:\"45851baf9e61f55ed9f5fa9d0beff77e\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"960\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:94;a:24:{s:2:\"id\";s:2:\"96\";s:5:\"title\";s:22:\"Website Builder Footer\";s:5:\"alias\";s:21:\"websitebuilder-footer\";s:3:\"zip\";s:31:\"packs/websitebuilder-footer.zip\";s:3:\"uid\";s:32:\"2732bbe66ef28219d6cc53ce8cc78863\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:95;a:21:{s:2:\"id\";s:2:\"97\";s:5:\"title\";s:21:\"Focus Parallax Effect\";s:5:\"alias\";s:13:\"focusparallax\";s:3:\"zip\";s:17:\"focusparallax.zip\";s:3:\"uid\";s:32:\"13bd15fb3ddf8b9841cb55b89389cc73\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";s:7:\"preview\";s:68:\" https://revolution.themepunch.com/parallax-effect-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:256:\"<span class=\"ttm_content\">A full-screen slider with mouse controlled parallax effects. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:96;a:21:{s:2:\"id\";s:2:\"98\";s:5:\"title\";s:14:\"Duotone Slider\";s:5:\"alias\";s:7:\"duotone\";s:3:\"zip\";s:11:\"duotone.zip\";s:3:\"uid\";s:32:\"494862ceb6cb7c6658ad7cd36848cccd\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-header-image-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:252:\"<span class=\"ttm_content\">A full-screen slider with unique parallax scroll effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:97;a:24:{s:2:\"id\";s:2:\"99\";s:5:\"title\";s:12:\"Minimal Menu\";s:5:\"alias\";s:6:\"r_menu\";s:3:\"zip\";s:16:\"packs/r_menu.zip\";s:3:\"uid\";s:32:\"30d6a6895db1a5f29b1679061551c9f0\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:98;a:24:{s:2:\"id\";s:3:\"100\";s:5:\"title\";s:12:\"Minimal Hero\";s:5:\"alias\";s:5:\"rhero\";s:3:\"zip\";s:16:\"packs/r_hero.zip\";s:3:\"uid\";s:32:\"b8b46186956f6e66ad0c08e4532bbbde\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:99;a:24:{s:2:\"id\";s:3:\"101\";s:5:\"title\";s:13:\"Minimal About\";s:5:\"alias\";s:7:\"r_about\";s:3:\"zip\";s:17:\"packs/r_about.zip\";s:3:\"uid\";s:32:\"343010c4b4c03f92888c3e9e95bc2bb1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:100;a:24:{s:2:\"id\";s:3:\"102\";s:5:\"title\";s:16:\"Minimal Products\";s:5:\"alias\";s:10:\"r_products\";s:3:\"zip\";s:20:\"packs/r_products.zip\";s:3:\"uid\";s:32:\"dda93e85c6a4456d132040147f087f39\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1100\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:101;a:24:{s:2:\"id\";s:3:\"103\";s:5:\"title\";s:12:\"Minimal Info\";s:5:\"alias\";s:6:\"r_info\";s:3:\"zip\";s:16:\"packs/r_info.zip\";s:3:\"uid\";s:32:\"d6e368e8fd4862174af6c980389ae530\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:102;a:21:{s:2:\"id\";s:3:\"104\";s:5:\"title\";s:18:\"Inspiration Header\";s:5:\"alias\";s:17:\"inspirationheader\";s:3:\"zip\";s:21:\"inspirationheader.zip\";s:3:\"uid\";s:32:\"69f04b2be0b618fa7e184af83b86b7e7\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/wordpress-theme-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This full-screen hero slider features sequentially animated texts and cool parallax elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:103;a:21:{s:2:\"id\";s:3:\"105\";s:5:\"title\";s:15:\"Magazine Slider\";s:5:\"alias\";s:13:\"magazineposts\";s:3:\"zip\";s:17:\"magazineposts.zip\";s:3:\"uid\";s:32:\"c562f3457e4edbd030959f7c5e6e0f7c\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-magazine-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:104;a:21:{s:2:\"id\";s:3:\"106\";s:5:\"title\";s:11:\"News Header\";s:5:\"alias\";s:17:\"explorationheader\";s:3:\"zip\";s:21:\"explorationheader.zip\";s:3:\"uid\";s:32:\"8f20d5a868c90ded08b835fb9e8307d7\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/wordpress-news-header/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:288:\"<span class=\"ttm_content\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to add links to buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:105;a:24:{s:2:\"id\";s:3:\"107\";s:5:\"title\";s:23:\"Minimal Website Package\";s:5:\"alias\";s:23:\"minimal-website-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:23:\"minimal-website-package\";s:3:\"img\";s:31:\"packages/template_group_1_1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">The Minimal Website Template is a one-pager website with a unique background color change effect on scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:106;a:24:{s:2:\"id\";s:3:\"108\";s:5:\"title\";s:23:\"Website Builder Package\";s:5:\"alias\";s:22:\"websitebuilder-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"websitebuilder-package\";s:3:\"img\";s:29:\"packages/template_group_2.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">The Website Builder Package is a clean, usable collection website modules that can be used all together or each on their own.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:107;a:24:{s:2:\"id\";s:3:\"109\";s:5:\"title\";s:26:\"Dark Content Block Package\";s:5:\"alias\";s:27:\"dark-fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"dark-fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_4.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:108;a:24:{s:2:\"id\";s:3:\"110\";s:5:\"title\";s:27:\"Light Content Block Package\";s:5:\"alias\";s:22:\"fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_3.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:109;a:21:{s:2:\"id\";s:3:\"111\";s:5:\"title\";s:17:\"Typewriter Effect\";s:5:\"alias\";s:16:\"typewritereffect\";s:3:\"zip\";s:20:\"typewritereffect.zip\";s:3:\"uid\";s:32:\"d6f8bae06cc4a7b158d680c01e59ddc2\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/wordpress-typewriter-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">This is the example slider from the Typewriter add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:403:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/typewriter-addon/\" target=\"_blank\">Typewriter add-on</a> to be installed. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:110;a:21:{s:2:\"id\";s:3:\"112\";s:5:\"title\";s:17:\"Blend Mode Header\";s:5:\"alias\";s:15:\"blendmodeheader\";s:3:\"zip\";s:19:\"blendmodeheader.zip\";s:3:\"uid\";s:32:\"2e44e976596d757aab40ffa28086dcf9\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/blend-mode-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:111;a:24:{s:2:\"id\";s:3:\"113\";s:5:\"title\";s:17:\"Themeplicity Menu\";s:5:\"alias\";s:17:\"themeplicity_menu\";s:3:\"zip\";s:27:\"packs/themeplicity_menu.zip\";s:3:\"uid\";s:32:\"7d5c1e75eaafa63683895a32a62f4ce0\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:112;a:24:{s:2:\"id\";s:3:\"114\";s:5:\"title\";s:19:\"Themeplicity Header\";s:5:\"alias\";s:19:\"themeplicity_header\";s:3:\"zip\";s:29:\"packs/themeplicity_header.zip\";s:3:\"uid\";s:32:\"907091e4d58acc7d12f802de2f280b7d\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:113;a:24:{s:2:\"id\";s:3:\"115\";s:5:\"title\";s:18:\"Themeplicity Offer\";s:5:\"alias\";s:18:\"themeplicity_offer\";s:3:\"zip\";s:28:\"packs/themeplicity_offer.zip\";s:3:\"uid\";s:32:\"1bd8f9aa2f3e340449664c65ba17fb51\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"330\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:114;a:24:{s:2:\"id\";s:3:\"116\";s:5:\"title\";s:23:\"Themeplicity What We Do\";s:5:\"alias\";s:21:\"themeplicity_whatwedo\";s:3:\"zip\";s:31:\"packs/themeplicity_whatwedo.zip\";s:3:\"uid\";s:32:\"aa800a44b5a3eab30414dde1f32bfed7\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:115;a:24:{s:2:\"id\";s:3:\"117\";s:5:\"title\";s:21:\"Themeplicity Projects\";s:5:\"alias\";s:21:\"themeplicity_projects\";s:3:\"zip\";s:31:\"packs/themeplicity_projects.zip\";s:3:\"uid\";s:32:\"5f61b3a13033ba6a51a18270163e0a50\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:116;a:24:{s:2:\"id\";s:3:\"118\";s:5:\"title\";s:24:\"Themeplicity Whats Great\";s:5:\"alias\";s:23:\"themeplicity_whatsgreat\";s:3:\"zip\";s:33:\"packs/themeplicity_whatsgreat.zip\";s:3:\"uid\";s:32:\"ce9faf8c55ed2e33e091b23667e7173b\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:117;a:24:{s:2:\"id\";s:3:\"119\";s:5:\"title\";s:19:\"Themeplicity Tables\";s:5:\"alias\";s:19:\"themeplicity_tables\";s:3:\"zip\";s:29:\"packs/themeplicity_tables.zip\";s:3:\"uid\";s:32:\"f28bb4cd20ec1f29a1de7da5ad09c293\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1059\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:118;a:24:{s:2:\"id\";s:3:\"120\";s:5:\"title\";s:24:\"Themeplicity Contactform\";s:5:\"alias\";s:24:\"themeplicity_contactform\";s:3:\"zip\";s:34:\"packs/themeplicity_contactform.zip\";s:3:\"uid\";s:32:\"3e59da970f534490774fa8e053f5b5ed\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1067\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:119;a:24:{s:2:\"id\";s:3:\"121\";s:5:\"title\";s:19:\"Themeplicity Footer\";s:5:\"alias\";s:19:\"themeplicity_footer\";s:3:\"zip\";s:29:\"packs/themeplicity_footer.zip\";s:3:\"uid\";s:32:\"89eeb0b4b852c5f743e1bd76e3e8f2ef\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"780\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:120;a:24:{s:2:\"id\";s:3:\"122\";s:5:\"title\";s:20:\"Themeplicity Package\";s:5:\"alias\";s:20:\"themeplicity-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:20:\"themeplicity-package\";s:3:\"img\";s:38:\"packages/templatepack_themeplicity.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Themeplicity Website Template uses the new groups & rows feature introduced in 5.3 to its full potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:121;a:24:{s:2:\"id\";s:3:\"123\";s:5:\"title\";s:19:\"Nice And Clean Menu\";s:5:\"alias\";s:17:\"NiceAndClean_Menu\";s:3:\"zip\";s:27:\"packs/NiceAndClean_Menu.zip\";s:3:\"uid\";s:32:\"3f8c01e26c7446428e045c4b1180776d\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:122;a:24:{s:2:\"id\";s:3:\"124\";s:5:\"title\";s:21:\"Nice And Clean Header\";s:5:\"alias\";s:19:\"NiceAndClean_Header\";s:3:\"zip\";s:29:\"packs/NiceAndClean_Header.zip\";s:3:\"uid\";s:32:\"76931033addb20a62557c2845a4d6a11\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:123;a:24:{s:2:\"id\";s:3:\"125\";s:5:\"title\";s:23:\"Nice And Clean Services\";s:5:\"alias\";s:21:\"NiceAndClean_Services\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Services.zip\";s:3:\"uid\";s:32:\"02f72ec606800c8215bcadea09624e87\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"360\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:124;a:24:{s:2:\"id\";s:3:\"126\";s:5:\"title\";s:20:\"Nice And Clean About\";s:5:\"alias\";s:18:\"NiceAndClean_About\";s:3:\"zip\";s:28:\"packs/NiceAndClean_About.zip\";s:3:\"uid\";s:32:\"9510f6fdbb8e9473e8c22f692a6bc89f\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:125;a:24:{s:2:\"id\";s:3:\"127\";s:5:\"title\";s:20:\"Nice And Clean Video\";s:5:\"alias\";s:18:\"niceandclean_video\";s:3:\"zip\";s:28:\"packs/niceandclean_video.zip\";s:3:\"uid\";s:32:\"2bb9e1ad329435cc500542d0c7025e15\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:126;a:24:{s:2:\"id\";s:3:\"128\";s:5:\"title\";s:25:\"Nice And Clean Highlights\";s:5:\"alias\";s:23:\"niceandclean_highlights\";s:3:\"zip\";s:33:\"packs/niceandclean_highlights.zip\";s:3:\"uid\";s:32:\"ff396af163a79d2d5b35db17c1ea7aa6\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:127;a:24:{s:2:\"id\";s:3:\"129\";s:5:\"title\";s:23:\"Nice And Clean Projects\";s:5:\"alias\";s:21:\"NiceAndClean_Projects\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Projects.zip\";s:3:\"uid\";s:32:\"1e6695959ef83f8975b52289c08a4d44\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:128;a:24:{s:2:\"id\";s:3:\"130\";s:5:\"title\";s:25:\"Nice And Clean TextBlocks\";s:5:\"alias\";s:23:\"niceandclean_textblocks\";s:3:\"zip\";s:33:\"packs/niceandclean_textblocks.zip\";s:3:\"uid\";s:32:\"1f33eb839c96ea3225faff1c8d382b05\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:129;a:24:{s:2:\"id\";s:3:\"131\";s:5:\"title\";s:22:\"Nice And Clean CallOut\";s:5:\"alias\";s:20:\"niceandclean_callout\";s:3:\"zip\";s:30:\"packs/niceandclean_callout.zip\";s:3:\"uid\";s:32:\"54d4d9bcf79d357de0e614700e909863\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:130;a:24:{s:2:\"id\";s:3:\"132\";s:5:\"title\";s:21:\"Nice And Clean Footer\";s:5:\"alias\";s:19:\"niceandclean_footer\";s:3:\"zip\";s:29:\"packs/niceandclean_footer.zip\";s:3:\"uid\";s:32:\"5492d7f72b3771a4e754f91bda063b15\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"400\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:542:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">For using the social sharing buttons, please install the social sharing add-on.<br><br></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:131;a:21:{s:2:\"id\";s:3:\"134\";s:5:\"title\";s:15:\"80s Style Intro\";s:5:\"alias\";s:3:\"80s\";s:3:\"zip\";s:7:\"80s.zip\";s:3:\"uid\";s:32:\"98881ab51f71b2fbdb220752d321b15a\";s:3:\"img\";s:14:\"80s/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/80s-style-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:139:\"<span class=\"ttm_content\">This intro hero block takes you back to the 80\'s with some funky effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:317:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and text.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:132;a:21:{s:2:\"id\";s:3:\"135\";s:5:\"title\";s:18:\"Blur Effect Slider\";s:5:\"alias\";s:10:\"blurslider\";s:3:\"zip\";s:14:\"blurslider.zip\";s:3:\"uid\";s:32:\"83bd6e1ccef83f03c944fa05b0a2d879\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/blur-effect-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:147:\"<span class=\"ttm_content\">This slider makes use of the brand new blur effects available with version 5.3.1.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:133;a:21:{s:2:\"id\";s:3:\"136\";s:5:\"title\";s:18:\"Coming Soon Add-On\";s:5:\"alias\";s:15:\"ComingSoonAddon\";s:3:\"zip\";s:19:\"ComingSoonAddon.zip\";s:3:\"uid\";s:32:\"51258492055b940099eb96ba52901fa9\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/coming-soon-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:133:\"<span class=\"ttm_content\">This slider template makes use of the brand new Coming Soon Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:134;a:24:{s:2:\"id\";s:3:\"137\";s:5:\"title\";s:22:\"Nice And Clean Package\";s:5:\"alias\";s:22:\"nice-and-clean-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"nice-and-clean-package\";s:3:\"img\";s:38:\"packages/templatepack_niceandclean.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:242:\"<span class=\"ttm_content\">The Nice & Clean Website Template uses groups & rows for a fully responsive website experience. Elegant blur effects available since version 5.3.1 make this template stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:135;a:21:{s:2:\"id\";s:3:\"138\";s:5:\"title\";s:18:\"Snow Effect Add-On\";s:5:\"alias\";s:9:\"snowaddon\";s:3:\"zip\";s:13:\"snowaddon.zip\";s:3:\"uid\";s:32:\"7408d8567b8af5716eaabd390422e51b\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/snow-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"<span class=\"ttm_content\">Add a pleasant Snow Effect to your website with this slider template. Make sure to install the \"Holiday Snow\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:153:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:136;a:21:{s:2:\"id\";s:3:\"139\";s:5:\"title\";s:19:\"Particle Effect One\";s:5:\"alias\";s:19:\"particle-effect-one\";s:3:\"zip\";s:23:\"particle-effect-one.zip\";s:3:\"uid\";s:32:\"a4611c906e35ca60f617da86217b5299\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/particle-effect-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:442:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND MODE IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:137;a:21:{s:2:\"id\";s:3:\"140\";s:5:\"title\";s:19:\"Particle Effect Two\";s:5:\"alias\";s:19:\"particle-effect-two\";s:3:\"zip\";s:23:\"particle-effect-two.zip\";s:3:\"uid\";s:32:\"b8ecbf43374a69e4ab329ea834862ef8\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/particle-effect-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:138;a:21:{s:2:\"id\";s:3:\"141\";s:5:\"title\";s:21:\"Particle Effect Three\";s:5:\"alias\";s:21:\"particle-effect-three\";s:3:\"zip\";s:25:\"particle-effect-three.zip\";s:3:\"uid\";s:32:\"b33bc2c5655d8d51cd17c3740f72e748\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/particle-background-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:437:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:139;a:21:{s:2:\"id\";s:3:\"142\";s:5:\"title\";s:16:\"Portfolio Viewer\";s:5:\"alias\";s:15:\"portfolioviewer\";s:3:\"zip\";s:19:\"portfolioviewer.zip\";s:3:\"uid\";s:32:\"9ac7230ff5b880fb6c8f28fbbc123b3b\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-portfolio-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:207:\"<span class=\"ttm_content\">This slider template can be used to display your portfolio highlights in a stunning way, utilising out free particles add-on and blend modes.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:387:\"<span class=\"ttm_content\">The navigation for the slides is found in the <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">Static Layers</a>.</span><span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:140;a:21:{s:2:\"id\";s:3:\"143\";s:5:\"title\";s:12:\"App Showcase\";s:5:\"alias\";s:11:\"appshowcase\";s:3:\"zip\";s:15:\"appshowcase.zip\";s:3:\"uid\";s:32:\"082aef931b0369080bc30c3a2a0c331f\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/app-showcase-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">This template shows off our new \"Polyfold Effects\" Add-On in form of an App product showcase module. Get started now and illustrate your Apps key features in a striking way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"[{\"path\":\"revslider-polyfold-addon\\/revslider-polyfold-addon.php\",\"name\":\"Polyfold Scroll Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:141;a:21:{s:2:\"id\";s:3:\"144\";s:5:\"title\";s:19:\"Gravity Design Hero\";s:5:\"alias\";s:13:\"gravitydesign\";s:3:\"zip\";s:17:\"gravitydesign.zip\";s:3:\"uid\";s:32:\"7bdbe73a6e5bf290cb4412708ac4134d\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2017/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.3.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">This hero template shows a striking mouse-parallax scene and cool particle effects. Requires our \"Particle Effects\" Add-on to be installed.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:142;a:21:{s:2:\"id\";s:3:\"145\";s:5:\"title\";s:14:\"404 Error Page\";s:5:\"alias\";s:12:\"404errorpage\";s:3:\"zip\";s:16:\"404errorpage.zip\";s:3:\"uid\";s:32:\"2dc62d802b42b73088651cac17d0c486\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/404-error-page-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.3.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This template can be used as a custom error page on your website with our new 404 page Add-On. Of course you can also use this template as a regular hero header.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"{\"1\":{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}}\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:143;a:21:{s:2:\"id\";s:3:\"146\";s:5:\"title\";s:16:\"Carousel Gallery\";s:5:\"alias\";s:15:\"carouselgallery\";s:3:\"zip\";s:19:\"carouselgallery.zip\";s:3:\"uid\";s:32:\"041838fd32923c40e15c998f0ea19526\";s:3:\"img\";s:26:\"carouselgallery/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-carousel-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This carousel gallery features a subtle parallax effect, html5 video and a fullscreen button.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:144;a:21:{s:2:\"id\";s:3:\"147\";s:5:\"title\";s:16:\"Filmstrip Effect\";s:5:\"alias\";s:9:\"filmstrip\";s:3:\"zip\";s:13:\"filmstrip.zip\";s:3:\"uid\";s:32:\"7bd142f272cc15d86998a79520e9e581\";s:3:\"img\";s:20:\"filmstrip/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/filmstrip-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">This template uses our Filmstrip Add-On to display a continuous scrolling set of images per slide.\r\n There is lots of customization options like animation speed and direction.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:180:\"[{\"path\":\"revslider-filmstrip-addon\\/revslider-filmstrip-addon.php\",\"name\":\"Background FilmStrip Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:145;a:21:{s:2:\"id\";s:3:\"148\";s:5:\"title\";s:11:\"Space Opera\";s:5:\"alias\";s:10:\"spaceopera\";s:3:\"zip\";s:14:\"spaceopera.zip\";s:3:\"uid\";s:32:\"a2c8bffcb138a86c0f373adebb6de046\";s:3:\"img\";s:21:\"spaceopera/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/space-opera-presentation/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">The Space Opera template can be enjoyed as a slow paced, full-screen slider experience and is great to show your most prominent photos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:146;a:21:{s:2:\"id\";s:3:\"149\";s:5:\"title\";s:13:\"Website Intro\";s:5:\"alias\";s:12:\"websiteintro\";s:3:\"zip\";s:16:\"websiteintro.zip\";s:3:\"uid\";s:32:\"348df76d999456aa19be58c9df56ae20\";s:3:\"img\";s:23:\"websiteintro/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/website-intro-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:274:\"<span class=\"ttm_content\">Making use of our new Slicey Add-On, this slider show a really cool effect you just have to experience yourself! Just change the slides background images and the existing slices will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:147;a:21:{s:2:\"id\";s:3:\"150\";s:5:\"title\";s:13:\"Mask Showcase\";s:5:\"alias\";s:12:\"maskshowcase\";s:3:\"zip\";s:16:\"maskshowcase.zip\";s:3:\"uid\";s:32:\"fc943c31e2da9c63b252aeabf554d128\";s:3:\"img\";s:23:\"maskshowcase/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/minimal-mask-showcase/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Mask Showcase template uses gradients and the amazing block layer animations. A minimal slider treat for any website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:148;a:21:{s:2:\"id\";s:3:\"151\";s:5:\"title\";s:20:\"Parallax Zoom Slices\";s:5:\"alias\";s:18:\"parallaxzoomslices\";s:3:\"zip\";s:22:\"parallaxzoomslices.zip\";s:3:\"uid\";s:32:\"83537cae05709ddb9bcb7375470a5894\";s:3:\"img\";s:29:\"parallaxzoomslices/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/parallax-zoom-slices-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:249:\"<span class=\"ttm_content\">This template uses the Slicey Add-On to add a unique effect to slide background images. You can simple change the background images and the slice effect will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:149;a:21:{s:2:\"id\";s:3:\"152\";s:5:\"title\";s:22:\"Double Exposure Effect\";s:5:\"alias\";s:20:\"doubleexposureeffect\";s:3:\"zip\";s:24:\"doubleexposureeffect.zip\";s:3:\"uid\";s:32:\"8d9229b5cbcf5bda5fbdc6a8e01a2b8c\";s:3:\"img\";s:31:\"doubleexposureeffect/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/wordpress-double-exposure-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">Make any website special with the double exposure effect slider. Use as a header module or anywhere you want!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:150;a:21:{s:2:\"id\";s:3:\"153\";s:5:\"title\";s:24:\"Mountain Parallax Header\";s:5:\"alias\";s:22:\"mountainparallaxheader\";s:3:\"zip\";s:26:\"mountainparallaxheader.zip\";s:3:\"uid\";s:32:\"8dc64663f317a2abdf179bbe341d016e\";s:3:\"img\";s:33:\"mountainparallaxheader/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/mountain-wordpress-parallax-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:192:\"<span class=\"ttm_content\">This template is a cool intro for any page, featuring a striking parallax effect. Just change texts and links and you\'re done!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:151;a:24:{s:2:\"id\";s:3:\"154\";s:5:\"title\";s:26:\"GoodNews One-Pager Package\";s:5:\"alias\";s:26:\"goodnews-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"goodnews-one-pager-package\";s:3:\"img\";s:44:\"packages/templatepack_goodnews_one_pager.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:4:{i:0;s:8:\"carousel\";i:1;s:6:\"slider\";i:2;s:4:\"hero\";i:3;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:152;a:24:{s:2:\"id\";s:3:\"155\";s:5:\"title\";s:13:\"GoodNews Menu\";s:5:\"alias\";s:12:\"goodnewsmenu\";s:3:\"zip\";s:22:\"packs/goodnewsmenu.zip\";s:3:\"uid\";s:32:\"4cbc82501ff340fcdc0acf7eb3ba2640\";s:3:\"img\";s:23:\"goodnewsmenu/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:153;a:24:{s:2:\"id\";s:3:\"156\";s:5:\"title\";s:15:\"GoodNews Header\";s:5:\"alias\";s:14:\"goodnewsheader\";s:3:\"zip\";s:24:\"packs/goodnewsheader.zip\";s:3:\"uid\";s:32:\"c6660b6bdbf596f38466f569596f5259\";s:3:\"img\";s:25:\"goodnewsheader/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:154;a:24:{s:2:\"id\";s:3:\"157\";s:5:\"title\";s:18:\"GoodNews Whats Hot\";s:5:\"alias\";s:16:\"goodnewswhatshot\";s:3:\"zip\";s:26:\"packs/goodnewswhatshot.zip\";s:3:\"uid\";s:32:\"cb841ce64a99a6644adab049cf5405cd\";s:3:\"img\";s:27:\"goodnewswhatshot/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:155;a:24:{s:2:\"id\";s:3:\"158\";s:5:\"title\";s:17:\"GoodNews Featured\";s:5:\"alias\";s:16:\"goodnewsfeatured\";s:3:\"zip\";s:26:\"packs/goodnewsfeatured.zip\";s:3:\"uid\";s:32:\"00bde4b09e3700da7183999eaf137ccc\";s:3:\"img\";s:27:\"goodnewsfeatured/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:156;a:24:{s:2:\"id\";s:3:\"159\";s:5:\"title\";s:18:\"GoodNews Spotlight\";s:5:\"alias\";s:17:\"goodnewsspotlight\";s:3:\"zip\";s:27:\"packs/goodnewsspotlight.zip\";s:3:\"uid\";s:32:\"138076241a828e1c5764379944755f2b\";s:3:\"img\";s:28:\"goodnewsspotlight/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:157;a:24:{s:2:\"id\";s:3:\"160\";s:5:\"title\";s:17:\"GoodNews Carousel\";s:5:\"alias\";s:16:\"goodnewscarousel\";s:3:\"zip\";s:26:\"packs/goodnewscarousel.zip\";s:3:\"uid\";s:32:\"d29d4460a6015e30d08d2714232d3768\";s:3:\"img\";s:27:\"goodnewscarousel/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:158;a:24:{s:2:\"id\";s:3:\"161\";s:5:\"title\";s:16:\"GoodNews Callout\";s:5:\"alias\";s:15:\"goodnewscallout\";s:3:\"zip\";s:25:\"packs/goodnewscallout.zip\";s:3:\"uid\";s:32:\"d9568b3193e96577fae630b3a6728785\";s:3:\"img\";s:26:\"goodnewscallout/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:159;a:24:{s:2:\"id\";s:3:\"162\";s:5:\"title\";s:15:\"GoodNews Footer\";s:5:\"alias\";s:14:\"goodnewsfooter\";s:3:\"zip\";s:24:\"packs/goodnewsfooter.zip\";s:3:\"uid\";s:32:\"34f43f891cb8d55375149dc4bbc38298\";s:3:\"img\";s:25:\"goodnewsfooter/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:160;a:24:{s:2:\"id\";s:3:\"163\";s:5:\"title\";s:29:\"GoodNews Content Page Package\";s:5:\"alias\";s:29:\"goodnews-content-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:29:\"goodnews-content-page-package\";s:3:\"img\";s:55:\"packages/templatepack_goodnews_content_page_package.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:161;a:24:{s:2:\"id\";s:3:\"164\";s:5:\"title\";s:18:\"GoodNews Menu Back\";s:5:\"alias\";s:16:\"goodnewsmenuback\";s:3:\"zip\";s:26:\"packs/goodnewsmenuback.zip\";s:3:\"uid\";s:32:\"1340d1aeefba497a7d404d12a1fceed4\";s:3:\"img\";s:27:\"goodnewsmenuback/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:162;a:24:{s:2:\"id\";s:3:\"165\";s:5:\"title\";s:20:\"GoodNews Blog Header\";s:5:\"alias\";s:18:\"goodnewsblogheader\";s:3:\"zip\";s:28:\"packs/goodnewsblogheader.zip\";s:3:\"uid\";s:32:\"abc4d7c1e48475c6def05f1f6d8bf564\";s:3:\"img\";s:29:\"goodnewsblogheader/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:163;a:24:{s:2:\"id\";s:3:\"166\";s:5:\"title\";s:21:\"GoodNews Blog Content\";s:5:\"alias\";s:19:\"goodnewsblogcontent\";s:3:\"zip\";s:29:\"packs/goodnewsblogcontent.zip\";s:3:\"uid\";s:32:\"bbf34563da6db2779c29599b503b07e9\";s:3:\"img\";s:30:\"goodnewsblogcontent/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:164;a:24:{s:2:\"id\";s:3:\"167\";s:5:\"title\";s:21:\"GoodNews Testimonials\";s:5:\"alias\";s:20:\"goodnewstestimonials\";s:3:\"zip\";s:30:\"packs/goodnewstestimonials.zip\";s:3:\"uid\";s:32:\"606b7336e86f69c567542d3f43712b56\";s:3:\"img\";s:31:\"goodnewstestimonials/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:165;a:24:{s:2:\"id\";s:3:\"168\";s:5:\"title\";s:20:\"GoodNews Blog Footer\";s:5:\"alias\";s:18:\"goodnewsblogfooter\";s:3:\"zip\";s:28:\"packs/goodnewsblogfooter.zip\";s:3:\"uid\";s:32:\"1fb88aecfb116fde67ce8d52bd3b5f05\";s:3:\"img\";s:29:\"goodnewsblogfooter/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:166;a:21:{s:2:\"id\";s:3:\"169\";s:5:\"title\";s:19:\"Before After Slider\";s:5:\"alias\";s:17:\"beforeafterslider\";s:3:\"zip\";s:21:\"beforeafterslider.zip\";s:3:\"uid\";s:32:\"6e615091a1fc3037c24b985ce5136fb2\";s:3:\"img\";s:28:\"beforeafterslider/slide1.jpg\";s:7:\"preview\";s:54:\"https://revolution.themepunch.com/before-after-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.3.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">This is the example slider for our Before / After Add-On that allows you to create unique presentations with a comparing functionality.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">How to install <a href=\"https://www.themepunch.com/slider-revolution/install-addons/\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:167;a:21:{s:2:\"id\";s:3:\"170\";s:5:\"title\";s:16:\"Product Showcase\";s:5:\"alias\";s:15:\"productshowcase\";s:3:\"zip\";s:19:\"productshowcase.zip\";s:3:\"uid\";s:32:\"a43447670260aaa7e8ff66cedfddb57a\";s:3:\"img\";s:26:\"productshowcase/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/wordpress-product-showcase-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:165:\"<span class=\"ttm_content\">Looking to sell products effectively? Our product showcase slider is just what you are looking for!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:168;a:21:{s:2:\"id\";s:3:\"171\";s:5:\"title\";s:23:\"Overexposure Transition\";s:5:\"alias\";s:22:\"overexposuretransition\";s:3:\"zip\";s:26:\"overexposuretransition.zip\";s:3:\"uid\";s:32:\"13f16bbe6c6d646c7d0cb817a0d3d181\";s:3:\"img\";s:33:\"overexposuretransition/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/overexposure-transition-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">Subtle overexposure transitions and smooth color fade effects make this slider stand out.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">How to install <a href=\"https://www.themepunch.com/slider-revolution/install-addons/\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:169;a:21:{s:2:\"id\";s:3:\"172\";s:5:\"title\";s:15:\"Parallax Scroll\";s:5:\"alias\";s:14:\"parallaxscroll\";s:3:\"zip\";s:18:\"parallaxscroll.zip\";s:3:\"uid\";s:32:\"82546ee2f6af6c6682852f495109b3c3\";s:3:\"img\";s:25:\"parallaxscroll/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/parallax-scroll/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A strikingly colourful header for your website with super smooth parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:170;a:24:{s:2:\"id\";s:3:\"173\";s:5:\"title\";s:24:\"TechCo One-Pager Package\";s:5:\"alias\";s:24:\"techco-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:24:\"techco-one-pager-package\";s:3:\"img\";s:28:\"packages/techco_overview.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:171;a:24:{s:2:\"id\";s:3:\"174\";s:5:\"title\";s:11:\"TechCo Menu\";s:5:\"alias\";s:11:\"techco-menu\";s:3:\"zip\";s:21:\"packs/techco-menu.zip\";s:3:\"uid\";s:32:\"55e5efee828cdf1ff7e2d3b90a301ea9\";s:3:\"img\";s:22:\"techco-menu/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:172;a:24:{s:2:\"id\";s:3:\"175\";s:5:\"title\";s:13:\"TechCo Header\";s:5:\"alias\";s:13:\"techco-header\";s:3:\"zip\";s:23:\"packs/techco-header.zip\";s:3:\"uid\";s:32:\"fb574d1376de9b1e408c91f51e6497d7\";s:3:\"img\";s:24:\"techco-header/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:173;a:24:{s:2:\"id\";s:3:\"176\";s:5:\"title\";s:12:\"TechCo About\";s:5:\"alias\";s:12:\"techco-about\";s:3:\"zip\";s:22:\"packs/techco-about.zip\";s:3:\"uid\";s:32:\"ba216da8231e55118d87e37d2358812c\";s:3:\"img\";s:23:\"techco-about/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:174;a:24:{s:2:\"id\";s:3:\"177\";s:5:\"title\";s:15:\"TechCo Services\";s:5:\"alias\";s:15:\"techco-services\";s:3:\"zip\";s:25:\"packs/techco-services.zip\";s:3:\"uid\";s:32:\"ef4a8ddbb5e1136133f7bc1227248e22\";s:3:\"img\";s:26:\"techco-services/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:175;a:24:{s:2:\"id\";s:3:\"178\";s:5:\"title\";s:12:\"TechCo Video\";s:5:\"alias\";s:12:\"techco-video\";s:3:\"zip\";s:22:\"packs/techco-video.zip\";s:3:\"uid\";s:32:\"d7bb92281d05f39f9bc9eca71f90e402\";s:3:\"img\";s:23:\"techco-video/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:176;a:24:{s:2:\"id\";s:3:\"179\";s:5:\"title\";s:13:\"TechCo Prices\";s:5:\"alias\";s:13:\"techco-prices\";s:3:\"zip\";s:23:\"packs/techco-prices.zip\";s:3:\"uid\";s:32:\"6291f404efbea12bb181352aba71ef11\";s:3:\"img\";s:24:\"techco-prices/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:177;a:24:{s:2:\"id\";s:3:\"180\";s:5:\"title\";s:19:\"TechCo Testimonials\";s:5:\"alias\";s:19:\"techco-testimonials\";s:3:\"zip\";s:29:\"packs/techco-testimonials.zip\";s:3:\"uid\";s:32:\"3460bd51f6b80599266fecb7fbb918be\";s:3:\"img\";s:30:\"techco-testimonials/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:178;a:24:{s:2:\"id\";s:3:\"181\";s:5:\"title\";s:13:\"TechCo Footer\";s:5:\"alias\";s:13:\"techco-footer\";s:3:\"zip\";s:23:\"packs/techco-footer.zip\";s:3:\"uid\";s:32:\"640abcd549137520461a4a71ff758a3b\";s:3:\"img\";s:24:\"techco-footer/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:179;a:21:{s:2:\"id\";s:3:\"182\";s:5:\"title\";s:12:\"Live Weather\";s:5:\"alias\";s:7:\"weather\";s:3:\"zip\";s:11:\"weather.zip\";s:3:\"uid\";s:32:\"aab92e69374e4c7b8c6741fe02e574b9\";s:3:\"img\";s:18:\"weather/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-live-weather-add-on/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">Showcasing our weather add-on, this slider show a different cities temperatures and forecast on each slide.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:168:\"[{\"path\":\"revslider-weather-addon\\/revslider-weather-addon.php\",\"name\":\"Live Weather Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:180;a:21:{s:2:\"id\";s:3:\"183\";s:5:\"title\";s:17:\"360 Panorama Tour\";s:5:\"alias\";s:11:\"360panorama\";s:3:\"zip\";s:15:\"360panorama.zip\";s:3:\"uid\";s:32:\"332720fdacdbb38f65e8327a2a96c52d\";s:3:\"img\";s:22:\"360panorama/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/360-degree-real-estate-virtual-tour/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">An example template for our Panorama 360 tour add-on, created for the real estate market.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:165:\"[{\"path\":\"revslider-panorama-addon\\/revslider-panorama-addon.php\",\"name\":\"Panorama AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:181;a:21:{s:2:\"id\";s:3:\"184\";s:5:\"title\";s:14:\"Duotone Add-on\";s:5:\"alias\";s:14:\"duotone-add-on\";s:3:\"zip\";s:18:\"duotone-add-on.zip\";s:3:\"uid\";s:32:\"a428c6f363b3146e96d20a6f44958922\";s:3:\"img\";s:25:\"duotone-add-on/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/wordpress-duotone-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:168:\"<span class=\"ttm_content\">This example template showcases 3 of the 30 Duotone filters available in our brand new Duotone Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:350:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-duotonefilters-addon\\/revslider-duotonefilters-addon.php\",\"name\":\"Duotone AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:182;a:21:{s:2:\"id\";s:3:\"185\";s:5:\"title\";s:13:\"Reveal Add-on\";s:5:\"alias\";s:13:\"reveal-add-on\";s:3:\"zip\";s:17:\"reveal-add-on.zip\";s:3:\"uid\";s:32:\"7fa7525d8ff7fa7365cb98a437e88e32\";s:3:\"img\";s:24:\"reveal-add-on/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/wordpress-content-reveal-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">An example template that uses our Reveal Add-On, which adds 14 new preloaders combined with reveal loading effects for any slider or hero.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:337:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:201;a:21:{s:2:\"id\";s:3:\"210\";s:5:\"title\";s:21:\"Cryptocurrency Prices\";s:5:\"alias\";s:12:\"cryptoslider\";s:3:\"zip\";s:16:\"cryptoslider.zip\";s:3:\"uid\";s:32:\"c4b02210387f11946223977e940d9e9e\";s:3:\"img\";s:23:\"cryptoslider/slide1.jpg\";s:7:\"preview\";s:95:\"https://revolution.themepunch.com/cryptocurrency-wordpress-price-api-bitcoin-ethereum-litecoin/\";s:7:\"version\";s:5:\"1.0.4\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:209:\"<span class=\"ttm_content\">This Template can show live, animated cryptocurrency prices. More than 1300 currencies are supported, getting prices via the cryptocompare API.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:410:\"<span class=\"ttm_content\">Please refer to the \"Custom JavaScript\" section of this sliders settings, for info on how to modify currencies. Provide a class to the row / column / group where the currency text elements are located in.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:202;a:24:{s:2:\"id\";s:3:\"211\";s:5:\"title\";s:18:\"Immersion One Page\";s:5:\"alias\";s:26:\"immersion-one-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"immersion-one-page-package\";s:3:\"img\";s:31:\"packages/immersion_overview.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";s:343:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"},{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:203;a:24:{s:2:\"id\";s:3:\"212\";s:5:\"title\";s:16:\"Immersion Header\";s:5:\"alias\";s:16:\"immersion_header\";s:3:\"zip\";s:26:\"packs/immersion_header.zip\";s:3:\"uid\";s:32:\"853da51256308b341ecd030bd4883229\";s:3:\"img\";s:27:\"immersion_header/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:204;a:24:{s:2:\"id\";s:3:\"213\";s:5:\"title\";s:19:\"Immersion Mountains\";s:5:\"alias\";s:19:\"immersion-mountains\";s:3:\"zip\";s:29:\"packs/immersion-mountains.zip\";s:3:\"uid\";s:32:\"817167eb3fe22b7e065ba210cbe6d53c\";s:3:\"img\";s:30:\"immersion-mountains/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:205;a:24:{s:2:\"id\";s:3:\"214\";s:5:\"title\";s:17:\"Immersion Product\";s:5:\"alias\";s:17:\"immersion-product\";s:3:\"zip\";s:27:\"packs/immersion-product.zip\";s:3:\"uid\";s:32:\"64134f263484d2bbcd7ef088ffbbfb4b\";s:3:\"img\";s:28:\"immersion-product/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:206;a:24:{s:2:\"id\";s:3:\"215\";s:5:\"title\";s:16:\"Immersion Design\";s:5:\"alias\";s:16:\"immersion-design\";s:3:\"zip\";s:26:\"packs/immersion-design.zip\";s:3:\"uid\";s:32:\"91e1d77c1a2826438763804f4d02bc26\";s:3:\"img\";s:27:\"immersion-design/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:207;a:24:{s:2:\"id\";s:3:\"216\";s:5:\"title\";s:22:\"Immersion Phototgraphy\";s:5:\"alias\";s:21:\"immersion-photography\";s:3:\"zip\";s:31:\"packs/immersion-photography.zip\";s:3:\"uid\";s:32:\"e3ddf0c577b09740f5cbf2e38ffd684d\";s:3:\"img\";s:32:\"immersion-photography/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:208;a:24:{s:2:\"id\";s:3:\"217\";s:5:\"title\";s:14:\"Immersion Grid\";s:5:\"alias\";s:14:\"immersion-grid\";s:3:\"zip\";s:24:\"packs/immersion-grid.zip\";s:3:\"uid\";s:32:\"b6903868189bb83b2c7a852fde3a7dc3\";s:3:\"img\";s:25:\"immersion-grid/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:209;a:21:{s:2:\"id\";s:3:\"218\";s:5:\"title\";s:18:\"Funky Intro Slider\";s:5:\"alias\";s:11:\"funkyslider\";s:3:\"zip\";s:15:\"funkyslider.zip\";s:3:\"uid\";s:32:\"2d4187e3fdad19b976be335253c8925d\";s:3:\"img\";s:22:\"funkyslider/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/funky-intro-slider-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">This funky intro slider fits just right if you need a striking introduction to your website! Sleek, beautiful and easily customizable!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:335:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:210;a:24:{s:2:\"id\";s:3:\"219\";s:5:\"title\";s:19:\"Clear View Magazine\";s:5:\"alias\";s:27:\"clear-view-magazine-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"clear-view-magazine-package\";s:3:\"img\";s:41:\"packages/clear_view_magazine_overview.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:211;a:24:{s:2:\"id\";s:3:\"220\";s:5:\"title\";s:15:\"Clear View Menu\";s:5:\"alias\";s:14:\"clearview_menu\";s:3:\"zip\";s:24:\"packs/clearview_menu.zip\";s:3:\"uid\";s:32:\"eaecee5fa5f3c3a7f4d2a96c4616a353\";s:3:\"img\";s:25:\"clearview_menu/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:212;a:24:{s:2:\"id\";s:3:\"221\";s:5:\"title\";s:17:\"Clear View Header\";s:5:\"alias\";s:16:\"clearview_header\";s:3:\"zip\";s:26:\"packs/clearview_header.zip\";s:3:\"uid\";s:32:\"25e3dd80ad130875d7438a07952cb0cd\";s:3:\"img\";s:27:\"clearview_header/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:213;a:24:{s:2:\"id\";s:3:\"222\";s:5:\"title\";s:18:\"Clear View Mission\";s:5:\"alias\";s:17:\"clearview_mission\";s:3:\"zip\";s:27:\"packs/clearview_mission.zip\";s:3:\"uid\";s:32:\"35b2092a49fd2beb549342e69097eb5b\";s:3:\"img\";s:28:\"clearview_mission/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:214;a:24:{s:2:\"id\";s:3:\"223\";s:5:\"title\";s:17:\"Clear View Slider\";s:5:\"alias\";s:17:\"clear-view-slider\";s:3:\"zip\";s:27:\"packs/clear-view-slider.zip\";s:3:\"uid\";s:32:\"d2e17edffce16ed78c54b0ef23fd7e05\";s:3:\"img\";s:28:\"clear-view-slider/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:215;a:24:{s:2:\"id\";s:3:\"224\";s:5:\"title\";s:15:\"Clear View News\";s:5:\"alias\";s:15:\"clear-view-news\";s:3:\"zip\";s:25:\"packs/clear-view-news.zip\";s:3:\"uid\";s:32:\"5698d3131ba141e9afcfd2906739dd00\";s:3:\"img\";s:26:\"clear-view-news/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:216;a:24:{s:2:\"id\";s:3:\"225\";s:5:\"title\";s:18:\"Clear View Clients\";s:5:\"alias\";s:18:\"clear-view-clients\";s:3:\"zip\";s:28:\"packs/clear-view-clients.zip\";s:3:\"uid\";s:32:\"b95616a94832e22bdfac5ce60232be1b\";s:3:\"img\";s:29:\"clear-view-clients/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:217;a:24:{s:2:\"id\";s:3:\"226\";s:5:\"title\";s:18:\"Clear View Contact\";s:5:\"alias\";s:18:\"clear-view-contact\";s:3:\"zip\";s:28:\"packs/clear-view-contact.zip\";s:3:\"uid\";s:32:\"0e0cc1d8f6f6500e5f8a2b091fa3b4cb\";s:3:\"img\";s:29:\"clear-view-contact/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-tem