import React, {Component} from 'react';

export default class Course extends Component {

	constructor(props){
		super(props);

		this.state={
			id:0,
			details:{}
		}
	}

	componentWillMount(){

		let details = sessionStorage.getItem('course_'+this.props.id);
		if(!details){
			fetch(`${window.wplms_commissions.api_url}course/${this.props.id}/`)
	        .then(res => res.json())
	        .then((details)=>{
	        	this.setState({details});
	        	sessionStorage.setItem('course_'+this.props.id,JSON.stringify(details));
			});
		}else{
			details = JSON.parse(details);
			this.setState({details});
		}
		
	}

	render(){
		return (
			<div className="course">
				<span>{this.state.details.name}</span>
			</div>
		);
	}
}
